package com.lerx.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.annotation.Token;
import com.lerx.aop.args.CutTags;
import com.lerx.dao.iface.IGroupDao;
import com.lerx.dao.iface.IPortalDao;
import com.lerx.dao.iface.ITempletPortalMainDao;
import com.lerx.entities.ArticleGroup;
import com.lerx.entities.Portal;
import com.lerx.entities.TempletPortalMain;
import com.lerx.portal.obj.ArticleGroupMapCreateArgs;
import com.lerx.portal.obj.ImageSize;
import com.lerx.v6.util.GroupUtil;

@RequestMapping("/action_agroup")
@Controller
public class GroupHandler {
	
	private static final String FAILED = "jsp/result/failed";
	private static final String ADMINFAILRETURN = "_admin.login.redirect_";
	private static final String GROUPLIST = "jsp/agroup/list";
	private static final String GROUPEDIT = "jsp/agroup/add";
	
	@Autowired
	private IGroupDao groupDaoImpl;
	
	@Autowired
	private IPortalDao portalDaoImpl;
	
	@Autowired
	private ITempletPortalMainDao templetPortalMainDaoImpl;
	
	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	@ModelAttribute
	public void getArticleGroup(@RequestParam(value = "id", required = false) Long id, Map<String, Object> map) {
		if (id != null && id > 0) {
			map.put("group", groupDaoImpl.findByID(id));
		}
	}
	
	
	@RequestMapping("/add")
	@Token(ajax=false,token=true,contrast = true,csrf = true,log=true,mark="agroup--<add>",admin=true,failedPage=FAILED,failedReturnUrl = ADMINFAILRETURN)
	public String add(ArticleGroup group, Errors result, HttpSession session,Map<String, Object> map, CutTags tags, String token) {
		boolean newg;
		if (group.getId()==0) {
			newg=true;
			group.setOpen(true);
			group.setStatus(true);
			group.setClogging(true);
			group.setGather(true);
			group.setStaticPage(true);
			group.setChanged(true);
			Portal portal=portalDaoImpl.query_update();
			group.setComm(portal.isComm());
			group.setPoll(portal.isPoll());
			if (group.getParent()!=null && group.getParent().getId()==0) {
				group.setParent(null);
			}
			groupDaoImpl.add(group);
			GroupUtil.clearCache();
//			GroupUtil.clearCache(group,groupDaoImpl.ht());
		}else {
			newg=false;
			int rootChg=groupDaoImpl.modify(group);
			if (rootChg>0) {
				GroupUtil.clearCache();
			}else {
				GroupUtil.clearCache(groupDaoImpl.findByID(group.getId()),groupDaoImpl.ht());
			}
			
		}
		
		if (newg) {
			if (group.getParent()!=null) {
				map.put("rid", group.getParent().getId());
			}
			return "jsp/agroup/continue" ;
		}else {
			return "jsp/result/success" ;
		}
		
		
		
		//mapCreate(map,groupDaoImpl,group);
		
		
	}
	
	@RequestMapping(value = {"/beforeAdd/{rid}","/beforeAdd"})
	@Token(contrast = true,csrf = true)
	public String beforeAdd(@PathVariable(value = "rid", required = false) Long rid,HttpServletRequest request, Map<String, Object> map) {
		ArticleGroup parent;
		
		if (rid == null) {
			parent=null;
		}else {
			parent=groupDaoImpl.findByID(rid);
		}
		ArticleGroup group = new ArticleGroup();
		group.setOpen(true);
		group.setClogging(true);
		group.setStatus(true);
		group.setParent(parent);
		map.put("group", group);
		map.put("parent", parent);
		String rootTitle=messageSource.getMessage("root.title", null, "Root", null);
		
		ArticleGroupMapCreateArgs agmca = new ArticleGroupMapCreateArgs();
		agmca.setCurrRoleMask("0");
		agmca.setCurrRoot(null);
		agmca.setGroupSelected(parent);
		agmca.setFree(true);
		agmca.setGroupDaoImpl(groupDaoImpl);
		agmca.setMap(map);
		agmca.setRootTitle(rootTitle);
		agmca.setStatus(0);
		agmca.setMessageSource(messageSource);
		agmca.setRequest(request);
		GroupUtil.mapCreate(agmca,rootTitle);
		return GROUPEDIT;
	}
	
	
	@RequestMapping(value = "/edit/{id}", method = RequestMethod.GET)
	@Token(contrast = true,csrf = true)
	public String edit(@PathVariable("id") Long id,HttpServletRequest request, Map<String, Object> map) {
		ArticleGroup group = groupDaoImpl.findByID(id);
//		map.put("group", group);
		
		String rootTitle=messageSource.getMessage("root.title", null, "Root", null);
		ArticleGroupMapCreateArgs agmca = new ArticleGroupMapCreateArgs();
		agmca.setCurrRoleMask("0");
		agmca.setCurrRoot(group);
		agmca.setFree(true);
		agmca.setGroupDaoImpl(groupDaoImpl);
		agmca.setMap(map);
		agmca.setRootTitle(rootTitle);
		agmca.setStatus(1);
		agmca.setMessageSource(messageSource);
		agmca.setRequest(request);
		GroupUtil.mapCreate(agmca,rootTitle);
		
		List<TempletPortalMain> list=templetPortalMainDaoImpl.queryAllUsable();
		String deftitle=agmca.getMessageSource().getMessage("value.default", null, "Default value", null);
		List<TempletPortalMain> list2=new ArrayList<TempletPortalMain>();
		TempletPortalMain tnull=new TempletPortalMain();
		tnull.setId(0);
		tnull.setName(deftitle);
		list2.add(tnull);
		for (TempletPortalMain templet:list) {
			list2.add(templet);
		}
		map.put("templetAll", list2);
		map.put("group", group);
//		map.put("excluded", group);
		return GROUPEDIT;
	}
	
	
	
	@ResponseBody
	@RequestMapping("/ipscope")
	@Token(ajax=true,csrf=true,contrast = true,log=true,mark="agroup--<ipscope-change>",admin=true,failedPage=FAILED,failedReturnUrl = ADMINFAILRETURN)
	public int modifyIpScope(Long id,String val) {
		if (val!=null && !val.trim().equals("") && val.trim().length()>6){
			ArticleGroup group = groupDaoImpl.findByID(id);
			group.setIpVisitAllow(val);
			groupDaoImpl.modify(group);
			return 0;
		}else{
			return -1;
		}
		
	}
	
	@ResponseBody
	@RequestMapping("/jumpurl")
	@Token(ajax=true,csrf=true,contrast = true,log=true,mark="agroup--<jumpurl-change>",admin=true,failedPage=FAILED,failedReturnUrl = ADMINFAILRETURN)
	public int modifyJumpUrl(Long id,String val) {
		if (val!=null && !val.trim().equals("") && val.trim().length()>6){
			ArticleGroup group = groupDaoImpl.findByID(id);
			group.setJumpToUrl(val);
			groupDaoImpl.modify(group);
			return 0;
		}else{
			return -1;
		}
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/del/{id}")
	@Token(ajax=true,csrf=true,contrast = true,log=true,mark="agroup--<del>",admin=true,failedPage=FAILED,failedReturnUrl = ADMINFAILRETURN)
	public int del(@PathVariable(value = "id", required = true) Long id,HttpSession session,Map<String, Object> map) {
		boolean result;
		
		result=groupDaoImpl.delByID(id);
		if (result) {
			GroupUtil.clearCache();
			return 0;
		}else {
			return -1;
		}
		
	}
	
	@ResponseBody
	@RequestMapping(value = "/clearCache")
	@Token(ajax=true,csrf=true,contrast = true,log=true,mark="agroup--<del>",admin=true,failedPage=FAILED,failedReturnUrl = ADMINFAILRETURN)
	public int clearCache(HttpSession session,Map<String, Object> map) {
		GroupUtil.clearCache();
		List<ArticleGroup> lag=groupDaoImpl.findAll();
		for (ArticleGroup ag:lag) {
			groupDaoImpl.modify(ag);
		}
		return 0;
	}
	
	@ResponseBody
	@RequestMapping(value = "/smartWH/{id}")
	@Token(csrf=true,contrast = true)
	public ImageSize smartWH(@PathVariable(value = "id", required = true) Long id) {
		ImageSize is = new ImageSize();
		ArticleGroup ag=groupDaoImpl.findByID(id);
		if (ag==null) {
			is.setWidth(0);
			is.setHeight(0);
		}else {
			if (ag.isImgIntact()) {
				is.setIntact(1);
				is.setWidth(0);
				is.setHeight(0);
			}else {
				is.setIntact(0);
				is.setWidth(ag.getCw());
				is.setHeight(ag.getCh());
			}
		}
		return is;
		
	}
	
	@RequestMapping("/list")
	@Token(ajax=false,admin=true,csrf=true,contrast = true,failedPage=FAILED,failedReturnUrl = ADMINFAILRETURN)
	public String list(HttpServletRequest request,Map<String, Object> map) {
		String rootTitle=messageSource.getMessage("root.title", null, "Root", null);
		ArticleGroupMapCreateArgs agmca = new ArticleGroupMapCreateArgs();
		agmca.setCurrRoleMask("0");
		agmca.setCurrRoot(null);
		agmca.setFree(true);
		agmca.setGroupDaoImpl(groupDaoImpl);
		agmca.setMap(map);
		agmca.setRootTitle(rootTitle);
		agmca.setStatus(0);
		agmca.setMessageSource(messageSource);
		agmca.setRequest(request);
		GroupUtil.mapCreate(agmca,rootTitle);
		return GROUPLIST;
	}
	
	@ResponseBody
	@RequestMapping(value = "/move/{id}/{offset}")
	@Token(ajax=true,csrf=true,contrast = true,log=true,mark="agroup--<move>",admin=true)
	public int modifyOrder(@PathVariable(value = "id", required = true) Long id,@PathVariable(value = "offset", required = true) int offset,HttpServletRequest request,Map<String, Object> map, CutTags tags) {
		ArticleGroup group=groupDaoImpl.findByID(id);
		groupDaoImpl.move(group, offset);
		GroupUtil.clearCache();
		String rootTitle=messageSource.getMessage("root.title", null, "Root", null);
		ArticleGroupMapCreateArgs agmca = new ArticleGroupMapCreateArgs();
		agmca.setCurrRoleMask("0");
		agmca.setCurrRoot(null);
		agmca.setFree(true);
		agmca.setGroupDaoImpl(groupDaoImpl);
		agmca.setMap(map);
		agmca.setRootTitle(rootTitle);
		agmca.setStatus(1);
		agmca.setMessageSource(messageSource);
		agmca.setRequest(request);
		GroupUtil.mapCreate(agmca,rootTitle);
		return 0;
	}
	
	@RequestMapping("/map")
	@Token(csrf=true,contrast = true)
	public String map(HttpServletRequest request,Map<String, Object> map) {
		Portal portal =portalDaoImpl.query_update();
		map.put("portal", portal);
		
		String rootTitle=messageSource.getMessage("root.title", null, "Root", null);
		ArticleGroupMapCreateArgs agmca = new ArticleGroupMapCreateArgs();
		agmca.setCurrRoleMask("0");
		agmca.setCurrRoot(null);
		agmca.setFree(true);
		agmca.setGroupDaoImpl(groupDaoImpl);
		agmca.setMap(map);
		agmca.setRootTitle(rootTitle);
		agmca.setStatus(1);
		agmca.setMessageSource(messageSource);
		agmca.setRequest(request);
		GroupUtil.mapCreate(agmca,rootTitle);
		
		return "jsp/agroup/map";
	}
		
}
