package com.lerx.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbgenreDao;
import com.lerx.dao.iface.IAlbumArticleDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.dao.iface.IArticleDao;
import com.lerx.dao.iface.ICommentBridgeDao;
import com.lerx.dao.iface.IGroupDao;
import com.lerx.dao.iface.IHtmlFileStaticDao;
import com.lerx.dao.iface.ISearchTotalModelDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.Albgenre;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumArticle;
import com.lerx.entities.Article;
import com.lerx.entities.ArticleGroup;
import com.lerx.entities.CommentBridge;
import com.lerx.entities.HtmlFileStatic;
import com.lerx.entities.SearchTotalModel;
import com.lerx.entities.User;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.FileEl;
import com.lerx.portal.obj.HtmlStaticTarget;
import com.lerx.portal.obj.LongPollingReturn;
import com.lerx.sys.obj.ReturnCollections;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.MavUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.v6.util.AlbgenreUtil;
import com.lerx.v6.util.AlbumArticleUtil;
import com.lerx.v6.util.AlbumUtil;
import com.lerx.v6.util.ArticleUtil;
import com.lerx.v6.util.GroupUtil;
import com.lerx.v6.util.PartnerUtil;
import com.lerx.v6.util.SitemapUtil;

@RequestMapping("/action_static")
@Controller
public class HtmlHandler {

	@Value("${context.path}")
	private String contextPath;

	@Autowired
	private IUserDao userDaoImpl;

	@Autowired
	private IGroupDao groupDaoImpl;

	@Autowired
	private IArticleDao articleDaoImpl;

	@Autowired
	private IAlbgenreDao albgenreDaoImpl;

	@Autowired
	private IAlbumDao albumDaoImpl;

	@Autowired
	private IAlbumArticleDao albumArticleDaoImpl;

	@Autowired
	private IHtmlFileStaticDao htmlFileStaticDaoImpl;

	@Autowired
	private ICommentBridgeDao commentBridgeDaoImpl;

	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;

	@Autowired
	private ISearchTotalModelDao searchTotalModelDaoImpl;

	@Autowired
	private ResourceBundleMessageSource messageSource;

	private static final String ADMINFAILRETURN = "_admin.login.redirect_";
	private static final String FORBIDU = "jsp/result/forbidu";
	private static final String FAILED = "jsp/result/failed";

	@RequestMapping(value = "/start")
	@Token(ajax = false, admin = true, csrf = true, contrast = true, failedPage = FAILED, msgKey = "fail.permission", failedReturnUrl = ADMINFAILRETURN)
	public ModelAndView start(Map<String, Object> map) {
		map.put("spacePercent", 0);

		return MavUtil.mav1("jsp/sys/static", "");

	}

	@SuppressWarnings("unchecked")
	@RequestMapping(value = "/check")
	@ResponseBody
	@Token(ajax = true, csrf = true, contrast = true, admin = true)
	public int check(@RequestParam(value = "tagstr", required = false) String tagstr, HttpServletRequest request,
			HttpSession session) {
		long tid = 0L;
		if (tagstr.indexOf("album_") > -1) { // 因为更新专辑会同时更新频道，所以如果选了更新频道，则去除。
			tagstr = StringUtil.strReplace(tagstr, "albgenre_", "");
		}
		String[] sArray = tagstr.split("_");
		List<HtmlStaticTarget> slist;
		int total = 0;

		slist = (List<HtmlStaticTarget>) session.getAttribute("taglist");
		if (slist != null && !slist.isEmpty()) {
			total = slist.size();
		}

		if (slist == null || slist.isEmpty()) {
			slist = new ArrayList<HtmlStaticTarget>();
			for (int step = 0; step < sArray.length; step++) {
				if (sArray[step].trim().equalsIgnoreCase("index")) {
					tid++;
					HtmlStaticTarget targ = new HtmlStaticTarget();
					targ.setId(tid);
					targ.setTarID(0);
					targ.setTypeNum(0);
					targ.setTitle(messageSource.getMessage("root.title", null, "root", null));
					targ.setTypeStr(messageSource.getMessage("title.index", null, "index", null));
					slist.add(targ);

				} else if (sArray[step].trim().equalsIgnoreCase("nav")) {

					List<ArticleGroup> list = groupDaoImpl.queryAllForStatic();

					for (ArticleGroup ag : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(ag.getId());
						targ.setId(tid);
						targ.setTypeNum(1);
						targ.setTitle(ag.getName());
						targ.setTypeStr(messageSource.getMessage("title.nav", null, "nav", null));
						slist.add(targ);
					}

				} else if (sArray[step].trim().equalsIgnoreCase("art")) {
					List<Long> list = articleDaoImpl.queryAllPassedID(0);

					for (long aid : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(aid);
						targ.setId(tid);
						targ.setTypeNum(2);
						targ.setTypeStr(messageSource.getMessage("title.article", null, "article", null));
						slist.add(targ);
					}
				} else if (sArray[step].trim().equalsIgnoreCase("albgenre")) {
					List<Albgenre> list = albgenreDaoImpl.queryAll();

					for (Albgenre genre : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(genre.getId());
						targ.setId(tid);
						targ.setTypeNum(3);
						targ.setTypeStr(messageSource.getMessage("title.albgenre", null, "albgenre", null));
						slist.add(targ);
					}
				} else if (sArray[step].trim().equalsIgnoreCase("album")) {
					List<Long> list = albumDaoImpl.queryAllPassedID();
//  	  	  		System.out.println("album:"+list.size());

					for (long aid : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(aid);
						targ.setId(tid);
						targ.setTypeNum(4);
						targ.setTypeStr(messageSource.getMessage("title.album", null, "album", null));
						slist.add(targ);
					}
				} else if (sArray[step].trim().equalsIgnoreCase("albart")) {
					List<Long> list = albumArticleDaoImpl.queryAllPassedID(0);
					for (long aid : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(aid);
						targ.setId(tid);
						targ.setTypeNum(5);
						targ.setTypeStr(messageSource.getMessage("title.albart", null, "article", null));
						slist.add(targ);
					}
				}
			}

			session.setAttribute("taglist", slist);
			total = slist.size();
		}
		
		

		return total;

	}

	// 静态化
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = { "/now/{id}/{total}/{startn}/{endn}/{pagehtml}/{pagelines}",
			"/now/{id}/{total}/{startn}/{endn}", "/now/{id}/{total}" })
	@Token(ajax = true, csrf = true, contrast = true, admin = true)
	public ReturnCollections runn(@PathVariable(value = "id", required = false) Integer id,
			@PathVariable(value = "total", required = false) Integer total,
			@PathVariable(value = "startn", required = false) Integer startn,
			@PathVariable(value = "endn", required = false) Integer endn,
			@PathVariable(value = "endn", required = false) Integer pagehtml,
			@PathVariable(value = "endn", required = false) Integer pagelines,HttpServletRequest request,
			HttpSession session) {
		
		boolean sitemapRebulid = false ;
		
		if (pagehtml==null) {
			pagehtml=0;
		}
		if (pagelines==null) {
			pagelines=20;
		}
		
		// sitemapFile文件是所有生成的html文件列表，可以向百度提交
		String sitemapFile = FileUtil.appPath() + File.separator + "sitemapFile.txt";
		String tmpFile=FileUtil.webinfPath()+File.separator+"temp"+File.separator+"sitemap";
		sitemapFile = FileUtil.repairFilePath(sitemapFile);
		tmpFile=FileUtil.repairFilePath(tmpFile);
		

		if (LoginUtil.adminChk(messageSource, session)) {
			LoginUtil.resaveAdmin(session);
		}

		ReturnCollections lr = new ReturnCollections();
		if (startn == null) {
			startn = 0;
		}
		if (endn == null) {
			endn = 0;
		}

		if (startn > 0 && id < startn) {
			lr.setRetult(-2);
			lr.setValue(startn);
			return lr;
		}
		
		if (startn==0 && endn == 0) {
			String sitemapRebulidStr = messageSource.getMessage("site.map.file.rebulid.onbatch", null, "false", null);
			if (sitemapRebulidStr.trim().equalsIgnoreCase("true")) {
				sitemapRebulid=true;
			}
		}
		
		if (startn==0 && endn == 0 && id==0) {
			
			request.getSession().removeAttribute("curPage");
			String sitemapHtmlRoot = messageSource.getMessage("group.file.static.root", null, "html", null);
			sitemapHtmlRoot=FileUtil.appPath()+File.separator+sitemapHtmlRoot+File.separator+"sitemap";
			if (sitemapRebulid) {
				File f= new File(sitemapHtmlRoot);
				try {
					FileUtils.deleteDirectory(f);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				f = new File(tmpFile);
				if (f.exists()) {
					try {
						FileUtils.deleteDirectory(f);
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
			
		}

		List<HtmlStaticTarget> slist = (List<HtmlStaticTarget>) session.getAttribute("taglist");
		String currTitle = "";
		if (slist == null || slist.isEmpty()) {
			lr.setRetult(-1);
		} else {
			boolean rebuild = false;
			if (messageSource.getMessage("file.html.art.rebulid", null, "false", null).trim()
					.equalsIgnoreCase("true")) {
				rebuild = true;
			}
			String htmlRoot;
			String indexFile = messageSource.getMessage("file.html.default", null, "index.html", null);
			String strCreateDateTime, fromurl, realPath;

			HtmlStaticTarget targ = slist.get(id);
			
			switch (targ.getTypeNum()) {
			case 0:

				String charset = messageSource.getMessage("charset", null, "utf-8", null);
				htmlRoot = messageSource.getMessage("group.file.static.root", null, "html", null);
				if (htmlRoot != null
						&& (htmlRoot.trim().equalsIgnoreCase("WebRoot") || htmlRoot.trim().equalsIgnoreCase("root"))) {
					htmlRoot = "";
				}
				strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
				fromurl = contextPath + "show_portal/index";
				String index = FileUtil.appPath() + indexFile;

				FileUtil.htmlBySniff(fromurl, index, strCreateDateTime, charset);
				String url = HttpUtil.getSrvUrl(request, false) + "/" + indexFile;
				url = HttpUtil.repairUrl(url);
				FileUtil.addStringToFile(FileUtil.appPath(), "sitemapFile.txt", url, true,"UTF-8");

				currTitle = messageSource.getMessage("title.index", null, "index", null);
				break;
			case 1:
				ArticleGroup ag = groupDaoImpl.findByID(targ.getTarID());
				if (GroupUtil.openChk(ag) && (ag.getJumpToUrl() == null || ag.getJumpToUrl().trim().equals(""))) {
					htmlRoot = messageSource.getMessage("group.file.static.root", null, "html", null);
					if (htmlRoot != null && (htmlRoot.trim().equalsIgnoreCase("WebRoot")
							|| htmlRoot.trim().equalsIgnoreCase("root"))) {
						htmlRoot = "";
					}
					charset = messageSource.getMessage("charset", null, "utf-8", null);
					realPath = FileUtil.appPath() + GroupUtil.htmlFolder(ag, htmlRoot);
					realPath = FileUtil.repairFilePath(realPath) + indexFile;
					strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
					fromurl = contextPath + "show_portal/nav/" + ag.getId();
					FileUtil.htmlBySniff(fromurl, realPath, strCreateDateTime, charset);
					/*
					 * fromurl=HttpUtil.getSrvUrl(request, false)+"/"+fromurl;
					 * fromurl=HttpUtil.repairUrl(fromurl);
					 */
					FileUtil.addStringToFile(FileUtil.appPath(), "sitemapFile.txt",
							getExtUrl(request, GroupUtil.getUrl(ag, htmlRoot, indexFile)),true, "UTF-8");

				}

				currTitle = messageSource.getMessage("title.nav", null, "nav", null);
				currTitle += " -- " + ag.getName();
				break;
			case 2:
				Article art = articleDaoImpl.findByID(targ.getTarID());
				boolean jump = false;
				if (art.getJumpUrl() != null && !art.getJumpUrl().trim().equals("")) {
					// lr.setRetult(-302);
					jump = true;
				}
				if (!jump) {
					if (rebuild) {
						FileEl fe = ArticleUtil.feBuild(messageSource, request, art, true);
						HtmlFileStatic hfs = art.getHfs();
						hfs = art.getHfs();
						hfs.setRealPath(fe.getRealPath());
						hfs.setUrl(fe.getUrl());
						hfs.setFilename(FileUtil.getFileFromPath(fe.getRealPath()));
						htmlFileStaticDaoImpl.modify(hfs);

						art.getCb().setHosturl(ArticleUtil.getHref(messageSource, request, art));
						commentBridgeDaoImpl.modify(art.getCb());

					}
					ArticleUtil.htmlCreate(request, messageSource, contextPath, art);

					art.getHfs().setStatus(true);
//					articleDaoImpl.modify(art);
					
					art = ArticleUtil.srtUpdate(art);
					String href = ArticleUtil.getHref(messageSource, request, art);
					art.getSrt().setHref(href);
					if (art.isDeled() || !art.isStatus() || art.getAgroup().isDeled() || !art.getAgroup().isStatus()) {
						art.getSrt().setStatus(false);
					}
					searchTotalModelDaoImpl.modify(art.getSrt());
					articleDaoImpl.update(art);
					
					if (sitemapRebulid) {
						SitemapUtil.write(messageSource, request, art);
					}
					

				}

				currTitle = messageSource.getMessage("title.article", null, "article", null);
				currTitle += " -- " + art.getSubject();
				break;
			case 3:
				Albgenre albgenre = albgenreDaoImpl.findByID(targ.getTarID());
				AlbgenreUtil.htmlCreate(albgenre, messageSource, contextPath);

				FileUtil.addStringToFile(FileUtil.appPath(), "sitemapFile.txt",
						getExtUrl(request, AlbgenreUtil.getHref(messageSource, request, albgenre, false)),true, "UTF-8");

				currTitle = messageSource.getMessage("title.albgenre", null, "albgenre", null);
				currTitle += " -- " + albgenre.getName();
				break;
			case 4:
				Album album = albumDaoImpl.findByID(targ.getTarID());
				AlbumUtil.htmlCreate(album, messageSource, contextPath, false);

				FileUtil.addStringToFile(FileUtil.appPath(), "sitemapFile.txt",
						getExtUrl(request, AlbumUtil.getHref(messageSource, request, album, false)), true,"UTF-8");

				currTitle = messageSource.getMessage("title.album", null, "album", null);
				currTitle += " -- " + album.getName();
				break;
			case 5:
				AlbumArticle albart = albumArticleDaoImpl.findByID(targ.getTarID());
				
				if (albart != null && albart.getOwner() == null) {
					albart.setOwner(albart.getAlbum().getLeader());
					albumArticleDaoImpl.modify(albart);
					albart = albumArticleDaoImpl.findByID(albart.getId());
				}
				
				Album alb = albumDaoImpl.findByID(albart.getAlbum().getId());
				Albgenre genre = albgenreDaoImpl.findByID(alb.getGenre().getId());
				
				if (albart != null && albart.isStatus() && genre.isStatus() && alb.isStatus() && !alb.isDeled() ) {

					if (albart.getHfs() == null) {
						HtmlFileStatic hfs = new HtmlFileStatic();
						FileEl fe = AlbumArticleUtil.feBuild(messageSource, request, albart, false);
						hfs.setRealPath(fe.getRealPath());
						hfs.setUrl(fe.getUrl());
						hfs.setFilename(FileUtil.getFileFromPath(fe.getRealPath()));
						htmlFileStaticDaoImpl.add(hfs);
						albart.setHfs(hfs);
						albumArticleDaoImpl.modify(albart, false, null);
					} else if (rebuild || albart.getHfs().getRealPath() == null
							|| albart.getHfs().getRealPath().trim().equals("")) {
						HtmlFileStatic hfs = albart.getHfs();
						FileEl fe = AlbumArticleUtil.feBuild(messageSource, request, albart, false);
						hfs.setRealPath(fe.getRealPath());
						hfs.setUrl(fe.getUrl());
						hfs.setFilename(FileUtil.getFileFromPath(fe.getRealPath()));
						htmlFileStaticDaoImpl.modify(hfs);
						albart.setHfs(hfs);
						albumArticleDaoImpl.modify(albart, false, null);
					}

					jump = false;
					if (albart.getContent().getJumpUrl() != null
							&& !albart.getContent().getJumpUrl().trim().equals("")) {
						jump = true;
					}
					
					AlbumArticleUtil.htmlCreate(albart, messageSource, request, htmlFileStaticDaoImpl, contextPath);
					if (sitemapRebulid) {
						SitemapUtil.write(messageSource, request, albart);
					}
					/*
					 * if (!jump) {
					 * 
					 * AlbumArticleUtil.htmlCreate(request, messageSource, contextPath, albart);
					 * albart.getHfs().setStatus(true);
					 * htmlFileStaticDaoImpl.modify(albart.getHfs());
					 * 
					 * 
					 * 
					 * }
					 */

					SearchTotalModel srt = albart.getSrt();

					if (srt == null) {
						albart = AlbumArticleUtil.srtUpdate(albart);
						srt = albart.getSrt();
						srt.setHref(AlbumArticleUtil.url(albart, messageSource, request));
						if (albart.isProhibit() || !albart.isStatus() || albart.getAlbum().isDeled() || !albart.getAlbum().isStatus() || !albart.getAlbum().getGenre().isStatus()) {
							srt.setStatus(false);
						}
						albart.setSrt(srt);
						albumArticleDaoImpl.modify(albart, false, null);
					} else {
						if (albart.isProhibit() || !albart.isStatus() || albart.getAlbum().isDeled() || !albart.getAlbum().isStatus() || !albart.getAlbum().getGenre().isStatus()) {
							srt.setStatus(false);
						}
						srt.setHref(AlbumArticleUtil.url(albart, messageSource, request));
						searchTotalModelDaoImpl.modify(srt);
					}
					
				}
				
				currTitle = messageSource.getMessage("title.albart", null, "albart", null);
				currTitle += " -- " + albart.getContent().getSubject();

				break;
			}

		}
		lr.setMsg(currTitle);
		if (id >= (total - 1)) {
			session.removeAttribute("taglist");
		}
		if (endn > 0 && endn <= id) {
			lr.setRetult(-3);
			lr.setValue(total);

			session.removeAttribute("taglist");
		}
		return lr;

	}

	// 批量静态化，暂不用
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = "/custom/{lastid}/{finished}/{total}")
	@Token(ajax = true, csrf = true, contrast = true, admin = true, failedPage = FAILED, msgKey = "fail.permission", failedReturnUrl = ADMINFAILRETURN)
	public LongPollingReturn staticFiles(@PathVariable(value = "lastid", required = false) Integer lastid,
			@PathVariable(value = "finished", required = false) Integer finished,
			@PathVariable(value = "total", required = false) Integer total,
			@RequestParam(value = "tagstr", required = false) String tagstr, HttpServletRequest request,
			HttpSession session) {
		long startT = System.currentTimeMillis();
		long tid = 0L;
		String currTitle = "";
//  		System.out.println("tagstr:"+tagstr);
		if (tagstr.indexOf("album_") > -1) { // 因为更新专辑会同时更新频道，所以如果选了更新频道，则去除。
			tagstr = StringUtil.strReplace(tagstr, "albgenre_", "");
		}
		String[] sArray = tagstr.split("_");
		List<HtmlStaticTarget> slist;

		if (finished == null) {
			finished = 0;
		}
		if (lastid == null) {
			lastid = 0;
		}
		/*
		 * 记录保存list的时间，超过10秒钟即无效
		 */
		long taglistActivityTime = (long) session.getAttribute("taglistActivityTime");
		if (taglistActivityTime > 0L && (System.currentTimeMillis() - taglistActivityTime) > 10000) {
			session.removeAttribute("taglist");
			session.removeAttribute("taglistActivityTime");
		} else {
			session.setAttribute("taglistActivityTime", System.currentTimeMillis());
		}
		slist = (List<HtmlStaticTarget>) session.getAttribute("taglist");
		if (slist != null && !slist.isEmpty()) {
			total = slist.size();
		}
		boolean rebuild = false;
		if (messageSource.getMessage("file.html.art.rebulid", null, "false", null).trim().equalsIgnoreCase("true")) {
			rebuild = true;
		}

		if (slist == null || slist.isEmpty()) {
			slist = new ArrayList<HtmlStaticTarget>();
			for (int step = 0; step < sArray.length; step++) {
				if (sArray[step].trim().equalsIgnoreCase("index")) {
					tid++;
					HtmlStaticTarget targ = new HtmlStaticTarget();
					targ.setId(tid);
					targ.setTarID(0);
					targ.setTypeNum(0);
					targ.setTitle(messageSource.getMessage("root.title", null, "root", null));
					targ.setTypeStr(messageSource.getMessage("title.index", null, "index", null));
					slist.add(targ);

				} else if (sArray[step].trim().equalsIgnoreCase("nav")) {
					List<ArticleGroup> list = groupDaoImpl.queryAllForStatic();

					for (ArticleGroup ag : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(ag.getId());
						targ.setId(tid);
						targ.setTypeNum(1);
						targ.setTitle(ag.getName());
						targ.setTypeStr(messageSource.getMessage("title.nav", null, "nav", null));
						slist.add(targ);
					}

				} else if (sArray[step].trim().equalsIgnoreCase("art")) {
					List<Long> list = articleDaoImpl.queryAllPassedID(0);

					for (long aid : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(aid);
						targ.setId(tid);
						targ.setTypeNum(2);
						targ.setTypeStr(messageSource.getMessage("title.article", null, "article", null));
						slist.add(targ);
					}
				} else if (sArray[step].trim().equalsIgnoreCase("albgenre")) {
					List<Albgenre> list = albgenreDaoImpl.queryAll();

					for (Albgenre genre : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(genre.getId());
						targ.setId(tid);
						targ.setTypeNum(3);
						targ.setTypeStr(messageSource.getMessage("title.albgenre", null, "albgenre", null));
						slist.add(targ);
					}
				} else if (sArray[step].trim().equalsIgnoreCase("album")) {
					List<Long> list = albumDaoImpl.queryAllPassedID();

					for (long aid : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(aid);
						targ.setId(tid);
						targ.setTypeNum(4);
						targ.setTypeStr(messageSource.getMessage("title.album", null, "album", null));
						slist.add(targ);
					}
				} else if (sArray[step].trim().equalsIgnoreCase("albart")) {
					List<Long> list = albumArticleDaoImpl.queryAllPassedID(0);
					for (long aid : list) {
						tid++;
						HtmlStaticTarget targ = new HtmlStaticTarget();
						targ.setTarID(aid);
						targ.setId(tid);
						targ.setTypeNum(5);
						targ.setTypeStr(messageSource.getMessage("title.albart", null, "article", null));
						slist.add(targ);
					}
				}
			}

			session.setAttribute("taglist", slist);
			currTitle = "init..";
			total = slist.size();
		}
		boolean jump = false;
		String indexFile = messageSource.getMessage("file.html.default", null, "index.html", null);
		String strCreateDateTime, fromurl, realPath;

		LongPollingReturn lpr = new LongPollingReturn();
		int lid = lastid;
		for (int i = lid; i < total; i++) {
			jump = false;
			HtmlStaticTarget targ = slist.get(i);
			switch (targ.getTypeNum()) {
			case 0:

				String charset = messageSource.getMessage("charset", null, "utf-8", null);
				String htmlRoot = messageSource.getMessage("group.file.static.root", null, "html", null);
				if (htmlRoot != null
						&& (htmlRoot.trim().equalsIgnoreCase("WebRoot") || htmlRoot.trim().equalsIgnoreCase("root"))) {
					htmlRoot = "";
				}
				strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
				fromurl = contextPath + "show_portal/index";
				String index = FileUtil.appPath() + indexFile;

				FileUtil.htmlBySniff(fromurl, index, strCreateDateTime, charset);

				currTitle = messageSource.getMessage("title.index", null, "index", null);
				break;
			case 1:
				ArticleGroup ag = groupDaoImpl.findByID(targ.getTarID());
				if (GroupUtil.openChk(ag) && (ag.getJumpToUrl() == null || ag.getJumpToUrl().trim().equals(""))) {
					htmlRoot = messageSource.getMessage("group.file.static.root", null, "html", null);
					if (htmlRoot != null && (htmlRoot.trim().equalsIgnoreCase("WebRoot")
							|| htmlRoot.trim().equalsIgnoreCase("root"))) {
						htmlRoot = "";
					}
					charset = messageSource.getMessage("charset", null, "utf-8", null);
					realPath = FileUtil.appPath() + GroupUtil.htmlFolder(ag, htmlRoot);
					realPath = FileUtil.repairFilePath(realPath) + indexFile;
					strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
					fromurl = contextPath + "show_portal/nav/" + ag.getId();
					FileUtil.htmlBySniff(fromurl, realPath, strCreateDateTime, charset);

				}
				currTitle = messageSource.getMessage("title.nav", null, "nav", null);
				currTitle += " -- " + ag.getName();
				break;
			case 2:
				Article art = articleDaoImpl.findByID(targ.getTarID());
				String jumprul = art.getJumpUrl();

				if (jumprul != null && !jumprul.trim().equals("")) {
					jump = true;
				}
				if (!jump) {
					if (rebuild) {
						FileEl fe = ArticleUtil.feBuild(messageSource, request, art, true);
						HtmlFileStatic hfs = art.getHfs();
						hfs = art.getHfs();
						hfs.setRealPath(fe.getRealPath());
						hfs.setUrl(fe.getUrl());
						hfs.setFilename(FileUtil.getFileFromPath(fe.getRealPath()));
						htmlFileStaticDaoImpl.modify(hfs);

						art.getCb().setHosturl(ArticleUtil.getHref(messageSource, request, art));
						commentBridgeDaoImpl.modify(art.getCb());

					}
					ArticleUtil.htmlCreate(request, messageSource, contextPath, art);

					art.getHfs().setStatus(true);
					articleDaoImpl.modify(art);
				}

				currTitle = messageSource.getMessage("title.article", null, "article", null);
				currTitle += " -- " + art.getSubject();
				break;
			case 3:
				Albgenre albgenre = albgenreDaoImpl.findByID(targ.getTarID());
				if (!albgenre.isStatus()) {
					continue;
				}
				AlbgenreUtil.htmlCreate(albgenre, messageSource, contextPath);

				currTitle = messageSource.getMessage("title.albgenre", null, "albgenre", null);
				currTitle += " -- " + albgenre.getName();
				break;
			case 4:
				Album album = albumDaoImpl.findByID(targ.getTarID());
				if (album.isDeled() || !album.isStatus()) {
					continue;
				}
				albumDaoImpl.modify(album);
				AlbumUtil.htmlCreate(album, messageSource, contextPath, false);

				currTitle = messageSource.getMessage("title.album", null, "album", null);

				currTitle += " -- " + album.getName();
				break;
			case 5:
				AlbumArticle albart = albumArticleDaoImpl.findByID(targ.getTarID());
				if (!albart.isStatus() || albart.isProhibit() || !albart.getAlbum().isStatus()
						|| albart.getAlbum().isDeled() || !albart.getAlbum().getGenre().isStatus()) {
					continue;
				}
				albumArticleDaoImpl.modify(albart, false, null);
				boolean m = false;
				if (albart != null && albart.isStatus()) {

					if (albart.getHfs() == null) {
						HtmlFileStatic hfs = new HtmlFileStatic();
						FileEl fe = AlbumArticleUtil.feBuild(messageSource, request, albart, false);
						hfs.setRealPath(fe.getRealPath());
						hfs.setUrl(fe.getUrl());
						hfs.setFilename(FileUtil.getFileFromPath(fe.getRealPath()));
						htmlFileStaticDaoImpl.add(hfs);
						albart.setHfs(hfs);
						albumArticleDaoImpl.modify(albart, false, null);
						m = true;
					}
					if (rebuild || albart.getHfs().getRealPath() == null
							|| albart.getHfs().getRealPath().trim().equals("")) {
						HtmlFileStatic hfs = albart.getHfs();
						FileEl fe = AlbumArticleUtil.feBuild(messageSource, request, albart, false);
						hfs.setRealPath(fe.getRealPath());
						hfs.setUrl(fe.getUrl());
						hfs.setFilename(FileUtil.getFileFromPath(fe.getRealPath()));
						htmlFileStaticDaoImpl.modify(hfs);
						albart.setHfs(hfs);
						albumArticleDaoImpl.modify(albart, false, null);
						m = true;
					}

					jump = false;
					if (albart.getContent().getJumpUrl() != null
							&& !albart.getContent().getJumpUrl().trim().equals("")) {
						jump = true;
					}
					AlbumArticleUtil.htmlCreate(albart, messageSource, request, htmlFileStaticDaoImpl, contextPath);
					/*
					 * if (!jump) {
					 * 
					 * AlbumArticleUtil.htmlCreate(request, messageSource, contextPath, albart);
					 * albart.getHfs().setStatus(true);
					 * htmlFileStaticDaoImpl.modify(albart.getHfs()); }
					 */
					if (!m) {
						albumArticleDaoImpl.modify(albart, false, null);
					}
					CommentBridge cb = albart.getCb();
					cb = commentBridgeDaoImpl.findByID(cb.getId());
					if (cb.getHosturl() == null || cb.getHosturl().trim().equals("")) {
						cb.setHosturl(albart.getHfs().getUrl());
						commentBridgeDaoImpl.modify(cb);
					}
					currTitle = messageSource.getMessage("title.albart", null, "albart", null);
					currTitle += " -- " + albart.getContent().getSubject();
				}

				break;
			}

			lpr.setLastID(targ.getId());
			lpr.setFinished(Integer.valueOf(String.valueOf(targ.getId())));
			lpr.setMsg(currTitle);
			long endT = System.currentTimeMillis();
			if (endT - startT >= 4200) {
				break;
			}
			lastid = i;
		}

		lpr.setTag(1);
		lpr.setTotal(total);

		if (lastid == total) {
			session.removeAttribute("taglist");
		}
		return lpr;
	}

	@RequestMapping(value = "/album/{aid}")
	@Token(ajax = false, csrf = true, contrast = true, login = true, failedPage = FORBIDU, msgKey = "fail.permission")
	public ModelAndView albstart(@PathVariable(value = "aid", required = true) long aid, HttpServletRequest request,
			Map<String, Object> map) {
		long uid = LoginUtil.uid(messageSource, request);
		Album album = albumDaoImpl.findByID(aid);

		if (album == null || album.isDeled() || !album.isStatus()
				|| !PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
			return MavUtil.mav1(FORBIDU, "");
		}
		map.put("albumID", aid);
		map.put("spacePercent", 0);

		return MavUtil.mav1("jsp/album/static", "");

	}

	// 专辑静态化
	@ResponseBody
	@RequestMapping(value = "/album/{aid}/{lastid}/{finished}/{total}")
	@Token(ajax = true, csrf = true, contrast = true, login = true, failedPage = FORBIDU, msgKey = "fail.permission")
	public LongPollingReturn staticAlbFiles(@PathVariable(value = "aid", required = true) long aid,
			@PathVariable(value = "lastid", required = false) Integer lastid,
			@PathVariable(value = "finished", required = false) Integer finished,
			@PathVariable(value = "total", required = false) Integer total,
			@RequestParam(value = "tagstr", required = false) String tagstr, HttpServletRequest request,
			HttpSession session) {
		LongPollingReturn lpr = new LongPollingReturn();
		long startT = System.currentTimeMillis();
		long uid = LoginUtil.uid(messageSource, request);

		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			lpr.setResult(-3);
			return lpr;
		}

		Album album = albumDaoImpl.findByID(aid);
		if (album == null || album.isDeled() || !album.isStatus() || !album.getGenre().isStatus()) {
			lpr.setResult(-11);
			return lpr;
		}
		if (!PartnerUtil.basicPowerChk(uid, album, albumPartnerDaoImpl)) {
			lpr.setResult(-2);
			return lpr;
		}
		long tid = 0L;

		if (finished == null) {
			finished = 0;
		}
		if (lastid == null) {
			lastid = 0;
		}

		if (finished == 0) {
			// 生成专辑首页
			AlbumUtil.htmlCreate(album, messageSource, contextPath, false);
		}
		@SuppressWarnings("unchecked")
		List<HtmlStaticTarget> slist = (List<HtmlStaticTarget>) session.getAttribute("taglist");
		if (slist != null && !slist.isEmpty()) {
			total = slist.size();
		}
		if (slist == null || slist.isEmpty()) {
			slist = new ArrayList<HtmlStaticTarget>();
			List<Long> list = albumArticleDaoImpl.queryAllPassedID(aid);
			total = list.size();
			for (long artid : list) {
				tid++;
				HtmlStaticTarget targ = new HtmlStaticTarget();
				targ.setTarID(artid);
				targ.setId(tid);
				targ.setTypeNum(5);
				targ.setTypeStr(messageSource.getMessage("title.albart", null, "article", null));
				slist.add(targ);
			}
		}
		session.setAttribute("taglist", slist);
		int lid = lastid;
		for (int i = lid; i < total; i++) {
			HtmlStaticTarget targ = slist.get(i);
			AlbumArticle art = albumArticleDaoImpl.findByID(targ.getTarID());
			if (art == null || !art.isStatus() || art.isProhibit() || !art.getAlbum().isStatus()
					|| !art.getAlbum().getGenre().isStatus()) {
				continue;
			}
			
			AlbumArticleUtil.htmlCreate(art, messageSource, request, htmlFileStaticDaoImpl, contextPath);

			SearchTotalModel srt = art.getSrt();

			if (srt == null) {
				art = AlbumArticleUtil.srtUpdate(art);
				srt = art.getSrt();
				srt.setHref(AlbumArticleUtil.url(art, messageSource, request));
				art.setSrt(srt);
				albumArticleDaoImpl.modify(art, false, null);
			} else {
				srt.setHref(AlbumArticleUtil.url(art, messageSource, request));
				searchTotalModelDaoImpl.modify(srt);
			}

			lpr.setLastID(targ.getId());
			lpr.setFinished(Integer.valueOf(String.valueOf(targ.getId())));
			lpr.setMsg(art.getContent().getSubject());
			long endT = System.currentTimeMillis();
			if (endT - startT >= 4200) {
				break;
			}
			lastid = i;

		}

		lpr.setTag(1);
		lpr.setTotal(total);

		if (lastid == total) {
			session.removeAttribute("taglist");
		}

		return lpr;
	}

	private static String getExtUrl(HttpServletRequest request, String interUrl) {

		String srvurl = HttpUtil.getSrvUrl(request, false);

		/*
		 * String cpStr=request.getContextPath(); if (cpStr!=null &&
		 * !cpStr.trim().equals("") || !cpStr.trim().equals("/") &&
		 * !interUrl.startsWith(cpStr)) { interUrl=cpStr+interUrl; }
		 */
		srvurl += "/";
		srvurl += interUrl;
		srvurl = HttpUtil.repairUrl(srvurl);
		return srvurl;
	}

}
