package com.lerx.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbgenreDao;
import com.lerx.dao.iface.IAlbumArticleClassifyDao;
import com.lerx.dao.iface.IAlbumArticleDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumExternalLinkDao;
import com.lerx.dao.iface.IAlbumFansDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.dao.iface.IArticleDao;
import com.lerx.dao.iface.ICommentBridgeDao;
import com.lerx.dao.iface.ICommentThreadDao;
import com.lerx.dao.iface.IFansGroupDao;
import com.lerx.dao.iface.IGroupDao;
import com.lerx.dao.iface.IHtmlFileStaticDao;
import com.lerx.dao.iface.IPortalDao;
import com.lerx.dao.iface.IRoleDao;
import com.lerx.dao.iface.ITempletAlbgenreMainDao;
import com.lerx.dao.iface.ITempletPortalMainDao;
import com.lerx.dao.iface.IUserArtsCountDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.dao.iface.IVisitArchivesDao;
import com.lerx.dao.iface.IVisitorCountInPeriodDao;
import com.lerx.dao.iface.IVisitorIPRecordDao;
import com.lerx.dao.iface.IVisitorsBookDao;
import com.lerx.entities.Article;
import com.lerx.entities.ArticleGroup;
import com.lerx.entities.CommentBridge;
import com.lerx.entities.CommentThread;
import com.lerx.entities.Portal;
import com.lerx.entities.TempletComment;
import com.lerx.entities.TempletPortalMain;
import com.lerx.entities.TempletSubElement;
import com.lerx.entities.User;
import com.lerx.entities.UserArtsCount;
import com.lerx.entities.VisitArchives;
import com.lerx.entities.VisitorIPRecord;
import com.lerx.entities.VisitorsBook;
import com.lerx.hql.entities.Rs;
import com.lerx.ip.util.IPUtil;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.AppEnvParms;
import com.lerx.portal.obj.FlowOut;
import com.lerx.portal.obj.EnvirSet;
import com.lerx.portal.obj.GlobalTagsAnalyzeReturn;
import com.lerx.portal.obj.LayerUserRankRs;
import com.lerx.portal.obj.UserPanelCodeArgs;
import com.lerx.portal.obj.PortalStatInfo;
import com.lerx.portal.obj.TempletCommentFmtRequisite;
import com.lerx.portal.obj.UserArtsRanking;
import com.lerx.sys.obj.DatetimeSpanSuffixTxt;
import com.lerx.sys.obj.EnvParms;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;
import com.lerx.sys.util.TokenUtil;
import com.lerx.v6.util.ArticleUtil;
import com.lerx.v6.util.CommUtil;
import com.lerx.v6.util.ConfigUtil;
import com.lerx.v6.util.GroupUtil;
import com.lerx.v6.util.HttpShowUtil;
import com.lerx.v6.util.TempletPortalUtil;
import com.lerx.v6.util.TempletUtil;
import com.lerx.v6.util.UserUtil;
import com.lerx.v6.util.VisitUtil;

@RequestMapping("/show_portal")
@Controller
public class HttpShowPortalHandler {

	@Autowired
	private ITempletPortalMainDao templetPortalMainDaoImpl;
	
	@Autowired
	private ITempletAlbgenreMainDao templetAlbgenreMainDaoImpl;

	@Autowired
	private ResourceBundleMessageSource messageSource;

	@Autowired
	private IPortalDao portalDaoImpl;

	@Autowired
	private IArticleDao articleDaoImpl;

	@Autowired
	private IGroupDao groupDaoImpl;

	@Autowired
	private IUserDao userDaoImpl;

	@Autowired
	private IUserArtsCountDao userArtsCountDaoImpl;

	@Autowired
	private IRoleDao roleDaoImpl;

	@Autowired
	private IVisitorIPRecordDao visitorIPRecordDaoImpl;

	@Autowired
	private IVisitorsBookDao visitorsBookDaoImpl;

	@Autowired
	private IVisitArchivesDao visitArchivesDaoImpl;

	@Autowired
	private IVisitorCountInPeriodDao visitorCountInPeriodDaoImpl;

	@Autowired
	private IHtmlFileStaticDao htmlFileStaticDaoImpl;

	@Autowired
	private ICommentBridgeDao commentBridgeDaoImpl;

	@Autowired
	private ICommentThreadDao commentThreadDaoImpl;
	
	@Autowired
	private IAlbgenreDao albgenreDaoImpl;
	
	@Autowired
	private IAlbumArticleDao albumArticleDaoImpl;
	
	@Autowired
	private IAlbumDao albumDaoImpl;
	
	@Autowired
	private IAlbumArticleClassifyDao albumArticleClassifyDaoImpl;
	
	@Autowired
	private IAlbumExternalLinkDao albumExternalLinkDaoImpl;
	
	@Autowired
	private IAlbumFansDao albumFansDaoImpl;
	
	@Autowired
	private IFansGroupDao fansGroupDaoImpl;
	
	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;

	private EnvirSet envirInit(long gid, long aid, HttpServletRequest request, HttpServletResponse response) {
		EnvirSet es = new EnvirSet();
		es.setStatus(true);
		es.setStartTime(System.currentTimeMillis());
		if (request == null) {
			es.setRequest(HttpUtil.currRequest());
		} else {
			es.setRequest(request);
		}
		if (response == null) {
			es.setResponse(HttpUtil.currResponse());
		} else {
			es.setResponse(response);
		}
		es.setGid(gid);
		es.setAid(aid);
		es.setMessageSource(messageSource);
		es.setPortalDaoImpl(portalDaoImpl);
		es.setGroupDaoImpl(groupDaoImpl);
		es.setTempletPortalMainDaoImpl(templetPortalMainDaoImpl);
		es.setTempletAlbgenreMainDaoImpl(templetAlbgenreMainDaoImpl);
		es.setUserDaoImpl(userDaoImpl);
		es.setUserArtsCountDaoImpl(userArtsCountDaoImpl);
		es.setArticleDaoImpl(articleDaoImpl);
		es.setRoleDaoImpl(roleDaoImpl);
		es.setAlbumDaoImpl(albumDaoImpl);
		es.setAlbgenreDaoImpl(albgenreDaoImpl);
		es.setAlbumArticleDaoImpl(albumArticleDaoImpl);
		es.setAlbumArticleClassifyDaoImpl(albumArticleClassifyDaoImpl);
		es.setAlbumExternalLinkDaoImpl(albumExternalLinkDaoImpl);
		es.setAlbumFansDaoImpl(albumFansDaoImpl);
		es.setFansGroupDaoImpl(fansGroupDaoImpl);
		es.setAlbumPartnerDaoImpl(albumPartnerDaoImpl);
		es.setVisitorIPRecordDaoImpl(visitorIPRecordDaoImpl);
		es.setVisitorsBookDaoImpl(visitorsBookDaoImpl);
		es.setVisitArchivesDaoImpl(visitArchivesDaoImpl);
		es.setVisitorCountInPeriodDaoImpl(visitorCountInPeriodDaoImpl);
		es.setHtmlFileStaticDaoImpl(htmlFileStaticDaoImpl);

		return es;
	}


	

	/*
	 * 取当前日期
	 */
	@ResponseBody
	@RequestMapping("/date")
	@Token(ajax = true,csrf=true)
	public String date(@RequestParam(value = "fmt", required = false) String fmt) {
		fmt = StringUtil.htmlFilter(fmt,true);
		if (fmt==null || fmt.trim().equals("")) {
			return "";
		}
		return TimeUtil.coverLongToStr(System.currentTimeMillis(), fmt);
	}

	/*
	 * 
	 */

	@ResponseBody
	@RequestMapping("/addChk")
	@Token(ajax = true,csrf=true)
	public String artAddChk(Long gid, HttpServletRequest request, HttpServletResponse response) {
		if (gid == null) {
			gid = 0L;
		}
		EnvirSet es = envirInit(gid, 0, request, response);
		return UserUtil.maskChkForArtAdd(es);
	}

	// 栏目IP检测
	@ResponseBody
	@RequestMapping("/navIPChk/{id}")
	@Token(ajax = true,csrf=true)
	public boolean navIPChk(@PathVariable(value = "id", required = false) Long id,HttpServletRequest request) {
		ArticleGroup ag = groupDaoImpl.findByID(id);
		if (ag==null) {
			return false;
		}
		if (ag.getIpVisitAllow()==null || ag.getIpVisitAllow().trim().equals("")) {
			return true;
		}else {
			String ip=IPUtil.getRealRemotIP(request);
			if (IPUtil.isInRange(ip, ag.getIpVisitAllow())) {
				return true;
			}else {
				return false;
			}
		}
	}

	// 返回统计信息psi
	@ResponseBody
	@RequestMapping("/portalStat")
	@Token(ajax = true,csrf=true)
	public PortalStatInfo portalStat() {
		PortalStatInfo psi = new PortalStatInfo();
		psi = articleDaoImpl.stat(psi);
		psi = albumDaoImpl.stat(psi);
		psi = albumArticleDaoImpl.stat(psi);
		psi = userDaoImpl.stat(psi);
		Portal portal = portalDaoImpl.query_update();
		psi.setViews(portal.getVbook().getViewsTotal());
		psi.setIps(portal.getVbook().getIpTotal());
		// System.out.println(psi.toString());
		return psi;
	}

	
	// 返回当天或某天的访问记录数 在VisitorHandler中也有同样的
	@ResponseBody
	@RequestMapping("/visitQuery")
	@Token(ajax = true,csrf=true)
	public VisitArchives visitQuery(long vid, int dayKey) {
		return VisitUtil.visitQuery(vid, dayKey, visitArchivesDaoImpl);
	}

	// 返回用户发布排行
	@ResponseBody
	@RequestMapping(value = "/rank/{mode}")
	@Token(ajax = true,csrf=true)
	public LayerUserRankRs rank(@PathVariable(value = "mode", required = false) Integer mode,
			@RequestParam(value = "page", required = false) Integer page,
			@RequestParam(value = "pagesize", required = false) Integer pagesize) {
		LayerUserRankRs lurr = new LayerUserRankRs();
		if (mode == null) {
			mode = 0;
		}
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		User user;
		Rs rs;
		int step = 0;
		List<UserArtsRanking> list = new ArrayList<UserArtsRanking>();
		java.text.SimpleDateFormat formatter;
		int timeKey;
		switch (mode) {
		case 1: // 本年度排行
			formatter = new java.text.SimpleDateFormat("yyyy");
			timeKey = Integer.valueOf(formatter.format(System.currentTimeMillis()));
			rs = userArtsCountDaoImpl.findTopByUKAndGroup(0, timeKey, 0, page, pagesize);
			break;
		case 2: // 本季度排行
			timeKey = TimeUtil.quarter(System.currentTimeMillis());
			rs = userArtsCountDaoImpl.findTopByUKAndGroup(0, timeKey, 0, page, pagesize);
			break;
		case 3: // 本月
			formatter = new java.text.SimpleDateFormat("yyyyMM");
			timeKey = Integer.valueOf(formatter.format(System.currentTimeMillis()));
			rs = userArtsCountDaoImpl.findTopByUKAndGroup(0, timeKey, 0, page, pagesize);
			break;
		case 4: // 本周排行
			Date weekStamp = TimeUtil.firstDayAtWeek(new Date(System.currentTimeMillis()));
			formatter = new java.text.SimpleDateFormat("yyyyMMdd");
			timeKey = Integer.valueOf(formatter.format(weekStamp.getTime()));
			rs = userArtsCountDaoImpl.findTopByUKAndGroup(0, timeKey, 0, page, pagesize);
			break;
		default: // 文章总通过数
			rs = userDaoImpl.artsPassedRank(page, pagesize);

		}
		UserArtsCount uac;
		for (Object u : rs.getList()) {
			step++;
			UserArtsRanking uar = new UserArtsRanking();
			if (mode == 0) {
				user = (User) u;
				uar.setNum(user.getArtsPassed());
			} else {
				uac = (UserArtsCount) u;
				user = uac.getUser();
				uar.setNum(uac.getArtsPassed());
			}

			uar.setUid(user.getId());
			uar.setUsername(user.getUsername());
			uar.setTrueName(user.getTruename());

			uar.setSn(step);
			list.add(uar);
		}
		lurr.setCount(rs.getCount());
		lurr.setCode(0);
		lurr.setData(list);
		return lurr;
	}

	/*
	 * 用户面板
	 */
	@ResponseBody
	@RequestMapping("/panel")
	@Token(ajax = true,csrf=true)
	public UserPanelCodeArgs panel(Long gid, HttpServletRequest request, HttpServletResponse response,
			@CookieValue(value = "username_lerx", required = false) String username_lerx,
			@CookieValue(value = "password_lerx", required = false) String password_lerx,
			@RequestParam(value = "currEl", required = false) String currEl) {
		
		UserPanelCodeArgs upca=new UserPanelCodeArgs();
		upca.setStatus(0);
		if (gid == null) {
			gid = 0L;
		}
		EnvirSet es = envirInit(gid, 0, request, response);
		long uid = UserUtil.loginRefresh(es, username_lerx, password_lerx);
		TempletPortalMain template = templetPortalMainDaoImpl.findDef();
		TempletPortalMain templet = TempletPortalUtil.currTemplet(es);
		es.setTempletPortal(templet);
		TempletSubElement el = TempletPortalUtil.elInitByTagStr(template, currEl);
		String panelCode;
		if (uid > 0L) {
			panelCode = el.getUserPanelCodeLogin();
			User user = userDaoImpl.findByID(uid);
			if (user != null) {
				panelCode = TempletUtil.roleExclusiveCode(panelCode, user);
				
				String imgHtmlTemplet = TempletPortalUtil.sundriesTag(messageSource, template, "htmlTemplet_img");
				panelCode = UserUtil.fmt(panelCode, user, imgHtmlTemplet);
				upca.setStatus(1);
				upca.setUid(user.getId());
				upca.setUsername(user.getUsername());
			}

		} else {
			panelCode = el.getUserPanelCodeLogout();
			String token = TokenUtil.buildToken();
			if (panelCode == null) {
				panelCode = "";
			}
			panelCode = AnalyzeUtil.replace(panelCode, "tag", "token", token);
		}
		panelCode = TempletUtil.tagToEnvir(panelCode, es);
		panelCode = TempletPortalUtil.tagForResFolder(messageSource, panelCode, template);
		upca.setHtml(panelCode);
		return upca;

	}

	/*
	 * 调查投票区域ajax
	 */
	@ResponseBody
	@RequestMapping(value = "/poll/{aid}")
	@Token(ajax = true,csrf=true)
	public String poll(@PathVariable(value = "aid", required = true) Long aid,
			@RequestParam(value = "titleLen", required = false) Integer titleLen,@RequestParam(value = "overMark", required = false) Integer overMark, HttpServletRequest request,
			HttpServletResponse response) {
		EnvParms ep = HttpUtil.epInit(request, response, null, messageSource);
		if (titleLen == null) {
			titleLen = 0;
		}
		if (overMark == null) {
			overMark=1;
		}
		Article art = articleDaoImpl.findByID(aid);
		TempletPortalMain template = templetPortalMainDaoImpl.findDef();
		String html = TempletPortalUtil.sundriesTag(messageSource, template, "htmlTemplet_poll");
		String imgHtmlTemplet = TempletPortalUtil.sundriesTag(messageSource, template, "htmlTemplet_img");
		AppEnvParms aep=TempletUtil.init(ep, template.getResFolder(), 0);
		if (art != null && art.getAgroup() != null && art.getPoll() != null && art.getPoll().isStatus()
				&& GroupUtil.poolchk(art.getAgroup())) {
			html = ArticleUtil.fmt(aep, html, art, imgHtmlTemplet, 0,0, overMark,false);
		} else {
			html = "";
		}

		html = AnalyzeUtil.replace(html, "tag", "contextPath", request.getContextPath());

		return html;
	}

	/*
	 * 评论表单加载
	 */

	@ResponseBody
	@RequestMapping(value = "/commform/{aid}")
	@Token(ajax = true,csrf=true)
	public String commForm(@PathVariable(value = "aid", required = true) Long aid,
			@CookieValue(value = "uid_lerx", required = false) String uid_lerx, HttpServletRequest request,
			HttpSession session, HttpServletResponse response) {
		Portal portal = portalDaoImpl.query_update();
		if (!portal.isComm()) {
			return "";
		}

		if (aid == null) {
			return "";
		}
		Article art = articleDaoImpl.findByID(aid);
		if (art==null) {
			return "";
		}
		ArticleGroup ag = art.getAgroup();
		if (!ag.isComm()) {
			return "";
		}

		CommentBridge cb = art.getCb();

		cb = commentBridgeDaoImpl.findByID(cb.getId());

		if (!cb.isStatus()) {
			return "";
		}

		TempletPortalMain template = templetPortalMainDaoImpl.findDef();
		TempletComment templatec = template.getElComment();
		String html = templatec.getFormCode();

		html = AnalyzeUtil.replace(html, "tag", "bid", "" + cb.getId());
		html = AnalyzeUtil.replace(html, "tag", "aid", "" + aid);
		
		EnvirSet es;
		es = envirInit(ag.getId(), aid, request, null);
		html = TempletUtil.tagToEnvir(html, es);
		html = TempletPortalUtil.tagForResFolder(messageSource, html, template);
		return html;

	}

	/*
	 * 评论加载
	 */

	@ResponseBody
	@RequestMapping(value = "/commlist/{id}")
	@Token(ajax = true,csrf=true)
	public FlowOut commlist(@PathVariable(value = "id", required = true) Long id,
			@RequestParam(value = "aid", required = false) Long aid,
			@RequestParam(value = "page", required = false) Integer page,
			@RequestParam(value = "pageSize", required = false) Integer pageSize,
			@CookieValue(value = "uid_lerx", required = false) String uid_lerx, HttpServletRequest request,
			HttpSession session, HttpServletResponse response) {
		FlowOut co = new FlowOut();
		co.setCount(0);
		co.setPage(1);
		co.setPageCount(0);
		co.setHtml("");
		co.setPageSize(pageSize);
		Portal portal = portalDaoImpl.query_update();
		if (!portal.isComm()) {
			return co;
		}

		CommentBridge cb = null;
		if (id == null) {
			return co;
		}
		cb = commentBridgeDaoImpl.findByID(id);

		if (cb == null || !cb.isStatus()) {
			return co;
		}
		ArticleGroup ag;

		if (aid == null) {
			return co;
		} else {
			Article art = articleDaoImpl.findByID(aid);

			if (art == null) {
				return co;
			} else {
				ag = art.getAgroup();
				if (ag == null || !ag.isComm()) {
					return co;
				}
			}
		}

		if (page == null) {
			page = 0;
		}

		if (pageSize == null) {
			pageSize = 10;
		}
		boolean deletedShow = false;
		User user = null;
		if (uid_lerx != null && !uid_lerx.trim().equals("") && StringUtil.isNumber(uid_lerx)) {
			long uid = Long.valueOf(uid_lerx);
			user = userDaoImpl.findByID(uid);
		}
		boolean master = false;
		/*
		 * if ((user!=null && cb.getUser()!=null && (user.getId() - cb.getUser().getId()
		 * == 0)) || LoginUtil.admin0Chk(messageSource, session)) { master=true;
		 * 
		 * }
		 */

		if (user != null && cb.getUser() != null) {
			if ((user.getId() - cb.getUser().getId() == 0)) {
				master = true;
			}
			if (UserUtil.isadmin(user)) {
				master = true;
				deletedShow = true;
			}
		}
		int showMode = 1;
		if (master) {
			showMode = 0;
		}
		if (!messageSource.getMessage("comment.thread.deleted.adminshow", null, "false", null).trim().equalsIgnoreCase("true")) {
			deletedShow=false;
		}
		Rs rs = commentThreadDaoImpl.queryByBid(cb.getId(), page, pageSize, false, showMode, deletedShow);
		TempletPortalMain template = ag.getTemplet();
		if (template==null) {
			template = templetPortalMainDaoImpl.findDef();
		}
		TempletComment templatec = template.getElComment();
		String lf =templatec.getItemLoopCode();
		if (lf==null || lf.trim().equals("")) {
			lf = TempletPortalUtil.sundriesTag(messageSource, template, "htmlTemplet_comm_loop");
		}
		String tmp, tmpAll = "";
		String imgHtmlTemplet = TempletPortalUtil.sundriesTag(messageSource, template, "htmlTemplet_img");
		String funHtmlDel = templatec.getActDelCode();
		String funHtmlPass = templatec.getActPassCode();
		String replyAdd = templatec.getActReplyCode();
		/*
		 * String funHtmlDel = TempletUtil.sundriesTag(messageSource,template,
		 * "htmlTemplet_comm_loop_act_del"); String funHtmlPass =
		 * TempletUtil.sundriesTag(messageSource,template,
		 * "htmlTemplet_comm_loop_act_pass"); String replyAdd =
		 * TempletUtil.sundriesTag(messageSource,template,
		 * "htmlTemplet_comm_loop_reply_add");
		 */
		String anonymity = TempletPortalUtil.sundriesTag(messageSource, template, "anonymity");
		String headDef = TempletPortalUtil.sundriesTag(messageSource, template, "headDef");
		DatetimeSpanSuffixTxt dsst = TempletPortalUtil.sundriesTimesLostedTag(template);
		TempletCommentFmtRequisite tcfr = new TempletCommentFmtRequisite();

		tcfr.setFunHtmlPass(funHtmlPass);
		tcfr.setImgHtmlTemplet(imgHtmlTemplet);
		tcfr.setReplyAdd(replyAdd);
		tcfr.setLf(lf);
		tcfr.setMaster(master);
		tcfr.setDsst(dsst);
		tcfr.setAnonymity(anonymity);
		tcfr.setHeadDef(headDef);
		tcfr.setFunHtmlDel(funHtmlDel);
		tcfr.setAvatarNull(ConfigUtil.getAvatarNullFile(messageSource, request));
		
		if (portal.isCommBack()) {
			tcfr.setInform(1);
		}else {
			tcfr.setInform(0);
		}
		
		for (Object o : rs.getList()) {
			CommentThread ct = (CommentThread) o;
			tcfr.setLf(lf);
			tmp = CommUtil.fmt(tcfr, ct);
			tmpAll += tmp;
		}

		tmpAll = AnalyzeUtil.replace(tmpAll, "tag", "contextPath", request.getContextPath());
		co.setHtml(tmpAll);
		co.setPage(rs.getPage());
		co.setPageCount(rs.getPageCount());
		co.setCount(rs.getCount());
		return co;

	}

	/*
	 * 会员发布排行
	 * 
	 */
	@ResponseBody
	@RequestMapping(value = "/rank")
	@Token(ajax = true,csrf=true)
	public String rank(@RequestParam(value = "pageSize", required = false) Integer pageSize, HttpServletRequest request,
			HttpServletResponse response) {
		return "";
	}

	/*
	 * 栏目热点文章 byclicks 指按点击量
	 */
	@ResponseBody
	@RequestMapping(value = "/hot/{gid}")
	@Token(ajax = true,csrf=true)
	public String hot(@PathVariable(value = "gid", required = true) Long gid,
			@RequestParam(value = "byclicks", required = false) Integer byclicks,
			@RequestParam(value = "pageSize", required = false) Integer pageSize,
			@RequestParam(value = "titleLen", required = false) Integer titleLen,
			@RequestParam(value = "overMark", required = false) Integer overMark,HttpServletRequest request,
			HttpServletResponse response) {

		EnvParms ep = HttpUtil.epInit(request, response, null, messageSource);
		
		if (titleLen == null) {
			titleLen = 0;
		}
		if (pageSize == null) {
			pageSize = 10;
		}
		if (overMark==null) {
			overMark=1;
		}
		TempletPortalMain template = templetPortalMainDaoImpl.findDef();
		AppEnvParms aep=TempletUtil.init(ep, template.getResFolder(), 0);
		String lf = TempletPortalUtil.sundriesTag(messageSource, template, "htmlTemplet_hot");
		Rs rs;
		if (byclicks == null) {
			byclicks = 0;
		}
		if (byclicks == 1) {
			rs = articleDaoImpl.clicksByGid(gid, 0, 1, pageSize);
		} else {
			rs = articleDaoImpl.hotByGid(gid, 0, 1, pageSize);
		}

		String html = "", tmp;
		@SuppressWarnings("unchecked")
		List<Article> artList = (List<Article>) rs.getList();
		for (Article art : artList) {
			tmp = lf;
			tmp = ArticleUtil.fmt(aep, tmp, art, "", titleLen,0,overMark, false);
			html += tmp;
		}
		return html;

	}

	/*
	 * 随机取文章
	 */
	@ResponseBody
	@RequestMapping(value = "/rand/{gid}")
	@Token(ajax = true,csrf=true)
	public String rand(@PathVariable(value = "gid", required = true) Long gid,
			@RequestParam(value = "pageSize", required = false) Integer pageSize,
			@RequestParam(value = "titleLen", required = false) Integer titleLen,
			@RequestParam(value = "overMark", required = false) Integer overMark,HttpServletRequest request,
			HttpServletResponse response) {
		EnvParms ep = HttpUtil.epInit(request, response, null, messageSource);
		if (titleLen == null) {
			titleLen = 0;
		}
		if (pageSize == null) {
			pageSize = 10;
		}
		if (overMark == null) {
			overMark=1;
		}
		TempletPortalMain template = templetPortalMainDaoImpl.findDef();
		AppEnvParms aep=TempletUtil.init(ep, template.getResFolder(), 0);
		String lf = TempletPortalUtil.sundriesTag(messageSource, template, "htmlTemplet_hot");
		Rs rs;
		rs = articleDaoImpl.randByGid(gid, 1, pageSize);

		String html = "", tmp;
		@SuppressWarnings("unchecked")
		List<Article> artList = (List<Article>) rs.getList();
		for (Article art : artList) {
			tmp = lf;
			tmp = ArticleUtil.fmt(aep, tmp, art, "", titleLen,0,overMark, false);
			html += tmp;
		}
		return html;

	}

	/*
	 * 个人热点文章 byclicks 指按点击量
	 */
	@ResponseBody
	@RequestMapping(value = "/personalHot/{uid}/{gid}")
	@Token(ajax = true,csrf=true)
	public String personalHot(@PathVariable(value = "uid", required = true) Long uid,
			@PathVariable(value = "gid", required = false) Long gid,
			@RequestParam(value = "byclicks", required = false) Integer byclicks,
			@RequestParam(value = "pageSize", required = false) Integer pageSize,
			@RequestParam(value = "titleLen", required = false) Integer titleLen,
			@RequestParam(value = "overMark", required = false) Integer overMark,HttpServletRequest request,
			HttpServletResponse response) {
		EnvParms ep = HttpUtil.epInit(request, response, null, messageSource);
		if (titleLen == null) {
			titleLen = 0;
		}
		if (pageSize == null) {
			pageSize = 10;
		}
		if (gid == null) {
			gid = 0L;
		}
		if (overMark==null) {
			overMark=1;
		}
		TempletPortalMain template = templetPortalMainDaoImpl.findDef();
		AppEnvParms aep=TempletUtil.init(ep, template.getResFolder(), 0);
		String lf = TempletPortalUtil.sundriesTag(messageSource, template, "htmlTemplet_hot");
		Rs rs;
		if (byclicks == null) {
			byclicks = 0;
		}
		if (byclicks == 1) {
			rs = articleDaoImpl.clicksByUid(uid, gid, 0, 1, pageSize);
		} else {
			rs = articleDaoImpl.hotByUid(uid, gid, 0, 1, pageSize);
		}

		String html = "", tmp;
		@SuppressWarnings("unchecked")
		List<Article> artList = (List<Article>) rs.getList();
		for (Article art : artList) {
			tmp = lf;
			tmp = ArticleUtil.fmt(aep, tmp, art, "", titleLen,0,overMark, false);
			html += tmp;
		}
		return html;

	}

	/*
	 * 首页被阅读信息
	 */
	@ResponseBody
	@RequestMapping(value = "/indexViewShow")
	@Token(ajax = true,csrf=true)
	public String indexVisitfun(@RequestParam(value = "url", required = false) String url,
			@RequestParam(value = "referer", required = false) String referer, HttpServletRequest request,
			@RequestParam(value = "bymobile", required = false) Integer bymobile,
			HttpServletResponse response) {
		if (bymobile==null) {
			bymobile=0;
		}
		String html = "";
		EnvirSet es = envirInit(0, 0, request, response);
		Portal portal = portalDaoImpl.query_update();
		VisitorsBook vbook = portal.getVbook();
		VisitUtil.visitorRefresh(es, vbook, "111", url, referer,bymobile); // 更新浏览者信息
		return html;
	}

	/*
	 * 栏目页被阅读信息
	 */
	@ResponseBody
	@RequestMapping(value = "/navViewShow/{id}")
	@Token(ajax = true,csrf=true)
	public String navVisitfun(@PathVariable(value = "id", required = true) Long id,
			@RequestParam(value = "url", required = false) String url,
			@RequestParam(value = "referer", required = false) String referer, HttpServletRequest request,
			@RequestParam(value = "bymobile", required = false) Integer bymobile,
			HttpServletResponse response) {
		if (bymobile==null) {
			bymobile=0;
		}
		String html = "";
		if (id == null || id == 0) {
			return html;
		}
		int hotnOfVisit,hotnOfIP;
		hotnOfVisit=Integer.valueOf(messageSource.getMessage("vbook.new.visitor.value", null, "0", null));
		hotnOfIP=Integer.valueOf(messageSource.getMessage("vbook.new.ip.value", null, "5", null));
		ArticleGroup agroup = groupDaoImpl.findByID(id);
		long gid = agroup.getId();
		EnvirSet es = envirInit(gid, 0, request, response);
		Portal portal = portalDaoImpl.query_update();
		VisitorsBook vbook = portal.getVbook();
		VisitUtil.visitorRefresh(es, vbook, "101", url, referer,bymobile); // 更新浏览者信息
		vbook = agroup.getVbook();
		boolean newip=VisitUtil.visitorRefresh(es, vbook, "111", url, referer,bymobile); // 更新浏览者信息
		HttpShowUtil.updateAgHotn(groupDaoImpl, agroup, newip, hotnOfVisit, hotnOfIP);
		ArticleGroup group = groupDaoImpl.findByID(gid);
		List<ArticleGroup> list = groupDaoImpl.queryParentBySubID(group.getId(), 1);
		for (ArticleGroup g : list) {
			vbook = g.getVbook();
			newip=VisitUtil.visitorRefresh(es, vbook, "110", url, referer,bymobile); // 更新浏览者信息
			HttpShowUtil.updateAgHotn(groupDaoImpl, g, newip, hotnOfVisit, hotnOfIP);
		}
		es.setGid(gid);
		TempletPortalMain templet = es.getTempletPortal();
		if (templet==null) {
			templet = TempletPortalUtil.currTemplet(es);
			es.setTempletPortal(templet);
		}
		
		html = TempletPortalUtil.sundriesTag(messageSource,templet, "htmlTemplet_view");
		/*
		 * ,htmlTemplet_view:浏览数：{$tag\58views$} IP数：{$tag\58ips$}
		 * 上次来访IP：{$tag\58lastip$}
		 */
		// html = TempletUtil.escape(html);
		if (agroup.getVbook()!=null) {
			html = AnalyzeUtil.replace(html, "tag", "views", "" + agroup.getVbook().getViewsTotal());
			html = AnalyzeUtil.replace(html, "tag", "ips", "" + agroup.getVbook().getIpTotal());
			html = AnalyzeUtil.replace(html, "tag", "vbID", agroup.getVbook().getId());
		}else {
			html = AnalyzeUtil.replace(html, "tag", "views", ""+0);
			html = AnalyzeUtil.replace(html, "tag", "ips", "");
			html = AnalyzeUtil.replace(html, "tag", "vbID", ""+0);
		}
		
		VisitorIPRecord vir = es.getVisitorIPRecordDaoImpl().findLast(agroup.getVbook().getId());
		// IPUtil.ipFilter(vir.getIp(),messageSource.getMessage("ip.filter.mask", null,
		// "1111",null) );
		html = AnalyzeUtil.replace(html, "tag", "lastip",
				IPUtil.ipFilter(vir.getIp(), messageSource.getMessage("ip.filter.mask", null, "1111", null)));
		return html;
	}

	/*
	 * 文章被阅读信息
	 */
	@ResponseBody
	@RequestMapping(value = "/artViewShow/{id}")
	@Token(ajax = true,csrf=true)
	public String artVisitfun(@PathVariable(value = "id", required = true) Long id,
			@RequestParam(value = "url", required = false) String url,
			@RequestParam(value = "referer", required = false) String referer, HttpServletRequest request,
			@RequestParam(value = "bymobile", required = false) Integer bymobile,
			HttpServletResponse response) {
		if (bymobile==null) {
			bymobile=0;
		}
		String html = "";
		if (id == null || id == 0) {
			return html;
		}
		Article art = articleDaoImpl.findByID(id);
		if (art == null || art.getAgroup() == null) {
			return html;
		}
		long gid = art.getAgroup().getId();
		EnvirSet es = envirInit(gid, 0, request, response);
		Portal portal = portalDaoImpl.query_update();
		int hotnOfVisit,hotnOfIP;
		hotnOfVisit=Integer.valueOf(messageSource.getMessage("vbook.new.visitor.value", null, "0", null));
		hotnOfIP=Integer.valueOf(messageSource.getMessage("vbook.new.ip.value", null, "5", null));
		boolean newip;
		VisitorsBook vbook = portal.getVbook();
		VisitUtil.visitorRefresh(es, vbook, "101", url, referer,bymobile); // 更新浏览者信息
		vbook = art.getVbook();
		newip=VisitUtil.visitorRefresh(es, vbook, "101", url, referer,bymobile); // 更新浏览者信息
		HttpShowUtil.updateArtHotn(articleDaoImpl, art, newip, hotnOfVisit, hotnOfIP);
		
		ArticleGroup group = groupDaoImpl.findByID(gid);
		vbook = group.getVbook();
		newip=VisitUtil.visitorRefresh(es, vbook, "111", url, referer,bymobile); // 更新浏览者信息
		HttpShowUtil.updateAgHotn(groupDaoImpl, group, newip, hotnOfVisit, hotnOfIP);
		
		List<ArticleGroup> list = groupDaoImpl.queryParentBySubID(group.getId(), 1);
		for (ArticleGroup g : list) {
			vbook = g.getVbook();
			newip=VisitUtil.visitorRefresh(es, vbook, "110", url, referer,bymobile); // 更新浏览者信息
			HttpShowUtil.updateAgHotn(groupDaoImpl, g, newip, hotnOfVisit, hotnOfIP);
		}
		
		TempletPortalMain templet = TempletPortalUtil.currTemplet(es);
		es.setTempletPortal(templet);
		
		html = TempletPortalUtil.sundriesTag(messageSource, templet, "htmlTemplet_view");
		/*
		 * ,htmlTemplet_view:浏览数：{$tag\58views$} IP数：{$tag\58ips$}
		 * 上次来访IP：{$tag\58lastip$}
		 */
		// html = TempletUtil.escape(html);
		html = AnalyzeUtil.replace(html, "tag", "views", "" + art.getVbook().getViewsTotal());
		html = AnalyzeUtil.replace(html, "tag", "ips", "" + art.getVbook().getIpTotal());
		html = AnalyzeUtil.replace(html, "tag", "vbID", art.getVbook().getId());
		VisitorIPRecord vir = es.getVisitorIPRecordDaoImpl().findLast(art.getVbook().getId());
		// IPUtil.ipFilter(vir.getIp(),messageSource.getMessage("ip.filter.mask", null,
		// "1111",null) );
		html = AnalyzeUtil.replace(html, "tag", "lastip",
				IPUtil.ipFilter(vir.getIp(), messageSource.getMessage("ip.filter.mask", null, "1111", null)));
		return html;
	}

	/*
	 * 文章编辑功能区域
	 */
	@ResponseBody
	@RequestMapping(value = "/artfun/{id}")
	@Token(ajax = true,csrf=true)
	public String artfun(@PathVariable(value = "id", required = true) Long id, HttpServletRequest request,
			HttpServletResponse response, HttpSession session,
			@CookieValue(value = "username_lerx", required = false) String username_lerx,
			@CookieValue(value = "password_lerx", required = false) String password_lerx) {

		String areaHtml = "";

		if (id == null || id == 0) {
			return areaHtml;
		}
		Article art = articleDaoImpl.findByID(id);
		if (art == null || art.getAgroup() == null) {
			return areaHtml;
		}

		long gid = art.getAgroup().getId();

		boolean backadmin = LoginUtil.adminChk(messageSource, session);

		EnvirSet es = envirInit(gid, 0, request, response);
		long uid = UserUtil.loginRefresh(es, username_lerx, password_lerx);
		User user = userDaoImpl.findByID(uid);
		boolean forePower = false;
		if (user != null && user.getRole() != null && user.getRole().getMask() != null) {

			forePower = GroupUtil.auditMaskChk(art.getAgroup(), user.getRole().getMask());
		}

		if (!backadmin && (user == null || user.getRole() == null)) {
			return areaHtml;
		}
		
		TempletPortalMain templetDef=templetPortalMainDaoImpl.findDef();
		

		if (backadmin || forePower) {

			String msg;
			// 审核
			String passHtmlTemplet = TempletPortalUtil.sundriesTag(messageSource, templetDef,
					"htmlTemplet_artpass");
			if (art.isStatus()) {
				msg = TempletPortalUtil.sundriesTag(messageSource, templetDef, "unpass");
			} else {
				msg = TempletPortalUtil.sundriesTag(messageSource, templetDef, "pass");
			}

			// passHtmlTemplet = TempletUtil.escape(passHtmlTemplet);

			passHtmlTemplet = AnalyzeUtil.replace(passHtmlTemplet, "tag", "status", "" + !art.isStatus());
			passHtmlTemplet = AnalyzeUtil.replace(passHtmlTemplet, "tag", "title", msg);

			passHtmlTemplet = passHtmlTemplet.replaceAll("\r|\n", "");
			areaHtml += passHtmlTemplet;

		}

		if (UserUtil.isadmin(user)) {
			String msg;
			//置顶
			String topOneHtmlTemplet = TempletPortalUtil.sundriesTag(messageSource, templetDef,
					"htmlTemplet_topOne");
			if (art.isTopOne()) {
				msg = TempletPortalUtil.sundriesTag(messageSource, templetDef, "unTopOne");
			} else {
				msg = TempletPortalUtil.sundriesTag(messageSource, templetDef, "topOne");
			}

			topOneHtmlTemplet = AnalyzeUtil.replace(topOneHtmlTemplet, "tag", "status", "" + !art.isTopOne());
			topOneHtmlTemplet = AnalyzeUtil.replace(topOneHtmlTemplet, "tag", "title", msg);

			topOneHtmlTemplet = topOneHtmlTemplet.replaceAll("\r|\n", "");
			areaHtml += topOneHtmlTemplet;
			
			//精华
			
			String soulHtmlTemplet = TempletPortalUtil.sundriesTag(messageSource, templetDef,
					"htmlTemplet_soul");
			if (art.isSoul()) {
				msg = TempletPortalUtil.sundriesTag(messageSource, templetDef, "unSoul");
			} else {
				msg = TempletPortalUtil.sundriesTag(messageSource, templetDef, "soul");
			}

			soulHtmlTemplet = AnalyzeUtil.replace(soulHtmlTemplet, "tag", "status", "" + !art.isSoul());
			soulHtmlTemplet = AnalyzeUtil.replace(soulHtmlTemplet, "tag", "title", msg);

			soulHtmlTemplet = soulHtmlTemplet.replaceAll("\r|\n", "");
			areaHtml += soulHtmlTemplet;
			
		}

		if (!forePower && (art.getUser() != null && art.getUser().getId() - uid == 0)) {
			forePower = true;
		}

		if (forePower) {
			// 编辑
			String editHtmlTemplet = TempletPortalUtil.sundriesTag(messageSource, templetPortalMainDaoImpl.findDef(),
					"htmlTemplet_edit");
			editHtmlTemplet = TempletUtil.escape(editHtmlTemplet);
			String msg = TempletPortalUtil.sundriesTag(messageSource, templetPortalMainDaoImpl.findDef(), "edit");
			editHtmlTemplet = AnalyzeUtil.replace(editHtmlTemplet, "tag", "title", msg);
			areaHtml += editHtmlTemplet;

		}

		areaHtml = AnalyzeUtil.replace(areaHtml, "tag", "aid", "" + art.getId());
		
		String subject=art.getSubject();
		subject=StringUtil.htmlRiskFilter(subject);

		subject=StringUtil.strReplace(subject, "'", "\\'");
		subject=StringUtil.strReplace(subject, "\"", "\\\"");
		subject=StringUtil.strReplace(subject, "&#39;", "");
		
		
		areaHtml = AnalyzeUtil.replace(areaHtml, "tag", "subject", subject);

		return areaHtml;
	}

	
	
	private class HtmlInit{
		
		private boolean status;
		private String html;
		private TempletPortalMain template;
		public boolean isStatus() {
			return status;
		}
		public void setStatus(boolean status) {
			this.status = status;
		}
		public String getHtml() {
			return html;
		}
		public void setHtml(String html) {
			this.html = html;
		}
		public TempletPortalMain getTemplate() {
			return template;
		}
		public void setTemplate(TempletPortalMain template) {
			this.template = template;
		}
		
	}
	
	private HtmlInit envChk(EnvirSet es,GlobalTagsAnalyzeReturn gtar) {
		HtmlInit hi=new HtmlInit();
		String html = gtar.getHtml();
		es = gtar.getEs();
		if (es == null) {
			hi.setStatus(false);
			return hi;
		}
		TempletPortalMain templet = es.getTempletPortal();
		if (templet==null) {
			templet = TempletPortalUtil.currTemplet(es);
			es.setTempletPortal(templet);
		}
		
		
		html = TempletUtil.tagToEnvir(html, es);
		html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
		hi.setHtml(html);
		hi.setStatus(true);
		
		
		hi.setTemplate(templet);
		if (templet==null) {
			hi.setStatus(false);
		}
		return hi;
	}

	/*
	 * 首页
	 */
	@ResponseBody
	@RequestMapping("/index")
	public String index(HttpServletRequest request) {
		EnvirSet es = envirInit(0, 0, request, null);
		TempletPortalMain templet = TempletPortalUtil.currTemplet(es);
		es.setTempletPortal(templet);
		GlobalTagsAnalyzeReturn gtar = HttpShowUtil.portalGlobalTagsAnalyze(es, "index");
		String html;
		HtmlInit hi = envChk(es,gtar);
		if (!hi.isStatus()) {
			return hi.getHtml();
		}else {
			html = hi.getHtml();
		}
		Portal portal = portalDaoImpl.query_update();
		VisitorsBook vbook = portal.getVbook();
		html = AnalyzeUtil.replace(html, "tag", "vbookID", "" + vbook.getId());
		
		html = AnalyzeUtil.replace(html, "tag", "station",
				TempletPortalUtil.sundriesTag(messageSource, hi.getTemplate(), "index"));
		return html;
	}

	/*
	 * 分类页
	 */
	@ResponseBody
	@RequestMapping(value = { "/nav/{id}/{page}/{pagesize}", "/nav/{id}" })
	public String nav(@PathVariable(value = "id", required = false) Long id, HttpServletRequest request,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize) {
		if (id == null) {
			id = 0L;
		}
		if (page == null) {
			page = 0;
		}

		if (pagesize == null) {
			pagesize = 0;
		}
		
		String html;

		EnvirSet es = envirInit(id, 0, request, null);
		ArticleGroup ag = es.getGroupDaoImpl().findByID(id);
		TempletPortalMain templet = es.getTempletPortal();
		if (templet==null) {
			templet = TempletPortalUtil.currTemplet(es);
			es.setTempletPortal(templet);
		}
		if (ag==null) {
			html = TempletUtil.tagToEnvir(FileUtil.readRes(messageSource, "template_res404"), es);
			html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
			return html;
		}
		
		
		es.setTempletPortal(templet);
		es.setPage(page);
		es.setPageSize(pagesize);
		GlobalTagsAnalyzeReturn gtar = HttpShowUtil.portalGlobalTagsAnalyze(es, "nav");
		HtmlInit hi = envChk(es,gtar);
		if (!hi.isStatus()) {
			return hi.getHtml();
		}else {
			html = hi.getHtml();
		}
		
		if (ag.getHtmlOwn() != null && !ag.getHtmlOwn().trim().equals("")) {
			html = AnalyzeUtil.replace(html, "code", "htmlOwn", ag.getHtmlOwn());
		} else {
			html = AnalyzeUtil.replace(html, "code", "htmlOwn", "");
		}
		
		long currUid = LoginUtil.uid(messageSource, request);
		boolean forbid=false;
		if (currUid==0L) {
			forbid=true;
		}else {
			User user=userDaoImpl.findByID(currUid);
			if (user==null || !user.isState() || (user.getRole()!=null && !user.getRole().isStatus())) {
				forbid=true;
			}
		}
		es.setUid(currUid);
		
		if (!GroupUtil.openChk(ag) && forbid ) {
			html = TempletUtil.tagToEnvir(FileUtil.readRes(messageSource, "template_forbid"), es);
			html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
			return html;
		}
		//
		
		if (ag.getJumpToUrl()!=null && !ag.getJumpToUrl().trim().equals("")) {
			html = TempletUtil.tagToEnvir(FileUtil.readRes(messageSource, "htmlTemplet_forward"), es);
			html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
			html =  AnalyzeUtil.replace(html, "tag", "returnUrl", ag.getJumpToUrl());
			return html;
		}
		
		if (ag != null && ag.getVbook() != null) {
			VisitorsBook vbook = ag.getVbook();
			html = AnalyzeUtil.replace(html, "tag", "vbookID", "" + vbook.getId());
		} else {
			html = AnalyzeUtil.replace(html, "tag", "vbookID", "0");
		}

		html = AnalyzeUtil.replace(html, "tag", "mappCurr",
				es.getRequest().getContextPath() + "/show_portal/nav/" + id);
		return html;
	}

	/*
	 * 文章编辑页
	 */
	@ResponseBody
	@RequestMapping(value = "/edit/{id}")
	@Token(ajax = true,csrf=true)
	public String edit(@PathVariable(value = "id", required = false) Long id, HttpServletRequest request) {
		Article art = null;
		long gid = 0L;
		if (id == null) {
			id = 0L;
		} else {
			art = articleDaoImpl.findByID(id);
			if (art != null && art.getAgroup() != null) {
				gid = art.getAgroup().getId();
			}

		}

		if (art == null) {
			art = new Article();
			art.setId(0);
		}

		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		String mask = "";

		if (user != null && user.getRole() != null && user.getRole().getMask() != null) {
			mask = user.getRole().getMask();
		}
		EnvirSet es;
		es = envirInit(gid, id, request, null);
		TempletPortalMain templet = TempletPortalUtil.currTemplet(es);
		es.setTempletPortal(templet);
		GlobalTagsAnalyzeReturn gtar = HttpShowUtil.portalGlobalTagsAnalyze(es, "edit");
		es = gtar.getEs();
		String html;
		HtmlInit hi = envChk(es,gtar);
		if (!hi.isStatus()) {
			return hi.getHtml();
		}else {
			html = hi.getHtml();
		}
		
		if (id > 0 && gid > 0L) {
			if (!GroupUtil.auditMaskChk(art.getAgroup(), mask) && art.getUser().getId() - uid != 0) {
				html = TempletPortalUtil.sundriesTag(messageSource, hi.getTemplate(), "resultHtml");
				if (html == null || html.trim().equals("")) {
					html = FileUtil.readRes(messageSource, "template_result");
				}
				html = StringUtil.clear65279(html);
				html = AnalyzeUtil.replace(html, "tag", "referer", request.getHeader("Referer"));
				html = AnalyzeUtil.replace(html, "tag", "returnUrl", request.getHeader("Referer"));
				html = AnalyzeUtil.replace(html, "tag", "msg", messageSource.getMessage("fail.permission", null,
						"You have no permissions for the current operation!", null));
				return html;
			}
		}

//		html = globalTagsAnalyze(es, "edit");
		html = TempletUtil.tagToEnvir(html, es);
		html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
		return html;
	}

	/*
	 * 文章页跳转
	 */
	@ResponseBody
	@RequestMapping(value = "/jump/{id}")
	@Token(ajax = true,csrf=true)
	public String jump(@PathVariable(value = "id", required = false) Long id, @RequestParam(value = "bymobile", required = false) Integer bymobile,HttpServletRequest request) {
		if (bymobile==null) {
			bymobile=0;
		}
		if (id == null) {
			id = 0L;
		}
		long gid;
		Article art = articleDaoImpl.findByID(id);
		EnvirSet es;
		
		if (art == null) {
			es = envirInit(0, id, request, null);
			
			TempletPortalMain templet = TempletPortalUtil.currTemplet(es);
			es.setTempletPortal(templet);
			String html = TempletUtil.tagToEnvir(FileUtil.readRes(messageSource, "template_res404"), es);
			html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
			return html;
		}else {
			gid = art.getAgroup().getId();
			es = envirInit(gid, id, request, null);
		}
		boolean jump = false;
		if (art.getJumpUrl() != null && !art.getJumpUrl().trim().equals("")) {
			jump = true;
		}
		if (jump) {
			
			art.setViews(art.getViews() + 1);
			
			GlobalTagsAnalyzeReturn gtar = HttpShowUtil.portalGlobalTagsAnalyze(es, "art");
			es = gtar.getEs();
			Portal portal = portalDaoImpl.query_update();
			VisitorsBook vbook = portal.getVbook();
			String url = request.getRequestURL().toString();
			String referer = request.getHeader("referer");
			VisitUtil.visitorRefresh(es, vbook, "101", url, referer,bymobile); // 更新浏览者信息
			vbook = art.getVbook();
			VisitUtil.visitorRefresh(es, vbook, "101", url, referer,bymobile); // 更新浏览者信息
			ArticleGroup group = groupDaoImpl.findByID(gid);
			vbook = group.getVbook();
			VisitUtil.visitorRefresh(es, vbook, "111", url, referer,bymobile); // 更新浏览者信息
			return art.getJumpUrl();
		} else {
			return request.getContextPath() + "/show_portal/art/" + id;
		}
	}

	/*
	 * 文章页显示
	 */
	@Transactional(propagation=Propagation.REQUIRED,isolation=Isolation.READ_UNCOMMITTED)
	@ResponseBody
	@RequestMapping(value = "/art/{id}")
	public String art(@PathVariable(value = "id", required = false) Long id, HttpServletRequest request,HttpSession session) {
		if (id == null) {
			id = 0L;
		}
		
		Article art = articleDaoImpl.findByID(id);
		
		long gid = 0;
		if (art != null && art.getAgroup() != null) {
			gid = art.getAgroup().getId();
		}
		String html;
		EnvirSet es;
		es = envirInit(gid, id, request, null);
		TempletPortalMain templet = TempletPortalUtil.currTemplet(es);
		es.setTempletPortal(templet);
		if (art==null) {
			html = TempletUtil.tagToEnvir(FileUtil.readRes(messageSource, "template_res404"), es);
			html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
			return html;
		}
		
		GlobalTagsAnalyzeReturn gtar = HttpShowUtil.portalGlobalTagsAnalyze(es, "art");
		HtmlInit hi = envChk(es,gtar);
		if (!hi.isStatus()) {
			return hi.getHtml();
		}else {
			html = hi.getHtml();
		}
		
		long uid = LoginUtil.uid(messageSource, request);
		
		User user = userDaoImpl.findByID(uid);
		boolean show=false;
		
		if (art.isStatus() && GroupUtil.statusChk(art.getAgroup(),groupDaoImpl)) {
			//如果文章状态已审，且栏目组级父组均状态正常
			show=true;
		}
		if (!show && LoginUtil.adminChk(messageSource, session)) {
			//如果是后台管理员
			show=true;
		}
		if (!show && user!=null && UserUtil.isadmin(user)) {
			//如果是前台管理员
			show=true;
		}
		if (!show && user!=null && user.getRole() != null && GroupUtil.auditMaskChk(art.getAgroup(), user.getRole().getMask())) {
			//如果前台用户在所属用户组有权限
			show=true;
		}
		if (!show && user!=null && art.getUser()!=null && art.getUser().getId() - user.getId()==0) {
			//如果是作者本人
			show=true;
		}
		
		if (show) {
			
			if (es.getRequest() == null) {
				System.out.println("es.getRequest() is null!");
			}
			if (es.getRequest().getContextPath() == null) {
				System.out.println("es.getRequest().getContextPath() is null!");
			}
			html = AnalyzeUtil.replace(html, "tag", "mappCurr",
					es.getRequest().getContextPath() + "/show_portal/art/" + id);
			if (art != null && art.getVbook() != null) {
				VisitorsBook vbook = art.getVbook();
				html = AnalyzeUtil.replace(html, "tag", "vbookID", "" + vbook.getId());
			} else {
				html = AnalyzeUtil.replace(html, "tag", "vbookID", "0");
			}

		} else {
			es = envirInit(0, id, request, null);
			html = FileUtil.readRes(messageSource, "template_res404");
		}
		if (art != null && art.getMediaUrl() != null && !art.getMediaUrl().trim().equals("")
				&& art.getMediaUrl().trim().length() > 3) {
			String videoHtmlTemplet = TempletPortalUtil.sundriesTag(messageSource, templetPortalMainDaoImpl.findDef(),
					"template_video");

			videoHtmlTemplet = AnalyzeUtil.replace(videoHtmlTemplet, "tag", "media", art.getMediaUrl().trim());

			html = AnalyzeUtil.replace(html, "code", "mediaPlayer", videoHtmlTemplet);

		} else {
			html = AnalyzeUtil.replace(html, "code", "mediaPlayer", "");
		}
		
		html = TempletUtil.tagToEnvir(html, es);
		html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
		return html;
	}

	/*
	 * 文集
	 */
	@ResponseBody
	@RequestMapping(value = { "/corpus/{uid}/{page}/{pagesize}", "/corpus/{uid}" })
	public String corpus(@PathVariable(value = "uid", required = false) Long uid,@PathVariable(value = "page", required = false) Integer page,@PathVariable(value = "pagesize", required = false) Integer pagesize,
			HttpServletRequest request) {
		EnvirSet es;
		String html;
		if (page == null) {
			page = 0;
		}
		if (pagesize == null) {
			pagesize = 0;
		}
		es = envirInit(0, 0, request, null);
		es.setPage(page);
		es.setPageSize(pagesize);
		
		TempletPortalMain templet = TempletPortalUtil.currTemplet(es);
		es.setTempletPortal(templet);
		
		boolean own = false;
		
		long currUid = LoginUtil.uid(messageSource, request);
		
		if (uid == null || uid == 0L) {

			own = true;
			uid = currUid;
			es.setPower(true);
		} else {
			if (uid - currUid == 0) {
				own = true;
				es.setPower(true);
			}
		}
		es.setUid(uid);
		
		String ownname = "null";
		User user = userDaoImpl.findByID(uid);
		if (user != null) {
			ownname = user.getUsername();
		}else {
			html = TempletUtil.tagToEnvir(FileUtil.readRes(messageSource, "template_res404"), es);
			html = TempletPortalUtil.tagForResFolder(messageSource, html, templet);
			return html;
		}
		GlobalTagsAnalyzeReturn gtar = HttpShowUtil.portalGlobalTagsAnalyze(es, "corpus");
		es = gtar.getEs();
		HtmlInit hi = envChk(es,gtar);
		if (!hi.isStatus()) {
			return hi.getHtml();
		}else {
			html = hi.getHtml();
		}

		if (own) {
			html = AnalyzeUtil.replace(html, "tag", "ownname",
					messageSource.getMessage("title.own", null, "My ", null));
		} else {
			html = AnalyzeUtil.replace(html, "tag", "ownname", ownname);
			
		}

		html = AnalyzeUtil.replace(html, "tag", "station",
				messageSource.getMessage("title.corpus.personal", null, "Personal corpus", null));
		html = AnalyzeUtil.replace(html, "tag", "ownUid", "" + uid);
		html = AnalyzeUtil.replace(html, "tag", "mappCurr",
				es.getRequest().getContextPath() + "/show_portal/corpus/" + uid);
		
		return html;
	}

}
