package com.lerx.handlers;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.annotation.Token;
import com.lerx.dao.iface.IMailTeamUnitDao;
import com.lerx.dao.iface.IMsgDao;
import com.lerx.dao.iface.IPortalDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.MailTeamUnit;
import com.lerx.entities.Msg;
import com.lerx.entities.Portal;
import com.lerx.entities.User;
import com.lerx.hql.entities.Rs;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.FlowOut;
import com.lerx.sys.obj.Website;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.v6.util.MsgUtil;
import com.lerx.v6.util.PortalUtil;
import com.lerx.v6.util.UserUtil;

@RequestMapping("/action_msg")
@Controller
public class MsgHandler {

	@Autowired
	private IMsgDao msgDaoImpl;
	
	@Autowired
	private IMailTeamUnitDao mailTeamUnitDaoImpl;

	@Autowired
	private IUserDao userDaoImpl;
	
	@Autowired
	private IPortalDao portalDaoImpl;

	@Autowired
	private ResourceBundleMessageSource messageSource;

	// 输出消息内容
	@SuppressWarnings("unchecked")
	@ResponseBody
	@RequestMapping(value = { "/mymsg/{page}/{pagesize}", "/mymsg" })
	@Token(ajax = true, csrf = true, contrast = true, login = true)
	public FlowOut mymsg(@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpServletRequest request) {

		if (page == null) {
			page = 0;
		}

		if (pagesize == null) {
			pagesize = 10;
		}

		FlowOut co = new FlowOut();
		co.setCount(0);
		co.setPage(page);
		co.setPageCount(0);
		co.setHtml("");
		co.setPageSize(pagesize);

		long uid = LoginUtil.uid(messageSource, request);

		Rs rs = msgDaoImpl.queryByUid(uid, page, pagesize);
		List<Msg> mlist;
		String tmpAll = "";
		mlist = (List<Msg>) rs.getList();
		if (mlist == null || mlist.isEmpty() || mlist.size() <= 0) {
			return co;
		} else {

			String msgContent = FileUtil.readRes(messageSource, "msg_fmt_show");

			for (Msg msg : mlist) {
				String tmp = msgContent;
				tmp = MsgUtil.fmt(tmp, msg);
				tmpAll += tmp;

			}
		}

		co.setHtml(tmpAll);
		co.setCount(rs.getCount());
		co.setPage(rs.getPage());
		co.setPageCount(rs.getPageCount());

		return co;

	}

	// 获取所有消息总数
	@ResponseBody
	@RequestMapping(value = "/allmsg")
	@Token(ajax = true, csrf = true, contrast = true, login = true)
	public int allmsg(HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		int r = Integer.valueOf(String.valueOf(msgDaoImpl.countByRecipientUID(uid)));
		return r;
	}

	// 清除所有消息
	@ResponseBody
	@RequestMapping(value = "/clear")
	@Token(ajax = true, csrf = true, contrast = true, login = true)
	public void clear(HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		msgDaoImpl.setAllReadByUID(uid);
	}

	// 删除消息
	@ResponseBody
	@RequestMapping(value = "/del/{id}")
	@Token(ajax = true, csrf = true, contrast = true, login = true,log=true,mark = "msg--<del>")
	public int del(@PathVariable(value = "id", required = true) Long id, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		Msg msg = msgDaoImpl.findByID(id);
		if (msg.getRecipient().getId() == uid) {
			msgDaoImpl.delByID(id);
			return 0;
		} else {
			return -200;
		}
	}

	// 增加一个消息 rid为接收者uid
	@ResponseBody
	@RequestMapping(value = "/add/{rid}")
	@Token(ajax = true, csrf = true, contrast = true, login = true)
	public int add(@PathVariable(value = "rid", required = true) Long rid, String content, HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		if (uid <= 0) {
			return -201;
		}

		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -201;
		}
		if (rid == null) {
			return -404;
		}
		User ruser = userDaoImpl.findByID(rid);
		if (ruser == null) {
			return -404;
		}

		if (uid == rid) {
			return -302;
		}

		if (user.isGag() && !UserUtil.isadmin(user)) { // 如果被禁言，只能发消息给管理员
			return -403;
		}

		String msgContent = FileUtil.readRes(messageSource, "msg_new_content");

		Msg msg = new Msg();
		msg.setCtext(content);
		msg.setContent(content);
		msg.setMainUuid(StringUtil.uuidStr());
		msg.setSender(user);
		msg.setRecipient(ruser);
		msg.setMtype(0);
		msg.setStatus(true);
		msg.setSendtime(System.currentTimeMillis());
		
		msgContent = MsgUtil.fmt(msgContent, msg);
		msg.setContent(msgContent);
		msgDaoImpl.add(msg);
		
		//存邮件队列
		
		Portal portal = portalDaoImpl.query_update();
		
		String recipients="";
		recipients += ruser.getEmail()+";";
		
		
		String subject = messageSource.getMessage("mail.subject.title.msg", null,
				"You have a new msg in {$tag:portalName$}.", null);
		subject = AnalyzeUtil.replace(subject, "tag", "portalName", portal.getName());
		String comsay = FileUtil.readRes(messageSource, "template_msg_mail");
		subject = AnalyzeUtil.replace(subject, "tag", "sender", user.getUsername());
		
		String nickname=user.getNickname();
		if (nickname==null || nickname.trim().equals("")) {
			nickname=user.getUsername();
		}
		
		comsay = AnalyzeUtil.replace(comsay, "tag", "username", user.getUsername());
		comsay = AnalyzeUtil.replace(comsay, "tag", "nickname", nickname);
		
		comsay = AnalyzeUtil.replace(comsay, "tag", "portalName", portal.getName());
		comsay = AnalyzeUtil.replace(comsay, "tag", "addtime", portal.getName());
		
//		String dtfmt = messageSource.getMessage("datetime.fmt.default", null, "yyyy-MM-dd HH:mm:ss", null);
		
		comsay = AnalyzeUtil.replace(comsay, "tag", "addTime", msg.getSendtime());
		comsay = AnalyzeUtil.replace(comsay, "tag", "content", msg.getContent());
		comsay = AnalyzeUtil.replace(comsay, "tag", "ctext", msg.getCtext());
		
		Website site = PortalUtil.lead(portal);
		comsay=HttpUtil.siteImplant(comsay, site, request);
		
		MailTeamUnit unit = new MailTeamUnit();
		unit.setCreateDT(System.currentTimeMillis());
		unit.setContent(comsay);
		unit.setDeled(false);
		unit.setFailures(0);
		unit.setRecipient(recipients);
		unit.setSender(user.getUsername());
		unit.setStatus(false);
		unit.setSubject(subject);
		unit.setTxt(content);
		unit.setCreater(user);
		
		mailTeamUnitDaoImpl.add(unit);
		
		/*
		int r = MailUtil.send(mes);
		if (r<0) {
			String lb = System.getProperty("line.separator");
			String err="info-proce-doAfterreturing " + lb + "An error occurred during the mail delivery. Error code:"+r+".";
			err+= lb +"msg id:"+msg.getId();
			
			LogWrite.logWrite(HttpUtil.currRequest(),err );
		}
		*/
		
		return 0;

	}

}
