package com.lerx.handlers;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.annotation.Token;
import com.lerx.login.util.LoginUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.StringUtil;


@Controller
public class PathHandler {
	
	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	@RequestMapping(value="/result/{name}")
	@Token(contrast = true,csrf = true)
	public ModelAndView resultPath (@PathVariable String name,HttpSession session,HttpServletRequest request, Map<String, Object> map){
		long uid=LoginUtil.userChk(messageSource, session) ;
		map.put("uid", uid);
		String url=request.getScheme()+"://";   
		   url+=request.getHeader("host");
		   map.put("currReq", url);
		return new ModelAndView("result/"+name);
	}
	
	@RequestMapping(value="/jsp/{name}/{act}")
	@Token(contrast = true,csrf = true)
	public ModelAndView jspPath (@PathVariable String name,@PathVariable String act,HttpSession session,HttpServletRequest request,HttpServletResponse response, Map<String, Object> map){
		long uid=LoginUtil.userChk(messageSource, session) ;
		map.put("uid", uid);
		String url=request.getScheme()+"://";   
		   url+=request.getHeader("host");
		   map.put("currReq", url);
		   
		if (name.equals("user") && act.startsWith("login")) {
			
			String referer = HttpUtil.referer(request);
			if (referer!=null && !referer.trim().equals("")) {
				referer=StringUtil.htmlFilter(referer,false);
				HttpUtil.saveCookie(messageSource, response, "referer_lerx", referer);
			}
			
		}
		return new ModelAndView("jsp/"+name+"/"+act);
	}
	
	@RequestMapping(value="/jsp/{name}/{sub}/{act}")
	@Token(contrast = true,csrf = true)
	public ModelAndView jspSubPath (@PathVariable String name,@PathVariable String sub,@PathVariable String act,HttpSession session,HttpServletRequest request, Map<String, Object> map){
		long uid=LoginUtil.userChk(messageSource, session) ;
		map.put("uid", uid);
		String url=request.getScheme()+"://";   
		   url+=request.getHeader("host");
		   map.put("currReq", url);
		return new ModelAndView("jsp/"+name+"/"+sub+"/"+act);
	}
	
	@RequestMapping(value="/login")
	@Token(contrast = true,csrf = true)
	public ModelAndView login (@RequestParam(value = "referer", required = false) String referer,HttpServletRequest request,HttpServletResponse response){
		if (referer==null || referer.trim().equals("")) {
			referer = HttpUtil.referer(request);
		}
		if (referer!=null && !referer.trim().equals("")) {
			referer=StringUtil.htmlFilter(referer,false);
			HttpUtil.saveCookie(messageSource, response, "referer_lerx", AnalyzeUtil.rpageAnalyze(referer));
		}
		return new ModelAndView("jsp/user/login");
	}

}
