package com.lerx.handlers;

import java.io.File;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.ISearchTotalModelDao;
import com.lerx.entities.SearchTotalModel;
import com.lerx.portal.obj.RiskLevelCollect;
import com.lerx.sys.util.FileUtil;
import com.lerx.v6.util.SysUtil;

@RequestMapping("/action_risk")
@Controller
public class RiskHandler {
	
	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	@Autowired
	private ISearchTotalModelDao searchTotalModelDaoImpl;
	
	@RequestMapping("/detail/{sid}")
	@ResponseBody
	@Token(ajax = true, csrf = true,admin = true)
	public RiskLevelCollect detail(@PathVariable(value = "sid", required = true) Long sid) {
		SearchTotalModel stm=searchTotalModelDaoImpl.findByID(sid);
		String folder = messageSource.getMessage("res", null, "res", null);
		String riskLevelFilePre = FileUtil.webinfPath()+File.separator+folder+File.separator+"risk_level";
		RiskLevelCollect coll=SysUtil.riskDetails(stm.getRiskContent(), riskLevelFilePre);
		return coll;
	}
	
	@RequestMapping("/clear/{sid}")
	@ResponseBody
	@Token(ajax = true, csrf = true,admin = true, log = true, mark = "risk--<clear>")
	public int clear(@PathVariable(value = "sid", required = true) Long sid) {
		SearchTotalModel stm=searchTotalModelDaoImpl.findByID(sid);
		stm.setRiskLevel(0);
		searchTotalModelDaoImpl.modify(stm);
		return 0;
	}

}
