package com.lerx.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.lerx.annotation.Token;
import com.lerx.aop.args.CutTags;
import com.lerx.dao.iface.IGroupDao;
import com.lerx.dao.iface.IRoleDao;
import com.lerx.entities.Role;
import com.lerx.sys.util.MavUtil;
import com.lerx.v6.util.GroupUtil;

@RequestMapping("/action_role")
@Controller
public class RoleHandler {
	
	private static final String FAILED = "jsp/result/failed";
	private static final String ADMINFAILRETURN = "_admin.login.redirect_";
	
	@Autowired
	private IGroupDao groupDaoImpl;

	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	@Autowired
	private IRoleDao roleDaoImpl;
	
	@ModelAttribute
	public void getRole(@RequestParam(value = "id", required = false) Long id, Map<String, Object> map) {
		if (id != null && id>0) {
			map.put("role", roleDaoImpl.findByID(id));
//			System.out.println("从数据库获取对象");
		}
	}
	
	//增加
	@ResponseBody
	@RequestMapping("/add")
	@Token(ajax = true,csrf=true, contrast = true,log=true,mark="role--<add>",admin=true)
	public int add(String name,Map<String, Object> map){
		if (name==null || name.trim().equals("")) {
			return -410;
		}
		
		if (roleDaoImpl.findByName(name)!=null) {
			return -502;
		}
		Role role=null;
		role=new Role();
		role.setDef(false);
		role.setStatus(true);
		role.setName(name.trim());
		role=roleDaoImpl.add(role);
		if (role==null) {
			return -1;
		}
		return 0;
		
	}
	
	
	//修改
	@RequestMapping("/chg")
	@Token(log=true,csrf = true, contrast = true,mark="role--<change>",admin=true,failedPage = FAILED,msgKey="fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String modify(@Valid Role role,Errors result,Map<String, Object> map){
			if (roleDaoImpl.findByNameOutID(role.getName(), role.getId())!=null) {
				map.put("error", messageSource.getMessage("fail.exists.name", null, "This name has been used by other roles!", null));
				return "jsp/result/failed";
			}
			roleDaoImpl.modify(role);
			return "jsp/result/success";
			
	}
	
	//删除
	@ResponseBody
	@RequestMapping("/del")
	@Token(ajax = true,csrf=true, contrast = true,log=true,mark="role--<del>",admin=true,failedPage = FAILED)
	public boolean del(Long id,HttpSession session) {
		boolean result=false;
		/*
		 * 检查是否有下级人员
		 */
		result=roleDaoImpl.delByID(id);
		
		return result;
	}
	
	//进入修改页面
	@RequestMapping("/edit")
	@Token(admin=true,csrf=true, contrast = true,failedPage = FAILED,msgKey="fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String edit(Map<String, Object> map,Long id) {
		
		Role role = roleDaoImpl.findByID(id);
		map.put("role", role);
		return "jsp/role/add";
		
	}
	
	/*
	 * 权限码
	 */
	@RequestMapping("/mask")
	@Token(admin=true,csrf=true, contrast = true,failedPage = FAILED,msgKey="fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public ModelAndView mask(long id,Map<String, Object> map) {
		String rootTitle=messageSource.getMessage("root.title", null, "Root", null);
		Role role = roleDaoImpl.findByID(id);
		if (role==null) {
			return MavUtil.mav1("jsp/result/error", "error");
		}
		String mask=role.getMask();
		GroupUtil.mapGroupMaskCreate(map,groupDaoImpl,rootTitle,mask,1);
		boolean admin=false;
		boolean addAll=false;
		boolean albAll=false;
		boolean sl=false;
		if (mask!=null && mask.trim().equals("0")) {
			admin=true;
		}
		if (mask!=null) {
			mask=","+mask+",";
			if (mask.indexOf(",a0,")!= -1) {
				addAll=true;
			}
			if (mask.indexOf(",b0,")!= -1) {
				albAll=true;
			}
			
			if (mask.indexOf(",sl,")!= -1) {
				sl=true;
			}
			
			
		}
		map.put("admin", admin);
		map.put("a0", addAll);
		map.put("b0", albAll);
		map.put("sl", sl);
		map.put("roleID", role.getId());
		
		return MavUtil.mav1("jsp/role/mask", "success");
	}
	
	protected List<String> getParameterValues(HttpServletRequest request,String str){
    	String[] arr = request.getParameterValues(str);
    	List<String> result = new ArrayList<String>();
    	if(null != arr && arr.length > 0){
    		for (int i = 0; i < arr.length; i++) {
				result.add(arr[i]);
			}
    	}
    	return result;
    }
	
	@RequestMapping(value="/maskchg")
	@Token(log=true,mark="role--<mask-change>",admin=true,csrf=true, contrast = true,failedPage = FAILED,msgKey="fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public ModelAndView modifyMask(HttpServletRequest request,Map<String, Object> map,long id,boolean admin,boolean a0,boolean b0,boolean sl, @RequestParam(required = false, value = "list[]") String[] mkey) {
		List<String> mvalueList=new ArrayList<String> ();
		Map<?, ?> map2 = request.getParameterMap();
		String value;
		for (Object key : map2.keySet()) {
			if (key.toString().startsWith("mvalue")){ 
		          value= request.getParameter(key.toString()); 
		          if (value!=null && !value.trim().equals("")) {
		        	  mvalueList.add(value);
		          }
		    } 
		}
		Role role = roleDaoImpl.findByID(id);
		
		String maskCode="";
		if (admin) {
			maskCode="0";
		}else {
			if (a0) {
				maskCode+="a0";
			}
			if (b0) {
				if (maskCode.trim().equals("")) {
					maskCode+="b0";
				}else {
					maskCode+=",b0";
				}
				
			}
			if (sl) {
				if (maskCode.trim().equals("")) {
					maskCode+="sl";
				}else {
					maskCode+=",sl";
				}
				
			}
			
			if (mvalueList != null && mvalueList.size() > 0) {
				for (int i = 0; i < mvalueList.size(); i++) {
					if (mvalueList.get(i)!=null && !mvalueList.get(i).equals("")) {
						if (a0 && mvalueList.get(i).trim().startsWith("a")) {
							continue;
						}
						if (maskCode.trim().equals("")) {
							maskCode+=mvalueList.get(i);
						}else {
							maskCode+=","+mvalueList.get(i);
						}
					}
				}
			}
			
		}
		
		role.setMask(maskCode);
		roleDaoImpl.modify(role);
		return MavUtil.mav1("jsp/result/success", "");
	}
	
	
	/*
	 * 列表
	 */
	@RequestMapping("/list")
	@Token(admin=true,csrf=true, contrast = true,failedPage = FAILED,msgKey="fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public ModelAndView list(Map<String, Object> map,HttpSession session,CutTags tags){
		List<Role> list = roleDaoImpl.queryAllAndCounts();
		map.put("pageUrl", "/action_role/list");
		map.put("roles", list);
		return MavUtil.mav1("jsp/role/list", "success");
		
	}
	
}
