package com.lerx.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.IAlbgenreDao;
import com.lerx.dao.iface.IAlbumArticleDao;
import com.lerx.dao.iface.IAlbumArtsCountDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.dao.iface.IRoleDao;
import com.lerx.dao.iface.IUserArtsCountDao;
import com.lerx.entities.Albgenre;
import com.lerx.entities.AlbumArtsCount;
import com.lerx.entities.Role;
import com.lerx.hql.entities.Rs;
import com.lerx.sys.util.TimeUtil;
import com.lerx.v6.util.AlbumUtil;
import com.lerx.v6.util.PartnerUtil;

import cn.hutool.core.date.DateUtil;

@RequestMapping("/action_summary")
@Controller
public class SummaryHandler {
	
	private static final String LOGINPAGE = "_admin.login_";
	private static final String ADMINFAILRETURN = "_admin.login.redirect_";
	
	@Autowired
	private IRoleDao roleDaoImpl;
	
	@Autowired
	private IAlbgenreDao albgenreDaoImpl;
	
	@Autowired
	private IAlbumDao albumDaoImpl;
	
	@Autowired
	private IAlbumArticleDao albumArticleDaoImpl;
	
	@Autowired
	private IUserArtsCountDao userArtsCountDaoImpl;
	
	@Autowired
	private IAlbumArtsCountDao albumArtsCountDaoImpl;
	
	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;
	
	@Autowired
	private ResourceBundleMessageSource messageSource;
	
	//统计用户发文情况
	@RequestMapping(value = {"/analyze/user/{rid}/{timeKey}/{page}/{pagesize}","/analyze/user/{rid}/{timeKey}"})
	@Token(admin = true, csrf = true, contrast = true, failedPage = LOGINPAGE, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String analyzeUser(@PathVariable(value = "rid", required = false) Integer rid,@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize,@PathVariable(value = "timeKey", required = false) Integer timeKey,Map<String, Object> map) {
		if (rid==null) {
			rid=0;
		}
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		int timeKeyInput=timeKey;
		if (timeKey==null || timeKey==0) {
			java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat("yyyyMM");
			timeKey = Integer.valueOf(formatter.format(System.currentTimeMillis()));
			timeKeyInput=timeKey;
		}else {
			if (timeKey>20000000 && timeKey<90000000) {
				long tk=TimeUtil.coverStrToLong(String.valueOf(timeKey), "yyyyMMdd");
				Date weekStamp=TimeUtil.firstDayAtWeek(new Date(tk));
				timeKey=Integer.valueOf(TimeUtil.coverLongToStr(weekStamp.getTime(), "yyyyMMdd"));
			}
		}
		Rs rs=userArtsCountDaoImpl.findTopByUKAndGroup(rid, timeKey, 0, page, pagesize);
		map.put("pageUrl", "/action_summary/analyze/user/"+rid+"/"+timeKey);
		map.put("rs", rs);
		map.put("timeKey", timeKeyInput);
		map.put("rid", rid);
		List<Role> list = roleDaoImpl.queryAll();
		map.put("roles", list);
		map.put("dateframe",dateframe(timeKey));
		return "jsp/summary/user/list";
	}
	
	//统计专辑发文情况
	@RequestMapping(value = {"/analyze/album/{gid}/{timeKey}/{page}/{pagesize}","/analyze/album/{gid}/{timeKey}"})
	@Token(admin = true, csrf = true, contrast = true, failedPage = LOGINPAGE, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String analyzeAlbum(@PathVariable(value = "gid", required = false) Integer gid,@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize,@PathVariable(value = "timeKey", required = false) Integer timeKey,HttpServletRequest request,Map<String, Object> map) {
		if (gid==null) {
			gid=0;
		}
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		int timeKeyInput=timeKey;
		if (timeKey==null || timeKey==0) {
			java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat("yyyyMM");
			timeKey = Integer.valueOf(formatter.format(System.currentTimeMillis()));
			timeKeyInput=timeKey;
		}else {
			if (timeKey>20000000 && timeKey<90000000) {
				long tk=TimeUtil.coverStrToLong(String.valueOf(timeKey), "yyyyMMdd");
				Date weekStamp=TimeUtil.firstDayAtWeek(new Date(tk));
				timeKey=Integer.valueOf(TimeUtil.coverLongToStr(weekStamp.getTime(), "yyyyMMdd"));
			}
		}
		Rs rs=albumArtsCountDaoImpl.findTopByAKAndGroup(gid, timeKey, 0, page, pagesize);
		
		@SuppressWarnings("unchecked")
		List<AlbumArtsCount> aacList=(List<AlbumArtsCount>) rs.getList();
		
		for (AlbumArtsCount a:aacList) {
			/*
			 * Album album=a.getAlbum(); album=albumDaoImpl.findByID(album.getId());
			 * album.setUrl(AlbumUtil.getHref(messageSource, request, album, false));
			 * a.setAlbum(album);
			 */
			a.setSpartnerList(PartnerUtil.query(a.getAlbum().getId(), albumDaoImpl, albumArticleDaoImpl, albumPartnerDaoImpl));
			a.getAlbum().setUrl(AlbumUtil.getHref(messageSource, request, a.getAlbum(), false));
			/*
			 * List<AlbumPartner>
			 * partnerList=albumPartnerDaoImpl.queryByAid(a.getAlbum().getId());
			 * a.setPartnerList(partnerList);
			 */
		}
		map.put("pageUrl", "/action_summary/analyze/album/"+gid+"/"+timeKey);
		map.put("rs", rs);
		map.put("timeKey", timeKeyInput);
		map.put("gid", gid);
		List<Albgenre> list=albgenreDaoImpl.queryAll();
		
		map.put("genres", list);
		map.put("dateframe",dateframe(timeKey));
		return "jsp/summary/album/list";
	}
	
	
	
	private String dateframe(int timekey) {
		String r="";
		if (timekey>1971 && timekey<9999) {
			r= timekey+messageSource.getMessage("title.date.span.y", null, "", null);
		}else if (timekey>10000 && timekey<90000) {
			int qv=timekey%10;
			int year=timekey/10;
			r=year+" "+messageSource.getMessage("title.date.span.y", null, "", null);
			if (qv>0 && qv<=4) {
				r+=" &nbsp;&nbsp;"+qv+" "+messageSource.getMessage("title.date.span.q", null, "", null);
			}else {
				r+=" &nbsp;&nbsp;err "+messageSource.getMessage("title.date.span.q", null, "", null);
			}
			
		}else if (timekey>100000 && timekey<900000){
			int year=timekey/100;
			int month=timekey % 100;
			r=year+" "+messageSource.getMessage("title.date.span.y", null, "", null);
			if (month<=0 || month>12) {
				r+=" &nbsp;&nbsp;err "+messageSource.getMessage("title.date.span.M", null, "", null);
			}else {
				r+=" &nbsp;&nbsp;"+month+" "+messageSource.getMessage("title.date.span.M", null, "", null);
				
			}
			
		}else if (timekey>10000000 && timekey<90000000) {
			long tk=TimeUtil.coverStrToLong(String.valueOf(timekey), "yyyyMMdd");
			String weekday=messageSource.getMessage("title.week", null, "week", null);
			String fmt=messageSource.getMessage("format.data.chinese.simple", null, "yyyy/MM/dd", null);
			Date weekStamp=TimeUtil.firstDayAtWeek(new Date(tk));
			
			weekday+=messageSource.getMessage("title.week.0", null, "0", null);
			String ds = DateUtil.format(weekStamp, fmt) + " "+weekday ;
			weekStamp=TimeUtil.lastDayAtWeek(new Date(tk));
			weekday=messageSource.getMessage("title.week", null, "week", null);
			weekday+=messageSource.getMessage("title.week.6", null, "6", null);
			String de = DateUtil.format(weekStamp, fmt) + " "+weekday;
			
			r=ds+" - "+de;
		}else {
			r+=" Error ";
		}
			
		return r;
	}

}
