package com.lerx.handlers;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.lerx.annotation.Token;
import com.lerx.sys.obj.PasswordComplexity;
import com.lerx.sys.util.StringUtil;
import com.lerx.v6.util.SysUtil;

@RequestMapping("/action_system")
@Controller
public class SystemHandler {

	@Autowired
	private ResourceBundleMessageSource messageSource;

	@RequestMapping("/random")
	@ResponseBody
	@Token(ajax = true, csrf = true)
	public String random() throws Exception {

		return StringUtil.uuidStr();
	}

	@RequestMapping("/pwsTest")
	@ResponseBody
	@Token(ajax = true, csrf = true,contrast = true)
	public int pwsComplexity(String password) throws Exception {

		PasswordComplexity pc = com.lerx.sys.util.SysUtil.init(messageSource);
		if (pc.isHighmode()) {
			boolean test = StringUtil.pwsComplexityTest(password, pc.getLenmin(), pc.getLenmax());
			if (!test) {
				return -416;
			}
		}
		return 0;
	}

	@RequestMapping("/contextPath")
	@ResponseBody
	@Token(ajax = true, contrast = true)
	public String contextPath(HttpServletRequest request) throws Exception {

		return request.getContextPath();
	}

	/*
	 * 取当前日期
	 */
	@ResponseBody
	@RequestMapping("/date")
	@Token(ajax = true, contrast = true)
	public String date() {
		
		
		return SysUtil.currdate(messageSource);
	}

}
