package com.lerx.handlers;

import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.ITempletPortalMainDao;
import com.lerx.entities.TempletComment;
import com.lerx.entities.TempletPortalMain;
import com.lerx.entities.TempletSubElement;
import com.lerx.hql.entities.Rs;
import com.lerx.sys.obj.LayerUploadReturnData;
import com.lerx.sys.obj.LayerUploadedReturn;
import com.lerx.sys.util.DesUtils;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.FileZip;
import com.lerx.sys.util.HttpPostUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.MavUtil;
import com.lerx.sys.util.ObjUtil;
import com.lerx.sys.util.RandomNumUtil;
import com.lerx.sys.util.SecurityUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.v6.util.TempletPortalUtil;

@RequestMapping("/action_portal_templet")
@Controller
public class TempletMainPortalHandler {

	private static final String FAILED = "jsp/result/failed";
	private static final String ADMINFAILRETURN = "_admin.login.redirect_";
	
	@Autowired
	private ITempletPortalMainDao templetPortalMainDaoImpl;

	@Autowired
	private ResourceBundleMessageSource messageSource;

	/*
	 * 本私有方法用于检测数据库的对象结构是否完整，如果不完整则进行修复
	 */
	private TempletPortalMain findByID(Long id) {
		boolean chg = false;
		TempletPortalMain touchShowTempletMain = templetPortalMainDaoImpl.findByID(id);
		if (touchShowTempletMain.getElArt() == null) {
			touchShowTempletMain.setElArt(new TempletSubElement());
			chg = true;
		}
		if (touchShowTempletMain.getElExtend() == null) {
			touchShowTempletMain.setElExtend(new TempletSubElement());
			chg = true;
		}
		if (touchShowTempletMain.getElIndex() == null) {
			touchShowTempletMain.setElIndex(new TempletSubElement());
			chg = true;
		}
		if (touchShowTempletMain.getElNav() == null) {
			touchShowTempletMain.setElNav(new TempletSubElement());
			chg = true;
		}
		if (touchShowTempletMain.getElPublic() == null) {
			touchShowTempletMain.setElPublic(new TempletSubElement());
			chg = true;
		}
		if (touchShowTempletMain.getElCorpus() == null) {
			touchShowTempletMain.setElCorpus(new TempletSubElement());
			chg = true;
		}
		if (touchShowTempletMain.getElEdit() == null) {
			touchShowTempletMain.setElEdit(new TempletSubElement());
			chg = true;
		}

		if (touchShowTempletMain.getElComment() == null) {
			touchShowTempletMain.setElComment(new TempletComment());
			chg = true;
		}
		if (chg) {
			templetPortalMainDaoImpl.modify(touchShowTempletMain);
		}
		return touchShowTempletMain;

	}

	@ModelAttribute
	public void getTempletPortalMain(@RequestParam(value = "id", required = false) Long id, Map<String, Object> map) {
		if (id != null && id > 0) {
			map.put("templetPortalMain", findByID(id));
			// System.out.println("从数据库获取对象");
		}
	}

	/*
	 * 列表
	 */
	@RequestMapping("/list")
	@Token(admin = true,csrf = true,contrast = true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String list(Map<String, Object> map, HttpSession session,
			@RequestParam(value = "page", required = false) Integer page,
			@RequestParam(value = "pageSize", required = false) Integer pageSize) {
		if (page == null) {
			page = 0;
		}
		if (pageSize == null) {
			pageSize = 10;
		}
		String securityStr = SecurityUtil.readWords(messageSource);
		map.put("security", securityStr);
		Rs rs = templetPortalMainDaoImpl.query(page, pageSize);

		map.put("rs", rs);
		String marketSrv = messageSource.getMessage("template.market.srv.url", null, "http://www.lerx.com/", null);
		marketSrv = marketSrv.trim();
		if (marketSrv.endsWith("/")) {
			marketSrv = marketSrv.substring(0, marketSrv.length() - 1);
		}
		map.put("marketUrl", marketSrv);

		map.put("pageUrl", "/action_portal_templet/list");

		return "jsp/templet/portal/list";
	}

	/*
	 * 列表
	 */
	@RequestMapping("/marketlist")
	@Token(admin = true,csrf = true,contrast = true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String marketlist(Map<String, Object> map, HttpSession session,
			@RequestParam(value = "page", required = false) Integer page,
			@RequestParam(value = "limit", required = false) Integer limit) {
		if (page == null) {
			page = 0;
		}
		if (limit == null) {
			limit = 10;
		}

		String marketSrv = messageSource.getMessage("template.market.srv.url", null, "http://www.lerx.com/", null);
		marketSrv = marketSrv.trim();
		if (marketSrv.endsWith("/")) {
			marketSrv = marketSrv.substring(0, marketSrv.length() - 1);
		}
		String securityStr = SecurityUtil.readWords(messageSource);
		securityStr+=StringUtil.md5("0"+securityStr);
		map.put("key", securityStr);
		map.put("marketUrl", marketSrv);
		map.put("page", page);
		map.put("pageSize", limit);
		map.put("marketUrl", marketSrv);

		return "jsp/templet/portal/market";
	}

	/*
	 * 增加
	 */
	@RequestMapping("/add")
	@ResponseBody
	@Token(ajax = true,csrf=true, contrast = true, log = true, mark = "template-portal--<add>", admin = true, failedPage = FAILED, msgKey = "fail.permission")
	public int add(String name, HttpServletRequest request, Map<String, Object> map) {

		if (name == null || name.trim().equals("")) {
			return -410;
		}
		List<TempletPortalMain> findedResult = templetPortalMainDaoImpl.findByTitle(name,0);
		if (findedResult.size() > 0) {
			return -502;
		}
		TempletPortalMain templetPortalMain = new TempletPortalMain();
		templetPortalMain.setName(name);
		templetPortalMain.setUuid(StringUtil.uuidStr());
		templetPortalMain.setState(true);
		templetPortalMain.setDef(false);
		templetPortalMain.setFreeOnClouds(false);
		templetPortalMain.setDesignTime(System.currentTimeMillis());
		templetPortalMain.setElPublic(new TempletSubElement());
		templetPortalMain.setElIndex(new TempletSubElement());
		templetPortalMain.setElNav(new TempletSubElement());
		templetPortalMain.setElArt(new TempletSubElement());
		templetPortalMain.setElCorpus(new TempletSubElement());
		templetPortalMain.setElEdit(new TempletSubElement());
		templetPortalMain.setElExtend(new TempletSubElement());
		templetPortalMain.setElComment(new TempletComment());
		long tid = templetPortalMainDaoImpl.add(templetPortalMain);
		if (tid > 0L) {
			return 0;
		} else {
			return -1;
		}

	}

	/*
	 * 查询并进入修改页面
	 */
	@RequestMapping(value = "/edit/{id}", method = RequestMethod.GET)
	@Token(ajax = false, admin = true,csrf = true,contrast = true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String edit(@PathVariable("id") Long id, long mid, Map<String, Object> map) {
		TempletPortalMain touchShowTempletMain = findByID(id);
		map.put("touchShowTempletMain", touchShowTempletMain);
		map.put("mid", mid);
		return "tctemplet/add";
	}

	/*
	 * 修改状态
	 */
	@ResponseBody
	@RequestMapping(value = "/chgstatus/{id}", method = RequestMethod.POST)
	@Token(ajax = true,csrf=true, contrast = true, log = true, mark = "template-portal--<chgstatus>", admin = true, failedPage = FAILED, msgKey = "fail.permission")
	public int status(@PathVariable(value = "id", required = true) Long id, HttpSession session) {
		TempletPortalMain templet = templetPortalMainDaoImpl.findByID(id);
		if (templet.isDef()) {
			return -501;
		} else {
			if (templet.isState()) {
				templet.setState(false);
			} else {
				templet.setState(true);
			}
			templetPortalMainDaoImpl.modify(templet);
			return 0;
		}

	}

	/*
	 * 删除
	 */
	@ResponseBody
	@RequestMapping(value = "/del/{id}", method = RequestMethod.POST)
	@Token(ajax = true,csrf=true, contrast = true, log = true, mark = "template-portal--<del>", admin = true, failedPage = FAILED, msgKey = "fail.permission")
	public int del(@PathVariable(value = "id", required = true) Long id, HttpSession session) {
		TempletPortalMain templet = templetPortalMainDaoImpl.findByID(id);
		boolean disableEdit=false;
		String editDisable=TempletPortalUtil.sundriesTag(templet, "editDisable");
		if (editDisable.trim().equalsIgnoreCase("true")) {
			disableEdit=true;
		}
		if (disableEdit || templet.isDef()) {
			return -501;
		} else {
			String resFolder = templet.getResFolder();
			if (resFolder!=null && ! resFolder.trim().equals("")) {
				String path = FileUtil.appPath();

				String templetPortalDir = messageSource.getMessage("templet.portal.dir", null, "templates/portal", null);
				String resPath = path + File.separator + templetPortalDir + File.separator + resFolder;
				
				File res=new File(resPath);
				if (res.exists()) {
					try {
						FileUtils.deleteDirectory(res);
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
			boolean r=templetPortalMainDaoImpl.delByID(id);
			if (r) {
				return 0;
			}else {
				return -1;
			}
		}

	}

	/*
	 * 设默认
	 */
	@ResponseBody
	@RequestMapping(value = "/def/{id}")
	@Token(ajax = true,csrf=true, contrast = true, log = true, mark = "template-portal--<def>", admin = true, failedPage = FAILED, msgKey = "fail.permission")
	public int modifyDef(@PathVariable(value = "id", required = true) Integer id, HttpSession session) {
		templetPortalMainDaoImpl.setDef(id);
		if (templetPortalMainDaoImpl.findDef().getId() == id) {
			return 0;
		} else {
			return -1;
		}

	}

	/*
	 * 复制
	 */
	@ResponseBody
	@RequestMapping(value = "/copy/{id}", method = RequestMethod.POST)
	@Token(log = true, mark = "template-portal--<copy>", admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public int copy(@PathVariable(value = "id", required = true) Long id, String newTitle, HttpSession session) {
		long r;
		String folderSource,folderTarget;
		TempletPortalMain templetPortalMain = findByID(id);
		folderSource = templetPortalMain.getResFolder();
		if (folderSource==null || folderSource.trim().equals("")) {
			folderSource="default";
		}
		if (folderSource.indexOf("_") > -1) {
			String[] folder = folderSource.split("_");
			folderTarget=folder[0];
		}else {
			folderTarget=folderSource;
		}
		SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
		folderTarget +="_"+ fmt.format(Calendar.getInstance().getTime().getTime());
		TempletPortalMain templateNew = TempletPortalUtil.copy(templetPortalMain, newTitle);
		templateNew.setUuid(StringUtil.uuidStr());
		templateNew.setFreeOnClouds(false);
		templateNew.setDef(false);
		templateNew.setResFolder(folderTarget);
		r = templetPortalMainDaoImpl.add(templateNew);
		
		String path = FileUtil.appPath();
		
		String templetPortalDir = messageSource.getMessage("templet.portal.dir", null, "templates/portal", null);
		if (folderSource.trim().equals("")) {
			folderSource = "default";
		}
		String resPath = path + File.separator + templetPortalDir + File.separator;
		folderSource=resPath+folderSource;
		folderTarget=resPath+folderTarget;
		folderSource = StringUtil.strReplace(folderSource, "/\\", File.separator);
		folderTarget = StringUtil.strReplace(folderTarget, "/\\", File.separator);
		folderSource=FileUtil.repairFilePath(folderSource);
		folderTarget=FileUtil.repairFilePath(folderTarget);
		
		File fs=new File(folderSource);
		File ft=new File(folderTarget);
		if (fs.exists()) {
			try {
				FileUtils.copyDirectory(fs, ft);
				FileUtil.erable(ft);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		

		if (r > 0L) {
			return 0;
		} else {
			return -1;
		}

	}

	/*
	 * 下载
	 */
	@ResponseBody
	@RequestMapping("/downRemote")
	@Token(ajax = true, log = true, mark = "template-portal--<downRemote>", admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission")
	public int downRemote(String url, String folder) {
		url=HttpUtil.repairUrl(url);
		String path = FileUtil.appPath();
		String tempDir = messageSource.getMessage("temp.dir", null, "temp", null);
		path += File.separator + tempDir;
		path=FileUtil.repairFilePath(path);
		File filePath = new File(path);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}

		URL urlfile = null;
		HttpURLConnection httpUrl = null;
		BufferedInputStream bis = null;
		BufferedOutputStream bos = null;
		String newfile=filePath + File.separator + "aaa.zip";
		newfile=FileUtil.repairFilePath(newfile);
		File f = new File(newfile);
		try {
			urlfile = new URL(url);
			httpUrl = (HttpURLConnection) urlfile.openConnection();
			httpUrl.connect();
			bis = new BufferedInputStream(httpUrl.getInputStream());
			bos = new BufferedOutputStream(new FileOutputStream(f));
			int len = 2048;
			byte[] b = new byte[len];
			while ((len = bis.read(b)) != -1) {
				bos.write(b, 0, len);
			}

			bos.flush();
			bos.close();
			bis.close();
			httpUrl.disconnect();

			List<String> urlList = new ArrayList<>();

			path = FileUtil.appPath();

			String templetPortalDir = messageSource.getMessage("templet.portal.dir", null, "templates/portal", null);
			if (folder == null) {
				folder = "default";
			}
			String resPath = path + File.separator + templetPortalDir + File.separator;

			FileZip.unZip(f, resPath, urlList);

			for (String s : urlList) {
				if (s.endsWith(".portal")) {
					String templateFile = s;
					TempletPortalMain temp, tfind;
					temp = (TempletPortalMain) ObjUtil.objectXmlDecoder(templateFile).get(0);
					// temp.setName(temp.getUuid());
					tfind = templetPortalMainDaoImpl.findByUuid(temp.getUuid());
					
					if (tfind != null) {
						TempletPortalUtil.copy(temp, tfind);
						tfind.setModifyTime(System.currentTimeMillis());
						if (tfind.isDef()) {
							tfind.setDef(true);
						}
						templetPortalMainDaoImpl.modify(tfind);

					} else {
						TempletPortalMain templateNew = TempletPortalUtil.copy(temp, temp.getName());
						templateNew.setDesignTime(System.currentTimeMillis());
						templateNew.setModifyTime(System.currentTimeMillis());
						templateNew.setUuid(temp.getUuid());
						templateNew.setFreeOnClouds(false);
						templetPortalMainDaoImpl.add(templateNew);
					}

					FileUtil.delete(s);

				}

				if (s.endsWith("md5") || s.endsWith("security")) {
					FileUtil.delete(s);
				}

			}
			// 下面设置文件可读
			f = new File(resPath);
			FileUtil.erable(f);
//			FileUtil.erablePath(resPath);
			f.delete();
			return 0;
		} catch (Exception e) {
			e.printStackTrace();
			return -1;
		}
	}

	/*
	 * 下载
	 */
	@ResponseBody
	@RequestMapping(value = "/download/{id}")
	@Token(ajax = true, log = true, mark = "template-portal--<down>", admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission")
	public int download(@PathVariable(value = "id", required = true) Long id, HttpServletResponse response)
			throws FileNotFoundException, IOException, Exception {
		TempletPortalMain templetPortalMain = findByID(id);
		templetPortalMain.setUuid(StringUtil.uuidStr());
		String path = FileUtil.appPath();
		String tempDir = messageSource.getMessage("temp.dir", null, "temp", null);
		path += File.separator + tempDir;
		File filePath = new File(path);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}
		java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
		String dateStr = fmt.format(System.currentTimeMillis());
		String fileName = "portalTemplate_" + dateStr + ".portal";
		ObjUtil.objectXmlEncoder(templetPortalMain, path + File.separator + fileName);
		FileUtil.download(response, path, fileName);
		/*
		 * System.out.println(path+" "+fileName); Thread.sleep(20000);
		 */

		FileUtil.delete(path, fileName);
		return 0;
	}

	/*
	 * 模板完整性检查
	 */
	@ResponseBody
	@RequestMapping(value = "/integrityCheck/{id}", method = RequestMethod.POST)
	@Token(ajax = true, admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission")
	public String integrityCheck(@PathVariable(value = "id", required = true) Long id) {
		String msg = "";
		TempletPortalMain templetPortalMain = findByID(id);
		// 检查模板中的标签有没有值
		if (templetPortalMain.getResFolder() == null || templetPortalMain.getResFolder().trim().equals("")) {
			msg += messageSource.getMessage("warn.template.res.folder.notdefinition", null, "", null);
		} else {
			String path = FileUtil.appPath();

			String templetPortalDir = messageSource.getMessage("templet.portal.dir", null, "templates/portal", null);

			String resPath = path + File.separator + templetPortalDir + File.separator
					+ templetPortalMain.getResFolder();

			File filePath = new File(resPath);
			if (!filePath.exists()) {
				msg += messageSource.getMessage("warn.template.res.folder.notfound", null, "", null) + "(" + filePath
						+ ")!";
			}
			String demoJpg = resPath + File.separator + "images" + File.separator + "demo.jpg";
			filePath = new File(demoJpg);
			if (!filePath.exists()) {
				msg += "<br />" + messageSource.getMessage("warn.template.res.demo.notfound", null, "", null) + "("
						+ filePath + ")!";
			}
		}

		return msg;
	}

	// 云端模板
	@ResponseBody
	@RequestMapping(value = "/remote/{id}")
	@Token(ajax = true, admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission")
	public ModelAndView remote(@PathVariable(value = "id", required = true) Long id, Map<String, Object> map) {
		map.put("remotID", id);
		String marketSrv = messageSource.getMessage("template.market.srv.url", null, "http://www.lerx.com/", null);
		marketSrv = marketSrv.trim();
		if (marketSrv.endsWith("/")) {
			marketSrv = marketSrv.substring(0, marketSrv.length() - 1);
		}
		map.put("marketUrl", marketSrv);
		String securityStr = SecurityUtil.readWords(messageSource);
		int keyn=RandomNumUtil.getRandom(1, 20);
		map.put("keyn", keyn);
		
		map.put("safekey", DesUtils.escapeStr(DesUtils.encode(securityStr, keyn),false,true));
		return MavUtil.mav1("jsp/templet/portal/remote", "");
	}

	@ResponseBody
	@RequestMapping(value = "/report/{id}")
	@Token(ajax = true, log = true, mark = "template-portal--<report>", admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission")
	public int report(@PathVariable(value = "id", required = true) Long id, HttpServletResponse response)
			throws FileNotFoundException, IOException, Exception {
		
		
		TempletPortalMain templetPortalMain = findByID(id);
		templetPortalMain.setState(true);
		String uuid = templetPortalMain.getUuid();
		String securityStr = SecurityUtil.readWords(messageSource);
		// System.out.println("securityStr:"+securityStr);
		templetPortalMain.setOwnerToken(StringUtil.md5(uuid + securityStr));
		String path = FileUtil.appPath();
		String templetPortalDir = messageSource.getMessage("templet.portal.dir", null, "templates/portal", null);
		String resPath = path + File.separator + templetPortalDir + File.separator + templetPortalMain.getResFolder();
		String reportPath = path + File.separator + "report";
		String tempDir = messageSource.getMessage("temp.dir", null, "temp", null);
		String tmpPath = path + File.separator + tempDir;
		resPath = StringUtil.strReplace(resPath, "\\", File.separator);

		File filePath = new File(resPath);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}
		filePath = new File(reportPath);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}

		filePath = new File(tmpPath);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}

		java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
		String dateStr = fmt.format(System.currentTimeMillis());
		String fileName = "portalTemplate_" + dateStr + ".portal";
		String templetFile = tmpPath + File.separator + fileName;
		ObjUtil.objectXmlEncoder(templetPortalMain, templetFile);
		FileInputStream fis = new FileInputStream(templetFile);
		String md5 = DigestUtils.md5DigestAsHex(IOUtils.toByteArray(fis));
		fis.close();
		fis = null;

		String md5File = tmpPath + File.separator + "md5";
		String securityFile = tmpPath + File.separator + "security";
		FileUtil.writeStringToFile(md5File, md5, false, messageSource.getMessage("charset", null, "UTF-8", null));
		FileUtil.writeStringToFile(securityFile, securityStr, false,
				messageSource.getMessage("charset", null, "UTF-8", null));
		FileZip zc = new FileZip(reportPath + File.separator + uuid + ".zip");
		templetFile = FileUtil.repairFilePath(templetFile);
		md5File = FileUtil.repairFilePath(md5File);
		securityFile = FileUtil.repairFilePath(securityFile);
		reportPath = FileUtil.repairFilePath(reportPath);
		resPath = FileUtil.repairFilePath(resPath);
		zc.compress(templetFile, resPath, md5File, securityFile);
		File f = new File(reportPath + File.separator + uuid + ".zip");
		float fileSize = ((float)f.length()) / (1024*1024);
		float maxFileSize = Float.parseFloat(messageSource.getMessage("templet.file.zip.maxMB", null, "10", null));
		if (fileSize>maxFileSize) {
			return -413;
		}

		String marketSrv = messageSource.getMessage("template.market.srv.url", null, "http://www.lerx.com/", null);
		marketSrv = marketSrv.trim();
		if (marketSrv.endsWith("/")) {
			marketSrv = marketSrv.substring(0, marketSrv.length() - 1);
		}
		
		
		// 此处修改为自己上传文件的地址
		String url = marketSrv + "/action_templet_market/receive/" + templetPortalMain.getUuid() + "/" + md5;
		securityStr+=StringUtil.md5("0"+securityStr);
		url+="/"+securityStr;
		String rstr = HttpPostUtil.uploadFile(f, url);
		if (StringUtil.isNumber(rstr)) {
			return Integer.valueOf(rstr);
		} else {
			return -1;
		}

	}

	/*
	 * 导入
	 */
	@RequestMapping(value = "/import", method = RequestMethod.POST)
	@ResponseBody
	@Token(ajax = true, log = true, mark = "template-portal--<import>", admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission")
	public LayerUploadedReturn importTemplet(@RequestParam(value = "file", required = false) MultipartFile file,
			HttpSession session) throws Exception {
		long r;

		String path = FileUtil.appPath();
		String tempDir = messageSource.getMessage("temp.dir", null, "temp", null);
		path += File.separator + tempDir;

		File filePath = new File(path);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}

		String fileName = path + File.separator + "portalTemplate_import_tmp.xml";
		fileName = FileUtil.repairFilePath(fileName);
		FileUtil.upload(file, tempDir+"/portalTemplate_import_tmp.xml");
		File f = new File(fileName);
		TempletPortalMain temp = (TempletPortalMain) ObjUtil.objectXmlDecoder(f.toString()).get(0);
		java.text.SimpleDateFormat fmt = new java.text.SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
		String dateStr = fmt.format(System.currentTimeMillis());
		String title = messageSource.getMessage("template.import.name", null, "newTemplate", null);

		TempletPortalMain templateNew = TempletPortalUtil.copy(temp, title + "_" + dateStr);
		templateNew.setUuid(StringUtil.uuidStr());
		templateNew.setFreeOnClouds(false);
		templateNew.setDef(false);
		r = templetPortalMainDaoImpl.add(templateNew);

		LayerUploadReturnData rd = new LayerUploadReturnData();
		LayerUploadedReturn lur = new LayerUploadedReturn();
		rd.setSrc("");
		lur.setData(rd);
		if (r > 0L) {
			lur.setCode(0);
			FileUtil.delete(fileName);
			lur.setMsg(messageSource.getMessage("success.upload", null, "Upload success!", null));
		} else {
			lur.setCode(-1);
			lur.setMsg(messageSource.getMessage("fail.upload", null, "Upload failure!", null));
		}

		return lur;

	}

	/*
	 * 获取类的属性，用于修改模板
	 */

	@RequestMapping(value = "/fields/{id}/{area}")
	@Token(admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String fields(@PathVariable(value = "id", required = true) Long id,
			@PathVariable(value = "area", required = true) Integer area, Map<String, Object> map) {
		TempletPortalMain templetPortalMain = findByID(id);
		
		List<String> fieldsList = new ArrayList<String>();
		List<String> elsList = new ArrayList<String>();
		String type;
		Field[] field = templetPortalMain.getClass().getDeclaredFields();
		for (int j = 0; j < field.length; j++) {
			type = field[j].getGenericType().toString();
			if (type.endsWith("TempletSubElement")) {
				field[j].setAccessible(true);
				String name = field[j].getName(); // 获取属性的名字
				if (name.endsWith("Index")) {
					name = " (" + messageSource.getMessage("el.area.index", null, null) + ")" + name;
				} else if (name.endsWith("Nav")) {
					name = " (" + messageSource.getMessage("el.area.nav", null, null) + ")" + name;
				} else if (name.endsWith("Art")) {
					name = " (" + messageSource.getMessage("el.area.art", null, null) + ")" + name;
				} else if (name.endsWith("Corpus")) {
					name = " (" + messageSource.getMessage("el.area.corpus", null, null) + ")" + name;
				} else if (name.endsWith("Public")) {
					name = " (" + messageSource.getMessage("el.area.public", null, null) + ")" + name;
				} else if (name.endsWith("Edit")) {
					name = " (" + messageSource.getMessage("el.area.edit", null, null) + ")" + name;
				} else if (name.endsWith("Extend")) {
					name = " (" + messageSource.getMessage("el.area.extend", null, null) + ")" + name;
				}
				elsList.add(name);
			} else if (type.endsWith("TempletComment")) {
				field[j].setAccessible(true);
				String name = field[j].getName(); // 获取属性的名字
				name = " (" + messageSource.getMessage("el.area.comment", null, null) + ")" + name;
				elsList.add(name);
			}
		}
		if (area > 0) {
			switch (area) {
			case 8:
				TempletComment elc = new TempletComment();
				field = elc.getClass().getDeclaredFields();
				break;
			default:
				TempletSubElement el = new TempletSubElement();
				field = el.getClass().getDeclaredFields();
			}

		}

		for (int j = 0; j < field.length; j++) {
			type = field[j].getGenericType().toString();
			if (type.endsWith("java.lang.String")) {
				String name = field[j].getName(); // 获取属性的名字
				fieldsList.add(name);
			}
		}

		map.put("templetID", templetPortalMain.getId());
		map.put("els", elsList);
		map.put("fields", fieldsList);
		map.put("templetTitle", templetPortalMain.getName());
		map.put("area", area);
		String editDisable=TempletPortalUtil.sundriesTag(templetPortalMain, "editDisable");
		if (editDisable.trim().equalsIgnoreCase("true")) {
			map.put("editDisable", true);
		}
		return "jsp/templet/portal/details";
	}

	/*
	 * 获取类的属性，用于修改模板
	 */

	@RequestMapping(value = "/viewcode/{id}/{area}/{var}")
	@Token(admin = true, contrast = true,csrf = true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String code(@PathVariable(value = "id", required = true) Long id,
			@PathVariable(value = "area", required = true) Integer area,
			@PathVariable(value = "var", required = true) String var, Map<String, Object> map, HttpSession session)
			throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IntrospectionException {
		TempletPortalMain templetPortalMain = findByID(id);
		String value = "";
		String areaTitle = "";

		switch (area) {
		case 0: // 全局
			value = (String) ObjUtil.getProperty(templetPortalMain, var);
			areaTitle = messageSource.getMessage("el.area.main", null, null);
			break;
		case 1: // public模块
			TempletSubElement el = templetPortalMain.getElPublic();
			areaTitle = messageSource.getMessage("el.area.public", null, null);
			value = (String) ObjUtil.getProperty(el, var);
			break;
		case 2: // index
			value = (String) ObjUtil.getProperty(templetPortalMain.getElIndex(), var);
			areaTitle = messageSource.getMessage("el.area.index", null, null);
			break;
		case 3: // nav
			value = (String) ObjUtil.getProperty(templetPortalMain.getElNav(), var);
			areaTitle = messageSource.getMessage("el.area.nav", null, null);
			break;
		case 4: // art
			value = (String) ObjUtil.getProperty(templetPortalMain.getElArt(), var);
			areaTitle = messageSource.getMessage("el.area.art", null, null);
			break;
		case 5: // corpus
			value = (String) ObjUtil.getProperty(templetPortalMain.getElCorpus(), var);
			areaTitle = messageSource.getMessage("el.area.corpus", null, null);
			break;
		case 6: // edit
			value = (String) ObjUtil.getProperty(templetPortalMain.getElEdit(), var);
			areaTitle = messageSource.getMessage("el.area.edit", null, null);
			break;
		case 7: // extend
			value = (String) ObjUtil.getProperty(templetPortalMain.getElExtend(), var);
			areaTitle = messageSource.getMessage("el.area.extend", null, null);
			break;
		case 8: // extend
			value = (String) ObjUtil.getProperty(templetPortalMain.getElComment(), var);
			areaTitle = messageSource.getMessage("el.area.comment", null, null);
			break;
		}

		map.put("code", value);
		map.put("areaTitle", areaTitle);
		map.put("area", area);

		map.put("templetID", templetPortalMain.getId());
		map.put("var", var);
		String editDisable=TempletPortalUtil.sundriesTag(templetPortalMain, "editDisable");
		if (editDisable.trim().equalsIgnoreCase("true")) {
			map.put("editDisable", true);
		}
		return "jsp/templet/portal/viewcode";
	}

	/*
	 * 修改模板
	 */

	@RequestMapping(value = "/modifyCode/{id}/{area}/{var}")
	@Token(ajax = false, log = true, mark = "template-portal--<modify>", admin = true, csrf = true, failedPage = FAILED, msgKey = "fail.permission",failedReturnUrl = ADMINFAILRETURN)
	public String modifyCode(HttpServletRequest request, @PathVariable(value = "id", required = true) Long id,
			@PathVariable(value = "area", required = true) Integer area,
			@PathVariable(value = "var", required = true) String var, String code, Map<String, Object> map,
			HttpSession session)
			throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IntrospectionException {
		TempletPortalMain templetPortalMain = findByID(id);

		switch (area) {
		case 0: // 全局
			if (!var.trim().equalsIgnoreCase("uuid") && !var.trim().equalsIgnoreCase("ownerToken")) {
				ObjUtil.setProperty(templetPortalMain, var, code);
			}

			// templetPortalMainDaoImpl.modify(templetPortalMain);
			// value=(String) ObjUtil.getProperty(touchShowTempletMain, var);
			break;
		case 1: // public模块
			ObjUtil.setProperty(templetPortalMain.getElPublic(), var, code);

			// value=(String) ObjUtil.getProperty(touchShowTempletMain.getElPublic(), var);
			break;
		case 2: // index
			ObjUtil.setProperty(templetPortalMain.getElIndex(), var, code);
			// value=(String) ObjUtil.getProperty(touchShowTempletMain.getElIndex(), var);
			break;
		case 3: // nav
			ObjUtil.setProperty(templetPortalMain.getElNav(), var, code);
			// value=(String) ObjUtil.getProperty(touchShowTempletMain.getElNav(), var);
			break;
		case 4: // art
			ObjUtil.setProperty(templetPortalMain.getElArt(), var, code);
			// value=(String) ObjUtil.getProperty(touchShowTempletMain.getElArt(), var);
			break;
		case 5: // corpus
			ObjUtil.setProperty(templetPortalMain.getElCorpus(), var, code);
			// value=(String) ObjUtil.getProperty(touchShowTempletMain.getElSearch(), var);
			break;
		case 6: // search
			ObjUtil.setProperty(templetPortalMain.getElEdit(), var, code);
			// value=(String) ObjUtil.getProperty(touchShowTempletMain.getElSearch(), var);
			break;
		case 7: // search
			ObjUtil.setProperty(templetPortalMain.getElExtend(), var, code);
			// value=(String) ObjUtil.getProperty(touchShowTempletMain.getElSearch(), var);
			break;
		case 8: // search
			ObjUtil.setProperty(templetPortalMain.getElComment(), var, code);
			// value=(String) ObjUtil.getProperty(touchShowTempletMain.getElSearch(), var);
			break;
		}

		if (area == 0) {

			if (!var.trim().equalsIgnoreCase("uuid") && !var.trim().equalsIgnoreCase("ownerToken")) {
				templetPortalMainDaoImpl.modify(templetPortalMain);
			}
		} else {
			templetPortalMainDaoImpl.modify(templetPortalMain);
		}

		map.put("area", area);
		map.put("templetID", templetPortalMain.getId());
		map.put("var", var);

		String url = request.getContextPath() + "/action_portal_templet/fields/" + id + "/" + area;

		map.put("his", url);
		return "jsp/templet/success";
	}

}
