package com.lerx.handlers;

import java.util.List;

import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.lerx.dao.iface.IAlbgenreDao;
import com.lerx.dao.iface.IGroupDao;
import com.lerx.dao.iface.IMailTeamUnitDao;
import com.lerx.entities.Albgenre;
import com.lerx.entities.ArticleGroup;
import com.lerx.entities.MailTeamUnit;
import com.lerx.log.util.LogWrite;
import com.lerx.mail.obj.MailMessage;
import com.lerx.mail.util.MailUtil;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.v6.util.AlbgenreUtil;
import com.lerx.v6.util.GroupUtil;

@Component
public class TimerHandler {

	@Autowired
	private IGroupDao groupDaoImpl;

	@Autowired
	private IAlbgenreDao albgenreDaoImpl;

	@Autowired
	private IMailTeamUnitDao mailTeamUnitDaoImpl;

	@Autowired
	private ResourceBundleMessageSource messageSource;

	@Value("${mail.server.config.success:false}")
	private String mailSrvConfigSuccess;

	@Value("${sms.server.config.success:false}")
	private String smsSrvConfigSuccess;

	@Value("${context.path}")
	private String contextPath;

	// @Scheduled(fixedRate = 1000*60*30)
	public void htmlCreateUpdate() {
		List<ArticleGroup> list = groupDaoImpl.queryChanged();
		String realPath, strCreateDateTime, fromurl;
		String charset = messageSource.getMessage("charset", null, "utf-8", null);
		String htmlRoot = messageSource.getMessage("group.file.static.root", null, "html", null);
		if (htmlRoot != null
				&& (htmlRoot.trim().equalsIgnoreCase("WebRoot") || htmlRoot.trim().equalsIgnoreCase("root"))) {
			htmlRoot = "";
		}
		String indexFile = messageSource.getMessage("file.html.default", null, "index.html", null);

		strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
		fromurl = contextPath + "show_portal/index";
		String index = FileUtil.appPath() + indexFile;
		FileUtil.htmlBySniff(fromurl, index, strCreateDateTime, charset);

		for (ArticleGroup ag : list) {
			if (GroupUtil.openChk(ag) && (ag.getJumpToUrl() == null || ag.getJumpToUrl().trim().equals(""))) {
				realPath = FileUtil.appPath() + GroupUtil.htmlFolder(ag, htmlRoot);
				realPath = FileUtil.repairFilePath(realPath) + indexFile;
				strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
				fromurl = contextPath + "show_portal/nav/" + ag.getId();
				FileUtil.htmlBySniff(fromurl, realPath, strCreateDateTime, charset);
			}
		}
		List<Albgenre> list2 = albgenreDaoImpl.queryAll();
		for (Albgenre genre : list2) {
			Albgenre albgenre = albgenreDaoImpl.findByID(genre.getId());
			AlbgenreUtil.htmlCreate(albgenre, messageSource, contextPath);
		}

		// 发邮件
		if (mailSrvConfigSuccess.trim().equalsIgnoreCase("true")) {
			List<MailTeamUnit> mlist = mailTeamUnitDaoImpl.findCurr();

			for (MailTeamUnit unit : mlist) {
				
				/*
				 * System.out.println(); System.out.println("正在发送第 "+(mlist.indexOf(unit)+1) +
				 * " 封邮件：" + unit.toString() );
				 */
				boolean isend = send(unit, charset);

				do {
					// 一秒判断一次是否执行完成，这里可以自由设置
					try {
						Thread.sleep(300);
					} catch (InterruptedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					if (isend) {
						break;
					}
				} while (true);
			}

			/*
			for (MailTeamUnit unit : mlist) {

				MailMessage mes = new MailMessage();
				mes.setCharset(charset);
				String recipients = unit.getRecipient();

				mes.setRecipient(recipients);
				mes.setBody(unit.getContent());
				mes.setSubject(unit.getSubject());

				int r = MailUtil.send(mes);

				try {
					Thread.sleep(300);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				if (r < 0) {

					String lb = System.getProperty("line.separator");
					String err = "info-proce-doAfterreturing " + lb
							+ "An error occurred during the mail delivery. Error code:" + r + ".";
					err += lb + "mail unit id:" + unit.getId();

					try {
						LogWrite.logWrite(HttpUtil.currRequest(), err);
					} catch (Exception e) {
						e.printStackTrace();
					}
					unit.setFailures(unit.getFailures() + 1);
					String failedLog = unit.getFailedLog();

					if (failedLog == null) {
						failedLog = "";
					}
					if (unit.getFailures() > 4) {
						unit.setFailures(unit.getFailures() + 1);
						unit.setDeled(true);
					}

					failedLog += unit.getFailures() + ":" + err + lb;
					unit.setFailedLog(failedLog);
					mailTeamUnitDaoImpl.modify(unit);

				} else {
					unit.setSendedDT(System.currentTimeMillis());
					unit.setStatus(true);
					mailTeamUnitDaoImpl.modify(unit);
				}

			}
			*/
		}

		/*
		 * SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd H:m:s");
		 * System.out.println("timer : "+format.format(new Date()));
		 */
	}

	private boolean send(MailTeamUnit unit, String charset) {
		String recipient=unit.getRecipient();
		if (recipient==null || recipient.trim().equals("null;") || recipient.indexOf("@") == -1 ) {
			unit.setDeled(true);
			mailTeamUnitDaoImpl.modify(unit);
			return true;
		}

		try {
			Thread.sleep(300);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		MailMessage mes = new MailMessage();
		mes.setCharset(charset);
		String recipients = unit.getRecipient();

		mes.setRecipient(recipients);
		mes.setBody(unit.getContent());
		mes.setSubject(unit.getSubject());

		int r = MailUtil.send(mes);

		if (r < 0) {

			String lb = System.getProperty("line.separator");
			String err = "info-proce-doAfterreturing " + lb + "An error occurred during the mail delivery. Error code:"
					+ r + ".";
			err += lb + "mail unit id:" + unit.getId();

			try {
				LogWrite.logWrite(HttpUtil.currRequest(), err);
			} catch (Exception e) {
				e.printStackTrace();
			}
			unit.setFailures(unit.getFailures() + 1);
			String failedLog = unit.getFailedLog();

			if (failedLog == null) {
				failedLog = "";
			}
			if (unit.getFailures() > 4) {
				unit.setFailures(unit.getFailures() + 1);
				unit.setDeled(true);
			}

			failedLog += unit.getFailures() + ":" + err + lb;
			unit.setFailedLog(failedLog);
			mailTeamUnitDaoImpl.modify(unit);

		} else {
			unit.setSendedDT(System.currentTimeMillis());
			unit.setStatus(true);
			mailTeamUnitDaoImpl.modify(unit);
		}

		return true;

	}

}
