package com.lerx.handlers;

import com.baidu.ueditor.ActionEnter;
import com.lerx.annotation.Token;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;


@Controller
@Scope("prototype")
@RequestMapping("/action_uedit")
public class UEditorController {
	
	
	@RequestMapping(value="/config")
	@Token(csrf = true,contrast = true)
    public void config(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
 
		request.setCharacterEncoding( "utf-8" );
		response.setHeader("Content-Type" , "text/html");
		
        response.setContentType("application/json");
        String rootPath = request.getSession()
                .getServletContext().getRealPath("/");
        
        try {
            String exec = new ActionEnter(request, rootPath).exec();
            PrintWriter writer = response.getWriter();
            writer.write(exec);
            writer.flush();
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
 
    }

}
