package com.lerx.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.annotation.Token;
import com.lerx.app.util.SafeStrUtil;
import com.lerx.dao.iface.IAlbumArticleDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.dao.iface.IArticleDao;
import com.lerx.dao.iface.IBaseDao;
import com.lerx.dao.iface.ICommentBridgeDao;
import com.lerx.dao.iface.ICommentThreadDao;
import com.lerx.dao.iface.ILoginConnecterDao;
import com.lerx.dao.iface.IPortalDao;
import com.lerx.dao.iface.IRoleDao;
import com.lerx.dao.iface.IUploadedFileDao;
import com.lerx.dao.iface.IUserArtsCountDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.LoginConnecter;
import com.lerx.entities.Portal;
import com.lerx.entities.Role;
import com.lerx.entities.User;
import com.lerx.hql.entities.Rs;
import com.lerx.ip.util.IPUtil;
import com.lerx.login.util.LoginSafeRecUtil;
import com.lerx.login.util.LoginUtil;
import com.lerx.open.sdk.util.SignUtil;
import com.lerx.open.sdk.wechat.OauthWeChat;
import com.lerx.portal.obj.ConnecterValidateRetrun;
import com.lerx.portal.obj.LayuiTransferData;
import com.lerx.portal.obj.LoginTest;
import com.lerx.portal.obj.LoginTestObj;
import com.lerx.portal.obj.AlbsShowAtUserCard;
import com.lerx.portal.obj.ConnecterUserInf;
import com.lerx.portal.obj.ResponseResult;
import com.lerx.portal.obj.SimpleAlbum;
import com.lerx.portal.obj.UserCollect;
import com.lerx.portal.obj.UserInfCompleteness;
import com.lerx.sms.tencent.cloudapi.obj.TencentSms;
import com.lerx.sms.tencent.cloudapi.util.SmsUtil;
import com.lerx.sys.obj.LoginSessionTest;
import com.lerx.sys.obj.PasswordComplexity;
import com.lerx.sys.obj.Website;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.MavUtil;
import com.lerx.sys.util.SecurityUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.v6.util.AlbumUtil;
import com.lerx.v6.util.CaptchaUtil;
import com.lerx.v6.util.ConfigUtil;
import com.lerx.v6.util.PortalUtil;
import com.lerx.v6.util.UserUtil;
import com.qq.connect.QQConnectException;
import com.qq.connect.api.OpenID;
import com.qq.connect.api.qzone.UserInfo;
import com.qq.connect.javabeans.AccessToken;
import com.qq.connect.javabeans.qzone.UserInfoBean;
import com.qq.connect.oauth.Oauth;
import com.tencentcloudapi.sms.v20190711.models.SendSmsResponse;

import net.sf.json.JSONArray;
import weibo4j.http.Response;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

@RequestMapping("/action_user")
@Controller
public class UserHandler {

	private static final String SUCCESS = "jsp/result/success";
	private static final String FAILED = "jsp/result/failed";
	private static final String ADMINFAILRETURN = "_admin.login.redirect_";
	private static final String LOGINPAGE = "jsp/user/login";
	private static final String USERLIST = "jsp/user/list";
	private static final String USERADD = "jsp/user/add";
	private static final String ADMINFORBID = "_admin.forbid_";

	@Autowired
	private IBaseDao baseDaoImpl;

	@Autowired
	private ResourceBundleMessageSource messageSource;

	@Autowired
	private IPortalDao portalDaoImpl;

	@Autowired
	private IUserDao userDaoImpl;

	@Autowired
	private IArticleDao articleDaoImpl;
	
	@Autowired
	private IAlbumArticleDao albumArticleDaoImpl;

	@Autowired
	private IRoleDao roleDaoImpl;

	@Autowired
	private IAlbumDao albumDaoImpl;

	@Autowired
	private ICommentBridgeDao commentBridgeDaoImpl;

	@Autowired
	private ICommentThreadDao commentThreadDaoImpl;

	@Autowired
	private IUploadedFileDao uploadedFileDaoImpl;

	@Autowired
	private IUserArtsCountDao userArtsCountDaoImpl;

	@Autowired
	private ILoginConnecterDao loginConnecterDaoImpl;

	@Autowired
	private IAlbumPartnerDao albumPartnerDaoImpl;


	@Value("${mail.server.config.success:false}")
	private String mailSrvConfigSuccess;
	
	@Value("${sms.server.config.success:false}")
	private String smsSrvConfigSuccess;

	/*
	 * 列表（扩展，可查第三方登录）
	 */
	@RequestMapping(value = { "/listExt/{gid}/{page}/{pagesize}", "/listExt/{gid}", "/listExt" })
	@Token(admin = true,csrf = true,contrast = true, failedPage = FAILED, msgKey = "fail.permission", failedReturnUrl = ADMINFAILRETURN)
	public ModelAndView listExt(@PathVariable(value = "gid", required = false) Long gid,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpSession session,
			Map<String, Object> map) {
		if (gid == null) {
			gid = 0L;
		}
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		Rs rs = userDaoImpl.find(gid, page, pagesize);
		@SuppressWarnings("unchecked")
		List<User> ulist = (List<User>) rs.getList();
		List<UserCollect> uclist = new ArrayList<UserCollect>();
		for (User u : ulist) {
			UserCollect uc = new UserCollect();
			uc.setUser(u);
			LoginConnecter lc = loginConnecterDaoImpl.findByUID(u.getId());

			if (lc != null) {
				if (lc.getOpenIDAtQQ() != null && !lc.getOpenIDAtQQ().trim().equals("")) {
					uc.setQq(true);
				}

				if (lc.getOpenIDAtWeChat() != null && !lc.getOpenIDAtWeChat().trim().equals("")) {
					uc.setWechat(true);
				}

				if (lc.getOpenIDAtWeibo() != null && !lc.getOpenIDAtWeibo().trim().equals("")) {
					uc.setWeibo(true);
				}
			} else {
				lc = new LoginConnecter();
				lc.setUser(u);
			}

			uc.setLc(lc);
			uclist.add(uc);
		}
		rs.setList(uclist);
		map.put("pageUrl", "/action_user/listExt/" + gid);
		map.put("rs", rs);

		return MavUtil.mav1("jsp/user/listExt", "");

	}

	/*
	 * 列表
	 */
	@RequestMapping(value = { "/list/{gid}/{page}/{pagesize}", "/list/{gid}", "/list" })
	@Token(admin = true,csrf = true,contrast = true, failedPage = FAILED, msgKey = "fail.permission", failedReturnUrl = ADMINFAILRETURN)
	public ModelAndView list(@PathVariable(value = "gid", required = false) Long gid,
			@PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpSession session,
			Map<String, Object> map) {
		if (gid == null) {
			gid = 0L;
		}
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		Rs rs = userDaoImpl.find(gid, page, pagesize);
		map.put("pageUrl", "/action_user/list/" + gid);
		map.put("rs", rs);

		return MavUtil.mav1(USERLIST, "");

	}

	/*
	 * 查找
	 */
	@RequestMapping(value = { "/find/{page}/{pagesize}", "/find" })
	@Token(admin = true,csrf = true,contrast = true, failedPage = FAILED, msgKey = "fail.permission", failedReturnUrl = ADMINFAILRETURN)
	public ModelAndView find(String key, @PathVariable(value = "page", required = false) Integer page,
			@PathVariable(value = "pagesize", required = false) Integer pagesize, HttpSession session,
			Map<String, Object> map) {
		if (page == null) {
			page = 1;
		}
		if (pagesize == null) {
			pagesize = 10;
		}
		Rs rs = userDaoImpl.findByName(key, page, pagesize);
		@SuppressWarnings("unchecked")
		List<User> ulist = (List<User>) rs.getList();
		List<UserCollect> uclist = new ArrayList<UserCollect>();
		for (User u : ulist) {
			UserCollect uc = new UserCollect();
			uc.setUser(u);
			LoginConnecter lc = loginConnecterDaoImpl.findByUID(u.getId());

			if (lc != null) {
				if (lc.getOpenIDAtQQ() != null && !lc.getOpenIDAtQQ().trim().equals("")) {
					uc.setQq(true);
				}

				if (lc.getOpenIDAtWeChat() != null && !lc.getOpenIDAtWeChat().trim().equals("")) {
					uc.setWechat(true);
				}

				if (lc.getOpenIDAtWeibo() != null && !lc.getOpenIDAtWeibo().trim().equals("")) {
					uc.setWeibo(true);
				}
			} else {
				lc = new LoginConnecter();
				lc.setUser(u);
			}

			uc.setLc(lc);
			uclist.add(uc);
		}
		rs.setList(uclist);
		map.put("pageUrl", "/action_user/find");
		map.put("rs", rs);
		map.put("key", key);

		return MavUtil.mav1("jsp/user/listExt", "");

	}

	// 查找用户名
	@RequestMapping(value = "/findname")
	@ResponseBody
	@Token(ajax = true, csrf = true)
	public int findname(String name) {
		boolean find=false;
		if (userDaoImpl.findByUsername(name) != null || userDaoImpl.findByNickname(name) != null) {
			find=true;
		}
		if (find) {
			return 1;
		} else {
			return -1;
		}
	}

	// 按id查找用户名
	@ResponseBody
	@RequestMapping("/findbyuid/{uid}")
	@Token(ajax = true, admin = true,csrf = true,contrast = true)
	public String chgLeader(@PathVariable(value = "uid", required = true) Long uid) {
		User user = userDaoImpl.findByID(uid);
		if (user == null || !user.isState()) {
			return "err";
		} else {
			return user.getUsername();
		}
	}

	// 更改手机号
	@RequestMapping(value = "/chgmobile/{uid}")
	@ResponseBody
	@Token(ajax = true,csrf = true,contrast = true, log = true, loginOrAdmin = true, mark = "user--<chgmobile>")
	public int mobile(String mobile, @PathVariable("uid") Long uid,String salt,String encryptStr, HttpServletRequest request, HttpSession session) {
		long currUid = LoginUtil.uid(messageSource, request);
		if (currUid <= 0 || currUid - uid != 0L) {
			return -406;
		}
		
		String securityStr = SecurityUtil.readWords(messageSource);
		String encryptStrEnd = StringUtil.md5(StringUtil.md5(securityStr).toLowerCase().concat(salt)).toLowerCase();
		if (!encryptStrEnd.equalsIgnoreCase(encryptStr)) {
			return -408;
		}
		
		if (userDaoImpl.findByMobile(mobile, uid) != null) {
			return -502;
		} else {
			User user = userDaoImpl.findByID(uid);
			if (mobile != null) {
				mobile = mobile.trim();
			}
			if (user.getMobile() != null && user.getMobile().trim().equals(mobile)) {
				return -402;
			}
			user.setMobile(mobile);
			String cvtmp = StringUtil.switchPosition(user.getContactsVerifyed(), 2, true);
			user.setContactsVerifyed(cvtmp);
			userDaoImpl.modify(user);
			session.removeAttribute("sendTarget");
			return 0;
		}
	}

	// 更改邮箱
	@RequestMapping(value = "/chgemail/{uid}")
	@ResponseBody
	@Token(ajax = true,csrf = true,contrast = true, log = true, loginOrAdmin = true, mark = "user--<chgmobile>")
	public int email(String email, @PathVariable("uid") Long uid,String salt,String encryptStr, HttpServletRequest request, HttpSession session) {
		long currUid = LoginUtil.uid(messageSource, request);
		if (currUid <= 0 || currUid - uid != 0L) {
			return -406;
		}
		String securityStr = SecurityUtil.readWords(messageSource);
		String encryptStrEnd = StringUtil.md5(StringUtil.md5(securityStr).toLowerCase().concat(salt)).toLowerCase();
		if (!encryptStrEnd.equalsIgnoreCase(encryptStr)) {
			return -408;
		}
		if (userDaoImpl.findByEmail(email, uid) != null) {
			return -502;
		} else {
			User user = userDaoImpl.findByID(uid);
			if (email != null) {
				email = email.trim();
			}
			if (user.getEmail() != null && user.getEmail().trim().equals(email)) {
				return -402;
			}
			user.setEmail(email);
			String cvtmp = StringUtil.switchPosition(user.getContactsVerifyed(), 1, true);
			user.setContactsVerifyed(cvtmp);
			userDaoImpl.modify(user);
			session.removeAttribute("sendTarget");
			return 0;
		}
	}

	// 查找手机号
	@RequestMapping(value = "/findmobile")
	@ResponseBody
	@Token(ajax = true,csrf = true,contrast = true)
	public int findMobile(String mobile, @RequestParam(value = "uid", required = false) Long excludeID) {
		if (excludeID == null) {
			excludeID = 0L;
		}
		if (userDaoImpl.findByMobile(mobile, excludeID) != null) {
			return 1;
		} else {
			return -1;
		}
	}

	// 查找邮箱
	@RequestMapping(value = "/findemail")
	@ResponseBody
	@Token(ajax = true,csrf = true,contrast = true)
	public int findEmail(String email, @RequestParam(value = "uid", required = false) Long excludeID) {
		if (excludeID == null) {
			excludeID = 0L;
		}
		if (userDaoImpl.findByEmail(email, excludeID) != null) {
			return 1;
		} else {
			return -1;
		}
	}

	// 注册
	@RequestMapping(value = "/reg")
	@Token(csrf = true,contrast = true, log = true, mark = "user--<reg>")
	public ModelAndView addByReg(@Valid User user, Errors result, String sendTarget, HttpServletRequest request,
			HttpSession session) {
		String ip = IPUtil.getRealRemotIP(request);
		
		Portal portal = portalDaoImpl.query_update();
		String ipRegion=portal.getIpRegScope();
		if (ipRegion != null && !ipRegion.trim().equals("") && !IPUtil.isInRange(ip, ipRegion)) {
			return MavUtil.mav1(FAILED, messageSource.getMessage("fail.ip.range.outside", null,
					"The IP address that is currently used is not within the permitted range!", null));
		}

		if (session.getAttribute("sendTarget") == null || session.getAttribute("targetMode") == null) {
			return MavUtil.mav1(FAILED,
					messageSource.getMessage("fail.session.timeout", null, "Session timeout!", null));
		}
		String sessionTarget = (String) session.getAttribute("sendTarget");
		int sessionTargetMode = (int) session.getAttribute("targetMode");

		if (sendTarget == null || sendTarget.trim().equals("") || sessionTarget == null
				|| !sendTarget.trim().equalsIgnoreCase(sessionTarget)) {
			return MavUtil.mav1(FAILED,
					messageSource.getMessage("fail.session.timeout", null, "Session timeout!", null));
		}

		PasswordComplexity pc = com.lerx.sys.util.SysUtil.init(messageSource);
		if (pc.isHighmode()) {
			boolean test = StringUtil.pwsComplexityTest(user.getPassword(), pc.getLenmin(), pc.getLenmax());
			if (!test) {
				return MavUtil.mav1(FAILED, messageSource.getMessage("fail.password.complexity", null,
						"Your password does not meet the required complexity requirements!", null));
			}
		}

		if (sessionTargetMode == 0) {
			user.setEmail(sessionTarget);
			user.setContactsVerifyed(StringUtil.switchPosition("", 1, true));
		} else {
			user.setMobile(sessionTarget);
			user.setContactsVerifyed(StringUtil.switchPosition("", 2, true));
		}

		if (userDaoImpl.findByUsername(user.getUsername()) != null) {
			return MavUtil.mav3(FAILED,
					messageSource.getMessage("fail.exists.username", null, "The username has already existed!", null),
					true);
		}

		String charset = messageSource.getMessage("charset", null, "UTF-8", null);
		String filterWords = ConfigUtil.configContentsByComma("filterUsernames", charset);
		if (StringUtil.findByWords(user.getUsername(), filterWords)) {
			return MavUtil.mav3(FAILED, messageSource.getMessage("fail.wrongful.title", null,
					"The name is not legal or is forbidden to use!", null), true); // 发现保留字
		}
		filterWords = ConfigUtil.configContentsByComma("filterWords", charset);
		if (StringUtil.findByWords(user.getUsername(), filterWords)) {
			return MavUtil.mav3(FAILED, messageSource.getMessage("fail.wrongful.title", null,
					"The name is not legal or is forbidden to use!", null), true); // 发现敏感词
		}

		if (userDaoImpl.findByEmail(user.getEmail(), 0) != null) {
			return MavUtil.mav3(FAILED,
					messageSource.getMessage("fail.exists.email", null, "The email has already existed!", null), true);
		}

		if (userDaoImpl.findByMobile(user.getMobile(), 0) != null) {
			return MavUtil.mav1(FAILED,
					messageSource.getMessage("fail.exists.mobile", null, "The phone code has already existed!", null));
		}

		user.setRegCodeSendTarget(sessionTarget);

		user.setCreateIP(ip);

		user.setState(true);
		user.setRole(roleDaoImpl.findDef());
		user = userDaoImpl.add(user);
		if (user == null) {
			return MavUtil.mav1(FAILED, messageSource.getMessage("fail.universal", null, "Failed!", null));
		} else {
			session.removeAttribute("sendTarget");
			session.removeAttribute("targetMode");
			return MavUtil.mav1(SUCCESS, messageSource.getMessage("success", null, "Success!", null));
		}
	}

	// 互联登录后注册
	@RequestMapping(value = "/regByOpenID")
	@Token(csrf = true,contrast = true, log = true, mark = "user--<regbyOpenID>")
	public ModelAndView addByOpenID(@Valid User user, Errors result,
			@RequestParam(value = "sendTarget", required = false) String sendTarget,
			@RequestParam(value = "openID", required = false) String openID,
			@RequestParam(value = "referer", required = false) String referer,
			@RequestParam(value = "targetMode", required = false) int targetMode,
			@RequestParam(value = "otype", required = false) int otype, HttpServletRequest request,
			HttpServletResponse response, HttpSession session) {
		String ip = IPUtil.getRealRemotIP(request);
		
		Portal portal = portalDaoImpl.query_update();
		String ipRegion=portal.getIpRegScope();
		if (ipRegion != null && !ipRegion.trim().equals("") && !IPUtil.isInRange(ip, ipRegion)) {
			return MavUtil.mav1(FAILED, messageSource.getMessage("fail.ip.range.outside", null,
					"The IP address that is currently used is not within the permitted range!", null));
		}
		ConnecterValidateRetrun cvr = new ConnecterValidateRetrun();
		if (openID == null || openID.trim().equals("") || sendTarget == null || sendTarget.trim().equals("")) {
			cvr.setStatus(-11);
			return MavUtil.mav1(FAILED, cvr.getMessage());
		}

		cvr.setStatus(0);
		cvr.setOpenID(openID);
		cvr.setOtype(otype);

		if (targetMode == 0) {
			user.setEmail(sendTarget);
		} else {
			user.setMobile(sendTarget);
		}

		if (userDaoImpl.findByUsername(user.getUsername()) != null) {
			cvr.setStatus(-502);

			cvr.setMessage(
					messageSource.getMessage("fail.exists.username", null, "The username has already existed!", null));
			return MavUtil.mav1(FAILED, cvr.getMessage());
		}

		String charset = messageSource.getMessage("charset", null, "UTF-8", null);
		String filterWords = ConfigUtil.configContentsByComma("filterUsernames", charset);
		if (StringUtil.findByWords(user.getUsername(), filterWords)) {
			cvr.setStatus(-417);
			cvr.setMessage(messageSource.getMessage("fail.wrongful.title", null,
					"The name is not legal or is forbidden to use!", null));// 发现保留字
			return MavUtil.mav1(FAILED, cvr.getMessage());
		}
		filterWords = ConfigUtil.configContentsByComma("filterWords", charset);
		if (StringUtil.findByWords(user.getUsername(), filterWords)) {
			cvr.setStatus(-418);
			cvr.setMessage(messageSource.getMessage("fail.wrongful.title", null,
					"The name is not legal or is forbidden to use!", null));// 发现敏感词
			return MavUtil.mav1(FAILED, cvr.getMessage());
		}

		if (userDaoImpl.findByEmail(user.getEmail(), 0) != null) {
			cvr.setStatus(-502);
			cvr.setMessage(messageSource.getMessage("fail.exists.email", null, "The email has already existed!", null));// 发现重复email
			return MavUtil.mav1(FAILED, cvr.getMessage());
		}

		if (userDaoImpl.findByMobile(user.getMobile(), 0) != null) {
			cvr.setStatus(-502);
			cvr.setMessage(
					messageSource.getMessage("fail.exists.mobile", null, "The phone code has already existed!", null));// 发现重复手机号码
			return MavUtil.mav1(FAILED, cvr.getMessage());
		}

		user.setRegCodeSendTarget(sendTarget);

		user.setCreateIP(ip);

		user.setState(true);
		user.setRole(roleDaoImpl.findDef());

		String cvtmp = StringUtil.switchPosition(user.getContactsVerifyed(), targetMode + 1, true);
		user.setContactsVerifyed(cvtmp);

		user = userDaoImpl.add(user);
		if (user == null) {
			cvr.setStatus(-500);
			cvr.setMessage(messageSource.getMessage("fail.universal", null, "Failed!", null));// 数据库操作失败
			return MavUtil.mav1(FAILED, cvr.getMessage());
		} else {
			cvr.setStatus(0);

			cvr.setMessage(messageSource.getMessage("success", null, "Success!", null));// 数据库操作失败

			session.removeAttribute("sendTarget");
			session.removeAttribute("targetMode");
			referer = HttpUtil.getCookie(messageSource, request, "referer_lerx");
			request.setAttribute("referer", referer);
			HttpUtil.clearCookie(request, response, "referer_lerx");
			cvr = createConnecter(cvr, loginConnecterDaoImpl, user, otype, openID, referer, request, response, session,
					messageSource, userDaoImpl);

			return MavUtil.mav1(SUCCESS, cvr.getMessage());
		}
	}

	// 增加
	@RequestMapping(value = "/addByName")
	@ResponseBody
	@Token(ajax = true,csrf = true,contrast = true, log = true, mark = "user--<addByName>", admin = true, failedPage = FAILED, msgKey = "fail.permission")
	public int addByName(String name, HttpServletRequest request) {

		boolean existing = false;
		if (userDaoImpl.findByUsername(name) != null || userDaoImpl.findByNickname(name) != null) {
			existing = true;
		}
		String charset = messageSource.getMessage("charset", null, "UTF-8", null);
		String filterWords = ConfigUtil.configContentsByComma("filterUsernames", charset);
		if (StringUtil.findByWords(name, filterWords)) {
			return -417; // 发现保留字
		}
		filterWords = ConfigUtil.configContentsByComma("filterWords", charset);
		if (StringUtil.findByWords(name, filterWords)) {
			return -418; // 发现敏感词
		}
		if (!existing) {
			String ip = IPUtil.getRealRemotIP(request);
			User user = new User();
			user.setUsername(name);
			user.setCreateTime(System.currentTimeMillis());
			user.setCreateIP(ip);

			user.setState(true);
			user.setRole(roleDaoImpl.findDef());
			user.setPassword(messageSource.getMessage("defalut.password", null, "123456", null));
			user = userDaoImpl.add(user);
			if (user == null) {
				return -500;
			} else {
				return 0;
			}
		} else {
			return -502;
		}

	}

	// 增加
	@RequestMapping("/add")
	@Token(log = true, mark = "user--<add>", admin = true,csrf = true,contrast = true, token = true, failedPage = FAILED, msgKey = "fail.permission", failedReturnUrl = ADMINFAILRETURN)
	public String add(@Valid User user, Errors result, Map<String, Object> map, HttpServletRequest request,
			HttpSession session, String token) {
		boolean existing = false;
		boolean r = false;
		String ip = null;

		String charset = messageSource.getMessage("charset", null, "UTF-8", null);
		String filterWords = ConfigUtil.configContentsByComma("filterUsernames", charset);
		if (StringUtil.findByWords(user.getUsername(), filterWords)) {
			return FAILED; // 发现保留字
		}
		filterWords = ConfigUtil.configContentsByComma("filterWords", charset);
		if (StringUtil.findByWords(user.getUsername(), filterWords)) {
			return FAILED;
		}

		if (user.getId() == 0) {
			if (userDaoImpl.findByUsername(user.getUsername()) != null || userDaoImpl.findByNickname(user.getUsername()) != null) {
				existing = true;
			}
			if (!existing) {
				ip = IPUtil.getRealRemotIP(request);
				user.setCreateTime(System.currentTimeMillis());
				user.setCreateIP(ip);

				user.setState(true);
				user.setRole(roleDaoImpl.findDef());

				if (user.getPassword() == null || user.getPassword().trim().equals("")) {
					user.setPassword(messageSource.getMessage("defalut.password", null, "123456", null));
				}

				user = userDaoImpl.add(user);
				if (user == null) {
					r = false;
				} else {
					r = true;
					user = userDaoImpl.findByID(user.getId());
					user.setPwdAtCreate(user.getPassword());
					userDaoImpl.modify(user);
				}

			} else {
				r = false;
				map.put("error", messageSource.getMessage("fail.exists.username", null,
						"The username has already existed!", null));
			}

		} else {

			if (user.getRole().getId() == 0) {
				user.setRole(null);
			}
			User userdb = userDaoImpl.findByID(user.getId());
			String regCodeSendTarget = userdb.getRegCodeSendTarget();
			String tmpcv = userdb.getContactsVerifyed();
			userDaoImpl.modifySafely(user);
			user.setRegCodeSendTarget(regCodeSendTarget);
			user.setContactsVerifyed(tmpcv);
			userDaoImpl.modify(user);
			r = true;

		}
		if (r) {
			return SUCCESS;
		} else {
			return FAILED;
		}

	}

	// 进入修改页面
	@RequestMapping("/edit")
	@Token(admin = true,csrf = true,contrast = true, failedPage = FAILED, msgKey = "fail.nologin", failedReturnUrl = ADMINFAILRETURN)
	public String edit(Map<String, Object> map, HttpSession session, Long id) {

		User user = userDaoImpl.findByID(id);
		user.setPassword(null);
		map.put("user", user);
		List<Role> list = roleDaoImpl.queryAll();
		map.put("roles", list);
		return USERADD;

	}

	// 网站名片
	@RequestMapping(value = "/card/{id}")
	@Token(contrast = true)
	public String card(Map<String, Object> map, HttpSession session,
			@CookieValue(value = "uid_lerx", required = false) String uid_lerx,
			@PathVariable(value = "id", required = false) Long id, HttpServletRequest request) {
		if (id == null) {
			id = 0L;
		}
		long uid;
		User loginer = null;
		if (uid_lerx == null) {
			uid = 0L;
		} else {
			uid = Long.valueOf(uid_lerx);
			loginer = userDaoImpl.findByID(uid);
		}

		boolean own = false;
		if (uid - id == 0) {
			own = true;
		}

		if (id == 0L) {
			id = uid;
		}

		if (id == 0) {
			return "jsp/result/failed";
		}

		User user = userDaoImpl.findByID(id);

		if (user == null) {
			return "jsp/result/failed";
		}
		boolean isadmin = UserUtil.isadmin(loginer);
		boolean issl=false;
		if (isadmin) {
			issl=true;
		}else {
			issl=UserUtil.isSl(loginer);
		}
		if (!own && !isadmin) {
			if (user.getLastLoginIP() != null && !user.getLastLoginIP().trim().equals("")) {
				user.setLastLoginIP(IPUtil.ipFilter(user.getLastLoginIP(),
						messageSource.getMessage("ip.filter.mask", null, "1111", null)));
			}

			if (user.getCreateIP() != null && !user.getCreateIP().trim().equals("")) {
				user.setCreateIP(IPUtil.ipFilter(user.getCreateIP(),
						messageSource.getMessage("ip.filter.mask", null, "1111", null)));
			}

		}

		LoginConnecter lc = loginConnecterDaoImpl.findByUID(user.getId());
		String bindStatus = StringUtil.countStr(3, "0");

		if (lc != null) {
			if (lc.getOpenIDAtQQ() != null && !lc.getOpenIDAtQQ().trim().equals("")) {
				bindStatus = StringUtil.switchPosition(bindStatus, 1, true);
				map.put("bindQQ", true);
				map.put("unBindQQ", "");
			} else {
				map.put("bindQQ", false);
				map.put("unBindQQ", "un");
			}

			if (lc.getOpenIDAtWeChat() != null && !lc.getOpenIDAtWeChat().trim().equals("")) {
				bindStatus = StringUtil.switchPosition(bindStatus, 2, true);
				map.put("bindWeChat", true);
				map.put("unBindWeChat", "");
			} else {
				map.put("bindWeChat", false);
				map.put("unBindWeChat", "un");
			}

			if (lc.getOpenIDAtWeibo() != null && !lc.getOpenIDAtWeibo().trim().equals("")) {
				bindStatus = StringUtil.switchPosition(bindStatus, 3, true);
				map.put("bindWeibo", true);
				map.put("unBindWeibo", "");
			} else {
				map.put("bindWeibo", false);
				map.put("unBindWeibo", "un");
			}
		} else {
			map.put("unBindQQ", "un");
			map.put("unBindWeChat", "un");
			map.put("unBindWeibo", "un");
		}
		map.put("bindStatus", bindStatus); // 此处以0和1生成一个绑定状态字符串，从右侧个位开始 1qq 2微信 3微博
		map.put("isadmin", isadmin);
		map.put("own", own);
		if (user.getNickname()==null || user.getNickname().trim().equals("")) {
			user.setNickname(user.getUsername());
		}
		map.put("user", user);
		map.put("issl", issl);
		map.put("loginerID", uid);
		map.put("totalArts", articleDaoImpl.countByUid(user.getId()));
		map.put("totalAlbArts", albumArticleDaoImpl.countByOwnUID(user.getId()));

		String avatarNull = ConfigUtil.getAvatarNullFile(messageSource, request);
		map.put("avatarNull", avatarNull);
		if (UserUtil.mailUsable(user) == null) {
			map.put("mailVerify", false);
		} else {
			map.put("mailVerify", true);
		}
		if (UserUtil.mobileUsable(user) == null) {
			map.put("mobileVerify", false);
		} else {
			map.put("mobileVerify", true);
		}

		List<SimpleAlbum> albList = AlbumUtil.allByUid(id, uid, albumDaoImpl, albumPartnerDaoImpl, messageSource,
				request);
		map.put("albtotal", albList.size());

		AlbsShowAtUserCard asauc=AlbumUtil.init(albList, user.getAlbDisFilterStr());
		map.put("albList", asauc.getShow());
		return "jsp/user/card";

	}
	
	
	/*
	 * 显示用户专辑的显示设定页，通过设置，可以将部分专辑隐藏，避免过多后在个人名片中显示过长。
	 */
	@RequestMapping("/albsshow/setup/{uid}")
	@Token(ajax = false,csrf=true,contrast = true,  failedPage = LOGINPAGE, msgKey = "fail.permission")
	public String albsshowSetup(@PathVariable(value = "uid", required = true) Long uid,HttpServletRequest request, Map<String, Object> map) {
		long cookieuid = LoginUtil.uid(messageSource, request);
		if (cookieuid!=uid) {
			return FAILED;
		}
		User user = userDaoImpl.findByID(uid);
		List<SimpleAlbum> albList = AlbumUtil.allByUid(uid, cookieuid, albumDaoImpl, albumPartnerDaoImpl, messageSource,
				request);
		AlbsShowAtUserCard asauc=AlbumUtil.init(albList, user.getAlbDisFilterStr());
		map.put("asauc", asauc);
		
		String noshow="";
		
		List<LayuiTransferData> showList=new ArrayList<LayuiTransferData>();
		for (SimpleAlbum sa:albList) {
			LayuiTransferData  ltd= new LayuiTransferData();
			ltd.setValue(""+sa.getId());
			ltd.setChecked("");
			ltd.setDisabled("");
			ltd.setTitle(sa.getName());
			showList.add(ltd);
			
		}
		
		for (SimpleAlbum sa:asauc.getNoshow()) {
			noshow+="'"+sa.getId()+"',";
		}
		
		if (noshow!=null && noshow.endsWith(",")) {
			noshow=noshow.substring(0, noshow.length()-1);
			noshow="["+noshow+"]";
		}else {
			noshow="[]";
		}
		
		JSONArray showstr = JSONArray.fromObject(showList);
		map.put("noshow", noshow);
		map.put("show", showstr);
		map.put("uid", uid);
		
		return "jsp/user/albShowSet";
		
	}
	
	/*
	 * 保存隐藏码
	 */
	@ResponseBody
	@RequestMapping("/albsshow/save/{uid}")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<password-reset>")
	public int albsshowSave(@PathVariable(value = "uid", required = true) Long uid, String filterStr, HttpServletRequest request, HttpSession session) {
		long cookieuid = LoginUtil.uid(messageSource, request);
		if (cookieuid==0) {
			return -201;
		}
		if (cookieuid!=uid) {
			return -200;
		}
		User user = userDaoImpl.findByID(uid);
		if (user==null) {
			return -201;
		}
		user.setAlbDisFilterStr(filterStr);
		userDaoImpl.modify(user);
		return 0;
		
	}
		
	/*
	 * 重置密码
	 */
	@ResponseBody
	@RequestMapping("/pwsReset")
	@Token(ajax = true, csrf = true,contrast = true,  log = true, mark = "user--<password-reset>")
	public int modifyPwsReset(long uid, String password,String salt,String encryptStr, int smod, HttpServletRequest request, HttpSession session) {
		if (session.getAttribute("sendTarget") == null) {
			return -401;
		}
		
		String securityStr = SecurityUtil.readWords(messageSource);
		String encryptStrEnd = StringUtil.md5(StringUtil.md5(securityStr).toLowerCase().concat(salt)).toLowerCase();
		if (!encryptStrEnd.equalsIgnoreCase(encryptStr)) {
			return -408;
		}
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -1;
		}

		PasswordComplexity pc = com.lerx.sys.util.SysUtil.init(messageSource);
		if (pc.isHighmode()) {
			boolean test = StringUtil.pwsComplexityTest(password, pc.getLenmin(), pc.getLenmax());
			if (!test) {
				return -416;
			}
		}

		userDaoImpl.modifypw(user, password);
		user = userDaoImpl.findByID(user.getId());
		String cvtmp = StringUtil.switchPosition(user.getContactsVerifyed(), smod, true);
		user.setContactsVerifyed(cvtmp);
		userDaoImpl.modify(user);

		session.removeAttribute("sendTarget");
		return 0;
	}

	@ResponseBody
	@RequestMapping("/pws")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<password>", loginOrAdmin = true)
	public int modifyPws(long uid, String password, HttpServletRequest request, HttpSession session) {
		User user = userDaoImpl.findByID(uid);
		// long uid = LoginUtil.uid(messageSource, request);
		boolean admin = LoginUtil.adminChk(messageSource, session);
		boolean con = admin;
		long curruid = 0;
		if (!con) {
			curruid = LoginUtil.uid(messageSource, request);
			if (curruid - uid == 0) {
				con = true;
			}
		}
		if (!con) {
			return -200;
		}
		PasswordComplexity pc = com.lerx.sys.util.SysUtil.init(messageSource);
		if (pc.isHighmode()) {
			boolean test = StringUtil.pwsComplexityTest(password, pc.getLenmin(), pc.getLenmax());
			if (!test) {
				return -416;
			}
		}
		userDaoImpl.modifypw(user, password);
		if (admin && user.getId() != curruid) {
			user = userDaoImpl.findByID(user.getId());
			user.setPwdAtCreate(user.getPassword());
			userDaoImpl.modify(user);
		}
		return 0;
	}

	@ResponseBody
	@RequestMapping("/truename")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<truename>", loginOrAdmin = true)
	public int modifyTruename(long uid, String truename, HttpServletRequest request, HttpSession session) {
		User user = userDaoImpl.findByID(uid);
		boolean admin = LoginUtil.adminChk(messageSource, session);
		boolean con = admin;
		if (!con) {
			long curruid = LoginUtil.uid(messageSource, request);
			if (curruid - uid == 0) {
				con = true;
			}
		}
		if (!con) {
			return -200;
		}

		if (truename != null) {
			truename = truename.trim();
		}

		user.setTruename(truename);

		userDaoImpl.modify(user);
		return 0;
	}

	@ResponseBody
	@RequestMapping("/dept")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<dept>", loginOrAdmin = true)
	public int modifyDept(long uid, String dept, HttpServletRequest request, HttpSession session) {
		User user = userDaoImpl.findByID(uid);
		boolean admin = LoginUtil.adminChk(messageSource, session);
		boolean con = admin;
		if (!con) {
			long curruid = LoginUtil.uid(messageSource, request);
			if (curruid - uid == 0) {
				con = true;
			}
		}
		if (!con) {
			return -200;
		}
		if (dept != null) {
			dept = dept.trim();
		}
		user.setDept(dept);
		userDaoImpl.modify(user);
		return 0;
	}

	@ResponseBody
	@RequestMapping(value = "/pws/{uid}")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<password>", login = true, failedPage = LOGINPAGE, msgKey = "fail.permission")
	public int modifySelfPws(@PathVariable("uid") Long uid, String password, HttpServletRequest request) {
		long currUid = LoginUtil.uid(messageSource, request);
		if (currUid <= 0) {
			return -201;
		}
		if (uid == null || uid == 0L) {
			return -400;
		}

		if (currUid - uid != 0) {
			return -200;
		}
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -400;
		}

		PasswordComplexity pc = com.lerx.sys.util.SysUtil.init(messageSource);
		if (pc.isHighmode()) {
			boolean test = StringUtil.pwsComplexityTest(password, pc.getLenmin(), pc.getLenmax());
			if (!test) {
				return -416;
			}
		}

		userDaoImpl.modifypw(user, password);
		return 0;
	}

	@ResponseBody
	@RequestMapping("/nickname/{id}")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<nickname>", login = true, failedPage = ADMINFORBID, msgKey = "fail.permission")
	public int nickname(@PathVariable(value = "id", required = true) Long id, String nickname,
			HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);
		if (uid != id) {
			return -200;
		}
		User user = userDaoImpl.findByID(uid);
		nickname=nickname.trim();
		User nick = userDaoImpl.findByNickname(nickname);
		if (nick==null) {
			nick = userDaoImpl.findByUsername(nickname);
		}
		if (nick != null) {
			return -420;
		}
		
		if (nickname.trim().equals("")) {
			nickname = null;
		}
		user.setNickname(nickname);
		userDaoImpl.modify(user);
		return 0;
	}

	@ResponseBody
	@RequestMapping(value = "/forget")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<forget>")
	public ResponseResult forget(String keywords, HttpServletRequest request, HttpSession session) {
		ResponseResult rr = new ResponseResult();
		/*
		if (session.getAttribute("vcodeSendDt") != null) {
			long lastSentDt=(long) session.getAttribute("vcodeSendDt");
			if (System.currentTimeMillis() - lastSentDt < (1000*60*5)) {
				rr.setResult(-409);
				return rr;
			}
		}
		*/
		boolean send=false;
		
		Portal portal = portalDaoImpl.query_update();
		User user = userDaoImpl.findByKeywords(keywords);
		if (user == null) {
			rr.setResult(-405);
			rr.setMsg(messageSource.getMessage("fail.null", null, "null", null));
		} else {
			rr.setValueL(user.getId());
			rr.setValueS1(user.getUsername());

			rr.setResult(0);
			int r = -1;

			Website site = new Website();
			site.setName(portal.getName());
			site.setHost(portal.getHost());
			site.setUrl(portal.getUrl());
			String charset = messageSource.getMessage("charset", null, "UTF-8", null);
			
			boolean sms=false;
			boolean mail=false;
			
			if (mailSrvConfigSuccess.trim().equalsIgnoreCase("true")) {
				mail=true;
			}
			
			if (smsSrvConfigSuccess.trim().equalsIgnoreCase("true")) {
				sms=true;
			}
			
			
			if (StringUtil.emailTest(keywords) && mail) {
				r = CaptchaUtil.send(messageSource, request, session, site, 0, keywords, "default", charset);
				if (r>=0) {
					rr.setValueS2(keywords);
					rr.setValueS1(StringUtil.hideEmail(keywords, 4, false));
					rr.setValueI(1);
					send=true;
				}
				
			}
			
			if (!send && StringUtil.isNumber(keywords) && keywords.length() == 11 && sms) {
				r = CaptchaUtil.send(messageSource, request, session, site, 1, keywords, "default", charset);
				if (r>=0) {
					rr.setValueS2(keywords);
					rr.setValueS1(StringUtil.hideMobile(keywords, 4, false));
					rr.setValueI(2);
					send=true;
				}
				
			} 
			
			if (!send && StringUtil.isNumber(user.getMobile()) && user.getMobile().length() == 11 && sms) {
				r = CaptchaUtil.send(messageSource, request, session, site, 1, user.getMobile(), "default", charset);
				if (r>=0) {
					rr.setValueS2(user.getMobile());
					rr.setValueS1(StringUtil.hideMobile(user.getMobile(), 4, false));
					rr.setValueI(2);
					
					send=true;
				}
				
			}
			
			if (!send && user.getEmail() != null && StringUtil.emailTest(user.getEmail()) && mail) {
				r = CaptchaUtil.send(messageSource, request, session, site, 0, user.getEmail(), "default", charset);
				if (r>=0) {
					rr.setValueS2(user.getEmail());
					rr.setValueS1(StringUtil.hideEmail(user.getEmail(), 4, false));
					rr.setValueI(1);
					send=true;
				}
				
			}
			if (!send && r!= -409) {
				r = -404;
			}else {
				//session.setAttribute("vcodeSendDt", System.currentTimeMillis());
			}
		
			rr.setResult(r);
		}

		return rr;
	}

	/*
	 * 删除
	 */
	@ResponseBody
	@RequestMapping("/del")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<del>", admin = true, failedPage = FAILED, msgKey = "fail.permission")
	public int del(Long id, HttpSession session) {

		if (articleDaoImpl.countByUid(id) > 0L) {
			return -501;
		}
		if (commentBridgeDaoImpl.countByUid(id) > 0L) {
			return -501;
		}
		if (commentThreadDaoImpl.countByUid(id) > 0L) {
			return -501;
		}
		if (uploadedFileDaoImpl.countByUid(id) > 0L) {
			return -501;
		}
		if (userArtsCountDaoImpl.countByUid(id) > 0L) {
			return -501;
		}

		loginConnecterDaoImpl.delByUID(id);

		boolean result = false;
		result = userDaoImpl.delByID(id);
		if (result) {
			return 0;
		} else {
			return -500;
		}

	}

	/*
	 * 查找当前登录用户的uid
	 */

	/*
	 * 匹配
	 */
	@ResponseBody
	@RequestMapping(value = "/match/{uid}")
	@Token(ajax = true, csrf = true,contrast = true)
	public int match(@PathVariable("uid") Long uid, HttpServletRequest request) {

		long currUid = LoginUtil.uid(messageSource, request);
		if (currUid <= 0) {
			return -201;
		}

		if (uid == null || uid == 0L) {
			return -400;
		}

		if (currUid - uid == 0) {
			return 0;
		} else {
			return -200;
		}

	}

	/*
	 * 更新头像
	 */
	@ResponseBody
	@RequestMapping("/avatar")
	@Token(csrf = true,contrast = true, log = true, mark = "user--<avatar-update>", login = true, failedPage = LOGINPAGE, msgKey = "fail.permission")
	public int avatar(@RequestParam(value = "uid", required = false) Long uid,
			@RequestParam(value = "avatar", required = false) String avatar, HttpServletRequest request) {

		if (uid == null) {
			uid = 0L;
			return -400;
		}
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -400;
		}

		long currUid = LoginUtil.uid(messageSource, request);

		if (currUid <= 0) {
			return -400;
		}
		if (currUid - uid != 0L) {
			return -200;
		}

		if (avatar == null || avatar.trim().equals("")) {
			return -410;
		}
		avatar = HttpUtil.contextPathRebulid(avatar, request);

		user.setAvatarUrl(avatar);
		userDaoImpl.modify(user);
		return 0;

	}

	// 获取用户头像
	@ResponseBody
	@RequestMapping("/getAvatar/{uid}")
	@Token(ajax = true, csrf = true,contrast = true)
	public String getAvatar(@PathVariable("uid") Long uid, HttpServletRequest request) {
		String nullAvatar = ConfigUtil.getAvatarNullFile(messageSource, request);
		if (uid == null) {
			uid = 0L;
			return nullAvatar;
		}
		User user = userDaoImpl.findByID(uid);
		if (user.getAvatarUrl() != null && !user.getAvatarUrl().equals("")) {
			return user.getAvatarUrl();
		} else {
			return nullAvatar;
		}
	}

	@RequestMapping("/login")
	@Token(ajax = false, log = true, mark = "user--<login>", token = true,csrf = true, contrast = true, failedPage = LOGINPAGE, msgKey = "fail.login")
	public ModelAndView login(@Valid User user, Errors result,
			@RequestParam(value = "vcode", required = false) String vcode, String referer,
			@RequestParam(value = "pop", required = false) Integer pop, Map<String, Object> map,
			HttpServletRequest request, HttpServletResponse response, HttpSession session, String token) {
		if (pop == null) {
			pop = 0;
		}
		if (pop == 1) {
			session.removeAttribute("referer_lerx");
		}
		LoginTestObj lto = new LoginTestObj();
		lto.setUser(user);
		lto.setVcode(vcode);
		lto.setFromConnecter(false);
		lto.setW(true);
		lto.setMessageSource(messageSource);
		lto.setUserDaoImpl(userDaoImpl);
		lto.setRequest(request);
		lto.setResponse(response);
		lto.setSession(session);

		LoginTest lt = loginTest(lto);
		if (lt.getResult() == 0 && pop != 1) {
			if (lt.getReferer()!=null && lt.getReferer().trim().indexOf("jsp/user/login")!= -1) {
				lt.setReferer(request.getContextPath());
			}
			map.put("referer", lt.getReferer());
			referer = lt.getReferer();
		} else {
			referer = null;
		}

		return MavUtil.mav4(lt.getReturnPage(), lt.getMsg(), referer);
	}

	@ResponseBody
	@RequestMapping("/pwsTest")
	@Token(ajax = true, csrf = true, contrast = true)
	public int pwsTest(String password, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -201;
		}
		User u = new User();
		u.setUsername(user.getUsername());
		u.setPassword(password);
		LoginTestObj lto = new LoginTestObj();
		lto.setUser(u);
		lto.setFromConnecter(false);
		lto.setW(false);
		lto.setMessageSource(messageSource);
		lto.setUserDaoImpl(userDaoImpl);
		lto.setRequest(request);
		lto.setResponse(response);
		lto.setSession(session);
		lto.setDisableVcode(true);

		LoginTest lt = loginTest(lto);
		return lt.getResult();
	}

	@ResponseBody
	@RequestMapping("/loginAjax")
	@Token(ajax = true, csrf = true, contrast = true, token = true)
	public int loginAjax(@Valid User user, Errors result, @RequestParam(value = "vcode", required = false) String vcode,
			Map<String, Object> map, HttpServletRequest request, HttpServletResponse response, HttpSession session,
			String token) {

		LoginTestObj lto = new LoginTestObj();
		lto.setUser(user);
		lto.setVcode(vcode);
		lto.setFromConnecter(false);
		lto.setW(false);
		lto.setMessageSource(messageSource);
		lto.setUserDaoImpl(userDaoImpl);
		lto.setRequest(request);
		lto.setResponse(response);
		lto.setSession(session);

		LoginTest lt = loginTest(lto);
		return lt.getResult();

	}

	@RequestMapping("/logout")
	@Token(csrf = true,contrast = true, log = true, mark = "user--<logout>")
	public String logout(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
		logout(request, response, session, true);
		long uid = LoginUtil.uid(messageSource, request);
		if (uid > 0L) {
			session.removeAttribute("vcode_user_lerx"); // 验证码需求清除
			session.removeAttribute("lsr_user"); // 登录次数Session清除
		}

		return "/jsp/user/login";

	}

	@ResponseBody
	@RequestMapping("/logoutAjax")
	@Token(ajax = true, csrf = true,contrast = true, log = true, mark = "user--<logout>")
	public int logoutAjax(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
		logout(request, response, session, true);
		return 0;

	}

	private void logout(HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean flag) {
		HttpUtil.clearCookie(request, response, "username_lerx");
		HttpUtil.clearCookie(request, response, "password_lerx");
		HttpUtil.clearCookie(request, response, "uid_lerx");
		HttpUtil.clearCookie(request, response, "rid_lerx");
		// HttpUtil.clearCookie(request, response, "role_mask_lerx");
		HttpUtil.clearCookie(request, response, "role0_lerx");

		HttpUtil.clearCookie(request, response, "role_name_lerx");
		session.removeAttribute("lsr"); // 清除登录次数Session
		session.removeAttribute("vcode_request_lerx"); // 清除验证码需求
	}

	@RequestMapping("/connecter/token")
	@ResponseBody
	@Token(contrast = true)
	public String token(HttpServletRequest request, HttpServletResponse response) throws Exception {
		/*
		 * String authUrl = WxConstants.AUTH_BASE_URL + "appid=" + WxConstants.APPID +
		 * "&redirect_uri=" + URLEncoder.encode(WxConstants.REDIRECT_URL) +
		 * "&response_type=code" + "&scope=" + WxConstants.SCOPE +
		 * "&state=STATE#wechat_redirect";
		 */
		OauthWeChat oauthWchat = new OauthWeChat();
		String authUrl = oauthWchat.authorize("code", "STATE#wechat_redirect", "snsapi_userinfo");

		String signature = request.getParameter("signature");/// 微信加密签名
		String timestamp = request.getParameter("timestamp");/// 时间戳
		String nonce = request.getParameter("nonce"); /// 随机数
		String echostr = request.getParameter("echostr"); // 随机字符串

		if (signature != null && timestamp != null && nonce != null && echostr != null) {
			if (SignUtil.checkSignature(signature, timestamp, nonce)) {
				return echostr;
			}
		} else {
			response.sendRedirect(authUrl);
			return null;
		}
		return echostr;

	}

	@ResponseBody
	@RequestMapping(value = "/connecter/auth/{otype}")
	@Token(contrast = true)
	public String connecterAuth(@PathVariable("otype") Integer otype, String referer, HttpServletRequest request,
			HttpServletResponse response, HttpSession session) {
		if (referer == null) {
			referer = request.getHeader("referer_lerx");
		} else {
			referer = StringUtil.escapeUrl(referer, 0);
		}
		String url;
		String stateCode = StringUtil.uuidStr();
		session.setAttribute("statecode", stateCode);
		if (referer != null && !referer.endsWith("jsp/user/login")) {
			referer = StringUtil.htmlFilter(referer, false);

			HttpUtil.saveCookie(messageSource, response, "referer_lerx", referer);
		}

		switch (otype) {
		case 1:
			OauthWeChat oauthWchat = new OauthWeChat();
			try {
				url = oauthWchat.authorize("code", stateCode, "snsapi_login");
				response.sendRedirect(url);
			} catch (IOException | WeiboException e) {
				e.printStackTrace();
			}
			break;
		case 2:
			weibo4j.Oauth oauth = new weibo4j.Oauth();

			try {
				url = oauth.authorize("code", "");
				response.sendRedirect(url);
			} catch (WeiboException | IOException e) {
				e.printStackTrace();
			}

			break;
		default:
			try {
				url = new Oauth().getAuthorizeURL(request);
				response.sendRedirect(url);
			} catch (QQConnectException | IOException e) {
				e.printStackTrace();
			}
		}
		return "/jsp/result/error";
	}

	@ResponseBody
	@RequestMapping(value = "/connecter/login/{otype}")
	@Token(contrast = true)
	public ModelAndView connecterLogin(@CookieValue(value = "referer_lerx", required = false) String referer,
			@PathVariable("otype") Integer otype, @RequestParam(value = "code", required = false) String code,
			@RequestParam(value = "state", required = false) String state, HttpServletRequest request,
			HttpServletResponse response, HttpSession session) {

		User u = null;
		String openID = null;
		ConnecterUserInf qui = new ConnecterUserInf();
		String stateCode = (String) session.getAttribute("statecode");
		if (stateCode == null) {
			stateCode = "null";
		}
		switch (otype) {

		case 1:

			OauthWeChat oauthWchat = new OauthWeChat();

			try {

				if (state == null) {
					state = "error";
				}

				if (!stateCode.trim().equals(state)) {
					break;
				}

				Response res = oauthWchat.authorizeByCode(code);

				JSONObject json = res.asJSONObject();
				String openid = null;
				try {
					openid = json.getString("openid");
				} catch (JSONException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				qui.setOpenID(openid);
				u = loginConnecterDaoImpl.findUserByOpenID(openid, otype);

			} catch (WeiboException e2) {
				// TODO Auto-generated catch block
				e2.printStackTrace();
			}
			break;
		case 2:
			if (code == null) {
				return MavUtil.mav1("/jsp/result/error",
						messageSource.getMessage("fail.login", null, "Login error!", null) + " (code:E10001)");
			}
			weibo4j.Oauth oauth = new weibo4j.Oauth();
			try {
				String pat = "\\[(.*?)\\]";

				Pattern pattern = Pattern.compile(pat);
				Matcher matcher = pattern.matcher(oauth.getAccessTokenByCode(code).toString());
				String uidstr = null;
				if (matcher.find()) {
					String tmp = matcher.group(1);
					String[] sArray = tmp.split(",");
					for (int i = 0; i < sArray.length; i++) {
						if (sArray[i] != null && sArray[i].trim().startsWith("uid=")) {
							uidstr = sArray[i];
							break;
						}
					}
				}

				if (uidstr != null) {
					String[] sArray = uidstr.split("=");
					if (sArray.length > 1) {
						String uid = sArray[1];
						openID = uid;
						qui.setOpenID(uid);
					}

				}

				u = loginConnecterDaoImpl.findUserByOpenID(openID, otype);

			} catch (WeiboException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}

			break;
		default:
			try {
				AccessToken accessTokenObj = (new Oauth()).getAccessTokenByRequest(request);
				if (accessTokenObj.getAccessToken().equals("")) {
					// 我们的网站被CSRF攻击了或者用户取消了授权
					// 做一些数据统计工作
					System.out.println("日志输出：没有获取到响应参数");
				} else {

					String accessToken = accessTokenObj.getAccessToken();
					long tokenExpireIn = accessTokenObj.getExpireIn();
					session.setAttribute("demo_access_token", accessToken);
					session.setAttribute("demo_token_expirein", String.valueOf(tokenExpireIn));
					OpenID openIDObj = new OpenID(accessToken);
					openID = openIDObj.getUserOpenID();
					qui.setOpenID(openID);
					session.setAttribute("demo_openid", openID);
					UserInfo qzoneUserInfo = new UserInfo(accessToken, openID);
					UserInfoBean userInfoBean = qzoneUserInfo.getUserInfo();
					if (userInfoBean.getRet() == 0) {
						String newname = UserUtil.findUsername(userDaoImpl, userInfoBean.getNickname());
						qui.setNickname(newname);
						qui.setGender(userInfoBean.getGender());
						qui.setLevel(userInfoBean.getLevel());
						qui.setVip(userInfoBean.isVip());
						qui.setYellowYearVip(userInfoBean.isYellowYearVip());
						qui.setAvatarURL30(userInfoBean.getAvatar().getAvatarURL30());
						qui.setAvatarURL50(userInfoBean.getAvatar().getAvatarURL50());
						qui.setAvatarURL100(userInfoBean.getAvatar().getAvatarURL100());

					} else {
						qui.setMsg(userInfoBean.getMsg());
					}

					com.qq.connect.api.weibo.UserInfo weiboUserInfo = new com.qq.connect.api.weibo.UserInfo(accessToken,
							openID);
					com.qq.connect.javabeans.weibo.UserInfoBean weiboUserInfoBean = weiboUserInfo.getUserInfo();
					if (weiboUserInfoBean.getRet() == 0) {
						qui.setWeiboAvatarURL30(weiboUserInfoBean.getAvatar().getAvatarURL30());
						qui.setWeiboAvatarURL50(weiboUserInfoBean.getAvatar().getAvatarURL50());
						qui.setWeiboAvatarURL100(weiboUserInfoBean.getAvatar().getAvatarURL100());
						qui.setWeiboBirthday(weiboUserInfoBean.getBirthday());

						qui.setWeiboCountryCode(weiboUserInfoBean.getCountryCode());
						qui.setWeiboProvinceCode(weiboUserInfoBean.getProvinceCode());
						qui.setWeiboCityCode(weiboUserInfoBean.getCityCode());
						qui.setWeiboLocation(weiboUserInfoBean.getLocation());

					} else {
						qui.setWeiboMsg(weiboUserInfoBean.getMsg());
					}

					u = loginConnecterDaoImpl.findUserByOpenID(openID, otype);

				}
			} catch (QQConnectException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return MavUtil.mav1("/jsp/result/error",
						messageSource.getMessage("fail.login", null, "Login error!", null) + " (code:E10002)");
			}
		}

		Portal portal = portalDaoImpl.query_update();
		request.setAttribute("targetMode", portal.getCodeSendMode());

		if (u != null) { // 如果发现互联记录
			u = userDaoImpl.findByID(u.getId());
			if (u.isState()) {
				LoginTestObj lto = new LoginTestObj();
				lto.setUser(u);
				lto.setVcode(null);
				lto.setFromConnecter(true);
				lto.setW(true);
				lto.setMessageSource(messageSource);
				lto.setUserDaoImpl(userDaoImpl);
				lto.setRequest(request);
				lto.setResponse(response);
				lto.setSession(session);

				LoginTest lt = loginTest(lto);

				HttpUtil.clearCookie(request, response, "referer_lerx");
				String contextPath = HttpUtil.getSrvUrl(request, true);
				try {

					if (referer != null && !referer.trim().equals("")) {
						response.sendRedirect(referer);
					} else {
						response.sendRedirect(contextPath);
					}
					return null;

				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				return MavUtil.mav1(lt.getReturnPage(), lt.getMsg());
			}
		} else {
			User user = new User();

			user.setUsername(qui.getNickname());
			request.setAttribute("user", user);
			request.setAttribute("qui", qui);
			request.setAttribute("otype", otype);

			request.setAttribute("connectTitle",
					messageSource.getMessage("connect.title." + otype, null, "Open connect", null));
			return MavUtil.mav1("/jsp/user/iccreate", "");
		}

		return MavUtil.mav1("/jsp/result/error",
				messageSource.getMessage("fail.login", null, "Login error!", null) + " (code:E10003)");
	}

	/*
	 * 检测 绑定
	 */
	@ResponseBody
	@RequestMapping("/bindConnecter")
	@Token(contrast = true,log = true,mark = "connecter--<bind>")
	public ConnecterValidateRetrun bindConnecter(String vcode, int otype, String openID, String target, int channel,
			HttpServletRequest request, @CookieValue(value = "referer_lerx", required = false) String referer,
			HttpServletResponse response, HttpSession session) throws Exception {
		ConnecterValidateRetrun cvr = new ConnecterValidateRetrun();
		if (openID == null || openID.trim().equals("") || target == null || target.trim().equals("") || vcode == null
				|| vcode.trim().equals("")) {
			cvr.setStatus(-11);
			return cvr;
		}
		int status = CaptchaUtil.valid(messageSource, vcode, target, "default", session);
		cvr.setStatus(status);
		cvr.setOpenID(openID);
		cvr.setOtype(otype);
		session.setAttribute("sendTarget", target);
		session.setAttribute("targetMode", channel);

		if (status >= 0) { // 如果有此手机或邮箱，验证通过

			User u = null;
			u = (User) LoginUtil.find(baseDaoImpl.getHT(), User.class, target); // 按邮箱或手机查找用户

			if (u != null) {

				cvr = createConnecter(cvr, loginConnecterDaoImpl, u, otype, openID, referer, request, response, session,
						messageSource, userDaoImpl);

				String cvtmp = StringUtil.switchPosition(u.getContactsVerifyed(), channel + 1, true);
				u.setContactsVerifyed(cvtmp);

				userDaoImpl.modify(u);

			} else { // 没有用户，新注册

			}

		}

		return cvr;

	}

	/*
	 * 解除绑定
	 */
	@ResponseBody
	@RequestMapping(value = "/connecter/ubind/{otype}")
	@Token(contrast = true, csrf = true,log=true,mark = "connecter--<ubind>")
	public int ubindConnecter(@PathVariable("otype") Integer otype, HttpServletRequest request) throws Exception {

		User user = UserUtil.findLoginer(messageSource, request, userDaoImpl);
		if (user != null) {
			LoginConnecter lc = loginConnecterDaoImpl.findByUID(user.getId());
			if (lc != null) {
				switch (otype) {
				case 1:
					if (lc.getOpenIDAtWeChat() != null && !lc.getOpenIDAtWeChat().trim().equals("")) {
						lc.setOpenIDAtWeChat(null);
						loginConnecterDaoImpl.modify(lc);
					} else {
						return -405;
					}
					break;
				case 2:
					if (lc.getOpenIDAtWeibo() != null && !lc.getOpenIDAtWeibo().trim().equals("")) {
						lc.setOpenIDAtWeibo(null);
						loginConnecterDaoImpl.modify(lc);
					} else {
						return -405;
					}
					break;
				default:
					if (lc.getOpenIDAtQQ() != null && !lc.getOpenIDAtQQ().trim().equals("")) {
						lc.setOpenIDAtQQ(null);
						loginConnecterDaoImpl.modify(lc);
					} else {
						return -405;
					}

				}
			}
		}

		return 0;

	}

	private static ConnecterValidateRetrun createConnecter(ConnecterValidateRetrun cvr,
			ILoginConnecterDao loginConnecterDaoImpl, User u, int otype, String openID, String referer,
			HttpServletRequest request, HttpServletResponse response, HttpSession session,
			ResourceBundleMessageSource messageSource, IUserDao userDaoImpl) {
		LoginConnecter lc = loginConnecterDaoImpl.findByUID(u.getId());
		boolean isnew = false;
		if (lc == null) {
			isnew = true;
			lc = new LoginConnecter();
			lc.setUser(u);
			lc.setCreateTimstamp(System.currentTimeMillis());
		}
		switch (otype) {
		case 1:
			lc.setOpenIDAtWeChat(openID);
			cvr.setOpenID(lc.getOpenIDAtWeChat());
			break;
		case 2:
			lc.setOpenIDAtWeibo(openID);
			cvr.setOpenID(lc.getOpenIDAtWeibo());
			break;
		default:
			lc.setOpenIDAtQQ(openID);
			cvr.setOpenID(lc.getOpenIDAtQQ());

		}

		if (isnew) {
			loginConnecterDaoImpl.add(lc, otype);
		} else {
			loginConnecterDaoImpl.modify(lc);
		}

		LoginTestObj lto = new LoginTestObj();
		lto.setUser(u);
		lto.setVcode(null);
		lto.setFromConnecter(true);
		lto.setW(true);
		lto.setMessageSource(messageSource);
		lto.setUserDaoImpl(userDaoImpl);
		lto.setRequest(request);
		lto.setResponse(response);
		lto.setSession(session);

		loginTest(lto);

		cvr.setUid(u.getId());
		cvr.setUsername(u.getUsername());

		if (referer != null && !referer.trim().equals("")) {
			cvr.setReferer(referer);
		} else {
			cvr.setReferer(request.getContextPath());
		}
		return cvr;
	}

	private static LoginTest loginTest(LoginTestObj lto) {

		User user = lto.getUser();
		String vcode = lto.getVcode();
		IUserDao userDaoImpl = lto.getUserDaoImpl();
		boolean fromConnecter = lto.isFromConnecter();
		boolean w = lto.isW();
		ResourceBundleMessageSource messageSource = lto.getMessageSource();
		HttpServletRequest request = lto.getRequest();
		HttpServletResponse response = lto.getResponse();
		HttpSession session = lto.getSession();
		LoginTest lt = new LoginTest();

		LoginSessionTest lst = LoginSafeRecUtil.interruptTest(
				messageSource.getMessage("login.upper.failed", null, "5", null),
				messageSource.getMessage("login.minutes.wait.afterFailed", null, "10", null), "user");
		if (lst != null && lst.isInterrup() && !lto.isDisableVcode()) {
			String failMes = messageSource.getMessage("fail.login.time.upper", null,
					"You have overloaded the misplaced username and password within the time limit. Please try again later!",
					null);
			failMes = AnalyzeUtil.replace(failMes, "tag", "upper",
					messageSource.getMessage("login.upper.failed", null, " 5 ", null));
			failMes = AnalyzeUtil.replace(failMes, "tag", "minutes",
					messageSource.getMessage("login.minutes.wait.afterFailed", null, " 10 ", null));
			lt.setMsg(failMes);
			lt.setReturnPage(LOGINPAGE);
			lt.setResult(-5);
			session.setAttribute("vcode_user_lerx", "true"); // 验证码需求
			return lt;
		}
		if (!fromConnecter && !lto.isDisableVcode()) { // 如果不是采用互联登录
			// 如果需要用验证码
			String vcodeRequest = (String) session.getAttribute("vcode_user_lerx");
			String safeSessionStr = SafeStrUtil.getstr(messageSource, request, "user");
			String vcodeSession = (String) session.getAttribute(safeSessionStr);

			if (vcodeRequest != null && !vcodeRequest.trim().equals("") && vcodeRequest.trim().equals("true")) {

				if (((vcode == null) || (!(vcode.trim().equalsIgnoreCase(vcodeSession))))) {

					String msg = messageSource.getMessage("error.verify.code", null, "Verification code error!", null);
					lt.setMsg(msg);
					lt.setReturnPage(LOGINPAGE);
					lt.setResult(-5);
					return lt;
				}

			}
		}
		if (user != null && user.getUsername() != null && !user.getUsername().trim().equals("")) {
			String passwordPlain;
			if (!fromConnecter) { // 如果不是采用互联登录
				passwordPlain = user.getPassword();
				user = userDaoImpl.login(user);
			} else {
				passwordPlain = user.getPassword();
			}

			if (user != null) { // 登录成功
				if (w) {
					String ip = IPUtil.getRealRemotIP(request);
					user.setLastLoginIP(ip);
					user.setLastLoginTime(System.currentTimeMillis());
					userDaoImpl.modify(user);
				}
				HttpUtil.saveCookie(messageSource, response, "username_lerx", user.getUsername());
				HttpUtil.saveCookie(messageSource, response, "password_lerx", passwordPlain);
				HttpUtil.saveCookie(messageSource, response, "uid_lerx", "" + user.getId());
				if (user.getRole() != null && user.getRole().getMask() != null
						&& user.getRole().getMask().trim().equals("0")) {
					HttpUtil.saveCookie(messageSource, response, "role0_lerx", "true");
				}
				session.removeAttribute("lsr_user"); // 清除登录次数Session
				session.removeAttribute("vcode_user_lerx"); // 清除验证码需求
				// if
				session.setAttribute("referer_lerx", HttpUtil.getCookie(messageSource, request, "referer_lerx"));

				lt.setMsg("");
				lt.setResult(0);
				String referer = (String) session.getAttribute("referer_lerx");
				lt.setReferer(referer);
				lt.setReturnPage("/jsp/user/login_success");
				session.removeAttribute("referer_lerx");
			} else {
				if (!lto.isDisableVcode()) {
					HttpUtil.clearCookie(request, response, "username_lerx");
					HttpUtil.clearCookie(request, response, "password_lerx");
					HttpUtil.clearCookie(request, response, "uid_lerx");
					HttpUtil.clearCookie(request, response, "rid_lerx");
					HttpUtil.clearCookie(request, response, "role0_lerx");
					HttpUtil.clearCookie(request, response, "role_name_lerx");
				}

				lt.setMsg(messageSource.getMessage("fail.login", null, "Login failed!", null));
				lt.setReturnPage(LOGINPAGE);
				lt.setResult(-1);
			}
		} else {
			lt.setMsg(messageSource.getMessage("fail.login", null, "Login failed!", null));
			lt.setReturnPage(LOGINPAGE);
			lt.setResult(-11);

		}
		if (lt.getResult() < 0 && !lto.isDisableVcode()) {
			session.setAttribute("vcode_user_lerx", "true"); // 验证码需求
			session.setAttribute("lsr_user", lst.getLsrStr()); // 登录次数Session
		}
		return lt;

	}

	/*
	 * 手机邮箱验证发送验证码
	 */
	@RequestMapping("/verify/send/{mode}")
	@ResponseBody
	@Token(ajax = true, csrf = true, contrast = true)
	public int verify(@PathVariable(value = "mode", required = false) Integer mode, String target,
			HttpServletRequest request, HttpSession session) {
		/*
		if (session.getAttribute("vcodeSendDt") != null) {
			long lastSentDt=(long) session.getAttribute("vcodeSendDt");
			if (System.currentTimeMillis() - lastSentDt < (1000*60*5)) {
				return -409;
			}
		}
		*/
		
		if (mode == null) {
			mode = 0;
		}
		long uid = LoginUtil.uid(messageSource, request);
		if (uid <= 0) {
			return -201;
		}
		Portal portal = portalDaoImpl.query_update();
		Website site = PortalUtil.lead(portal);
		String charset = messageSource.getMessage("charset", null, "UTF-8", null);
		int r;
		if (mode==0) {
			r = CaptchaUtil.send(messageSource, request, session, site, mode, target, "mailchk", charset);
		}else {
			r = CaptchaUtil.send(messageSource, request, session, site, mode, target, "mobilechk", charset);
		}
		/*
		if (r>=0) {
			session.setAttribute("vcodeSendDt", System.currentTimeMillis());
		}
		*/
		
		return r;

	}

	/*
	 * 邮箱验证 验证码验证
	 */
	@RequestMapping("/verify/code/{mode}")
	@ResponseBody
	@Token(ajax = true, csrf = true, contrast = true)
	public int verifyCode(@PathVariable(value = "mode", required = false) Integer mode, String vcode, String target,
			HttpServletRequest request, HttpSession session) {
		if (mode == null) {
			mode = 0;
		}
		long uid = LoginUtil.uid(messageSource, request);
		if (uid <= 0) {
			return -201;
		}
		int r;
		if (mode == 0) {
			String email = (String) session.getAttribute("sendTarget");
			r = CaptchaUtil.valid(messageSource, vcode, target, "mailchk", session);
			if (r == 0) {

				User user = userDaoImpl.findByID(uid);
				user.setEmail(email);
				String cvtmp = StringUtil.switchPosition(user.getContactsVerifyed(), 1, true);
				user.setContactsVerifyed(cvtmp);
				userDaoImpl.modify(user);
			}
		} else {
			String mobile = (String) session.getAttribute("sendTarget");
			r = CaptchaUtil.valid(messageSource, vcode, target, "mobilechk", session);
			if (r == 0) {

				User user = userDaoImpl.findByID(uid);
				user.setMobile(mobile);
				String cvtmp = StringUtil.switchPosition(user.getContactsVerifyed(), 2, true);
				user.setContactsVerifyed(cvtmp);
				userDaoImpl.modify(user);
			}
		}

		return r;

	}

	/*
	 * 邮箱验证 验证码验证
	 */
	@RequestMapping("/mailUsable")
	@ResponseBody
	@Token(ajax = true, csrf = true, contrast = true)
	public int mailUsable(String vcode, String target, HttpServletRequest request, HttpSession session) {
		long uid = LoginUtil.uid(messageSource, request);
		if (uid <= 0) {
			return 0;
		}
		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return 0;
		}
		if (UserUtil.mailUsable(user) == null) {
			return -1;
		} else {
			return 0;
		}

	}

	/*
	 * 禁止发言状态改变
	 */
	@RequestMapping("/gag/{uid}")
	@ResponseBody
	@Token(ajax = true, csrf = true, contrast = true, login = true,log=true,mark = "user--<gag>", role0 = true)
	public int gag(@PathVariable(value = "uid", required = true) Long uid, HttpServletRequest request) {
		long cuid = LoginUtil.uid(messageSource, request);
		if (cuid <= 0) {
			return -200;
		}
		User admin = userDaoImpl.findByID(cuid);
		if (!UserUtil.isadmin(admin)) {
			return -200;
		}

		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			return -404;
		}
		if (UserUtil.isadmin(user)) {
			return -403;
		}

		user.setGag(!user.isGag() && !user.getRole().isGag());
		userDaoImpl.modify(user);
		return 0;

	}

	/*
	 * 生成一个二维码，用于手机端扫描登录
	 */
	@RequestMapping("/qrcode/generate/{uid}")
	@ResponseBody
	@Token(ajax = true, csrf = true, contrast = true, login = true)
	public String rcloginGenerate(@PathVariable(value = "uid", required = true) Long uid, HttpServletRequest request,
			Map<String, Object> map) {
		String qrcStr;
		long mid = LoginUtil.uid(messageSource, request);
		if (uid == 0 || mid == 0 || mid != uid) {
			return "";
		}
		User user = userDaoImpl.findByID(mid);
		if (user == null) {
			return "";
		}

		long curr = System.currentTimeMillis();

		qrcStr = String.valueOf(curr) + "_" + UserUtil.qrcode(user, curr);

		String url = HttpUtil.getSrvUrl(request, true) + "/action_user/qrcode/read/" + user.getId() + "/" + qrcStr;
		return HttpUtil.repairUrl(url);
	}

	@RequestMapping("/qrcode/read/{uid}/{key}")
	@Token(ajax = false, contrast = true, failedPage = LOGINPAGE, msgKey = "fail.login")
	public ModelAndView rcloginRead(@PathVariable(value = "uid", required = true) Long uid,
			@PathVariable(value = "key", required = true) String key, HttpServletRequest request,
			HttpServletResponse response, Map<String, Object> map) {
		User user = null;
		if (uid == null) {
			uid = 0L;
		} else {
			user = userDaoImpl.findByID(uid);
		}

		if (user != null) {
			String[] strArray = key.split("_");
			if (strArray.length == 2) {
				String timestr = strArray[0];
				String md5 = strArray[1];
				long keyTime = Long.valueOf(timestr);
				long curr = System.currentTimeMillis();

				if ((curr - keyTime) < (2 * 60 * 1000)) {
					String md5tmp=UserUtil.qrcode(user, keyTime);
					if (md5tmp.equals(md5)) {
						String passwordPlain = user.getPassword();
						HttpUtil.saveCookie(messageSource, response, "username_lerx", user.getUsername());
						HttpUtil.saveCookie(messageSource, response, "password_lerx", passwordPlain);
						HttpUtil.saveCookie(messageSource, response, "uid_lerx", "" + user.getId());
						if (user.getRole() != null && user.getRole().getMask() != null
								&& user.getRole().getMask().trim().equals("0")) {
							HttpUtil.saveCookie(messageSource, response, "role0_lerx", "true");
						}

						map.put("msg", "");
						map.put("referer", request.getContextPath());
						map.put("returnPage", request.getContextPath());
						return MavUtil.mav4("/jsp/user/qrlogin_success", "", request.getContextPath());
					} else {
						
						HttpUtil.clearCookie(request, response, "username_lerx");
						HttpUtil.clearCookie(request, response, "password_lerx");
						HttpUtil.clearCookie(request, response, "uid_lerx");
						HttpUtil.clearCookie(request, response, "rid_lerx");
						HttpUtil.clearCookie(request, response, "role0_lerx");
						HttpUtil.clearCookie(request, response, "role_name_lerx");
					}

				}

			}
		}

		return MavUtil.mav4(FAILED, messageSource.getMessage("fail.login", null, "Login failed!", null),
				request.getContextPath());

	}

	// 用户注册信息完整度检查
	@RequestMapping("/complcheck")
	@ResponseBody
	@Token(ajax = true, csrf = true, contrast = true, login = true)
	public UserInfCompleteness complcheck(HttpServletRequest request) {
		long uid = LoginUtil.uid(messageSource, request);

		UserInfCompleteness compl = new UserInfCompleteness();
		if (uid <= 0) {
			compl.setCode(-201);
			return compl;
		}

		User user = userDaoImpl.findByID(uid);
		if (user == null) {
			compl.setCode(-201);
			return compl;
		}
		Role role = user.getRole();
		role = roleDaoImpl.findByID(role.getId());
		if (!role.isCheckComple()) {
			return compl;
		} else {
			compl.setCode(-1);
		}

		if (user.isGag()) {
			compl.setGag(-1);
		}

		if (!user.isState()) {
			compl.setStatus(-1);
		}

		if (user.getDept() == null || user.getDept().trim().equals("")) {
			compl.setDept(-1);
		}

		if (user.getEmail() == null || user.getEmail().trim().equals("")) {
			compl.setEmail(-1);
		}

		if (user.getAvatarUrl() == null || user.getAvatarUrl().trim().equals("")) {
			compl.setAvatar(-1);
		}

		if (user.getMobile() == null || user.getMobile().trim().equals("")) {
			compl.setMobile(-1);
		}

		if (user.getNickname() == null || user.getNickname().trim().equals("")) {
			compl.setNickname(-1);
			;
		}

		if (user.getTruename() == null || user.getTruename().trim().equals("")) {
			compl.setTruename(-1);
		}

		if (user.getPassword().equals(user.getPwdAtCreate())) {
			compl.setPwschg(-1);
		}

		if (UserUtil.mailUsable(user) == null) {
			compl.setEmailpass(-1);
		}

		if (UserUtil.mobileUsable(user) == null) {
			compl.setMobilepass(-1);
		}

		return compl;

	}

	@RequestMapping("/mobileValidRemind")
	@ResponseBody
	@Token(ajax = true, csrf = true, contrast = true, admin = true)
	public int mobileValidRemind() {
		
		if (!smsSrvConfigSuccess.trim().equalsIgnoreCase("true")) {
			return -421;
		}
		List<Long> ulist = userDaoImpl.findNeverValidPhone();
		int rc = 0;

		String charset = messageSource.getMessage("charset", null, "UTF-8", null);

		List<String> parmsList = new ArrayList<String>();
		List<String> phoneList = new ArrayList<String>();

		for (long uid : ulist) {
			try {
				Thread.sleep(2);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			parmsList.clear();
			phoneList.clear();
			User user = userDaoImpl.findByID(uid);
			if (user.getMobile() == null || user.getMobile().trim().equals("")) {
				continue;
			}

			parmsList.add(user.getUsername());
			phoneList.add(user.getMobile());

			TencentSms ts = new TencentSms();
			ts.setParmsList(parmsList);
			ts.setPhoneList(phoneList);
			ts.setSubdir("mobilevalid");
			ts.setCharset(charset);

			SendSmsResponse res = SmsUtil.v3send(ts);

			if (res != null && res.getSendStatusSet() != null
					&& res.getSendStatusSet()[0].getCode().equalsIgnoreCase("ok")) {
				rc++;
				user.setLastMsgSendDt(System.currentTimeMillis());
				userDaoImpl.modify(user);
			}
		}
		return rc;

	}

}
