package com.lerx.handlers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.lerx.annotation.Token;
import com.lerx.dao.iface.IPortalDao;
import com.lerx.dao.iface.IVisitArchivesDao;
import com.lerx.dao.iface.IVisitorIPRecordDao;
import com.lerx.dao.iface.IVisitorsBookDao;
import com.lerx.entities.Portal;
import com.lerx.entities.VisitArchives;
import com.lerx.entities.VisitorIPRecord;
import com.lerx.entities.VisitorsBook;
import com.lerx.hql.entities.Rs;
import com.lerx.ip.qqwry.entities.IPLocation;
import com.lerx.ip.util.IPUtil;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.VisitorRec;
import com.lerx.sys.util.MavUtil;
import com.lerx.v6.util.VisitUtil;

@RequestMapping("/action_visitor")
@Controller
public class VisitorHandler {

	private static final String FAILED = "jsp/result/failed";

	@Autowired
	private IPortalDao portalDaoImpl;

	@Autowired
	private IVisitorIPRecordDao visitorIPRecordDaoImpl;

	@Autowired
	private IVisitorsBookDao visitorsBookDaoImpl;

	@Autowired
	private IVisitArchivesDao visitArchivesDaoImpl;
	
	@Autowired
	private ResourceBundleMessageSource messageSource;

	/*
	 * 列表
	 */
	@RequestMapping("/list")
	@Token(ajax = false,loginOrAdmin = true, failedPage = FAILED,contrast = true,csrf = true, msgKey = "fail.permission",failedReturnUrl = FAILED)
	public ModelAndView list(long id,@RequestParam(value = "vmode", required = false) Integer vmode, @RequestParam(value = "page", required = false) Integer page,
			@RequestParam(value = "pageSize", required = false) Integer pageSize, HttpServletRequest request,HttpSession session,
			Map<String, Object> map) {
		if (vmode==null) {
			vmode=0;
		}
		Portal portal = portalDaoImpl.query_update();
		long pid = portal.getVbook().getId();
		if (id==pid) {
			if (!LoginUtil.adminChk(messageSource, session)) {
				return MavUtil.mav1("jsp/result/forbid", "");
			}
		}
		listInit(id,page,pageSize,session,map);
		
		String curIP = IPUtil.getRealRemotIP(request);
		map.put("curIP", curIP);
		map.put("vmode", vmode);

		return MavUtil.mav1("jsp/visitor/list", "");

	}
	
	private void listInit(long id,Integer page,Integer pageSize,HttpSession session,Map<String, Object> map) {
		if (id == 0) {
			map.put("portal", true);
			Portal portal = portalDaoImpl.query_update();
			id = portal.getVbook().getId();
		} else {
			map.put("portal", false);
		}
		VisitorsBook vbook = visitorsBookDaoImpl.findByID(id);
		if (page == null) {
			page = 1;
		}
		if (pageSize == null) {
			pageSize = 10;
		}
		Rs rs = visitorIPRecordDaoImpl.find(vbook.getId(), page, pageSize);
		@SuppressWarnings("unchecked")
		List<VisitorIPRecord> list = (List<VisitorIPRecord>) rs.getList();
		List<VisitorIPRecord> listnew = new ArrayList<VisitorIPRecord>();
		for (VisitorIPRecord vipr : list) {
			IPLocation ipl = IPUtil.queryQQWry(vipr.getIp());
			String ipfrom = ipl.getCountry() + " | " + ipl.getArea();
			vipr.setIpfrom(ipfrom);
			listnew.add(vipr);
		}
		rs.setList(listnew);
		map.put("pageUrl", "/action_visitor/list?id=" + id);
		map.put("rs", rs);
		map.put("vbook", vbook);

		VisitorRec vr;
		vr = (VisitorRec) session.getAttribute("vr" + id);
		long vrcurrtime;
		if (session.getAttribute("vrcurrtime" + id)==null) {
			vrcurrtime=0;
		}else {
			vrcurrtime= (long) session.getAttribute("vrcurrtime" + id);
		}
		if (vrcurrtime==0) {
			vr = null;
		}else if ((System.currentTimeMillis() - vrcurrtime) >= (1000*60*10)){	//如果超过10分钟
			vr = null;
			
			
		}else {
			Calendar c = Calendar.getInstance();
			int day=c.get(Calendar.DATE);
			c.setTimeInMillis(vrcurrtime);
			if (c.get(Calendar.DATE)!=day) {		//如果不是同一天
				vr = null;
			}
		}
		
		if (vr == null || vr.getTag() != 1) {
			vr = new VisitorRec();
			vr.setTag(1);
			vr.setCurrDay(visitorIPRecordDaoImpl.currPeriod(vbook.getId(), 0));
			vr.setCurrWeek(visitorIPRecordDaoImpl.currPeriod(vbook.getId(), 1));
			vr.setCurrMonth(visitorIPRecordDaoImpl.currPeriod(vbook.getId(), 2));
			vr.setCurrQuarter(visitorIPRecordDaoImpl.currPeriod(vbook.getId(), 3));
			vr.setCurrYear(visitorIPRecordDaoImpl.currPeriod(vbook.getId(), 4));
		}

		map.put("vr", vr);
		session.setAttribute("vr" + id, vr);
		session.setAttribute("vrcurrtime" + id, System.currentTimeMillis());
	}

	// 返回当天或某天的访问记录数
	@ResponseBody
	@RequestMapping("/visitQuery")
	@Token(ajax = true,csrf=true,contrast = true)
	public VisitArchives visitQuery(long vid, int dayKey) {
		return VisitUtil.visitQuery(vid, dayKey, visitArchivesDaoImpl);
	}

	@ResponseBody
	@RequestMapping(value = "/details/{id}")
	@Token(ajax = true,csrf=true,contrast = true)
	public String details(@PathVariable(value = "id", required = true) Long id) {
		VisitorIPRecord vipr = visitorIPRecordDaoImpl.findByID(id);
		String details = vipr.getDetails();
		/*
		 * details = details.replaceAll("[\\t\\n\\r]", "<br>");// 将内容区域的回车换行去除 details =
		 * details.replaceAll("<br><br>", "<br>");
		 */
		return details;
	}

}
