package com.lerx.portal.obj;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Order;

public class ArticleCustomOrder extends Order{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String propertyName; 
	
    protected ArticleCustomOrder(String propertyName, boolean ascending,int sc) {
		super(propertyName, ascending);
		this.propertyName = propertyName; 
		if (sc==0) {
			Order.asc(propertyName);
		}else {
			Order.desc(propertyName);
		}

	}
	
	public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery)  
            throws HibernateException {  
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria,  
                propertyName);  
        
        String ocol=columns[0] + "/( TO_DAYS(NOW()) - (TO_DAYS(creationTime)-1) )";
        return ocol;
        //在这里自定义你的字段
       /* return " case "+columns[0]+" when '42' then 1 "
        		+ "when '138' then 2 "
        		+ "when '136' then 3 "
        		+ "when '137' then 4 end ";*/  
    }  
	
	public static ArticleCustomOrder getOrder(String propertyName,int sc ) {  
        return new ArticleCustomOrder(propertyName, true,sc);  
    }  
 

}
