package com.lerx.v6.util;

import java.io.File;

import javax.servlet.http.HttpServletRequest;

import org.springframework.context.support.ResourceBundleMessageSource;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.dao.iface.IAlbgenreMangerDao;
import com.lerx.entities.Albgenre;
import com.lerx.entities.Role;
import com.lerx.entities.User;
import com.lerx.portal.obj.FileEl;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;

public class AlbgenreUtil {
	
	public static String getHref(ResourceBundleMessageSource messageSource,HttpServletRequest request,Albgenre ag,boolean cp) {
		String rootPath = messageSource.getMessage("albgenre.file.static.root", null, "html/albgenre", null);
		String indexFile=messageSource.getMessage("file.html.default", null, "index.html", null);
		String href=rootPath+"/"+ag.getId()+"/"+indexFile;
		String realFile = FileUtil.appPath() + href;
		realFile=FileUtil.repairFilePath(realFile);
		if (realFile.substring(0,1).equals("\\")) {
			realFile=realFile.substring(1, realFile.length());
		}
		File f = new File(realFile);
		if (!f.exists()) {
			href="/show_albgenre/index/"+ag.getId();
		}
		if (cp) {
			href=HttpUtil.getSrvUrl(request, false)+"/"+request.getContextPath()+"/"+href;
		}else {
			href=request.getContextPath()+"/"+href;
		}
		href=HttpUtil.repairUrl(href);
		return href;
	}
	
	public static String fmt(String lf,Albgenre ag){
		lf=AnalyzeUtil.replace(lf, "tag", "gid", ""+ag.getId());
		lf=AnalyzeUtil.replace(lf, "tag", "gname", ag.getName());
		lf=AnalyzeUtil.replace(lf, "tag", "folder", ag.getFolder());
		lf=AnalyzeUtil.replace(lf, "tag", "banner", ag.getBanner());
		lf=AnalyzeUtil.replace(lf, "tag", "staticFolder", ""); 		//静态目录，以后再写
		
		return lf;
	}
	
	public static boolean adminChk(User user,Albgenre ag,IAlbgenreMangerDao albgenreMangerDaoImpl) {
		if (user==null) {
			return false;
		}
		Role role=user.getRole();
		if (role==null) {
			return false;
		}
		String mask=role.getMask();
		if (mask!=null && mask.trim().equals("0")) {
			return true;
		}
		if (albgenreMangerDaoImpl.findByUID(ag.getId(), user.getId())!=null) {
			return true;
		}
		return false;
	}
	
	/*
	 * 构造静态文件
	 */
	public static FileEl feBuild(ResourceBundleMessageSource messageSource, Albgenre ag) {
		FileEl fe = new FileEl();
		String fmtStr = messageSource.getMessage("albgenre.file.static.root", null, "html/albgenre", null);
		String file;
		file = fmtStr + "/" +ag.getId();
		
		String indexFile=messageSource.getMessage("file.html.default", null, "index.html", null);
		
		file += "/" +indexFile;

		String url=FileUtil.repairUrl(file);
		String realFile = FileUtil.appPath() + file;
		realFile=FileUtil.repairFilePath(realFile);
		fe.setUrl(url);
		fe.setRealPath(realFile);

		return fe;
	}
	
	
	public static void htmlCreate(Albgenre ag, ResourceBundleMessageSource messageSource, String contextPath) {
		// 更新专辑首页
		String strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
		FileEl fe = feBuild(messageSource, ag);
		String charset = messageSource.getMessage("charset", null, "utf-8", null);
		String url = contextPath+"/show_albgenre/index/"+ag.getId();
		url=HttpUtil.repairUrl(url);
		FileUtil.htmlBySniff(url, fe.getRealPath(), strCreateDateTime, charset);
	}

}
