package com.lerx.v6.util;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.springframework.beans.BeanUtils;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.ReflectionUtils;
import org.wltea.analyzer.lucene.IKAnalyzer;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.dao.iface.IAlbumArticleDao;
import com.lerx.dao.iface.IHtmlFileStaticDao;
import com.lerx.entities.AlbumArticle;
import com.lerx.entities.AlbumArticleContent;
import com.lerx.entities.SearchTotalModel;
import com.lerx.portal.obj.AppEnvParms;
import com.lerx.portal.obj.FileEl;
import com.lerx.sys.obj.EnvParms;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.StringUtil;

public class AlbumArticleUtil {

	public static String url(AlbumArticle article, ResourceBundleMessageSource messageSource,
			HttpServletRequest request) {
		boolean cp = false;
		if (messageSource.getMessage("hrefurl.context.path", null, "false", null).trim().equals("true")) {
			cp = true;
		}
		if (!article.isStatus() || article.isProhibit() || !article.getHfs().isStatus()) {
			return "";
		}
		AlbumArticleContent content = article.getContent();
		boolean jump = false;
		if (content.getJumpUrl() != null && !content.getJumpUrl().trim().equals("")) {
			jump = true;
		}
		String href;
		if (jump) {
			if (messageSource.getMessage("art.jump.mode", null, "direct", null).trim().equals("direct")) {
				href = content.getJumpUrl().trim();
			} else {
				href = request.getContextPath() + "/show_album/art/" + article.getId();
			}
		} else {
			if (article.getHfs() != null && article.getHfs().isStatus()) {
				href = article.getHfs().getUrl();
			} else {

				href = request.getContextPath() + "/show_album/art/" + article.getId();
			}
		}

		if (cp) {
			href = HttpUtil.getSrvUrl(request, false) + "/" + href;
		}

		href = HttpUtil.repairUrl(href);
		return href;
	}

	public static String fmt(String lf, AlbumArticle article, String href) {
		lf = AnalyzeUtil.replace(lf, "tag", "albname", "" + article.getAlbum().getName());
		lf = AnalyzeUtil.replace(lf, "tag", "artid", "" + article.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "albid", "" + article.getAlbum().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "gname", article.getAlbum().getGenre().getName());
		lf = AnalyzeUtil.replace(lf, "tag", "gid", "" + article.getAlbum().getGenre().getId());
		AlbumArticleContent content = article.getContent();
		String title = content.getSubjectShort();
		if (title==null || title.trim().equals("")) {
			title = content.getSubject();
		}
		title=StringUtil.htmlRiskFilter(title);
		lf = AnalyzeUtil.replace(lf, "tag", "title", title);
		lf = AnalyzeUtil.replace(lf, "tag", "subject", StringUtil.htmlRiskFilter(content.getSubject()));
		lf = AnalyzeUtil.replace(lf, "tag", "subjectShort", StringUtil.htmlRiskFilter(content.getSubjectShort()));

		lf = AnalyzeUtil.replace(lf, "tag", "href", href);
		String nickname;
		if (article.getOwner() == null) {
			nickname=article.getAlbum().getLeader().getNickname();
			if (nickname==null || nickname.trim().equals("")) {
				nickname=article.getAlbum().getLeader().getUsername();
			}
			lf = AnalyzeUtil.replace(lf, "tag", "uid", "" + article.getAlbum().getLeader().getId());
			lf = AnalyzeUtil.replace(lf, "tag", "username", article.getAlbum().getLeader().getUsername());
			
			lf = AnalyzeUtil.replace(lf, "tag", "owner", article.getAlbum().getLeader().getUsername());
		} else {
			nickname=article.getOwner().getNickname();
			if (nickname==null || nickname.trim().equals("")) {
				nickname=article.getOwner().getUsername();
			}
			lf = AnalyzeUtil.replace(lf, "tag", "uid", "" + article.getOwner().getId());
			lf = AnalyzeUtil.replace(lf, "tag", "username", article.getOwner().getUsername());
			lf = AnalyzeUtil.replace(lf, "tag", "owner", article.getOwner().getUsername());
		}
		
		lf = AnalyzeUtil.replace(lf, "tag", "nickname", nickname);
		lf = AnalyzeUtil.replace(lf, "tag", "leader", article.getAlbum().getLeader().getUsername());
		lf = AnalyzeUtil.replace(lf, "tag", "leaderuid", "" + article.getAlbum().getLeader().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "editoruid", "" + content.getEditor().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "editorUID", "" + content.getEditor().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "editor", content.getEditor().getUsername());
		lf = AnalyzeUtil.replace(lf, "tag", "author", content.getAuthor());
		lf = AnalyzeUtil.replace(lf, "tag", "authorDept", content.getAuthorDept());

		lf = AnalyzeUtil.replace(lf, "tag", "addTime", article.getCreationTime());

		return lf;

	}

	public static String fmt(AppEnvParms aep, String lf, AlbumArticle article, String imgHtmlTemplet, int titleLen,
			int txtLen, int overMark, boolean complete) {
		EnvParms ep = aep.getEp();
		HttpServletRequest request = ep.getRequest();
		AlbumArticleContent content = article.getContent();
		String overExtWords = "";
		if (overMark == 1) {
			overExtWords = "…";
		}
		ResourceBundleMessageSource messageSource = ep.getMessageSource();
		boolean halfCharacter;
		if (messageSource.getMessage("art.title.character.width", null, "full", null).trim().equals("half")) {
			halfCharacter = true;
		} else {
			halfCharacter = false;
		}
		lf = AnalyzeUtil.replace(lf, "tag", "artid", "" + article.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "albid", "" + article.getAlbum().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "albname", "" + article.getAlbum().getName());
		lf = AnalyzeUtil.replace(lf, "tag", "gname", article.getAlbum().getGenre().getName());
		lf = AnalyzeUtil.replace(lf, "tag", "gid", "" + article.getAlbum().getGenre().getId());
		
		String title = content.getSubjectShort();
		if (title==null || title.trim().equals("")) {
			title = content.getSubject();
		}
		title=StringUtil.htmlRiskFilter(title);
		
		lf = AnalyzeUtil.replace(lf, "tag", "title", title);
		
		if (article.isStatus()) {
			lf = AnalyzeUtil.replace(lf, "tag", "passed", "1");
		} else {
			lf = AnalyzeUtil.replace(lf, "tag", "passed", "0");
		}

		lf = AnalyzeUtil.replace(lf, "tag", "alt", title);
		String titleProhibit = messageSource.getMessage("title.prohibit", null,
				"According to the relevant laws and regulations of the state, this article is blocked.", null);
		String subject = content.getSubject();
		String subjectShort = content.getSubjectShort();
		String synopsis = content.getSynopsis();

		if (synopsis == null || synopsis.trim().equals("")) {
			synopsis = content.getContent();
		}
		synopsis=synopsis.trim();
		synopsis=StringUtil.htmlRiskFilter(synopsis);
		synopsis = StringUtil.htmlFilter(synopsis, true);
		synopsis = StringUtil.htmlBlankTrim(synopsis, false);
		synopsis = StringUtil.strReplace(synopsis, "　", "");
		synopsis = StringUtil.strReplace(synopsis, " ", "");

		if (article.isProhibit()) {
			lf = AnalyzeUtil.replace(lf, "tag", "prohibit", "1");
			lf = AnalyzeUtil.replace(lf, "tag", "subject", titleProhibit);
			lf = AnalyzeUtil.replace(lf, "tag", "subjectShort", titleProhibit);
			lf = AnalyzeUtil.replace(lf, "tag", "synopsis", "");
		} else {
			lf = AnalyzeUtil.replace(lf, "tag", "prohibit", "0");
			if (content.getSubjectShort() == null || content.getSubjectShort().trim().equals("")) {
				subjectShort = title;
			} else {
				subjectShort=StringUtil.htmlRiskFilter(subjectShort);
			}
			if (halfCharacter) {
				if (titleLen > 0 && title.length() > titleLen) {
					title = title.substring(0, titleLen) + overExtWords;
				}

				if (titleLen > 0 && subject.length() > titleLen) {
					subject = subject.substring(0, titleLen) + overExtWords;
				}
				
				if (titleLen > 0 && subjectShort.length() > titleLen) {
					subjectShort = subjectShort.substring(0, titleLen) + overExtWords;
				}

				if (txtLen > 0 && synopsis.length() > txtLen) {
					synopsis = synopsis.substring(0, txtLen) + overExtWords;
				}

			} else {
				int len = StringUtil.byteLen(title);
				titleLen = titleLen * 2;
				if (titleLen > 0 && len > titleLen) {
					title = StringUtil.cutByte(title, titleLen);
					title += overExtWords;
				}
				len = StringUtil.byteLen(subjectShort);
				if (titleLen > 0 && len > titleLen) {
					subjectShort = StringUtil.cutByte(subjectShort, titleLen);
					subjectShort += overExtWords;
				}

				len = StringUtil.byteLen(synopsis);
				txtLen = txtLen * 2;
				if (txtLen > 0 && len > txtLen) {
					synopsis = StringUtil.cutByte(synopsis, txtLen);
					synopsis += overExtWords;
				}

			}

			lf = AnalyzeUtil.replace(lf, "tag", "synopsis", synopsis);

			lf = AnalyzeUtil.replace(lf, "tag", "subject", subject);
			lf = AnalyzeUtil.replace(lf, "tag", "subjectShort", subjectShort);
			lf = AnalyzeUtil.replace(lf, "tag", "albumTitle", content.getSubject());
		}
		if (article.isSoul()) {
			lf = AnalyzeUtil.replace(lf, "tag", "soul", "1");
		} else {
			lf = AnalyzeUtil.replace(lf, "tag", "soul", "0");
		}
		
		String nickname;

		if (article.getOwner() == null) {
			nickname=article.getAlbum().getLeader().getNickname();
			if (nickname==null || nickname.trim().equals("")) {
				nickname=article.getAlbum().getLeader().getUsername();
			}
			lf = AnalyzeUtil.replace(lf, "tag", "uid", "" + article.getAlbum().getLeader().getId());
			lf = AnalyzeUtil.replace(lf, "tag", "username", article.getAlbum().getLeader().getUsername());
			lf = AnalyzeUtil.replace(lf, "tag", "owner", article.getAlbum().getLeader().getUsername());
		} else {
			nickname=article.getOwner().getNickname();
			if (nickname==null || nickname.trim().equals("")) {
				nickname=article.getOwner().getUsername();
			}
			lf = AnalyzeUtil.replace(lf, "tag", "uid", "" + article.getOwner().getId());
			lf = AnalyzeUtil.replace(lf, "tag", "username", article.getOwner().getUsername());
			lf = AnalyzeUtil.replace(lf, "tag", "owner", article.getOwner().getUsername());
		}
		
		lf = AnalyzeUtil.replace(lf, "tag", "nickname", nickname);
		lf = AnalyzeUtil.replace(lf, "tag", "penname", nickname);

		lf = AnalyzeUtil.replace(lf, "tag", "leader", article.getAlbum().getLeader().getUsername());
		lf = AnalyzeUtil.replace(lf, "tag", "leaderuid", "" + article.getAlbum().getLeader().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "editoruid", "" + content.getEditor().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "editorUID", "" + content.getEditor().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "editor", content.getEditor().getUsername());
		lf = AnalyzeUtil.replace(lf, "tag", "author", content.getAuthor());
		lf = AnalyzeUtil.replace(lf, "tag", "authorDept", content.getAuthorDept());

		lf = AnalyzeUtil.replace(lf, "tag", "albHref",
				AlbumUtil.getHref(messageSource, request, article.getAlbum(), false));
		lf = AnalyzeUtil.replace(lf, "tag", "alburl",
				AlbumUtil.getHref(messageSource, request, article.getAlbum(), false));

		lf = AnalyzeUtil.replace(lf, "tag", "addTime", article.getCreationTime());
		lf = AnalyzeUtil.replace(lf, "tag", "views", article.getVbook().getViewsTotal());
		lf = AnalyzeUtil.replace(lf, "tag", "ips", article.getVbook().getIpTotal());
		long lastModifyTime = content.getEditTime();
		if (lastModifyTime <= 0) {
			lastModifyTime = article.getCreationTime();
		}
		lf = AnalyzeUtil.replace(lf, "tag", "modifyTime", lastModifyTime);
		lf = AnalyzeUtil.replace(lf, "tag", "lastModifyTime", lastModifyTime);
		boolean jump = false;
		if (content.getJumpUrl() != null && !content.getJumpUrl().trim().equals("")) {
			jump = true;
		}
		String href;
		if (jump) {
			if (messageSource.getMessage("art.jump.mode", null, "direct", null).trim().equals("direct")) {
				href = content.getJumpUrl().trim();
			} else {
				href = request.getContextPath() + "/show_album/art/" + article.getId();
			}
		} else {
			if (article.isStatus() && article.getHfs() != null && article.getHfs().isStatus()) {
				href = article.getHfs().getUrl();
			} else {

				href = request.getContextPath() + "/show_album/art/" + article.getId();
			}
		}

		lf = AnalyzeUtil.replace(lf, "tag", "href", href);
		lf = AnalyzeUtil.replace(lf, "tag", "pollID", "" + article.getPoll().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "poll_id", "" + article.getPoll().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "poll_agrees", "" + article.getPoll().getAgrees());
		lf = AnalyzeUtil.replace(lf, "tag", "poll_antis", "" + article.getPoll().getAntis());
		lf = AnalyzeUtil.replace(lf, "tag", "poll_passbys", "" + article.getPoll().getPassbys());
		lf = AnalyzeUtil.replace(lf, "tag", "pollAgrees", "" + article.getPoll().getAgrees());
		lf = AnalyzeUtil.replace(lf, "tag", "pollAntis", "" + article.getPoll().getAntis());
		lf = AnalyzeUtil.replace(lf, "tag", "pollPassbys", "" + article.getPoll().getPassbys());
		if (article.getCb() != null) {
			lf = AnalyzeUtil.replace(lf, "tag", "cbid", "" + article.getCb().getId());
		} else {
			lf = AnalyzeUtil.replace(lf, "tag", "cbid", "0");
		}

		lf = AnalyzeUtil.replace(lf, "tag", "authorEmail", content.getEmail());
		lf = AnalyzeUtil.replace(lf, "tag", "authorUrl", content.getHomepage());

		if (complete) {
			lf = AnalyzeUtil.replace(lf, "tag", "content", HttpShowUtil.escape(content.getContent()));
			/*
			 * if (article.isProhibit()) { lf = AnalyzeUtil.replace(lf, "tag", "content",
			 * titleProhibit); }else { lf = AnalyzeUtil.replace(lf, "tag", "content",
			 * HttpShowUtil.escape(content.getContent())); }
			 */

			lf = AnalyzeUtil.replace(lf, "tag", "body", HttpShowUtil.escape(content.getContent()));
			
			lf = AnalyzeUtil.replace(lf, "tag", "topic", StringUtil.htmlRiskFilter(content.getToppic()));
			lf = AnalyzeUtil.replace(lf, "tag", "extra", StringUtil.htmlRiskFilter(content.getExtra()));

		}

		if (article.isProhibit()) {
			lf = AnalyzeUtil.replace(lf, "tag", "thumbnail", "");
			lf = AnalyzeUtil.replace(lf, "tag", "imgMain", "");
			lf = AnalyzeUtil.replace(lf, "tag", "imgMainTxt", "");
			lf = AnalyzeUtil.replace(lf, "tag", "thumbnailLabel", "");
			lf = AnalyzeUtil.replace(lf, "tag", "imgMainLabel", "");
		} else {
			String thumbnail;

			thumbnail = content.getThumbnail();
			if (thumbnail == null || thumbnail.trim().equals("")) {
				thumbnail = content.getTitleImg();
			}
			if (thumbnail == null || thumbnail.trim().equals("")) {
				thumbnail = aep.getThumbnailNone();
			}

			lf = AnalyzeUtil.replace(lf, "tag", "thumbnail", thumbnail);
			lf = AnalyzeUtil.replace(lf, "tag", "imgMain", content.getTitleImg());

			/*
			 * 由于图像需要一段代码，src为空将会产生错误。所以，如果传入一段 img src=格式的模板将避免出现错误 所以加入thumbnailLabel
			 * imgMainLabel两个标签
			 */
			String tmp;
			if (imgHtmlTemplet != null && !imgHtmlTemplet.trim().equals("")) {
				tmp = imgHtmlTemplet;
				tmp = AnalyzeUtil.replace(tmp, "tag", "src", thumbnail);
				lf = AnalyzeUtil.replace(lf, "tag", "thumbnailLabel", tmp);

				if (content.getTitleImg() != null && !content.getTitleImg().trim().equals("")) {
					tmp = imgHtmlTemplet;
					tmp = AnalyzeUtil.replace(tmp, "tag", "src", content.getTitleImg());

					lf = AnalyzeUtil.replace(lf, "tag", "imgMainLabel", tmp);
					lf = AnalyzeUtil.replace(lf, "tag", "imgMainTxt", content.getTitleImgTxt());
				} else {
					lf = AnalyzeUtil.replace(lf, "tag", "imgMainLabel", "");
					lf = AnalyzeUtil.replace(lf, "tag", "imgMainTxt", "");
				}

			} else {
				lf = AnalyzeUtil.replace(lf, "tag", "thumbnailLabel", thumbnail);
				lf = AnalyzeUtil.replace(lf, "tag", "imgMainLabel", content.getTitleImg());
			}
		}

		return lf;
	}

	/*
	 * 构造静态文件
	 */
	public static FileEl feBuild(ResourceBundleMessageSource messageSource, HttpServletRequest request,
			AlbumArticle art, boolean rebuild) {
		FileEl fe = new FileEl();
		String fmtStr = messageSource.getMessage("albart.file.static.fmt", null, "", null);
		SimpleDateFormat fm = new SimpleDateFormat(fmtStr);
		String file;
		if (rebuild) {
			file = fm.format(art.getCreationTime());
		} else {
			file = fm.format(System.currentTimeMillis());
		}
		file = StringUtil.strReplace(file, "albid", "" + art.getAlbum().getId());
		file = StringUtil.strReplace(file, "gid", "" + art.getAlbum().getGenre().getId());
		file = StringUtil.strReplace(file, "aid", "" + art.getAlbum().getId());
		file = StringUtil.strReplace(file, "id", "" + art.getId());
		file = StringUtil.strReplace(file, "artid", "" + art.getId());

		String url = request.getContextPath() + "/" + file;
		String realFile = file;
		fe.setUrl(url);
		fe.setRealPath(realFile);

		return fe;
	}

	

	public static boolean classChgChk(AlbumArticle albumArticle, IAlbumArticleDao albumArticleDaoImpl) {
		AlbumArticle atDb = albumArticleDaoImpl.findByID(albumArticle.getId());
		long aid = 0;
		long adid = 0;
		if (albumArticle.getClassify() != null) {
			aid = albumArticle.getClassify().getId();
		}
		if (atDb.getClassify() != null) {
			adid = atDb.getClassify().getId();
		}
		if (aid != adid) {
			return false;
		}
		return true;
	}

	public static boolean contentChgChk(AlbumArticle albumArticle, IAlbumArticleDao albumArticleDaoImpl) {
		AlbumArticleContent contentCur = albumArticle.getContent();
		AlbumArticleContent contentDb = albumArticleDaoImpl.findCurrContentByID(albumArticle.getId());
		if (!StringUtil.compare(contentCur.getAuthor(), contentDb.getAuthor())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getAuthorDept(), contentDb.getAuthorDept())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getContent(), contentDb.getContent())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getEmail(), contentDb.getEmail())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getExtra(), contentDb.getExtra())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getHomepage(), contentDb.getHomepage())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getJumpUrl(), contentDb.getJumpUrl())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getMediaUrl(), contentDb.getMediaUrl())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getSecondTitle(), contentDb.getSecondTitle())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getSubject(), contentDb.getSubject())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getSubjectShort(), contentDb.getSubjectShort())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getSynopsis(), contentDb.getSynopsis())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getThumbnail(), contentDb.getThumbnail())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getTitleImg(), contentDb.getTitleImg())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getTitleImgTxt(), contentDb.getTitleImgTxt())) {
			return false;
		}
		if (!StringUtil.compare(contentCur.getToppic(), contentDb.getToppic())) {
			return false;
		}

		return true;
	}

	public static boolean attaChgChk(AlbumArticle albumArticle, IAlbumArticleDao albumArticleDaoImpl) {
		AlbumArticle artDB = albumArticleDaoImpl.findByID(albumArticle.getId());
		if (artDB.isStatus() != albumArticle.isStatus() || artDB.isSoul() != albumArticle.isSoul()
				|| artDB.getCb().isStatus() != albumArticle.getCb().isStatus()
				|| artDB.getPoll().isStatus() != albumArticle.getPoll().isStatus()) {
			return false;
		}
		return true;
	}

	public static List<String> compare(AlbumArticleContent content1, AlbumArticleContent content2) {
		List<String> listmsg = new ArrayList<String>();
		if (!StringUtil.compare(content1.getSubject(), content2.getSubject())) {
			listmsg.add("subject");
		}
		if (!StringUtil.compare(content1.getSubjectShort(), content2.getSubjectShort())) {
			listmsg.add("subjectShort");
		}
		if (!StringUtil.compare(content1.getSecondTitle(), content2.getSecondTitle())) {
			listmsg.add("secondTitle");
		}
		if (!StringUtil.compare(content1.getToppic(), content2.getToppic())) {
			listmsg.add("toppic");
		}
		if (!StringUtil.compare(content1.getExtra(), content2.getExtra())) {
			listmsg.add("extra");
		}
		if (!StringUtil.compare(content1.getSynopsis(), content2.getSynopsis())) {
			listmsg.add("synopsis");
		}
		if (!StringUtil.compare(content1.getAuthor(), content2.getAuthor())) {
			listmsg.add("author");
		}
		if (!StringUtil.compare(content1.getAuthorDept(), content2.getAuthorDept())) {
			listmsg.add("authorDept");
		}
		if (!StringUtil.compare(content1.getEmail(), content2.getEmail())) {
			listmsg.add("email");
		}
		if (!StringUtil.compare(content1.getHomepage(), content2.getHomepage())) {
			listmsg.add("homepage");
		}
		if (!StringUtil.compare(content1.getJumpUrl(), content2.getJumpUrl())) {
			listmsg.add("jumpUrl");
		}
		if (!StringUtil.compare(content1.getMediaUrl(), content2.getMediaUrl())) {
			listmsg.add("mediaUrl");
		}
		if (!StringUtil.compare(content1.getThumbnail(), content2.getThumbnail())) {
			listmsg.add("thumbnail");
		}
		if (!StringUtil.compare(content1.getTitleImg(), content2.getTitleImg())) {
			listmsg.add("titleImg");
		}
		if (!StringUtil.compare(content1.getTitleImgTxt(), content2.getTitleImgTxt())) {
			listmsg.add("titleImgTxt");
		}
		if (!StringUtil.compare(content1.getContent(), content2.getContent())) {
			listmsg.add("content");
		}
		return listmsg;
	}

	public static AlbumArticleContent validate(ResourceBundleMessageSource messageSource, AlbumArticleContent content) {
		String charset = messageSource.getMessage("charset", null, "UTF-8", null);
		String filterWords = ConfigUtil.configContentsByComma("filterWords", charset);
		String repTarget = "";
		boolean rep = false;
		if (messageSource.getMessage("filter.replace", null, "true", null).trim().equals("true")) {
			rep = true;
			repTarget = messageSource.getMessage("filter.replace.target", null, "*", null);
		}
		content.setSubject(SysUtil.validateAss(content.getSubject(), filterWords, rep, repTarget, true));
		content.setSubjectShort(SysUtil.validateAss(content.getSubjectShort(), filterWords, rep, repTarget, true));
		content.setContent(StringUtil.filterByWords(content.getContent(), filterWords, rep, repTarget));

		content.setAuthor(SysUtil.validateAss(content.getAuthor(), filterWords, rep, repTarget, false));
		content.setAuthorDept(SysUtil.validateAss(content.getAuthorDept(), filterWords, rep, repTarget, false));
		content.setExtra(SysUtil.validateAss(content.getExtra(), filterWords, rep, repTarget, false));
		content.setSynopsis(SysUtil.validateAss(content.getSynopsis(), filterWords, rep, repTarget, false));
		content.setTitleImg(SysUtil.validateAss(content.getTitleImg(), filterWords, rep, repTarget, false));
		content.setTitleImgTxt(SysUtil.validateAss(content.getTitleImgTxt(), filterWords, rep, repTarget, false));
		content.setToppic(SysUtil.validateAss(content.getToppic(), filterWords, rep, repTarget, false));
		content.setThumbnail(SysUtil.validateAss(content.getThumbnail(), filterWords, rep, repTarget, false));

		return content;
	}

	/**
	 * 高亮显示文章
	 * 
	 * @param query  {@link org.apache.lucene.search.Query}
	 * @param data   未高亮的数据
	 * @param fields 需要高亮的字段
	 * @return 高亮数据
	 */
	public static List<AlbumArticle> hightLight(Query query, List<AlbumArticle> data, String... fields) {
		List<AlbumArticle> result = new ArrayList<AlbumArticle>();
//		Formatter formatter = new SimpleHTMLFormatter("<b style=\"color:red\">", "</b>");
		Formatter formatter = new SimpleHTMLFormatter("_lerx_search_key_s_", "_lerx_search_key_e_");
		QueryScorer queryScorer = new QueryScorer(query);
		Fragmenter fragmenter = new SimpleSpanFragmenter(queryScorer);
		Highlighter highlighter = new Highlighter(formatter, queryScorer);
		highlighter.setTextFragmenter(fragmenter);// 设置成高亮
		// 使用IK中文分词
		Analyzer analyzer = new IKAnalyzer();
		String content;
		for (AlbumArticle a : data) {
			// 构建新的对象进行返回，避免页面错乱（我的页面有错乱）
			/*
			 * AlbumArticle article = new AlbumArticle();
			 * article.setCreationTime(a.getCreationTime()); article.setHfs(a.getHfs());
			 * article.setAlbum(a.getAlbum());
			 */
			a.setTmpContent(StringUtil.nullAndHtmlFilter(a.getTmpContent()));
//			article.setTmpContent(a.getTmpContent());
			for (String fieldName : fields) {
				// 获得字段值，并给新的文章对象赋值
				Object fieldValue = ReflectionUtils.invokeMethod(
						BeanUtils.getPropertyDescriptor(AlbumArticle.class, fieldName).getReadMethod(), a);
				ReflectionUtils.invokeMethod(
						BeanUtils.getPropertyDescriptor(AlbumArticle.class, fieldName).getWriteMethod(), a, fieldValue);
				String hightLightFieldValue = null;
				try {
					hightLightFieldValue = highlighter.getBestFragment(analyzer, fieldName, String.valueOf(fieldValue));
				} catch (Exception e) {
					throw new RuntimeException("高亮显示关键字失败", e);
				}
				// 如果高亮成功则重新赋值
				if (hightLightFieldValue != null) {
					hightLightFieldValue = StringUtil.nullAndHtmlFilter(hightLightFieldValue);
					hightLightFieldValue = StringUtil.strReplace(hightLightFieldValue, "_lerx_search_key_s_",
							"<b style=\"color:red\">");
					hightLightFieldValue = StringUtil.strReplace(hightLightFieldValue, "_lerx_search_key_e_", "</b>");
					ReflectionUtils.invokeMethod(
							BeanUtils.getPropertyDescriptor(AlbumArticle.class, fieldName).getWriteMethod(), a,
							hightLightFieldValue);
				}
			}
			// 赋值ID
			ReflectionUtils.invokeMethod(BeanUtils.getPropertyDescriptor(AlbumArticle.class, "id").getWriteMethod(), a,
					a.getId());
			content = a.getTmpContent();

			Pattern pattern = Pattern.compile("</p>(&nbsp;*)<p>");
			Matcher matcher = pattern.matcher(content);
			content = matcher.replaceAll(" ");

			// 任意空白字符
			pattern = Pattern.compile("</p>(\\s*)<p>");
			matcher = pattern.matcher(content);
			content = matcher.replaceAll(" ");

			content = StringUtil.htmlBlankTrim(content,false);
			a.setTmpContent(content);

			String subject = a.getTmpSubject();
			subject = StringUtil.htmlBlankTrim(subject,false);
			a.setTmpSubject(subject);

			result.add(a);
		}
		return result;
	}

	public static AlbumArticle srtUpdate(AlbumArticle art) {

		SearchTotalModel srt = art.getSrt();
		if (srt == null) {
			srt = new SearchTotalModel();
		}
		srt.setAuthor(art.getContent().getAuthor());
		srt.setContent(StringUtil.nullAndHtmlFilter(art.getTmpContent()));
		srt.setCreationTime(art.getCreationTime());
		srt.setOperationTime(System.currentTimeMillis());
		srt.setDept(art.getContent().getAuthorDept());
		if (art.isStatus() && !art.isProhibit()) {
			srt.setStatus(true);
		} else {
			srt.setStatus(false);
		}
		srt.setSubject(art.getTmpSubject());
		srt.setSubjectShort(art.getSubjectShort());
		srt.setDgroup(art.getAlbum().getName());
		srt.setSynopsis(art.getContent().getSynopsis());
		srt.setUser(art.getAlbum().getLeader().getUsername());
		srt.setDtype("album");
		art.setSrt(srt);
		return art;

	}

	public static SearchTotalModel srtUpdate(SearchTotalModel srt, AlbumArticle art) {

		if (srt == null) {
			srt = new SearchTotalModel();
		}
		srt.setAuthor(art.getContent().getAuthor());
		srt.setContent(StringUtil.nullAndHtmlFilter(art.getTmpContent()));
		srt.setCreationTime(art.getCreationTime());
		srt.setOperationTime(System.currentTimeMillis());
		srt.setDept(art.getContent().getAuthorDept());
		if (art.isStatus() && !art.isProhibit()) {
			srt.setStatus(true);
		} else {
			srt.setStatus(false);
		}
		srt.setSubject(art.getTmpSubject());
		srt.setSubjectShort(art.getSubjectShort());
		srt.setDgroup(art.getAlbum().getName());
		srt.setSynopsis(art.getContent().getSynopsis());
		srt.setUser(art.getAlbum().getLeader().getUsername());
		srt.setDtype("albart");
		return srt;

	}

	public static void htmlCreate(AlbumArticle albumArticle, ResourceBundleMessageSource messageSource,
			HttpServletRequest request, IHtmlFileStaticDao htmlFileStaticDaoImpl, String contextPath) {
		if (albumArticle.isStatus()) {

			boolean jump = false;
			if (albumArticle.getContent().getJumpUrl() != null
					&& !albumArticle.getContent().getJumpUrl().trim().equals("")) {
				jump = true;
			}
			if (!jump) {

				htmlCreate(request, messageSource, contextPath, albumArticle);
				albumArticle.getHfs().setStatus(true);
				htmlFileStaticDaoImpl.modify(albumArticle.getHfs());
			}
		}
	}
	
	
	private static void htmlCreate(HttpServletRequest request, ResourceBundleMessageSource messageSource,
			String contextPath, AlbumArticle art) {
		if (contextPath == null || contextPath.trim().equals("")) {
			contextPath = "http://localhost/";
		}
		String strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
		String fromurl = contextPath + "/show_album/art/" + art.getId();
		fromurl = FileUtil.repairUrl(fromurl);
		String charset = messageSource.getMessage("charset", null, "utf-8", null);
		FileUtil.htmlBySniff(fromurl, FileUtil.appPath() + File.separator + art.getHfs().getRealPath(),
				strCreateDateTime, charset);

	}

}
