package com.lerx.v6.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.io.FileUtils;
import org.springframework.context.support.ResourceBundleMessageSource;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.dao.iface.IAlbumArtsCountDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumArtsCount;
import com.lerx.entities.AlbumPartner;
import com.lerx.entities.SearchTotalModel;
import com.lerx.entities.TempletAlbumMain;
import com.lerx.entities.User;
import com.lerx.portal.obj.AacCollArgs;
import com.lerx.portal.obj.AlbsShowAtUserCard;
import com.lerx.portal.obj.EnvirSet;
import com.lerx.portal.obj.FileEl;
import com.lerx.portal.obj.ImgUploadSize;
import com.lerx.portal.obj.SimpleAlbum;
import com.lerx.sys.obj.KeyValue;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;

public class AlbumUtil {

	public static SimpleAlbum cover(ResourceBundleMessageSource messageSource, HttpServletRequest request, Album album,
			boolean cp) {
		SimpleAlbum salbum = new SimpleAlbum();
		salbum.setGenre(album.getGenre().getName());
		salbum.setId(album.getId());
		salbum.setLeader(album.getLeader().getUsername());
		salbum.setUid(album.getLeader().getId());
		salbum.setName(album.getName());
		String href = getHref(messageSource, request, album, cp);
		href = HttpUtil.contextPathRebulid(href, request);
		salbum.setHref(href);
		salbum.setGenreHref(AlbgenreUtil.getHref(messageSource, request, album.getGenre(), cp));
		salbum.setLogo(album.getLogo());
		salbum.setTxt1(album.getTxt1());
		salbum.setTxt2(album.getTxt2());
		salbum.setAvatar(album.getLeader().getAvatarUrl());

		return salbum;
	}
	
	public static void delFolder(ResourceBundleMessageSource messageSource,  Album album) {
		String rootPath = messageSource.getMessage("album.file.static.root", null, "html/album", null);
		String href = rootPath + File.separator + album.getId();
		String realPath = FileUtil.appPath()+ File.separator + href;
		realPath = FileUtil.repairFilePath(realPath);
		File f= new File(realPath);
		if (f.exists()) {
			try {
				FileUtils.deleteDirectory(f);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
	}

	public static String getHref(ResourceBundleMessageSource messageSource, HttpServletRequest request, Album album,
			boolean cp) {
		String rootPath = messageSource.getMessage("album.file.static.root", null, "html/album", null);
		String indexFile = messageSource.getMessage("file.html.default", null, "index.html", null);
		String href = rootPath + "/" + album.getId() + "/" + indexFile;
		String realFile = FileUtil.appPath() + href;
		realFile = FileUtil.repairFilePath(realFile);
		if (realFile.substring(0, 1).equals("\\")) {
			realFile = realFile.substring(1, realFile.length());
		}
		File f = new File(realFile);
		if (!f.exists()) {
			href = "/show_album/index/" + album.getId();
		}
		if (cp) {
			href = HttpUtil.getSrvUrl(request, false) + "/" + request.getContextPath() + "/" + href;
		} else {
			href = request.getContextPath() + "/" + href;
		}
		href = HttpUtil.repairUrl(href);
		return href;
	}

	public static String hrefAnalyze(String html, Album album, ResourceBundleMessageSource messageSource,
			HttpServletRequest request, boolean cp) {
		String rootPath = messageSource.getMessage("album.file.static.root", null, "html/album", null);
		String indexFile = messageSource.getMessage("file.html.default", null, "index.html", null);
		String href = rootPath + "/" + album.getId() + "/" + indexFile;
		String realFile = FileUtil.appPath() + href;
		realFile = FileUtil.repairFilePath(realFile);
		if (realFile.substring(0, 1).equals("\\")) {
			realFile = realFile.substring(1, realFile.length());
		}
		File f = new File(realFile);
		if (!f.exists()) {
			href = "/show_album/index/" + album.getId();
		}
		if (cp) {
			href = HttpUtil.getSrvUrl(request, false) + "/" + request.getContextPath() + "/" + href;
		} else {
			href = request.getContextPath() + "/" + href;
		}
		href = HttpUtil.repairUrl(href);
		html = AnalyzeUtil.replace(html, "tag", "albhref", href);
		html = AnalyzeUtil.replace(html, "tag", "href", href);
		return html;
	}

	public static String fmt(String html, Album album) {
		html = AnalyzeUtil.replace(html, "tag", "albid", "" + album.getId());
		html = AnalyzeUtil.replace(html, "tag", "albname", album.getName());
		html = AnalyzeUtil.replace(html, "tag", "name", album.getName());
		html = AnalyzeUtil.replace(html, "tag", "gname", album.getGenre().getName());
		html = AnalyzeUtil.replace(html, "tag", "gid", "" + album.getGenre().getId());
		html = AnalyzeUtil.replace(html, "tag", "txt1", album.getTxt1());
		html = AnalyzeUtil.replace(html, "tag", "txt2", album.getTxt2());
		html = AnalyzeUtil.replace(html, "tag", "logo", album.getLogo());
		html = AnalyzeUtil.replace(html, "tag", "logoSmall", album.getLogoSmall());
		html = AnalyzeUtil.replace(html, "tag", "logo8831", album.getLogo8831());
		html = AnalyzeUtil.replace(html, "tag", "banner", album.getBanner());
		html = AnalyzeUtil.replace(html, "tag", "bannerSmall", album.getBannerSmall());
		html = AnalyzeUtil.replace(html, "tag", "description", album.getDescription());
		
		String nickname=album.getLeader().getNickname();
		if (nickname==null || nickname.trim().equals("")) {
			nickname=album.getLeader().getUsername();
		}
		
		html = AnalyzeUtil.replace(html, "tag", "leader", album.getLeader().getUsername());
		html = AnalyzeUtil.replace(html, "tag", "nickname", nickname);
		html = AnalyzeUtil.replace(html, "tag", "leaderUid", "" + album.getLeader().getId());
		html = AnalyzeUtil.replace(html, "tag", "htmlOwn", album.getHtmlOwn());
		return html;
	}

	/*
	 * 构造静态文件
	 */
	public static FileEl feBuild(ResourceBundleMessageSource messageSource, Album album) {
		FileEl fe = new FileEl();
		String fmtStr = messageSource.getMessage("album.file.static.root", null, "html/album", null);
		String file;
		file = fmtStr + "/" + album.getId();

		String indexFile = messageSource.getMessage("file.html.default", null, "index.html", null);

		file += "/" + indexFile;

		String url = FileUtil.repairUrl(file);
		String realFile = FileUtil.appPath() + file;
		realFile = FileUtil.repairFilePath(realFile);
		fe.setUrl(url);
		fe.setRealPath(realFile);

		return fe;
	}

	public static void htmlCreate(Album album, ResourceBundleMessageSource messageSource, String contextPath,
			boolean genreBuild) {
		// 更新专辑首页
		String strCreateDateTime = messageSource.getMessage("msg.datetime.html.static.create", null, "", null);
		FileEl fe = feBuild(messageSource, album);
		String charset = messageSource.getMessage("charset", null, "utf-8", null);
		String url = contextPath + "/show_album/index/" + album.getId();
		url = HttpUtil.repairUrl(url);
		FileUtil.htmlBySniff(url, fe.getRealPath(), strCreateDateTime, charset);
		// 更新频道首页
		if (genreBuild) {
			AlbgenreUtil.htmlCreate(album.getGenre(), messageSource, contextPath);
		}

	}

	public static Album validate(ResourceBundleMessageSource messageSource, Album album) {
		String charset = messageSource.getMessage("charset", null, "UTF-8", null);
		String filterWords = ConfigUtil.configContentsByComma("filterWords", charset);
		String repTarget = "";
		boolean rep = false;
		if (messageSource.getMessage("filter.replace", null, "true", null).trim().equals("true")) {
			rep = true;
			repTarget = messageSource.getMessage("filter.replace.target", null, "*", null);
		}
		album.setBanner(SysUtil.validateAss(album.getBanner(), filterWords, rep, repTarget, true));
		album.setBannerSmall(SysUtil.validateAss(album.getBannerSmall(), filterWords, rep, repTarget, true));
		album.setDescription(SysUtil.validateAss(album.getDescription(), filterWords, rep, repTarget, true));
		album.setLogo(SysUtil.validateAss(album.getLogo(), filterWords, rep, repTarget, true));
		album.setLogo8831(SysUtil.validateAss(album.getLogo8831(), filterWords, rep, repTarget, true));
		album.setLogoSmall(SysUtil.validateAss(album.getLogoSmall(), filterWords, rep, repTarget, true));
		album.setMail(SysUtil.validateAss(album.getMail(), filterWords, rep, repTarget, true));
		album.setName(SysUtil.validateAss(album.getName(), filterWords, rep, repTarget, true));
		album.setTxt1(SysUtil.validateAss(album.getTxt1(), filterWords, rep, repTarget, true));
		album.setTxt2(SysUtil.validateAss(album.getTxt2(), filterWords, rep, repTarget, true));
		return album;
	}

	public static List<SimpleAlbum> allByUid(long uid, long loginID, IAlbumDao albumDaoImpl,
			IAlbumPartnerDao albumPartnerDaoImpl, ResourceBundleMessageSource messageSource,
			HttpServletRequest request) {
		Set<Album> albums = new HashSet<Album>();
		List<Album> list = albumDaoImpl.findByLeaderID(uid, 0L, 1);
		for (Album a : list) {
			albums.add(a);
		}
		List<AlbumPartner> list2 = albumPartnerDaoImpl.findByUid(uid);
		for (AlbumPartner a : list2) {

			albums.add(a.getAlbum());
		}

		List<SimpleAlbum> listend = new ArrayList<SimpleAlbum>();
		for (Album a : albums) {
			SimpleAlbum sa = AlbumUtil.cover(messageSource, request, a, false);
			if (PartnerUtil.basicPowerChk(uid, a, albumPartnerDaoImpl)) {
				sa.setAdmin(true);
			}
			if (a.getLeader().getId() == uid) {
				sa.setOwn(true);
			}
			if (PartnerUtil.basicPowerChk(loginID, a, albumPartnerDaoImpl)) {
				sa.setMangerAbleCurr(true);
			}

			listend.add(sa);
		}

		/*
		 * 通过排序，将有spare1的排到最后
		 */
		Comparator<SimpleAlbum> comparator = new Comparator<SimpleAlbum>() {
			public int compare(SimpleAlbum a1, SimpleAlbum a2) {
				if (a1.getId() != a2.getId()) {
					return (int) (a1.getId() - a2.getId());
				} else {
					return (int) (a2.getId() - a1.getId());
				}
			}
		};
		Collections.sort(listend, comparator);
		return listend;

	}

	private static void aacModify(Album a, String timeKeyStr, long addTime,
			IAlbumArtsCountDao albumArtsCountDaoImpl, int col, int v, boolean quarter) {
		java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat(timeKeyStr);
		int timeKey;
		if (!quarter) {
			timeKey = Integer.valueOf(formatter.format(addTime));
		} else {
			timeKey = Integer.parseInt(timeKeyStr);
		}
		AlbumArtsCount aac = albumArtsCountDaoImpl.findByAK(a, timeKey);
		if (aac == null) {
			aac = new AlbumArtsCount();
			aac.setAlbum(a);
			aac.setTimeKey(timeKey);
			/*
			 * uac.setArtsTotal(0); uac.setArtsPassed(0); uac.setAlbumPassed(0);
			 */

		}

		switch (col) {
		case 1:
			aac.setPassed(aac.getPassed() + v);
			break;
		case 2:
			aac.setSoul(aac.getSoul() + v);
			break;
		default:
			aac.setTotal(aac.getTotal() + v);
		}
		
		if (aac.getPassed()<0) {
			aac.setPassed(0);
		}
		if (aac.getSoul()<0) {
			aac.setSoul(0);
		}
		if (aac.getTotal()<0) {
			aac.setTotal(0);
		}

		albumArtsCountDaoImpl.modify(aac);

		/*
		 * if (col == 1) { if (v == 1) { aac.setArtsPassed(uac.getArtsPassed() + 1); if
		 * (atype==1) { aac.setAlbumPassed(uac.getAlbumPassed()+1); }else {
		 * aac.setPortalPassed(uac.getPortalPassed()+1); } } else if (v == -1) { if
		 * (aac.getArtsPassed() > 0) { aac.setArtsPassed(uac.getArtsPassed() - 1); } if
		 * (atype==1) { if (aac.getAlbumPassed() > 0) {
		 * aac.setAlbumPassed(aac.getAlbumPassed() - 1); } }else { if
		 * (aac.getPortalPassed()>0) { aac.setPortalPassed(uac.getPortalPassed() - 1); }
		 * } } } else if (col == 0) { if (v == 1) { aac.setArtsTotal(aac.getArtsTotal()
		 * + 1); if (atype==1) { aac.setAlbumTotal(aac.getAlbumTotal() + 1); }else {
		 * aac.setPortalTotal(aac.getPortalTotal() + 1); } } else if (v == -1) { if
		 * (aac.getArtsTotal() > 0) { aac.setArtsTotal(aac.getArtsTotal() - 1); } if
		 * (atype==1) { if (aac.getAlbumTotal() > 0) {
		 * aac.setAlbumTotal(aac.getAlbumTotal() - 1); } }else { if
		 * (aac.getPortalTotal()>0) { aac.setPortalTotal(aac.getPortalTotal() - 1); } }
		 * } }
		 * 
		 * userArtsCountDaoImp.modify(uac);
		 */
	}
	
	
	/*
	 * 更新用户的文章发表和通数数
	 */
	public static void aacUpdate(AacCollArgs aca) {
		if (aca.getAlbum()!=null) {
			aacModify(aca.getAlbum(),"yyyy", aca.getCreationDT(),aca.getAlbumArtsCountDaoImpl(), aca.getTag(), aca.getV(),false);
			aacModify(aca.getAlbum(), "yyyyMM", aca.getCreationDT(),aca.getAlbumArtsCountDaoImpl(), aca.getTag(), aca.getV(),false);
			
			Date weekStamp=TimeUtil.firstDayAtWeek(new Date(aca.getCreationDT()));
			aacModify(aca.getAlbum(), "yyyyMMdd", weekStamp.getTime(),aca.getAlbumArtsCountDaoImpl(), aca.getTag(), aca.getV(),false);
			
			aacModify(aca.getAlbum(), String.valueOf(TimeUtil.quarter(aca.getCreationDT())), aca.getCreationDT(),aca.getAlbumArtsCountDaoImpl(), aca.getTag(), aca.getV(),false);
			
		}
		
	}

	public static SearchTotalModel srtUpdate(SearchTotalModel srt, Album album, IAlbumPartnerDao albumPartnerDaoImpl) {

		if (srt == null) {
			srt = new SearchTotalModel();
		}
		String austr = album.getLeader().getUsername();
		if (album.getLeader().getNickname() != null && !album.getLeader().getNickname().trim().equals("")) {
			austr += "<" + album.getLeader().getNickname() + ">";
		}
		srt.setAuthor(austr);
		srt.setSubject(album.getName());
		srt.setSynopsis(album.getDescription());
		String content = PartnerUtil.allPartner(album, albumPartnerDaoImpl);
		if (album.getTxt1() != null && !album.getTxt1().trim().equals("")) {
			content += album.getTxt1();
		}

		if (album.getTxt2() != null && !album.getTxt2().trim().equals("")) {
			content += " " + album.getTxt2();
		}
		srt.setContent(content);
		srt.setCreationTime(album.getCreateTime());
		srt.setOperationTime(System.currentTimeMillis());

		if (album.isStatus() && !album.isDeled() && album.isOpen()) {
			srt.setStatus(true);
		} else {
			srt.setStatus(false);
		}
		srt.setDtype("album");
		return srt;

	}
	
	//以下用于用户专辑过多时的显示处理
	//根据用户的 filter 生成两组，一组是显示的，一组是屏蔽的
	public static AlbsShowAtUserCard init(List<SimpleAlbum> albList,String filterStr) {
		AlbsShowAtUserCard asauc = new  AlbsShowAtUserCard();
		List<SimpleAlbum> noselected = new ArrayList<SimpleAlbum>();
		List<SimpleAlbum> selected = new ArrayList<SimpleAlbum>();
		for (SimpleAlbum sa:albList) {
			if (filterStr!=null && filterStr.indexOf("_"+sa.getId()+"_")!= -1) {
				noselected.add(sa);
			}else {
				selected.add(sa);
			}
		}
		
		asauc.setNoshow(noselected);
		asauc.setShow(selected);
		String filterTmp="";
		for (SimpleAlbum sa:noselected) {
			filterTmp += "_"+sa.getId()+"_";
		}
		if (!filterTmp.trim().equals("")) {
			asauc.setFilterStr(filterTmp);
		}
		
		return asauc;
		
	}
	
	
	//根据屏蔽的列表生成屏蔽码字符串
	public static String noshowAtCardFilterSet(List<SimpleAlbum> noselected,String filterStr) {
		String filterTmp="";
		for (SimpleAlbum sa:noselected) {
			filterTmp += "_"+sa.getId()+"_";
		}
		if (!filterTmp.trim().equals("")) {
			return filterTmp;
		}else {
			return null;
		}
	}
	
	/*
	 * 判别是否是主人或领衔人
	 */
	public static boolean isLeader(Album album,long currUid, IAlbumPartnerDao albumPartnerDaoImpl) {
		
		if (currUid==album.getLeader().getId()) {
			return true;
		}
		
		if (albumPartnerDaoImpl.findLeaderUid(album.getId())==currUid) {
			return true;
		}
		return false;
	}
	
	/*
	 * 根据模板取图片设定的尺寸。
	 */
	public static ImgUploadSize fromTemplet(ResourceBundleMessageSource messageSource,TempletAlbumMain templet) {
		ImgUploadSize ius= new ImgUploadSize();
		if (templet!=null) {
			String thumbnailWidthStr=TempletAlbumUtil.sundriesTag(templet, "thumbnail_width");
			String thumbnailHeightStr=TempletAlbumUtil.sundriesTag(templet, "thumbnail_height");
			
			String titleImgWidthStr=TempletAlbumUtil.sundriesTag(templet, "titleImg_width");
			String titleImgHeightStr=TempletAlbumUtil.sundriesTag(templet, "titleImg_height");
			
			if (thumbnailWidthStr!=null && !thumbnailWidthStr.trim().equals("") && StringUtil.isNumber(thumbnailWidthStr.trim())) {
				ius.setThumbnailWidth(Integer.valueOf(thumbnailWidthStr.trim()));
			}
			
			if (thumbnailHeightStr!=null && !thumbnailHeightStr.trim().equals("") && StringUtil.isNumber(thumbnailHeightStr.trim())) {
				ius.setThumbnailHeight(Integer.valueOf(thumbnailHeightStr.trim()));
			}
			
			if (titleImgWidthStr!=null && !titleImgWidthStr.trim().equals("") && StringUtil.isNumber(titleImgWidthStr.trim())) {
				ius.setTitleImgWidth(Integer.valueOf(titleImgWidthStr.trim()));
			}
			if (titleImgHeightStr!=null && !titleImgHeightStr.trim().equals("") && StringUtil.isNumber(titleImgHeightStr.trim())) {
				ius.setTitleImgHeight(Integer.valueOf(titleImgHeightStr.trim()));
			}
			
		}
		
		
		if (ius.getThumbnailWidth() == 0) {
			ius.setThumbnailWidth(Integer.valueOf(messageSource.getMessage("img.resize.cut.default.width", null, "0", null)));
		}
		if (ius.getThumbnailHeight() == 0) {
			ius.setThumbnailHeight(Integer.valueOf(messageSource.getMessage("img.resize.cut.default.height", null, "0", null)));
		}
		
		if (ius.getTitleImgWidth() == 0) {
			ius.setTitleImgWidth(Integer.valueOf(messageSource.getMessage("img.resize.cut.default.width", null, "0", null)));
		}
		if (ius.getTitleImgHeight() == 0) {
			ius.setTitleImgHeight(Integer.valueOf(messageSource.getMessage("img.resize.cut.default.height", null, "0", null)));
		}
		
		return ius;
	}
	
	public static List<KeyValue> lablesInit(Album album){
		List<KeyValue> list = new ArrayList<KeyValue>();
		String lables=album.getLabels();
		if (lables!=null && !lables.trim().equals("")) {
			lables=lables.trim();
			lables=StringUtil.strReplace(lables, " ", "");
			lables=StringUtil.htmlBlankTrim(lables, true);
			String[] sArray = lables.split(",");
			for (int step = 0; step < sArray.length; step++) {
				String[] kvs = sArray[step].split(":");
				if (kvs.length==2) {
					KeyValue kv = new KeyValue();
					kv.setName(kvs[0]);
					kv.setValue(kvs[1]);
					list.add(kv);
				}
			}
		}
		return list;
	}
	
	//检查是否审核员
	public static boolean checker(Album album,User user,EnvirSet es) {
		if (user.getId()==album.getLeader().getId()) {
			return true;
		}
		AlbumPartner partner=es.getAlbumPartnerDaoImpl().findByAIDAndUid(album.getId(), user.getId());
		
		if (partner==null) {
			return false;
		}else {
			if (partner.isChecker()) {
				return true;
			}
		}
		
		return false;
	}
	
	public static boolean checker(Album album,User user,IAlbumPartnerDao albumPartnerDaoImpl) {
		if (user.getId()==album.getLeader().getId()) {
			return true;
		}
		AlbumPartner partner=albumPartnerDaoImpl.findByAIDAndUid(album.getId(), user.getId());
		
		if (partner==null) {
			return false;
		}else {
			if (partner.isChecker()) {
				return true;
			}
		}
		
		return false;
	}

}
