package com.lerx.v6.util;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.entities.CommentBridge;
import com.lerx.entities.CommentThread;
import com.lerx.entities.Poll;
import com.lerx.entities.SearchTotalModel;
import com.lerx.entities.User;
import com.lerx.portal.obj.TempletCommentFmtRequisite;
import com.lerx.sys.obj.DatetimeSpanSuffixTxt;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;

public class CommUtil {
	
	public static String fmt(String lf, CommentThread ct) {
		
		lf = AnalyzeUtil.replace(lf, "tag", "content", StringUtil.htmlRiskFilter(ct.getContent()));
		lf = AnalyzeUtil.replace(lf, "tag", "subject", StringUtil.htmlRiskFilter(ct.getCb().getObjTitle()));
		lf = AnalyzeUtil.replace(lf, "tag", "replies", "" + ct.getReplies());
		lf = AnalyzeUtil.replace(lf, "tag", "views", "" + ct.getViews());
		lf = AnalyzeUtil.replace(lf, "tag", "id", "" + ct.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "cid", "" + ct.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "bid", "" + ct.getCb().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "ip", ct.getIp());
		lf = AnalyzeUtil.replace(lf, "tag", "href", ct.getCb().getHosturl());
		String nickname=ct.getUser().getNickname();
		if (nickname==null || nickname.trim().equals("")) {
			nickname=ct.getUser().getUsername();
		}
		lf = AnalyzeUtil.replace(lf, "tag", "username", ct.getUser().getUsername());
		lf = AnalyzeUtil.replace(lf, "tag", "nickname", nickname);
		lf = AnalyzeUtil.replace(lf, "tag", "uid", ""+ct.getUser().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "addTime", ct.getOccurDatetime());
		return lf;
	}

	public static String fmt(TempletCommentFmtRequisite tcfr, CommentThread ct) {
		int inform = tcfr.getInform();
		String lf = tcfr.getLf();
		String funHtmlPass = tcfr.getFunHtmlPass();
		String funHtmlDel = tcfr.getFunHtmlDel();
		DatetimeSpanSuffixTxt dsst = tcfr.getDsst();

		if (ct.isDeleted()) {
			funHtmlDel = " --deleted--";
		}

		if (ct.isStatus()) {
			funHtmlPass = " --passed--";
		}

		if (tcfr.isMaster()) {
			lf = AnalyzeUtil.replace(lf, "tag", "del", funHtmlDel);
			lf = AnalyzeUtil.replace(lf, "tag", "pass", funHtmlPass);
		} else {
			lf = AnalyzeUtil.replace(lf, "tag", "del", "");
			lf = AnalyzeUtil.replace(lf, "tag", "pass", "");
		}
		
		lf = AnalyzeUtil.replace(lf, "tag", "content", StringUtil.htmlRiskFilter(ct.getContent()));
		lf = AnalyzeUtil.replace(lf, "tag", "subject", StringUtil.htmlRiskFilter(ct.getSubject()));
		lf = AnalyzeUtil.replace(lf, "tag", "replies", "" + ct.getReplies());
		lf = AnalyzeUtil.replace(lf, "tag", "views", "" + ct.getViews());
		lf = AnalyzeUtil.replace(lf, "tag", "id", "" + ct.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "cid", "" + ct.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "bid", "" + ct.getCb().getId());
		lf = AnalyzeUtil.replace(lf, "tag", "ip", ct.getIp());
		lf = AnalyzeUtil.replace(lf, "tag", "addTime", ct.getOccurDatetime());
		lf = AnalyzeUtil.replace(lf, "tag", "timesLosted", TimeUtil.statTimesLosted(ct.getOccurDatetime(), dsst));

		lf = speakerFmt(lf, ct.getUser(), tcfr);

		String replyAdd = tcfr.getReplyAdd();
		if (ct.getParent() != null) {
			replyAdd = speakerFmt(replyAdd, ct.getParent().getUser(), tcfr);

		} else {
			replyAdd = "";
		}
		lf = AnalyzeUtil.replace(lf, "tag", "replyAdd", replyAdd);

		/*
		 * 投票处理
		 */

		Poll poll = ct.getPoll();
		lf = AnalyzeUtil.replace(lf, "tag", "pollID", "" + poll.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "pollAgrees", "" + poll.getAgrees());
		lf = AnalyzeUtil.replace(lf, "tag", "pollAntis", "" + poll.getAntis());
		lf = AnalyzeUtil.replace(lf, "tag", "pollPassbys", "" + poll.getPassbys());

		lf = AnalyzeUtil.replace(lf, "tag", "inform", "" + inform);
		return lf;
	}

	private static String speakerFmt(String lf, User user, TempletCommentFmtRequisite tcfr) {
		String herdSrc;
		if (user == null) {
			herdSrc = tcfr.getHeadDef();
			lf = AnalyzeUtil.replace(lf, "tag", "username", tcfr.getAnonymity());
			lf = AnalyzeUtil.replace(lf, "tag", "nickname", tcfr.getAnonymity());
			lf = AnalyzeUtil.replace(lf, "tag", "UID", "-1");
			lf = AnalyzeUtil.replace(lf, "tag", "uid", "-1");
			lf = AnalyzeUtil.replace(lf, "tag", "avatarSrc", tcfr.getAvatarNull());

		} else {
			if (user.getAvatarUrl() != null && !user.getAvatarUrl().trim().equals("")) {
				herdSrc = user.getAvatarUrl();
				lf = AnalyzeUtil.replace(lf, "tag", "avatarSrc", user.getAvatarUrl());
			} else {
				herdSrc = tcfr.getHeadDef();
				lf = AnalyzeUtil.replace(lf, "tag", "avatarSrc", tcfr.getAvatarNull());
			}
			
			String nickname=user.getNickname();
			if (nickname==null || nickname.trim().equals("")) {
				nickname=user.getUsername();
			}
			lf = AnalyzeUtil.replace(lf, "tag", "nickname", nickname);
			lf = AnalyzeUtil.replace(lf, "tag", "username", user.getUsername());
			lf = AnalyzeUtil.replace(lf, "tag", "UID", "" + user.getId());
			lf = AnalyzeUtil.replace(lf, "tag", "uid", "" + user.getId());
		}

		String tmp;
		if (tcfr.getImgHtmlTemplet() != null && !tcfr.getImgHtmlTemplet().trim().equals("")) {

			if (user != null && user.getAvatarUrl() != null && !user.getAvatarUrl().equals("")) {
				tmp = tcfr.getImgHtmlTemplet();
				tmp = AnalyzeUtil.replace(tmp, "tag", "src", herdSrc);
				lf = AnalyzeUtil.replace(lf, "tag", "avatar", tmp);
			} else {
				lf = AnalyzeUtil.replace(lf, "tag", "src", herdSrc);
				lf = AnalyzeUtil.replace(lf, "tag", "avatar", tcfr.getAvatarNull());
			}

		} else {
			lf = AnalyzeUtil.replace(lf, "tag", "avatar", tcfr.getAvatarNull());
		}

		tmp = AnalyzeUtil.replace(lf, "tag", "herdSrc", herdSrc);
		return lf;
	}

	public static SearchTotalModel srtUpdate(SearchTotalModel srt, CommentThread ct) {

		CommentBridge cb = ct.getCb();

		if (srt == null) {
			srt = new SearchTotalModel();
		}
		String austr = cb.getUser().getUsername();
		if (cb.getUser().getNickname() != null && !cb.getUser().getNickname().trim().equals("")) {
			austr += "<" + cb.getUser().getNickname() + ">";
		}
		srt.setAuthor(austr);
		srt.setSubject(cb.getObjTitle());
		srt.setSynopsis(ct.getContent());
		String content = ct.getContent();
		
		content=StringUtil.htmlRiskFilter(content);
		srt.setContent(content);
		srt.setCreationTime(ct.getOccurDatetime());
		srt.setOperationTime(System.currentTimeMillis());
		srt.setHref(cb.getHosturl());
		srt.setOperator(ct.getUser());

		if (cb.isStatus()) {
			srt.setStatus(true);
		} else {
			srt.setStatus(false);
		}
		
		srt.setDtype("comm");

		/*
		switch (cb.getObjType()) {
		case 2:
			srt.setDtype("art");
			break;
		case 3:
			srt.setDtype("album");
			break;
		case 4:
			srt.setDtype("albart");
			break;
		default:
			srt.setDtype("unknow");
		}
		*/

		return srt;

	}

}
