package com.lerx.v6.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.orm.hibernate5.HibernateTemplate;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.dao.iface.IGroupDao;
import com.lerx.entities.ArticleGroup;
import com.lerx.portal.obj.ArticleGroupMapCreateArgs;
import com.lerx.portal.obj.ArticleGroupNearby;
import com.lerx.portal.obj.CacheArticleGroupTreeMap;
import com.lerx.portal.obj.EnvirSet;
import com.lerx.rank.obj.RankUnitPlace;
import com.lerx.rank.util.RankUnitUtil;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.ObjUtil;
import com.lerx.sys.util.StringUtil;

public class GroupUtil {

	/*
	 * public static List<ArticleGroup> prebuild666(HibernateTemplate
	 * ht,List<ArticleGroup> list,ArticleGroup disabler,String pre,String
	 * preFront,String preEnd){ List<ArticleGroup> prelist = new
	 * ArrayList<ArticleGroup>(); for (ArticleGroup g:list) {
	 * 
	 * if (disabler == null || (disabler != null &&
	 * !(g.getFootLeft()>=disabler.getFootLeft() && g.getFootRight() <=
	 * disabler.getFootRight()))) { RankUnitPlace
	 * rup=RankUnitUtil.placeInfInParent(ht, g); g.setRup(rup);
	 * 
	 * String preStr; if (preEnd==null || preEnd.trim().equals("")) { preEnd = pre;
	 * } if (rup.getNextID()==0) { preStr=preEnd; }else { preStr=pre; }
	 * g.setTitle(StringUtil.countStr((g.getOrderStr().length()-1)/3 -
	 * 1,preFront)+preStr+g.getName());
	 * 
	 * prelist.add(g); }
	 * 
	 * } return prelist; }
	 */

	/*
	 * public static List<ArticleGroup> prebuild(HibernateTemplate ht,
	 * List<ArticleGroup> list, ArticleGroup disabler, String pre, String rootTitle)
	 * { List<ArticleGroup> prelist = new ArrayList<ArticleGroup>(); if (rootTitle
	 * != null) { ArticleGroup groot = new ArticleGroup(); groot.setId(0);
	 * groot.setTitle(rootTitle); groot.setName(rootTitle); prelist.add(groot); }
	 * for (ArticleGroup g : list) { if (disabler == null || (disabler != null &&
	 * !(g.getFootLeft() >= disabler.getFootLeft() && g.getFootRight() <=
	 * disabler.getFootRight()))) { RankUnitPlace rup =
	 * RankUnitUtil.placeInfInParent(ht, g); g.setRup(rup);
	 * g.setTitle(StringUtil.countStr((g.getOrderStr().length() - 1) / 3 - 1, "　") +
	 * pre + g.getName());
	 * 
	 * prelist.add(g); } } return prelist; }
	 */

	public static List<ArticleGroup> prebuild2(ArticleGroupMapCreateArgs agmca, List<ArticleGroup> list,
			ArticleGroup disabler, String pre) {
		List<ArticleGroup> prelist = new ArrayList<ArticleGroup>();
		String indexFile = agmca.getMessageSource().getMessage("file.html.default", null, "index.html", null);
		String htmlRoot = agmca.getMessageSource().getMessage("group.file.static.root", null, "html", null);
		htmlRoot = agmca.getRequest().getContextPath() + "/" + htmlRoot;

		if (agmca.getRootTitle() != null) {
			ArticleGroup groot = new ArticleGroup();
			groot.setId(0);
			groot.setTitle("{navRoot}");
			groot.setName("{navRoot}");
			prelist.add(groot);
		}
		List<ArticleGroup> listInMask = mGroupsListCreate(agmca.getGroupDaoImpl(), agmca.getCurrRoleMask());
		// 这上面一行
		for (ArticleGroup g : list) {
			if (disabler == null || (disabler != null
					&& !(g.getFootLeft() >= disabler.getFootLeft() && g.getFootRight() <= disabler.getFootRight()))) {
				RankUnitPlace rup = RankUnitUtil.placeInfInParent(agmca.getGroupDaoImpl().ht(), g);
				g.setRup(rup);
				g.setTitle(StringUtil.countStr((g.getOrderStr().length() - 1) / 3 - 1, "　") + pre + g.getName());

				if ((g.getJumpToUrl() == null || g.getJumpToUrl().trim().equals(""))) {
					String htmlFolder = htmlFolder(g, htmlRoot);
					String href;
					href = htmlFolder + indexFile;
					href = StringUtil.strReplace(href, "\\", "/");
					g.setUrl(href);
				} else {
					g.setUrl(g.getJumpToUrl());
				}

				if (agmca.isFree() || powerChk(g, listInMask)) {
					prelist.add(g);
				}

			}
		}
		List<ArticleGroup> prelistend = new ArrayList<ArticleGroup>();
		for (ArticleGroup g : prelist) {
			g = jumpClogging(g);
			prelistend.add(g);
		}
		return prelistend;
	}

	// 根据掩码，生成一个全部的可增加文章的栏目列表
	private static List<ArticleGroup> mGroupsListCreate(IGroupDao groupDaoImpl, String mask) {

		List<ArticleGroup> listMAg = new ArrayList<ArticleGroup>();
		Long gid;
		if (mask != null && mask.indexOf(",a0,") == -1 && !mask.trim().equals("0")) {
			String[] sArray = mask.split(",");
			String spanStr;
			for (int i = 0; i < sArray.length; i++) {
				spanStr = sArray[i];
				if (spanStr != null && (spanStr.startsWith("a") || spanStr.startsWith("p"))) {
					spanStr = spanStr.substring(1, spanStr.length()); // 取数字
					gid = Long.valueOf(spanStr);
					ArticleGroup ag = groupDaoImpl.findByID(gid);
					if (statusChk(ag, groupDaoImpl)) {
						listMAg.add(ag);
					}

				}
			}

		}
		return listMAg;
	}

	private static boolean powerChk(ArticleGroup g, List<ArticleGroup> maskGoupList) {
		for (ArticleGroup mag : maskGoupList) {
			if (g.isStatus() && ((g.getJumpToUrl() == null || g.getJumpToUrl().trim().equals("")))
					&& g.getFootLeft() <= mag.getFootLeft() && g.getFootRight() >= mag.getFootRight()) {
				return true;
			}
		}
		return false;
	}

	public static List<ArticleGroup> preAndMaskBuild(HibernateTemplate ht, List<ArticleGroup> list, String pre,
			String rootTitle, String mask) {
		List<ArticleGroup> prelist = new ArrayList<ArticleGroup>();
		boolean admin = false;
		boolean addAll = false;
		boolean ignore = false;
//		System.out.println("mask:"+mask);
		if (mask == null || mask.trim().equals("")) {
			ignore = true; // 忽略
		}
		if (!ignore) {
			mask = "," + mask + ",";
			if (mask != null && mask.trim().equals("0")) {
				admin = true;
			}
			if (mask != null && mask.trim().equals("a0")) {
				addAll = true;
			}
		}

		if (rootTitle != null) {
			ArticleGroup groot = new ArticleGroup();
			groot.setId(0);
			groot.setTitle(rootTitle);
			groot.setName(rootTitle);

			prelist.add(groot);
		}
		for (ArticleGroup g : list) {
			RankUnitPlace rup = RankUnitUtil.placeInfInParent(ht, g);
			g.setRup(rup);
			g.setTitle(StringUtil.countStr((g.getOrderStr().length() - 1) / 3 - 1, "　") + pre + g.getName());
			g.setTmp(0);
			if (!ignore) {
				if (!admin) {
					if (mask != null) {
						if (addAll || mask.indexOf(",a" + g.getId() + ",") != -1) {
							g.setTmp(1);
						}
						if (mask.indexOf(",p" + g.getId() + ",") != -1) {
							g.setTmp(2);
						}
					}
				} else {
					g.setTmp(2);
				}
			}
			prelist.add(g);

		}
		return prelist;
	}

	public static void clearCache() {
		String cachePath = FileUtil.repairFilePath(FileUtil.webinfPath() + File.separator + "cache");

		String articleGroupTree = cachePath + File.separator + "agroupTree.xml";
		File f = new File(articleGroupTree);
		if (f.exists()) {
			f.delete();
		}

	}
	
	
	


	public static void clearCache(ArticleGroup ag, HibernateTemplate ht) {
		String cachePath = FileUtil.repairFilePath(FileUtil.webinfPath() + File.separator + "cache");

		String articleGroupTree = cachePath + File.separator + "agroupTree.xml";
		File f = new File(articleGroupTree);
		if (ag == null) {
			if (f.exists()) {
				f.delete();
			}
		} else {
			CacheArticleGroupTreeMap cagtm;
			if (f.exists()) {
				
				
				try {
					cagtm = (CacheArticleGroupTreeMap) ObjUtil.objectXmlDecoder(f.toString()).get(0);

					List<ArticleGroup> aonroot = cagtm.getOnroot();
					
					RankUnitPlace rup = RankUnitUtil.placeInfInParent(ht, ag);
					ag.setRup(rup);
					ag.setTitle(StringUtil.countStr((ag.getOrderStr().length() - 1) / 3 - 1, "　") + "├ "
							+ ag.getName());
					
					
					for (ArticleGroup g : aonroot) {
						if (ag.getId() == g.getId()) {
//							g = CollUtil.findOneByField(aonroot, "id", ag.getId());
							Collections.replaceAll(aonroot, g, ag);
							break;
						}
					}
					

					/*
					 * for (ArticleGroup g : aonroot) { if (ag.getId() == g.getId()) {
					 * ag.setTitle(StringUtil.countStr((ag.getOrderStr().length() - 1) / 3 - 1, "　")
					 * + "├ " + ag.getName());
					 * 
					 * RankUnitPlace rup = RankUnitUtil.placeInfInParent(ht, g); ag.setRup(rup);
					 * Collections.replaceAll(aonroot, g, ag);
					 * 
					 * break; } }
					 */

					f.delete();
					cagtm.setOnroot(aonroot);
					ObjUtil.objectXmlEncoder(cagtm, articleGroupTree);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}

		}

	}

	public static List<ArticleGroup> readFromCache(ArticleGroupMapCreateArgs agmca, String rootTitle) {
		String cachePath = FileUtil.repairFilePath(FileUtil.webinfPath() + File.separator + "cache");
		File filePath = new File(cachePath);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}
		String articleGroupTree = cachePath + File.separator + "agroupTree.xml";
		File f = new File(articleGroupTree);
		CacheArticleGroupTreeMap cagtm;
		if (f.exists()) {
			try {
				cagtm = (CacheArticleGroupTreeMap) ObjUtil.objectXmlDecoder(f.toString()).get(0);
				List<ArticleGroup> aonroot = cagtm.getOnroot();
				if (aonroot.size() > 0) {
					aonroot.get(0).setName(rootTitle);
					aonroot.get(0).setTitle(rootTitle);
				}
				return aonroot;
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else {
			cagtm = new CacheArticleGroupTreeMap();
			List<ArticleGroup> glist = agmca.getGroupDaoImpl().queryByParentID(0L, true, false, 0);
			List<ArticleGroup> glist2;
			glist2 = new ArrayList<ArticleGroup>();
			for (ArticleGroup g : glist) {

				switch (agmca.getStatus()) {
				case 1:
					if (statusChk(g, agmca.getGroupDaoImpl())) {
						glist2.add(g);
					}
					break;
				case -1:
					if (!g.isStatus()) {
						glist2.add(g);
					}
					break;
				default:
					glist2.add(g);
				}

			}

			cagtm.setOnroot(prebuild2(agmca, glist2, null, "├ "));
			List<ArticleGroup> aonroot = cagtm.getOnroot();
			if (aonroot.size() > 0) {
				aonroot.get(0).setName(rootTitle);
				aonroot.get(0).setTitle(rootTitle);
			}
			return aonroot;
		}
		return null;
	}

	public static void mapCreate(ArticleGroupMapCreateArgs agmca, String rootTitle) {
		Map<String, Object> map = agmca.getMap();
		// Map<String, Object> map,IGroupDao groupDaoImpl,ArticleGroup group,String
		// rootTitle,int status,boolean free,String mask
		String cachePath = FileUtil.repairFilePath(FileUtil.webinfPath() + File.separator + "cache");
		File filePath = new File(cachePath);
		if (!filePath.exists()) {
			filePath.mkdirs();
			FileUtil.erable(filePath);
		}
		String articleGroupTree = cachePath + File.separator + "agroupTree.xml";
		File f = new File(articleGroupTree);
		CacheArticleGroupTreeMap cagtm;
		ArticleGroup group = agmca.getCurrRoot();
		if (group != null && group.getId() > 0L) {
			map.put("excluded", group);

		}
		if (f.exists()) {
			try {
				cagtm = (CacheArticleGroupTreeMap) ObjUtil.objectXmlDecoder(f.toString()).get(0);
				List<ArticleGroup> aonroot = cagtm.getOnroot();
				if (aonroot.size() > 0) {
					aonroot.get(0).setName(rootTitle);
					aonroot.get(0).setTitle(rootTitle);
				}
				map.put("preListAll", aonroot);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else {
			cagtm = new CacheArticleGroupTreeMap();

			List<ArticleGroup> glist = agmca.getGroupDaoImpl().queryByParentID(0L, true, false, 0);
			List<ArticleGroup> glist2;
			glist2 = new ArrayList<ArticleGroup>();
			for (ArticleGroup g : glist) {

				switch (agmca.getStatus()) {
				case 1:
					if (statusChk(g, agmca.getGroupDaoImpl())) {
						glist2.add(g);
					}
					break;
				case -1:
					if (!g.isStatus()) {
						glist2.add(g);
					}
					break;
				default:
					glist2.add(g);
				}

			}

			cagtm.setOnroot(prebuild2(agmca, glist2, null, "├ "));
			List<ArticleGroup> aonroot = cagtm.getOnroot();
			if (aonroot.size() > 0) {
				aonroot.get(0).setName(rootTitle);
				aonroot.get(0).setTitle(rootTitle);
			}
			map.put("preListAll", aonroot);

			String xmlFile = articleGroupTree;
			try {
				ObjUtil.objectXmlEncoder(cagtm, xmlFile);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}

	}

	public static void mapGroupMaskCreate(Map<String, Object> map, IGroupDao groupDaoImpl, String rootTitle,
			String mask, int status) {

		List<ArticleGroup> glist = groupDaoImpl.queryByParentID(0L, true, false, status);

		map.put("preListAll", preAndMaskBuild(groupDaoImpl.ht(), glist, "├ ", rootTitle, mask));

	}

	public static String fmt(String lf, ArticleGroup agroup) {
		/*
		 * String tail=""; if (sub) { tail="_sub"; }
		 */
		lf = AnalyzeUtil.replace(lf, "tag", "id", "" + agroup.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "gid", "" + agroup.getId());
		lf = AnalyzeUtil.replace(lf, "tag", "name", agroup.getName());
		lf = AnalyzeUtil.replace(lf, "tag", "navName", agroup.getName());
		lf = AnalyzeUtil.replace(lf, "tag", "title", agroup.getTitle());
		lf = AnalyzeUtil.replace(lf, "tag", "folder", agroup.getFolder());
		lf = AnalyzeUtil.replace(lf, "tag", "jumpToUrl", agroup.getJumpToUrl());
		lf = AnalyzeUtil.replace(lf, "tag", "staticFolder", ""); // 静态目录，以后再写

		if (agroup.getVbook() != null) {
			lf = AnalyzeUtil.replace(lf, "tag", "views", agroup.getVbook().getViewsTotal());
			lf = AnalyzeUtil.replace(lf, "tag", "vbID", agroup.getVbook().getId());
			lf = AnalyzeUtil.replace(lf, "tag", "ips", agroup.getVbook().getIpTotal());
		} else {
			lf = AnalyzeUtil.replace(lf, "tag", "views", "0");
			lf = AnalyzeUtil.replace(lf, "tag", "vbID", "0");
			lf = AnalyzeUtil.replace(lf, "tag", "ips", "0");
		}

		return lf;
	}

	public static String locationStr(EnvirSet es, String href, String sundrieTag, boolean endHref) {
		String locationStr = "";
		String currLocation;
		String tmpHref;
		String indexFile = es.getMessageSource().getMessage("file.html.default", null, "index.html", null);
		String htmlRoot = es.getMessageSource().getMessage("group.file.static.root", null, "html", null);
		ArticleGroup agroup = es.getGroupDaoImpl().findByID(es.getGid());
		htmlRoot = es.getRequest().getContextPath() + "/" + htmlRoot;
		currLocation = agroup.getName();
		if (endHref) {
			tmpHref = href;
			tmpHref = AnalyzeUtil.replace(tmpHref, "tag", "folder", agroup.getFolder());
			tmpHref = AnalyzeUtil.replace(tmpHref, "tag", "gid", "" + agroup.getId());
			tmpHref = AnalyzeUtil.replace(tmpHref, "tag", "name", agroup.getName());
			tmpHref = GroupUtil.folderUrl(tmpHref, agroup, htmlRoot, indexFile);
			currLocation = tmpHref;
		} else {
			currLocation = "<a href=\"" + es.getRequest().getContextPath() + "/show_portal/nav/" + agroup.getId()
					+ "\">" + agroup.getName() + "</a>"; // endHref flase 在当前页，无须链接
		}
		if (agroup.getParent() != null) {
			boolean con = true;
			ArticleGroup parent;

			while (con) {
				tmpHref = href;
				parent = (ArticleGroup) agroup.getParent();
				if (parent == null) {
					con = false;
				} else {
					tmpHref = AnalyzeUtil.replace(tmpHref, "tag", "folder", parent.getFolder());
					tmpHref = AnalyzeUtil.replace(tmpHref, "tag", "gid", "" + parent.getId());
					tmpHref = AnalyzeUtil.replace(tmpHref, "tag", "name", parent.getName());
					tmpHref = GroupUtil.folderUrl(tmpHref, parent, htmlRoot, indexFile);
					locationStr = tmpHref + sundrieTag + currLocation;

					agroup = (ArticleGroup) agroup.getParent();
					currLocation = locationStr;
				}

			}
		}

		return currLocation;
	}

	public static List<ArticleGroupNearby> subOrNearby(IGroupDao groupDaoImpl, long gid, int upper) {
		List<ArticleGroupNearby> listAgn = new ArrayList<ArticleGroupNearby>();
		ArticleGroup agcurr = groupDaoImpl.findByID(gid);
		List<ArticleGroup> listAg = groupDaoImpl.queryByParentID(gid, false, false, 1);
		int step = 0;
		for (ArticleGroup ag : listAg) {
			step++;
			ArticleGroupNearby agn = new ArticleGroupNearby();
			agn.setAgroup(ag);
			agn.setProp(0);

			listAgn.add(agn);
			if (upper > 0 && step == upper) {
				break;
			}
		}
		/*
		 * 取同级的
		 */
		boolean root = false;
		long parentID;
		if (agcurr.getParent() != null) {
			parentID = agcurr.getParent().getId();
		} else {
			parentID = 0;
			root = true;
		}
		if (listAgn.size() < upper && agcurr != null) {
			listAg = groupDaoImpl.queryByParentID(parentID, false, false, 1);
			for (ArticleGroup ag : listAg) {
				if (ag.getId() == gid) {
					continue;
				}
				step++;
				ArticleGroupNearby agn = new ArticleGroupNearby();
				agn.setAgroup(ag);
				agn.setProp(1);
				listAgn.add(agn);
				if (upper > 0 && step == upper) {
					break;
				}
			}
		}

		if (agcurr.getParent() != null) {
			if (agcurr.getParent().getParent() != null) {
				parentID = agcurr.getParent().getParent().getId();
			} else {
				parentID = 0;
			}
		} else {
			parentID = 0;
		}

		if (listAgn.size() < upper && agcurr != null) {
			if (parentID == 0 && root) {
				return listAgn;
			}
			listAg = groupDaoImpl.queryByParentID(parentID, false, false, 1);
			for (ArticleGroup ag : listAg) {
				step++;
				ArticleGroupNearby agn = new ArticleGroupNearby();
				agn.setAgroup(ag);
				agn.setProp(2);
				listAgn.add(agn);
				if (upper > 0 && step == upper) {
					break;
				}
			}
		}

		return listAgn;
	}
	
	/*
	 * 根据权限码，生成一个可以管理的gid数组
	 */
	public static List<Long> pchk(String mask,IGroupDao groupDaoImpl){
		if (mask==null || mask.trim().equals("")) {
			return null;
		}
		mask = mask.trim();
		List<Long> list = new ArrayList<Long>();
		if (mask.equals("0")) {
			list.add(0L);
		}else {
			String[] sArray = mask.split(",");
			String spanStr;
			for (int i = 0; i < sArray.length; i++) {
				spanStr = sArray[i];
				if (spanStr != null && spanStr.trim().startsWith("p")) {
					spanStr = spanStr.substring(1, spanStr.length()); // 取数字
					long gid = Long.valueOf(spanStr);
					ArticleGroup ag = groupDaoImpl.findByID(gid);
					if (statusChk(ag, groupDaoImpl)) {
						list.add(gid);
					}

				}
			}
		}
		if (list.isEmpty() || list.size()==0) {
			return null;
		}else {
			return list;
		}
	}

	/*
	 * 根据掩码，判断是否可以审核
	 */
	public static boolean auditMaskChk(ArticleGroup ag, String mask) {
		if (mask == null || mask.trim().equals("")) {
			return false;
		}
		if (mask.trim().equals("0")) {
			return true;
		}
		if (ag == null) {
			return false;
		}
		mask = "," + mask + ",";
		List<ArticleGroup> agList = new ArrayList<ArticleGroup>();
		agList.add(ag);
		boolean con = true;
		if (ag.getParent() != null) {
			ArticleGroup parent;

			while (con) {
				parent = (ArticleGroup) ag.getParent();
				if (parent == null) {
					con = false;
				} else {
					agList.add(parent);
					ag = parent;
				}

			}
		}

		for (ArticleGroup g : agList) {
			if (mask.indexOf(",p" + g.getId() + ",") != -1) {
				return true;
			}
		}

		return false;
	}

	/*
	 * 根据掩码，判断是否可以编辑
	 */
	public static boolean editMaskChk(ArticleGroup ag, String mask) {
		if (mask == null || mask.trim().equals("")) {
			return false;
		}
		if (mask.trim().equals("0")) {
			return true;
		}
		if (ag == null) {
			return false;
		}
		mask = "," + mask + ",";
		List<ArticleGroup> agList = new ArrayList<ArticleGroup>();
		agList.add(ag);
		boolean con = true;
		if (ag.getParent() != null) {
			ArticleGroup parent;

			while (con) {
				parent = (ArticleGroup) ag.getParent();
				if (parent == null) {
					con = false;
				} else {
					agList.add(parent);
					ag = parent;
				}

			}
		}

		for (ArticleGroup g : agList) {
			if (mask.indexOf(",p" + g.getId() + ",") != -1 || mask.indexOf(",a" + g.getId() + ",") != -1) {
				return true;
			}
		}

		return false;
	}

	public static boolean poolchk(ArticleGroup ag) {

		if (!ag.isPoll()) {
			return false;
		}
		boolean con = true;
		if (ag.getParent() != null) {
			ArticleGroup parent;

			while (con) {
				parent = (ArticleGroup) ag.getParent();
				if (parent == null) {
					con = false;
				} else {
					if (!parent.isPoll()) {
						return false;
					}
					ag = parent;
				}

			}
		}

		return true;

	}

	// 递归检查栏目的公开状态
	public static boolean openChk(ArticleGroup ag) {
		if (ag == null || !ag.isStatus() || !ag.isOpen()) {
			return false;
		}
		boolean con = true;
		if (ag.getParent() != null) {
			ArticleGroup parent;

			while (con) {
				parent = (ArticleGroup) ag.getParent();
				if (parent == null) {
					con = false;
				} else {
					if (!parent.isStatus() || !parent.isOpen()) {
						return false;
					}
					ag = parent;
				}

			}
		}

		return true;
	}

	// 递归检查栏目的状态
	public static boolean statusChk(ArticleGroup ag, IGroupDao groupDaoImpl) {
		ArticleGroup g = groupDaoImpl.findByID(ag.getId());
		if (g == null || !g.isStatus()) {
			return false;
		}

		while (g.getParent() != null) {
			ArticleGroup parent = groupDaoImpl.findByID(g.getParent().getId());
			if (!parent.isStatus()) {
				return false;
			}
			g = parent;
		}

		return true;
	}

	public static String htmlFolder(ArticleGroup ag, String htmlRoot) {
		String dir = null;
		if (ag != null) {
			if (htmlRoot != null && !htmlRoot.trim().equals("")) {
				htmlRoot = htmlRoot + File.separator;
			}
			if (htmlRoot == null) {
				htmlRoot = "";
			}
			if (ag.getFolder() != null && !ag.getFolder().trim().equals("")) {
				dir = htmlRoot + ag.getFolder() + File.separator;
			} else {
				dir = htmlRoot + "g" + ag.getId() + File.separator;
			}
		}

		return dir;
	}
	
	public static String getUrl(ArticleGroup agroup, String htmlRoot, String indexName) {
		String htmlFolder = htmlFolder(agroup, htmlRoot);
		String href;
		href = htmlFolder + indexName;
		href = StringUtil.strReplace(href, "\\", "/");
		return href;
	}

	public static String folderUrl(String lf, ArticleGroup agroup, String htmlRoot, String indexName) {
		if ((agroup.getJumpToUrl() == null || agroup.getJumpToUrl().trim().equals(""))) {
			/*
			 * String htmlFolder = htmlFolder(agroup, htmlRoot); String href; href =
			 * htmlFolder + indexName; href = StringUtil.strReplace(href, "\\", "/");
			 * href=getUrl(agroup,htmlRoot,indexName);
			 */
			lf = AnalyzeUtil.replace(lf, "tag", "href", getUrl(agroup,htmlRoot,indexName));
		} else {
			lf = AnalyzeUtil.replace(lf, "tag", "href", agroup.getJumpToUrl());
		}

		return lf;
	}

	private static ArticleGroup jumpClogging(ArticleGroup g) {
		if (g != null && g.getJumpToUrl() != null && !g.getJumpToUrl().trim().equals("")) {
			g.setClogging(false);
		}
		return g;
	}

}
