package com.lerx.v6.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.lerx.dao.iface.IAlbumArticleDao;
import com.lerx.dao.iface.IAlbumDao;
import com.lerx.dao.iface.IAlbumPartnerDao;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumPartner;
import com.lerx.entities.User;
import com.lerx.portal.obj.SimplePartner;

public class PartnerUtil {
	
	public static boolean basicPowerChk(long uid,Album album,IAlbumPartnerDao albumPartnerDaoImpl) {
		boolean con=false;
		if (uid>0L) {
			if (album.getLeader()!=null && album.getLeader().getId()==uid) {
				con=true;
			}
			
			if (!con) {
				List<AlbumPartner> lap= albumPartnerDaoImpl.queryByAid(album.getId());
				for (int i=0;i<lap.size();i++) {
					AlbumPartner partner = lap.get(i);
					if (partner.getUser().getId()==uid) {
						con=true;
						break;
					}
				}
			}
		}
		return con;
	}
	
	public static String allPartner(Album album,IAlbumPartnerDao albumPartnerDaoImpl) {
		
		Set<String> partners=new HashSet<String>();
		partners.add(album.getLeader().getUsername());
		
		List<AlbumPartner> lap= albumPartnerDaoImpl.queryByAid(album.getId());
		for (int i=0;i<lap.size();i++) {
			AlbumPartner partner = lap.get(i);
			partners.add(partner.getUser().getUsername());
		}
		String rtmp="";
		for (String tmp:partners) {
			rtmp += "|"+ tmp + "|";
		}
		
		return rtmp;
		
	}
	
	
	public static List<SimplePartner> query(long aid,IAlbumDao albumDaoImpl,IAlbumArticleDao albumArticleDaoImpl,IAlbumPartnerDao albumPartnerDaoImpl){
		Album album = albumDaoImpl.findByID(aid);
		if (album == null  || album.isDeled() || !album.isStatus()) {
			return null;
		}
		
		List<SimplePartner> lr=new ArrayList<SimplePartner>();
		SimplePartner partner = new  SimplePartner();
		partner.setUid(album.getLeader().getId());
		partner.setUsername(album.getLeader().getUsername());
		partner.setTab(0);
		partner.setNickname(album.getLeader().getNickname());
		long countarts=albumArticleDaoImpl.countByAlbumIDAndOwnUID(aid, album.getLeader().getId(),false);
		partner.setArts(Integer.valueOf(String.valueOf(countarts)));
		long countsouls=albumArticleDaoImpl.countByAlbumIDAndOwnUID(aid, album.getLeader().getId(),true);
		partner.setSouls(Integer.valueOf(String.valueOf(countsouls)));
		lr.add(partner);
		List<AlbumPartner> listAP=albumPartnerDaoImpl.queryByAid(aid);
		for (int i=0;i<listAP.size();i++) {
			AlbumPartner ap = listAP.get(i);
			partner = new  SimplePartner();
			partner.setUid(ap.getUser().getId());
			partner.setUsername(ap.getUser().getUsername());
			partner.setTab(1);
			partner.setNickname(ap.getUser().getNickname());
			countarts=albumArticleDaoImpl.countByAlbumIDAndOwnUID(aid, ap.getUser().getId(),false);
			partner.setArts(Integer.valueOf(String.valueOf(countarts)));
			countsouls=albumArticleDaoImpl.countByAlbumIDAndOwnUID(aid, ap.getUser().getId(),true);
			partner.setSouls(Integer.valueOf(String.valueOf(countsouls)));
			lr.add(partner);
		}
		return lr;
	}
	
	//
	public static List<User> queryChecker(long aid,IAlbumDao albumDaoImpl,IAlbumPartnerDao albumPartnerDaoImpl){
		Album album = albumDaoImpl.findByID(aid);
		if (album == null  || album.isDeled() || !album.isStatus()) {
			return null;
		}
		Set<User> scheckers =  new HashSet<User>();
		scheckers.add(album.getLeader());
		List<AlbumPartner> listAP=albumPartnerDaoImpl.queryByAid(aid);
		for (int i=0;i<listAP.size();i++) {
			AlbumPartner partner=listAP.get(i);
			if (partner.isChecker()) {
				scheckers.add(partner.getUser());
			}
			
		}
		List<User>  lr =new ArrayList<User>();
		for (User partner:scheckers) {
			lr.add(partner);
		}
		return lr;
		
	}

}
