package com.lerx.v6.util;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.entities.Portal;
import com.lerx.sys.obj.Website;

public class PortalUtil {
	
	public static String fmt(String lf,Portal portal) {
		
		lf = AnalyzeUtil.replace(lf, "tag", "portalName", portal.getName());
		lf = AnalyzeUtil.replace(lf, "tag", "portalFullName", portal.getFullName());
		lf = AnalyzeUtil.replace(lf, "tag", "portalKeyWords", portal.getKeyWords());
		lf = AnalyzeUtil.replace(lf, "tag", "portalDescription", portal.getDescription());
		lf = AnalyzeUtil.replace(lf, "tag", "portalHost", portal.getHost());
		lf = AnalyzeUtil.replace(lf, "tag", "portalUrl", portal.getUrl());
		lf = AnalyzeUtil.replace(lf, "tag", "portalWelcomeStr", portal.getWelcomeStr());
		lf = AnalyzeUtil.replace(lf, "tag", "portalViews", ""+portal.getVbook().getViewsTotal());
		lf = AnalyzeUtil.replace(lf, "tag", "portalIps", ""+portal.getVbook().getIpTotal());
		
		return lf;
	}
	
	public static Website lead(Portal portal) {
		Website site = new Website();
		site.setName(portal.getName());
		site.setHost(portal.getHost());
		site.setUrl(portal.getUrl());
		return site;
	}
	
	
			

}
