package com.lerx.v6.util;

import javax.servlet.http.HttpServletRequest;

import org.springframework.context.support.ResourceBundleMessageSource;

import com.lerx.entities.AlbumArticle;
import com.lerx.entities.Article;
import com.lerx.portal.obj.SimpleArticleHref;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;

/*
 * 该类两个方法用于将静态文件的url地址写入地图文件 
 */

public class SitemapUtil {

	public static void write(ResourceBundleMessageSource messageSource, HttpServletRequest request, Article art) {
		
		if (art.isStatus() && !art.isDeled() && art.getAgroup().isStatus() && !art.getAgroup().isDeled() && art.getHfs()!=null && art.getHfs().isStatus()) {
			
			boolean sitemapbulid = false;
			int maxline = Integer.valueOf(messageSource.getMessage("site.map.file.html.lines", null, "20", null));
			
			if (messageSource.getMessage("site.map.file.bulid", null, "true", null).trim().equalsIgnoreCase("true")) {
				sitemapbulid = true;
			}

			if (sitemapbulid) {
				
				String href = ArticleUtil.getHref(messageSource, request, art);

				FileUtil.addStringToFile(FileUtil.appPath(), "sitemapFile.txt", getExtUrl(request, href),
						true, "UTF-8");
				
				SimpleArticleHref sah = new SimpleArticleHref();
				sah.setUid(art.getUser().getId());
				sah.setAddDt(art.getCreationTime());
				sah.setGenre(art.getAgroup().getName());
				sah.setTitle(art.getSubject());
				sah.setUrl(href);
				String nickname=art.getUser().getNickname();
				if (nickname==null || nickname.trim().equals("")) {
					nickname=art.getUser().getUsername();
				}
				sah.setUsername(art.getUser().getUsername());
				sah.setNickname(nickname);

				SysUtil.writePageHtml(sah, request, maxline, messageSource);
			}
		}
		
	}
	
	
	public static void write(ResourceBundleMessageSource messageSource, HttpServletRequest request, AlbumArticle art) {
		if (art.isStatus() && !art.isProhibit() && art.getAlbum().isStatus() && !art.getAlbum().isDeled() && art.getAlbum().getGenre().isStatus() && art.getHfs()!=null &&  art.getHfs().isStatus()) {
			boolean sitemapbulid = false;
			int pagerows = Integer.valueOf(messageSource.getMessage("site.map.file.html.lines", null, "20", null));
			
			if (messageSource.getMessage("site.map.file.bulid", null, "true", null).trim().equalsIgnoreCase("true")) {
				sitemapbulid = true;
			}
			
			if (sitemapbulid) {
				
				String arturl=AlbumArticleUtil.url(art, messageSource, request);
				
				FileUtil.addStringToFile(FileUtil.appPath(), "sitemapFile.txt",
						getExtUrl(request, arturl), true,"UTF-8");
				
				SimpleArticleHref sah = new SimpleArticleHref();
				sah.setUid(art.getOwner().getId());
				sah.setAddDt(art.getCreationTime());
				sah.setGenre(art.getAlbum().getGenre().getName()+"-"+art.getAlbum().getName());
				sah.setTitle(art.getContent().getSubject());
				sah.setUrl(arturl);
				
				String nickname=art.getOwner().getNickname();
				if (nickname==null || nickname.trim().equals("")) {
					nickname=art.getOwner().getUsername();
				}
				sah.setUsername(art.getOwner().getUsername());
				sah.setNickname(nickname);
				
				SysUtil.writePageHtml(sah, request, pagerows, messageSource);
			}
		}
	}
	

	private static String getExtUrl(HttpServletRequest request, String interUrl) {

		String srvurl = HttpUtil.getSrvUrl(request, false);

		srvurl += "/";
		srvurl += interUrl;
		srvurl = HttpUtil.repairUrl(srvurl);
		return srvurl;
	}

}
