package com.lerx.v6.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.context.support.ResourceBundleMessageSource;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.portal.obj.RiskLevelCollect;
import com.lerx.portal.obj.SimpleArticleHref;
import com.lerx.sys.obj.TimeSpanUnit;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.RandomNumUtil;
import com.lerx.sys.util.SecurityUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.Week;

public class SysUtil {
	
	/*
	 * 根据配置文件的设置，生成验证码
	 */
	public static String vcode(ResourceBundleMessageSource messageSource) {
		/*
		 * 生成验证字符串 authStr
		 */
		int charMode; // 1纯数字 2纯字母 0混合
		String vartmp = messageSource.getMessage("vcode.sendchar.mode", null, "0", null);
		if (StringUtil.isNumber(vartmp)) {
			charMode = Integer.valueOf(vartmp);
		} else {
			charMode = 0;
		}

		int charLength; // 长度或字符数量
		vartmp = messageSource.getMessage("vcode.sendchar.length", null, "4", null);
		if (StringUtil.isNumber(vartmp)) {
			charLength = Integer.valueOf(vartmp);
		} else {
			charLength = 4;
		}

		String authStr = RandomNumUtil.getRandStr(charLength, charMode);
		
		return authStr;
	}
	
	/*
	 * 生成加密字符串
	 */
	
	public static String encrypt(String vcode,ResourceBundleMessageSource messageSource,HttpSession session) {
		String securityStr = SecurityUtil.readWords(messageSource);
		/*
		 * 根据配置文件获得允许的截止时间剩余
		 */
		String vartmp = messageSource.getMessage("vcode.sendchar.effective", null, "30m", null);
		TimeSpanUnit tsu = TimeUtil.unixLenAtFmt(vartmp);
		long endTime = System.currentTimeMillis() + tsu.getSeconds();
		
		/*
		 * 根据配置文件获得允许的截止时间剩余
		 */

		if (session.getAttribute("lastSend") != null) {
			long lastSend = (long) session.getAttribute("lastSend");
			if (lastSend > 0 && (System.currentTimeMillis() - lastSend < tsu.getSeconds())) {
				return null;
			}
		}
		
		/*
		 * 生成加密字符
		 */
		String md5 = StringUtil.md5(String.valueOf(endTime) + "|" + vcode + "|" + securityStr);
		String encryptedStr = String.valueOf(endTime) + "|" + vcode + "|" + md5;
		
		session.setAttribute("validateEnd", endTime);
		session.setAttribute("encryptedStr", encryptedStr);
		
		return encryptedStr;
	}
	
	public static String validateAss(String str,String filterWords, boolean rep, String repTarget,boolean nullfilter) {
		if (nullfilter) {
			str=StringUtil.nullAndHtmlFilter(str);
		}else {
			str=StringUtil.htmlFilter(str,true);
		}
		
		str=StringUtil.filterByWords(str, filterWords, rep, repTarget);
		/*if (str!=null && !str.trim().equals("")) {
			str = StringUtil.escape(str);
		}*/
		return str;
	}
	
	public static String currdate(ResourceBundleMessageSource messageSource) {
		String fmt=messageSource.getMessage("format.data.chinese", null, "yyyy-MM-dd", null);
		Week w;
		w = DateUtil.dayOfWeekEnum(TimeUtil.getCurDate());
		String ws = w.toChinese();
		ws=StringUtil.strReplace(ws, "星期", "");
		fmt=StringUtil.strReplace(fmt, "{weekday}", ws);
		fmt=StringUtil.strReplace(fmt, "{weekday0}", ""+(w.getValue()-1));
		
		java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat(fmt);
		return formatter.format(System.currentTimeMillis());
	}
	
	//检测url是否关键后台地址
	public static int chkadminurl(String url) {
		if (url.indexOf("/action_portal") != -1 || url.indexOf("/action_admin") != -1 || url.indexOf("/action_templet_") != -1) {
			return 1;
		}
		return 0;
	}
	
	
	//将一网址写入 html文件
		public static void writePageHtml(SimpleArticleHref sah,HttpServletRequest request,int pagerows,ResourceBundleMessageSource messageSource) {
			
			String linefmt = FileUtil.readRes(messageSource, "htmlTemplet_sitemap_line");
			
			
			String tmpFile=FileUtil.webinfPath()+File.separator+"temp"+File.separator+"sitemap";
			tmpFile=FileUtil.repairFilePath(tmpFile);
			
			String pageTxtFile=tmpFile+File.separator+"currpage.txt";
			pageTxtFile=FileUtil.repairFilePath(pageTxtFile);
			
			File fp=new File(pageTxtFile);
			int curPage;
			if (fp.exists()) {
				String tmpfp=FileUtil.readFile(pageTxtFile, false, "utf-8");
				if (tmpfp != null && !tmpfp.trim().equals("") && StringUtil.isNumber(tmpfp.trim())) {
					tmpfp=tmpfp.trim();
					curPage=Integer.valueOf(tmpfp);
				}else {
					curPage=1;
				}
				
			}else {
				curPage=1;
			}
			
			/*
			 * if (request.getSession().getAttribute("curPage")==null ) { curPage=1; }else {
			 * curPage= (int) request.getSession().getAttribute("curPage"); }
			 * request.getSession().setAttribute("curPage", curPage);
			 */
			
			String curPagefile=tmpFile+File.separator+"page"+curPage+".html";
			curPagefile=FileUtil.repairFilePath(curPagefile);
			File f=new File(curPagefile);
			
			int lines=0;
			boolean con=false;
			String br="";
			if (f.exists()) {
				try {
					LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(f));
					lineNumberReader.skip(Long.MAX_VALUE);
					lines = lineNumberReader.getLineNumber();
					lineNumberReader.close();
					if (lines<(pagerows-1)) {
						con=true;
					}else {
						con=false;
					}
				} catch (FileNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					lines=0;
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					lines=0;
				}
				lines++;
			}else {
				con=true;
			}
			if (lines>0) {
				br="\n";
			}
			
			linefmt=AnalyzeUtil.replace(linefmt, "tag", "sn", ""+((curPage-1)*pagerows + lines + 1));
			linefmt=AnalyzeUtil.replace(linefmt, "tag", "name", sah.getTitle());
			linefmt=AnalyzeUtil.replace(linefmt, "tag", "href", sah.getUrl());
			linefmt=AnalyzeUtil.replace(linefmt, "tag", "uid", ""+sah.getUid());
			linefmt=AnalyzeUtil.replace(linefmt, "tag", "nickname", sah.getNickname());
			linefmt=AnalyzeUtil.replace(linefmt, "tag", "username", sah.getUsername());
			linefmt=AnalyzeUtil.replace(linefmt, "tag", "addTime", sah.getAddDt());
			linefmt=AnalyzeUtil.replace(linefmt, "tag", "genre", sah.getGenre());
			
			
			String str=linefmt;
//			String str="<p><a target=\"_blank\" href=\""+url+"\">" + title +"</a></p>";
			
			String htmlRoot = messageSource.getMessage("group.file.static.root", null, "html", null);
			htmlRoot=FileUtil.appPath()+File.separator+htmlRoot+File.separator+"sitemap";
			htmlRoot=FileUtil.repairFilePath(htmlRoot);
			
			
			if (con) {
				FileUtil.addStringToFile(tmpFile, "page"+curPage+".html", br+str,false, "utf-8");
				
			}else {
				curPage++;
				curPagefile = tmpFile+File.separator+"page"+curPage+".html";
				curPagefile=FileUtil.repairFilePath(curPagefile);
				
				FileUtil.addStringToFile(tmpFile, "page"+curPage+".html", str,false, "utf-8");
				
				request.getSession().setAttribute("curPage", curPage);
			}
			
			
			//写入完整html文件
			
			String tmpBody=FileUtil.readLargeFile4(curPagefile, null, "utf-8");
			String htmlFrame = FileUtil.readRes(messageSource, "htmlTemplet_sitemap_body");
			htmlFrame=AnalyzeUtil.replace(htmlFrame, "tag", "body", tmpBody);
			htmlFrame=AnalyzeUtil.replace(htmlFrame, "tag", "body", tmpBody);
			htmlFrame = AnalyzeUtil.replace(htmlFrame, "tag", "contextPath", request.getContextPath());
			htmlFrame=AnalyzeUtil.replace(htmlFrame, "tag", "page", ""+curPage);
			//
			htmlFrame=AnalyzeUtil.replace(htmlFrame, "tag", "pagerows", ""+pagerows);
			
			htmlFrame=AnalyzeUtil.replace(htmlFrame, "tag", "prevpn", ""+(curPage-1));
			htmlFrame=AnalyzeUtil.replace(htmlFrame, "tag", "nextpn", ""+(curPage+1));
			htmlFrame = AnalyzeUtil.replace(htmlFrame, "tag", "currTime", ""+System.currentTimeMillis());
			
			FileUtil.writeStringToFile(htmlRoot, "page"+curPage+".html", htmlFrame, true, "utf-8");
			
			htmlFrame = FileUtil.readRes(messageSource, "htmlTemplet_sitemap_pagecount");
			htmlFrame=AnalyzeUtil.replace(htmlFrame, "tag", "pagecount", ""+curPage);
			FileUtil.writeStringToFile(htmlRoot, "pagecount.js", htmlFrame, false, "utf-8");
			
			FileUtil.writeStringToFile(pageTxtFile, ""+curPage, false, "utf-8");
			
			
		}
		
		
		public static String htmlAlockAnnotationFilter(String str) {
			Pattern pattern = Pattern.compile("<!--.*?-->");
			Matcher matcher = pattern.matcher(str);
			str = matcher.replaceAll("");
			return str;
		}
		
		public static int riskLevelSet(String content,String filenamePre) {
			int riskLevel=0;
			content = content.toLowerCase();
			for (int i=3;i>0;i--) {
				riskLevel=findRisk(content,filenamePre,i);
				if (riskLevel>0) {
					return riskLevel;
				}
			}
			return riskLevel;
		}
		
		public static int findRisk(String content,String filenamePre,int index) {
			int riskLevel=0;
			String filename=filenamePre+"_"+index+".res";
			filename=FileUtil.repairFilePath(filename);
			File f=new File(filename);
			if (!f.exists()) {
				return 0;
			}
			BufferedReader reader;
			try {
				String strLine;
				reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));
					while ((strLine = reader.readLine()) != null) {
					
						if (!strLine.trim().equals("")){
							
							strLine = strLine.toLowerCase();
							if (content.indexOf(strLine) != -1) {
								riskLevel=index;
							}
							
						}
					}
				reader.close();
				return riskLevel;
			} catch (FileNotFoundException e1) {
				return 0;
			} catch (IOException e) {
				return 0;
			}
		}
		
		
		public static String findRiskComp(String content,String filenamePre,int index) {
			if (content==null || content.trim().equals("")) {
				return "";
			}
			String filename=filenamePre+"_"+index+".res";
			filename=FileUtil.repairFilePath(filename);
			File f=new File(filename);
			if (!f.exists()) {
				return "";
			}
			String detail="";
			BufferedReader reader;
			try {
				String strLine;
				reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));
					while ((strLine = reader.readLine()) != null) {
					
						if (!strLine.trim().equals("")){
							
							strLine = strLine.toLowerCase();
							if (content.indexOf(strLine) != -1) {
								String tmp=strLine;
								tmp=StringUtil.strReplace(tmp, "<", "< ");
								detail+=tmp+";";
							}
							
						}
					}
				reader.close();
				return detail;
			} catch (FileNotFoundException e1) {
				return "";
			} catch (IOException e) {
				return "";
			}
		}
		
		
		public static RiskLevelCollect riskDetails(String str,String filenamePre) {
			RiskLevelCollect coll=new RiskLevelCollect();
			coll.setResult1(findRiskComp(str,filenamePre,1));
			coll.setResult2(findRiskComp(str,filenamePre,2));
			coll.setResult3(findRiskComp(str,filenamePre,3));
			return coll;
		}

}
