package com.lerx.v6.util;

import java.util.ArrayList;
import java.util.List;

import org.springframework.context.support.ResourceBundleMessageSource;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.analyze.vo.DataShowParams;
import com.lerx.analyze.vo.FindedDataAnalyzeResult;
import com.lerx.dao.iface.ITempletAlbgenreMainDao;
import com.lerx.entities.Albgenre;
import com.lerx.entities.TempletAlbgenreMain;
import com.lerx.entities.TempletSubElement;
import com.lerx.portal.obj.EnvirSet;
import com.lerx.portal.obj.TempletSimple;
import com.lerx.sys.obj.DatetimeSpanSuffixTxt;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.TimeUtil;

public class TempletAlbgenreUtil {

	/*
	 * 根据tag字符串得到当前模板
	 */
	public static TempletSubElement elInitByTagStr(TempletAlbgenreMain templetMain, String tagStr) {
		TempletSubElement el;
		if (tagStr==null || tagStr.trim().equals("") || tagStr.trim().equals("public")) {
			el = templetMain.getElPublic();
		}else if (tagStr.trim().equals("index")) {
			el = templetMain.getElIndex();
		}else if (tagStr.trim().equals("nav")) {
			el = templetMain.getElNav();
		}else if (tagStr.trim().equals("art") || tagStr.trim().equals("article") || tagStr.trim().equals("artshow")) {
			el = templetMain.getElArt();
		}else if (tagStr.trim().equals("extend")) {
			el = templetMain.getElExtend();
		}else {
			el = templetMain.getElPublic();
		}
		return el;
	}

	// 返回一个el，如果当前el中的某属性为空，则赋值为上一层public中对应的属性值
	public static TempletSubElement elInit(TempletSubElement subpub, TempletSubElement subel) {
		TempletSubElement el = new TempletSubElement();
		if (subel.getBorderCode() != null && !subel.getBorderCode().trim().equals("")) {
			el.setBorderCode(subel.getBorderCode());
		} else {
			el.setBorderCode(subpub.getBorderCode());
		}
		if (subel.getMainCode() != null && !subel.getMainCode().trim().equals("")) {
			el.setMainCode(subel.getMainCode());
		} else {
			el.setMainCode(subpub.getMainCode());
		}
		if (subel.getCssCode() != null && !subel.getCssCode().trim().equals("")) {
			el.setCssCode(subel.getCssCode());
		} else {
			el.setCssCode(subpub.getCssCode());
		}
		if (subel.getTopCode() != null && !subel.getTopCode().trim().equals("")) {
			el.setTopCode(subel.getTopCode());
		} else {
			el.setTopCode(subpub.getTopCode());
		}
		if (subel.getFooterCode() != null && !subel.getFooterCode().trim().equals("")) {
			el.setFooterCode(subel.getFooterCode());
		} else {
			el.setFooterCode(subpub.getFooterCode());
		}
		if (subel.getTargetStr() != null && !subel.getTargetStr().trim().equals("")) {
			el.setTargetStr(subel.getTargetStr());
		} else {
			el.setTargetStr(subpub.getTargetStr());
		}
		if (subel.getTitleFormat() != null && !subel.getTitleFormat().trim().equals("")) {
			el.setTitleFormat(subel.getTitleFormat());
		} else {
			el.setTitleFormat(subpub.getTitleFormat());
		}
		if (subel.getFunctionAreaCode() != null && !subel.getFunctionAreaCode().trim().equals("")) {
			el.setFunctionAreaCode(subel.getFunctionAreaCode());
		} else {
			el.setFunctionAreaCode(subpub.getFunctionAreaCode());
		}

		if (subel.getSearchAreaCode() != null && !subel.getSearchAreaCode().trim().equals("")) {
			el.setSearchAreaCode(subel.getSearchAreaCode());
		} else {
			el.setSearchAreaCode(subpub.getSearchAreaCode());
		}
		if (subel.getMajorLoopCodeInLump() != null && !subel.getMajorLoopCodeInLump().trim().equals("")) {
			el.setMajorLoopCodeInLump(subel.getMajorLoopCodeInLump());
		} else {
			el.setMajorLoopCodeInLump(subpub.getMajorLoopCodeInLump());
		}
		if (subel.getMinorLoopCodeInLump() != null && !subel.getMinorLoopCodeInLump().trim().equals("")) {
			el.setMinorLoopCodeInLump(subel.getMinorLoopCodeInLump());
		} else {
			el.setMinorLoopCodeInLump(subpub.getMinorLoopCodeInLump());
		}
		if (subel.getExclusiveCode1() != null && !subel.getExclusiveCode1().trim().equals("")) {
			el.setExclusiveCode1(subel.getExclusiveCode1());
		} else {
			el.setExclusiveCode1(subpub.getExclusiveCode1());
		}
		if (subel.getExclusiveCode2() != null && !subel.getExclusiveCode2().trim().equals("")) {
			el.setExclusiveCode2(subel.getExclusiveCode2());
		} else {
			el.setExclusiveCode2(subpub.getExclusiveCode2());
		}
		if (subel.getExclusiveCode3() != null && !subel.getExclusiveCode3().trim().equals("")) {
			el.setExclusiveCode3(subel.getExclusiveCode3());
		} else {
			el.setExclusiveCode3(subpub.getExclusiveCode3());
		}
		if (subel.getExclusiveCode4() != null && !subel.getExclusiveCode4().trim().equals("")) {
			el.setExclusiveCode4(subel.getExclusiveCode4());
		} else {
			el.setExclusiveCode4(subpub.getExclusiveCode4());
		}
		return el;
	}

	// 通用模块代码替换
	public static String mainCodeReplace(String html, TempletAlbgenreMain template) {
		html = AnalyzeUtil.replace(html, "code", "public1", template.getPublicCode1());
		html = AnalyzeUtil.replace(html, "code", "public2", template.getPublicCode2());
		html = AnalyzeUtil.replace(html, "code", "public3", template.getPublicCode3());
		html = AnalyzeUtil.replace(html, "code", "public4", template.getPublicCode4());
		html = AnalyzeUtil.replace(html, "code", "custom1", template.getCustomFormatCode1());
		html = AnalyzeUtil.replace(html, "code", "custom2", template.getCustomFormatCode2());
		html = AnalyzeUtil.replace(html, "code", "custom3", template.getCustomFormatCode3());
		html = AnalyzeUtil.replace(html, "code", "custom4", template.getCustomFormatCode4());
		html = AnalyzeUtil.replace(html, "code", "custom5", template.getCustomFormatCode5());
		html = AnalyzeUtil.replace(html, "code", "custom6", template.getCustomFormatCode6());
		html = AnalyzeUtil.replace(html, "code", "custom7", template.getCustomFormatCode7());
		html = AnalyzeUtil.replace(html, "code", "custom8", template.getCustomFormatCode8());
		return html;
	}

	// 当前子模块代码替换
	public static String elCodeReplace(String html, TempletSubElement elTemplate) {
		html = AnalyzeUtil.replace(html, "code", "main", elTemplate.getMainCode());
		html = AnalyzeUtil.replace(html, "code", "top", elTemplate.getTopCode());
		html = AnalyzeUtil.replace(html, "code", "footer", elTemplate.getFooterCode());
		html = AnalyzeUtil.replace(html, "code", "css", elTemplate.getCssCode());
		html = AnalyzeUtil.replace(html, "code", "search", elTemplate.getSearchAreaCode());
		html = AnalyzeUtil.replace(html, "code", "function", elTemplate.getFunctionAreaCode());
		html = AnalyzeUtil.replace(html, "code", "exclusive1", elTemplate.getExclusiveCode1());
		html = AnalyzeUtil.replace(html, "code", "exclusive2", elTemplate.getExclusiveCode2());
		html = AnalyzeUtil.replace(html, "code", "exclusive3", elTemplate.getExclusiveCode3());
		html = AnalyzeUtil.replace(html, "code", "exclusive4", elTemplate.getExclusiveCode4());
		html = AnalyzeUtil.replace(html, "code", "loopMajor", elTemplate.getMajorLoopCodeInLump());
		html = AnalyzeUtil.replace(html, "code", "loopMinor", elTemplate.getMinorLoopCodeInLump());
		html = AnalyzeUtil.replace(html, "tag", "target", elTemplate.getTargetStr());
		html = AnalyzeUtil.replace(html, "tag", "htmlTitle", elTemplate.getTitleFormat());
		return html;
	}
	
	//得到逝去的时间说明
	public static String statTimesLosted(TempletAlbgenreMain template,long datetime) {
		DatetimeSpanSuffixTxt dsst=sundriesTimesLostedTag(template);
		return TimeUtil.statTimesLosted(datetime,dsst);
	}
	
	/*
	 * 获得逝去的时间标签库
	 */
	public static DatetimeSpanSuffixTxt sundriesTimesLostedTag(TempletAlbgenreMain template) {
		return TimeUtil.dsst(sundriesTag(template,"dsst"));
	}
	
	
	
	/*
	 * 解析标签
	 */
	public static String sundriesTag(TempletAlbgenreMain template,
			String station) {
		String tagVal="";
		
		String tags=template.getSundriesTag();
		if (tags == null || tags.trim().equals("")) {
			return "";
		}
		if (tags.indexOf(station + ":") == -1) {
			return "";
		}
		String[] sArray = tags.split(",");
		String kv;
		String[] kvArray;
		for (int i = 0; i < sArray.length; i++) {
			kv = sArray[i];
			kvArray = kv.split(":");
			if (kvArray.length > 1 && kvArray[0].trim().equals(station)) {
				tagVal=TempletUtil.escape(kvArray[1]);
			}
		}
		
		if (tagVal!=null && tagVal.trim().startsWith("code_with_")) {
			tagVal = tagVal.trim();
			String codewith=tagVal.substring(9, tagVal.length());
			if (codewith.trim().equalsIgnoreCase("_public_1")) {
				return template.getPublicCode1();
			}else if(codewith.trim().equalsIgnoreCase("_public_2")) {
				return template.getPublicCode2();
			}else if(codewith.trim().equalsIgnoreCase("_public_3")) {
				return template.getPublicCode3();
			}else if(codewith.trim().equalsIgnoreCase("_public_4")) {
				return template.getPublicCode4();
			}else if(codewith.trim().equalsIgnoreCase("_custom_1")) {
				return template.getCustomFormatCode1();
			}else if(codewith.trim().equalsIgnoreCase("_custom_2")) {
				return template.getCustomFormatCode2();
			}else if(codewith.trim().equalsIgnoreCase("_custom_3")) {
				return template.getCustomFormatCode3();
			}else if(codewith.trim().equalsIgnoreCase("_custom_4")) {
				return template.getCustomFormatCode4();
			}else if(codewith.trim().equalsIgnoreCase("_custom_5")) {
				return template.getCustomFormatCode5();
			}else if(codewith.trim().equalsIgnoreCase("_custom_6")) {
				return template.getCustomFormatCode6();
			}else if(codewith.trim().equalsIgnoreCase("_custom_7")) {
				return template.getCustomFormatCode7();
			}else if(codewith.trim().equalsIgnoreCase("_custom_8")) {
				return template.getCustomFormatCode8();
			}else if(codewith.trim().startsWith("_exclusive_")) {
				codewith=codewith.substring(10, codewith.length());
				TempletSubElement el=null;
				int num=Integer.valueOf(codewith.substring(1, 2));
				String exc=codewith.substring(2, codewith.length());
				if (exc.trim().equalsIgnoreCase("_public")) {
					el=template.getElPublic();
				}else if (exc.trim().equalsIgnoreCase("_index")) {
					el=template.getElIndex();
				}else if (exc.trim().equalsIgnoreCase("_nav")) {
					el=template.getElNav();
				}else if (exc.trim().equalsIgnoreCase("_art")) {
					el=template.getElArt();
				}else if (exc.trim().equalsIgnoreCase("_extend")) {
					el=template.getElExtend();
				}
				if (el!=null) {
					switch (num) {
					case 1:
						return el.getExclusiveCode1();
					case 2:
						return el.getExclusiveCode2();
					case 3:
						return el.getExclusiveCode3();
					case 4:
						return el.getExclusiveCode4();
					}
				}
				
			}
		}
		return tagVal;
	}
	
	
	/*
	 * 解析标签，如果模板中没有，则从资源文件中获取
	 */
	
	public static String sundriesTag(ResourceBundleMessageSource messageSource,TempletAlbgenreMain template,
			String station) {
		String val=sundriesTag(template,station);
		if (val==null || val.trim().equals("")) {
			val = FileUtil.readRes(messageSource, station);
		}
		return val;
	}
	
	private static FindedDataAnalyzeResult lfSetup(FindedDataAnalyzeResult fdar, TempletAlbgenreMain main,
			TempletSubElement el,boolean sub) {
		DataShowParams dsp = fdar.getDsp();
		String lf,fs;
		int fid;
		if (sub) {
			lf=dsp.getSubLoopFormatStr();
			fs = dsp.getSubFormatSource();
			fid=dsp.getSubFid();
		}else {
			fs = dsp.getFormatSource();
			lf=dsp.getLoopFormatStr();
			fid=dsp.getFid();
		}
		
		if (lf != null && lf.trim().equals("")) {
			lf=null;
		}
		
		if (fs != null && fs.trim().equals("")) { // 特例： 如果强制性规定格式化字符串和格式化来源均为空，返回null，应不处理子级
			fs = null;
		}
		
		//如果格式来源和格式字符串均为空
		if (!(fs==null && lf==null)) {
			/*
			 * 详细处理
			 */

			// 如果是模块
			if (fs.trim().equalsIgnoreCase("el")) {
				switch (fid) {
				case 1:
					lf=el.getMajorLoopCodeInLump();
					break;
				default:
					lf=el.getMinorLoopCodeInLump();
				}
				
			}
			
			// 如果是模块
			if (fs.trim().equalsIgnoreCase("el_major")) {
				lf=el.getMajorLoopCodeInLump();
			}
			
			// 如果是模块
			if (fs.trim().equalsIgnoreCase("el_majinor")) {
				lf=el.getMinorLoopCodeInLump();
			}

			// 如果是exclusive
			if (fs.trim().equalsIgnoreCase("exclusive")) {
				switch (dsp.getFid()) {
				case 2:
					lf=el.getExclusiveCode2();
					break;
				case 3:
					lf=el.getExclusiveCode3();
					break;
				case 4:
					lf=el.getExclusiveCode4();
					break;
				default:
					lf=el.getExclusiveCode1();
				}
			}

			// 如果是publicCode
			if (fs.trim().equalsIgnoreCase("public")) {
				switch (fid) {
				case 2:
					lf=main.getPublicCode2();
					break;
				case 3:
					lf=main.getPublicCode3();
					break;
				case 4:
					lf=main.getPublicCode4();
					break;
				default:
					lf=main.getPublicCode1();
				}
			}

			// 如果是publicCode
			if (fs.trim().equalsIgnoreCase("custom")) {
				switch (fid) {
				case 2:
					lf=main.getCustomFormatCode2();
					break;
				case 3:
					lf=main.getCustomFormatCode3();
					break;
				case 4:
					lf=main.getCustomFormatCode4();
					break;
				case 5:
					lf=main.getCustomFormatCode5();
					break;
				case 6:
					lf=main.getCustomFormatCode6();
					break;
				case 7:
					lf=main.getCustomFormatCode7();
					break;
				case 8:
					lf=main.getCustomFormatCode8();
					break;
				default:
					lf=main.getCustomFormatCode1();
				}
				
			}

			/*
			 * 下面是提供的更加变态更加激进更加疯狂的几个标签 pubic_exclusive index_exclusive nav_exclusive
			 * article_exclusive extend_exclusive search_exclusive artbody
			 */

			// 如果是pubic_exclusive
			if (fs.trim().equalsIgnoreCase("pubic_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElPublic().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElPublic().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElPublic().getExclusiveCode4();
					break;
				default:
					lf=main.getElPublic().getExclusiveCode1();
				}
			}

			// 如果是index_exclusive
			if (fs.trim().equalsIgnoreCase("index_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElIndex().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElIndex().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElIndex().getExclusiveCode4();
					break;
				default:
					lf=main.getElIndex().getExclusiveCode1();
				}
			}

			// 如果是nav_exclusive
			if (fs.trim().equalsIgnoreCase("nav_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElNav().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElNav().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElNav().getExclusiveCode4();
					break;
				default:
					lf=main.getElNav().getExclusiveCode1();
				}
			}

			// 如果是article_exclusive
			if (fs.trim().equalsIgnoreCase("article_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElArt().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElArt().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElArt().getExclusiveCode4();
					break;
				default:
					lf=main.getElArt().getExclusiveCode1();
				}
			}

			// 如果是extend_exclusive
			if (fs.trim().equalsIgnoreCase("extend_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElExtend().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElExtend().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElExtend().getExclusiveCode4();
					break;
				default:
					lf=main.getElExtend().getExclusiveCode1();
				}
			}
		}
		
		// 如果未指定格式源或格式源不是上述几种，则失败

		if (sub) {
			dsp.setSubLoopFormatStr(lf);
		}else {
			dsp.setLoopFormatStr(lf);
		}
		
		fdar.setDsp(dsp);
		return fdar;
	
	}

	/*
	 * 初始化标签返回对象，主要是给格式化字符串进行检查和赋值
	 */
	public static FindedDataAnalyzeResult fmt(FindedDataAnalyzeResult fdar, TempletAlbgenreMain main,
			TempletSubElement el) {
		
		fdar = lfSetup(fdar, main, el, false);		//处理主格式化字符串
		if (fdar.getDsp()!=null && fdar.getDsp().getLoopFormatStr()==null) {
			return null;
		}
		fdar = lfSetup(fdar, main, el, true);		//处理子层

		return fdar;
	}
	
	/*
	 * 模板中数据标签解析
	 */
	public static String tagToData(String html, EnvirSet es, FindedDataAnalyzeResult fdar) {
		Albgenre genre=es.getAlbgenreDaoImpl().findByID(es.getGid());
		if (genre==null) {
			return html;
		}
		TempletAlbgenreMain template=genre.getTemplet();
		if (template==null) {
			template=es.getTempletAlbgenreMainDaoImpl().findDef();
		}
		if (template==null) {
			return html;
		}
		String imgHtmlTemplet=TempletAlbgenreUtil.sundriesTag(template, "imgHtmlTemplet");
		DataShowParams dsp = fdar.getDsp();
		if (fdar.getDsp().getCurpage()==0) {
			fdar.getDsp().setCurpage(es.getPage());
		}
		if (fdar.getDsp().getPagesize()==0) {
			fdar.getDsp().setPagesize(es.getPageSize());
		}
		//如果是文章
		if (dsp.getDataSource().equalsIgnoreCase("albarts")) {
			dsp.setAacid(es.getAacid());
			return TempletAlbumUtil.analyzeAlbumArts(html,dsp.getAlbid(),imgHtmlTemplet,template.getResFolder(),1,es,fdar,ConfigUtil.wvov(es.getMessageSource()));
		}else if (dsp.getDataSource().equalsIgnoreCase("albums")) {
			return TempletAlbumUtil.analyzeAlbums(html,es,fdar);
		}

		/*
		 * 以后再增加
		 * 
		 */

		return html;

	}
	
	
	public static String tagForResFolder(ResourceBundleMessageSource messageSource,String html,TempletAlbgenreMain templet) {
		if (templet!=null && templet.getResFolder()!=null && !templet.getResFolder().trim().equals("")) {
			html = AnalyzeUtil.replace(html, "tag", "resFolder", templet.getResFolder());
		}else {
			html = AnalyzeUtil.replace(html, "tag", "resFolder",messageSource.getMessage("res.folder.default", null, "resFolder", null));
		}
		return html;
	}
	
	
	
	public static TempletAlbgenreMain copy(TempletAlbgenreMain oldTemplate,TempletAlbgenreMain newTemplate){
		newTemplate.setName(oldTemplate.getName());
		newTemplate.setAuthor(oldTemplate.getAuthor());
		newTemplate.setResFolder(oldTemplate.getResFolder());
		newTemplate.setCustomFormatCode1(oldTemplate.getCustomFormatCode1());
		newTemplate.setCustomFormatCode2(oldTemplate.getCustomFormatCode2());
		newTemplate.setCustomFormatCode3(oldTemplate.getCustomFormatCode3());
		newTemplate.setCustomFormatCode4(oldTemplate.getCustomFormatCode4());
		newTemplate.setCustomFormatCode5(oldTemplate.getCustomFormatCode5());
		newTemplate.setCustomFormatCode6(oldTemplate.getCustomFormatCode6());
		newTemplate.setCustomFormatCode7(oldTemplate.getCustomFormatCode7());
		newTemplate.setCustomFormatCode8(oldTemplate.getCustomFormatCode8());
		newTemplate.setDef(false);
		newTemplate.setDescription(oldTemplate.getDescription());
		newTemplate.setSundriesTag(oldTemplate.getSundriesTag());
		newTemplate.setOrderNum(0);
		newTemplate.setPublicCode1(oldTemplate.getPublicCode1());
		newTemplate.setPublicCode2(oldTemplate.getPublicCode2());
		newTemplate.setPublicCode3(oldTemplate.getPublicCode3());
		newTemplate.setPublicCode4(oldTemplate.getPublicCode4());
		newTemplate.setState(true);
		newTemplate.setElArt(TempletUtil.copy(oldTemplate.getElArt()));
		newTemplate.setElExtend(TempletUtil.copy(oldTemplate.getElExtend()));
		newTemplate.setElIndex(TempletUtil.copy(oldTemplate.getElIndex()));
		newTemplate.setElNav(TempletUtil.copy(oldTemplate.getElNav()));
		newTemplate.setElPublic(TempletUtil.copy(oldTemplate.getElPublic()));
		newTemplate.setElComment(TempletUtil.copy(oldTemplate.getElComment()));
		return newTemplate;
		
	}
	
	public static TempletAlbgenreMain copy(TempletAlbgenreMain oldTemplate,String newTitle){
		TempletAlbgenreMain newTemplate=new TempletAlbgenreMain();
		newTemplate.setAuthor(oldTemplate.getAuthor());
		newTemplate.setResFolder(oldTemplate.getResFolder());
		newTemplate.setCustomFormatCode1(oldTemplate.getCustomFormatCode1());
		newTemplate.setCustomFormatCode2(oldTemplate.getCustomFormatCode2());
		newTemplate.setCustomFormatCode3(oldTemplate.getCustomFormatCode3());
		newTemplate.setCustomFormatCode4(oldTemplate.getCustomFormatCode4());
		newTemplate.setCustomFormatCode5(oldTemplate.getCustomFormatCode5());
		newTemplate.setCustomFormatCode6(oldTemplate.getCustomFormatCode6());
		newTemplate.setCustomFormatCode7(oldTemplate.getCustomFormatCode7());
		newTemplate.setCustomFormatCode8(oldTemplate.getCustomFormatCode8());
		newTemplate.setDef(false);
		newTemplate.setDescription(oldTemplate.getDescription());
		newTemplate.setDesignTime(System.currentTimeMillis());
		newTemplate.setSundriesTag(oldTemplate.getSundriesTag());
		newTemplate.setOrderNum(0);
		newTemplate.setPublicCode1(oldTemplate.getPublicCode1());
		newTemplate.setPublicCode2(oldTemplate.getPublicCode2());
		newTemplate.setPublicCode3(oldTemplate.getPublicCode3());
		newTemplate.setPublicCode4(oldTemplate.getPublicCode4());
		newTemplate.setState(oldTemplate.isState());
		newTemplate.setName(newTitle);
		newTemplate.setElArt(TempletUtil.copy(oldTemplate.getElArt()));
		newTemplate.setElExtend(TempletUtil.copy(oldTemplate.getElExtend()));
		newTemplate.setElIndex(TempletUtil.copy(oldTemplate.getElIndex()));
		newTemplate.setElNav(TempletUtil.copy(oldTemplate.getElNav()));
		newTemplate.setElPublic(TempletUtil.copy(oldTemplate.getElPublic()));
		newTemplate.setElComment(TempletUtil.copy(oldTemplate.getElComment()));
		return newTemplate;
		
	}
	
	/*
	 * 查询并返回一个简单模板列表
	 */
	public static List<TempletSimple> queryAllSimple(ITempletAlbgenreMainDao templetAlbgenreMainDaoImpl){
		List<TempletAlbgenreMain> list=templetAlbgenreMainDaoImpl.queryAll();
		List<TempletSimple> listSimple= new ArrayList<TempletSimple>();
		for (TempletAlbgenreMain templet:list) {
			if (templet.isState()) {
				TempletSimple tabms=new TempletSimple();
				tabms.setId(templet.getId());
				tabms.setName(templet.getName());
				tabms.setAuthor(templet.getAuthor());
				tabms.setDescription(templet.getDescription());
				tabms.setResFolder(templet.getResFolder());
				tabms.setDowns(templet.getDowns());
				tabms.setDesignTime(TimeUtil.coverLongToStr(templet.getDesignTime(), "yyyy-MM-dd HH:mm:ss"));
				tabms.setModifyTime(TimeUtil.coverLongToStr(templet.getModifyTime(), "yyyy-MM-dd HH:mm:ss"));
				if (templet.isFreeOnClouds()) {
					tabms.setFree(1);
				} else {
					tabms.setFree(0);
				}
				listSimple.add(tabms);
			}
			
		}
		return listSimple;
	}
	

}
