package com.lerx.v6.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import org.springframework.context.support.ResourceBundleMessageSource;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.analyze.vo.DataShowParams;
import com.lerx.analyze.vo.FindedDataAnalyzeResult;
import com.lerx.entities.Album;
import com.lerx.entities.AlbumArticle;
import com.lerx.entities.AlbumArticleClassify;
import com.lerx.entities.AlbumExternalLink;
import com.lerx.entities.AlbumFans;
import com.lerx.entities.AlbumPartner;
import com.lerx.entities.FansGroup;
import com.lerx.entities.TempletAlbumMain;
import com.lerx.entities.TempletSubElement;
import com.lerx.hql.entities.Rs;
import com.lerx.portal.obj.AppEnvParms;
import com.lerx.portal.obj.EnvirSet;
import com.lerx.portal.obj.WeightValuesOfVisit;
import com.lerx.sys.obj.DatetimeSpanSuffixTxt;
import com.lerx.sys.obj.EnvParms;
import com.lerx.sys.obj.KeyValue;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;

public class TempletAlbumUtil {

	/*
	 * 根据tag字符串得到当前模板
	 */
	public static TempletSubElement elInitByTagStr(TempletAlbumMain templetMain, String tagStr) {
		TempletSubElement el;
		if (tagStr==null || tagStr.trim().equals("") || tagStr.trim().equals("public")) {
			el = templetMain.getElPublic();
		}else if (tagStr.trim().equals("index")) {
			el = templetMain.getElIndex();
		}else if (tagStr.trim().equals("nav")) {
			el = templetMain.getElNav();
		}else if (tagStr.trim().equals("art") || tagStr.trim().equals("article") || tagStr.trim().equals("artshow")) {
			el = templetMain.getElArt();
		}else if (tagStr.trim().equals("corpus")) {
			el = templetMain.getElCorpus();
		}else if (tagStr.trim().equals("edit")) {
			el = templetMain.getElEdit();
		}else if (tagStr.trim().equals("extend")) {
			el = templetMain.getElExtend();
		}else {
			el = templetMain.getElPublic();
		}
		return el;
	}

	// 返回一个el，如果当前el中的某属性为空，则赋值为上一层public中对应的属性值
	public static TempletSubElement elInit(TempletSubElement subpub, TempletSubElement subel) {
		TempletSubElement el = new TempletSubElement();
		if (subel.getBorderCode() != null && !subel.getBorderCode().trim().equals("")) {
			el.setBorderCode(subel.getBorderCode());
		} else {
			el.setBorderCode(subpub.getBorderCode());
		}
		if (subel.getMainCode() != null && !subel.getMainCode().trim().equals("")) {
			el.setMainCode(subel.getMainCode());
		} else {
			el.setMainCode(subpub.getMainCode());
		}
		if (subel.getCssCode() != null && !subel.getCssCode().trim().equals("")) {
			el.setCssCode(subel.getCssCode());
		} else {
			el.setCssCode(subpub.getCssCode());
		}
		if (subel.getTopCode() != null && !subel.getTopCode().trim().equals("")) {
			el.setTopCode(subel.getTopCode());
		} else {
			el.setTopCode(subpub.getTopCode());
		}
		if (subel.getFooterCode() != null && !subel.getFooterCode().trim().equals("")) {
			el.setFooterCode(subel.getFooterCode());
		} else {
			el.setFooterCode(subpub.getFooterCode());
		}
		if (subel.getTargetStr() != null && !subel.getTargetStr().trim().equals("")) {
			el.setTargetStr(subel.getTargetStr());
		} else {
			el.setTargetStr(subpub.getTargetStr());
		}
		if (subel.getTitleFormat() != null && !subel.getTitleFormat().trim().equals("")) {
			el.setTitleFormat(subel.getTitleFormat());
		} else {
			el.setTitleFormat(subpub.getTitleFormat());
		}
		if (subel.getFunctionAreaCode() != null && !subel.getFunctionAreaCode().trim().equals("")) {
			el.setFunctionAreaCode(subel.getFunctionAreaCode());
		} else {
			el.setFunctionAreaCode(subpub.getFunctionAreaCode());
		}

		if (subel.getSearchAreaCode() != null && !subel.getSearchAreaCode().trim().equals("")) {
			el.setSearchAreaCode(subel.getSearchAreaCode());
		} else {
			el.setSearchAreaCode(subpub.getSearchAreaCode());
		}
		if (subel.getMajorLoopCodeInLump() != null && !subel.getMajorLoopCodeInLump().trim().equals("")) {
			el.setMajorLoopCodeInLump(subel.getMajorLoopCodeInLump());
		} else {
			el.setMajorLoopCodeInLump(subpub.getMajorLoopCodeInLump());
		}
		if (subel.getMinorLoopCodeInLump() != null && !subel.getMinorLoopCodeInLump().trim().equals("")) {
			el.setMinorLoopCodeInLump(subel.getMinorLoopCodeInLump());
		} else {
			el.setMinorLoopCodeInLump(subpub.getMinorLoopCodeInLump());
		}
		if (subel.getExclusiveCode1() != null && !subel.getExclusiveCode1().trim().equals("")) {
			el.setExclusiveCode1(subel.getExclusiveCode1());
		} else {
			el.setExclusiveCode1(subpub.getExclusiveCode1());
		}
		if (subel.getExclusiveCode2() != null && !subel.getExclusiveCode2().trim().equals("")) {
			el.setExclusiveCode2(subel.getExclusiveCode2());
		} else {
			el.setExclusiveCode2(subpub.getExclusiveCode2());
		}
		if (subel.getExclusiveCode3() != null && !subel.getExclusiveCode3().trim().equals("")) {
			el.setExclusiveCode3(subel.getExclusiveCode3());
		} else {
			el.setExclusiveCode3(subpub.getExclusiveCode3());
		}
		if (subel.getExclusiveCode4() != null && !subel.getExclusiveCode4().trim().equals("")) {
			el.setExclusiveCode4(subel.getExclusiveCode4());
		} else {
			el.setExclusiveCode4(subpub.getExclusiveCode4());
		}
		return el;
	}

	// 通用模块代码替换
	public static String mainCodeReplace(String html, TempletAlbumMain template) {
		html = AnalyzeUtil.replace(html, "code", "public1", template.getPublicCode1());
		html = AnalyzeUtil.replace(html, "code", "public2", template.getPublicCode2());
		html = AnalyzeUtil.replace(html, "code", "public3", template.getPublicCode3());
		html = AnalyzeUtil.replace(html, "code", "public4", template.getPublicCode4());
		html = AnalyzeUtil.replace(html, "code", "custom1", template.getCustomFormatCode1());
		html = AnalyzeUtil.replace(html, "code", "custom2", template.getCustomFormatCode2());
		html = AnalyzeUtil.replace(html, "code", "custom3", template.getCustomFormatCode3());
		html = AnalyzeUtil.replace(html, "code", "custom4", template.getCustomFormatCode4());
		html = AnalyzeUtil.replace(html, "code", "custom5", template.getCustomFormatCode5());
		html = AnalyzeUtil.replace(html, "code", "custom6", template.getCustomFormatCode6());
		html = AnalyzeUtil.replace(html, "code", "custom7", template.getCustomFormatCode7());
		html = AnalyzeUtil.replace(html, "code", "custom8", template.getCustomFormatCode8());
		return html;
	}

	// 当前子模块代码替换
	public static String elCodeReplace(String html, TempletSubElement elTemplate) {
		html = AnalyzeUtil.replace(html, "code", "main", elTemplate.getMainCode());
		html = AnalyzeUtil.replace(html, "code", "top", elTemplate.getTopCode());
		html = AnalyzeUtil.replace(html, "code", "footer", elTemplate.getFooterCode());
		html = AnalyzeUtil.replace(html, "code", "css", elTemplate.getCssCode());
		html = AnalyzeUtil.replace(html, "code", "search", elTemplate.getSearchAreaCode());
		html = AnalyzeUtil.replace(html, "code", "function", elTemplate.getFunctionAreaCode());
		html = AnalyzeUtil.replace(html, "code", "exclusive1", elTemplate.getExclusiveCode1());
		html = AnalyzeUtil.replace(html, "code", "exclusive2", elTemplate.getExclusiveCode2());
		html = AnalyzeUtil.replace(html, "code", "exclusive3", elTemplate.getExclusiveCode3());
		html = AnalyzeUtil.replace(html, "code", "exclusive4", elTemplate.getExclusiveCode4());
		html = AnalyzeUtil.replace(html, "code", "loopMajor", elTemplate.getMajorLoopCodeInLump());
		html = AnalyzeUtil.replace(html, "code", "loopMinor", elTemplate.getMinorLoopCodeInLump());
		html = AnalyzeUtil.replace(html, "tag", "target", elTemplate.getTargetStr());
		html = AnalyzeUtil.replace(html, "tag", "htmlTitle", elTemplate.getTitleFormat());
		return html;
	}
	
	//得到逝去的时间说明
	public static String statTimesLosted(TempletAlbumMain template,long datetime) {
		DatetimeSpanSuffixTxt dsst=sundriesTimesLostedTag(template);
		return TimeUtil.statTimesLosted(datetime,dsst);
	}
	
	/*
	 * 获得逝去的时间标签库
	 */
	public static DatetimeSpanSuffixTxt sundriesTimesLostedTag(TempletAlbumMain template) {
		return TimeUtil.dsst(sundriesTag(template,"dsst"));
	}
	
	
	
	/*
	 * 解析标签
	 */
	public static String sundriesTag(TempletAlbumMain template,
			String station) {
		String tagVal="";
		
		String tags=template.getSundriesTag();
		if (tags == null || tags.trim().equals("")) {
			return "";
		}
		if (tags.indexOf(station + ":") == -1) {
			return "";
		}
		String[] sArray = tags.split(",");
		String kv;
		String[] kvArray;
		for (int i = 0; i < sArray.length; i++) {
			kv = sArray[i];
			kvArray = kv.split(":");
			if (kvArray.length > 1 && kvArray[0].trim().equals(station)) {
				tagVal=TempletUtil.escape(kvArray[1]);
			}
		}
		
		if (tagVal!=null && tagVal.trim().startsWith("code_with_")) {
			tagVal = tagVal.trim();
			String codewith=tagVal.substring(9, tagVal.length());
			if (codewith.trim().equalsIgnoreCase("_public_1")) {
				return template.getPublicCode1();
			}else if(codewith.trim().equalsIgnoreCase("_public_2")) {
				return template.getPublicCode2();
			}else if(codewith.trim().equalsIgnoreCase("_public_3")) {
				return template.getPublicCode3();
			}else if(codewith.trim().equalsIgnoreCase("_public_4")) {
				return template.getPublicCode4();
			}else if(codewith.trim().equalsIgnoreCase("_custom_1")) {
				return template.getCustomFormatCode1();
			}else if(codewith.trim().equalsIgnoreCase("_custom_2")) {
				return template.getCustomFormatCode2();
			}else if(codewith.trim().equalsIgnoreCase("_custom_3")) {
				return template.getCustomFormatCode3();
			}else if(codewith.trim().equalsIgnoreCase("_custom_4")) {
				return template.getCustomFormatCode4();
			}else if(codewith.trim().equalsIgnoreCase("_custom_5")) {
				return template.getCustomFormatCode5();
			}else if(codewith.trim().equalsIgnoreCase("_custom_6")) {
				return template.getCustomFormatCode6();
			}else if(codewith.trim().equalsIgnoreCase("_custom_7")) {
				return template.getCustomFormatCode7();
			}else if(codewith.trim().equalsIgnoreCase("_custom_8")) {
				return template.getCustomFormatCode8();
			}else if(codewith.trim().startsWith("_exclusive_")) {
				codewith=codewith.substring(10, codewith.length());
				TempletSubElement el=null;
				int num=Integer.valueOf(codewith.substring(1, 2));
				String exc=codewith.substring(2, codewith.length());
				if (exc.trim().equalsIgnoreCase("_public")) {
					el=template.getElPublic();
				}else if (exc.trim().equalsIgnoreCase("_index")) {
					el=template.getElIndex();
				}else if (exc.trim().equalsIgnoreCase("_nav")) {
					el=template.getElNav();
				}else if (exc.trim().equalsIgnoreCase("_art")) {
					el=template.getElArt();
				}else if (exc.trim().equalsIgnoreCase("_corpus")) {
					el=template.getElCorpus();
				}else if (exc.trim().equalsIgnoreCase("_edit")) {
					el=template.getElEdit();
				}else if (exc.trim().equalsIgnoreCase("_extend")) {
					el=template.getElExtend();
				}
				if (el!=null) {
					switch (num) {
					case 1:
						return el.getExclusiveCode1();
					case 2:
						return el.getExclusiveCode2();
					case 3:
						return el.getExclusiveCode3();
					case 4:
						return el.getExclusiveCode4();
					}
				}
				
			}
		}
		return tagVal;
	}
	
	
	/*
	 * 解析标签，如果模板中没有，则从资源文件中获取
	 */
	
	public static String sundriesTag(ResourceBundleMessageSource messageSource,TempletAlbumMain template,
			String station) {
		String val=sundriesTag(template,station);
		if (val==null || val.trim().equals("")) {
			val = FileUtil.readRes(messageSource, station);
		}
		return val;
	}
	
	public static FindedDataAnalyzeResult lfSetup(FindedDataAnalyzeResult fdar, TempletAlbumMain main,
			TempletSubElement el,boolean sub) {
		DataShowParams dsp = fdar.getDsp();
		String lf,fs;
		int fid;
		if (sub) {
			lf=dsp.getSubLoopFormatStr();
			fs = dsp.getSubFormatSource();
			fid=dsp.getSubFid();
		}else {
			fs = dsp.getFormatSource();
			lf=dsp.getLoopFormatStr();
			fid=dsp.getFid();
		}
		
		if (lf != null && lf.trim().equals("")) {
			lf=null;
		}
		
		if (fs != null && fs.trim().equals("")) { // 特例： 如果强制性规定格式化字符串和格式化来源均为空，返回null，应不处理子级
			fs = null;
		}
		
		//如果格式来源和格式字符串均为空
		if (!(fs==null && lf==null)) {
			/*
			 * 详细处理
			 */
			// 如果是模块
			if (fs.trim().equalsIgnoreCase("el")) {
				switch (fid) {
				case 1:
					lf=el.getMajorLoopCodeInLump();
					break;
				default:
					lf=el.getMinorLoopCodeInLump();
				}
				
			}
			
			// 如果是模块
			if (fs.trim().equalsIgnoreCase("el_major")) {
				lf=el.getMajorLoopCodeInLump();
			}
			
			// 如果是模块
			if (fs.trim().equalsIgnoreCase("el_majinor")) {
				lf=el.getMinorLoopCodeInLump();
			}

			// 如果是exclusive
			if (fs.trim().equalsIgnoreCase("exclusive")) {
				
				switch (fid) {
				case 2:
					lf=el.getExclusiveCode2();
					break;
				case 3:
					lf=el.getExclusiveCode3();
					break;
				case 4:
					lf=el.getExclusiveCode4();
					break;
				default:
					lf=el.getExclusiveCode1();
				}
			}
			

			// 如果是publicCode
			if (fs.trim().equalsIgnoreCase("public")) {
				switch (fid) {
				case 2:
					lf=main.getPublicCode2();
					break;
				case 3:
					lf=main.getPublicCode3();
					break;
				case 4:
					lf=main.getPublicCode4();
					break;
				default:
					lf=main.getPublicCode1();
				}
			}

			// 如果是publicCode
			if (fs.trim().equalsIgnoreCase("custom")) {
				switch (fid) {
				case 2:
					lf=main.getCustomFormatCode2();
					break;
				case 3:
					lf=main.getCustomFormatCode3();
					break;
				case 4:
					lf=main.getCustomFormatCode4();
					break;
				case 5:
					lf=main.getCustomFormatCode5();
					break;
				case 6:
					lf=main.getCustomFormatCode6();
					break;
				case 7:
					lf=main.getCustomFormatCode7();
					break;
				case 8:
					lf=main.getCustomFormatCode8();
					break;
				default:
					lf=main.getCustomFormatCode1();
				}
				
			}

			/*
			 * 下面是提供的更加变态更加激进更加疯狂的几个标签 pubic_exclusive index_exclusive nav_exclusive
			 * article_exclusive extend_exclusive search_exclusive artbody
			 */

			// 如果是pubic_exclusive
			if (fs.trim().equalsIgnoreCase("pubic_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElPublic().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElPublic().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElPublic().getExclusiveCode4();
					break;
				default:
					lf=main.getElPublic().getExclusiveCode1();
				}
			}

			// 如果是index_exclusive
			if (fs.trim().equalsIgnoreCase("index_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElIndex().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElIndex().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElIndex().getExclusiveCode4();
					break;
				default:
					lf=main.getElIndex().getExclusiveCode1();
				}
			}

			// 如果是nav_exclusive
			if (fs.trim().equalsIgnoreCase("nav_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElNav().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElNav().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElNav().getExclusiveCode4();
					break;
				default:
					lf=main.getElNav().getExclusiveCode1();
				}
			}

			// 如果是article_exclusive
			if (fs.trim().equalsIgnoreCase("article_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElArt().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElArt().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElArt().getExclusiveCode4();
					break;
				default:
					lf=main.getElArt().getExclusiveCode1();
				}
			}

			// 如果是extend_exclusive
			if (fs.trim().equalsIgnoreCase("extend_exclusive")) {

				switch (fid) {
				case 2:
					lf=main.getElExtend().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElExtend().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElExtend().getExclusiveCode4();
					break;
				default:
					lf=main.getElExtend().getExclusiveCode1();
				}
			}

			// 如果是corpus_exclusive
			if (fs.trim().equalsIgnoreCase("corpus_exclusive")) {
				
				switch (fid) {
				case 2:
					lf=main.getElCorpus().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElCorpus().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElCorpus().getExclusiveCode4();
					break;
				default:
					lf=main.getElCorpus().getExclusiveCode1();
				}
			}
			
			if (fs.trim().equalsIgnoreCase("edit_exclusive")) {
				
				switch (fid) {
				case 2:
					lf=main.getElEdit().getExclusiveCode2();
					break;
				case 3:
					lf=main.getElEdit().getExclusiveCode3();
					break;
				case 4:
					lf=main.getElEdit().getExclusiveCode4();
					break;
				default:
					lf=main.getElEdit().getExclusiveCode1();
				}
			}
		}
		
		// 如果未指定格式源或格式源不是上述几种，则失败
		if (sub) {
			dsp.setSubLoopFormatStr(lf);
		}else {
			dsp.setLoopFormatStr(lf);
		}
		
		fdar.setDsp(dsp);
		return fdar;
	
	}

	/*
	 * 初始化标签返回对象，主要是给格式化字符串进行检查和赋值
	 */
	public static FindedDataAnalyzeResult fmt(FindedDataAnalyzeResult fdar, TempletAlbumMain main,
			TempletSubElement el) {
		
		fdar = lfSetup(fdar, main, el, false);		//处理主格式化字符串
		if (fdar.getDsp()!=null && fdar.getDsp().getLoopFormatStr()==null) {
			return null;
		}
		fdar = lfSetup(fdar, main, el, true);		//处理子层
		//
		return fdar;
	}
	
	
	
	/*
	 * 模板中数据标签解析
	 */
	public static String tagToData(String html, long albid,EnvirSet es, FindedDataAnalyzeResult fdar,WeightValuesOfVisit wvov) {
		EnvParms ep = HttpUtil.epInit(es.getRequest(), es.getResponse(), null,es.getMessageSource());
		
		Album album=es.getAlbumDaoImpl().findByID(albid);
		if (album==null) {
			return html;
		}
		TempletAlbumMain template=album.getTemplet();
		
		if (template==null) {
			template=es.getTempletAlbumMainDaoImpl().findDef();
		}
		if (template==null) {
			return html;
		}
		
		String imgHtmlTemplet=TempletAlbumUtil.sundriesTag(template, "htmlTemplet_img");
		DataShowParams dsp = fdar.getDsp();
		String lf = dsp.getLoopFormatStr();
		if (fdar.getDsp().getCurpage()==0) {
			fdar.getDsp().setCurpage(es.getPage());
		}
		if (fdar.getDsp().getPagesize()==0) {
			fdar.getDsp().setPagesize(es.getPageSize());
		}
//		
		//如果是文章
		if (dsp.getDataSource().equalsIgnoreCase("albarts")) {
			AppEnvParms aep=TempletUtil.init(ep, template.getResFolder(), 2);
			if (dsp.getSingle() == 1) {
				
				if (dsp.getSingleID() > 0) {
					AlbumArticle article = es.getAlbumArticleDaoImpl().findByID(dsp.getSingleID());
					lf = AlbumArticleUtil.fmt(aep,lf, article,imgHtmlTemplet,dsp.getTitleLen(),dsp.getTxtlen(),dsp.getOverMark(),true);
				} 
				html = StringUtil.strReplace(html, fdar.getWholeTag(), lf);
				
			} else {
				return analyzeAlbumArts(html,albid,imgHtmlTemplet,template.getResFolder(),2,es,fdar,wvov);
			
			
			}

			return html;
		} else if (dsp.getDataSource().equalsIgnoreCase("links")) {
			return analyzeAlbumLinks(html,es,albid,fdar);
		} else if (dsp.getDataSource().equalsIgnoreCase("idols")) {
			return analyzeAlbumIdols(html,es,fdar);
			
		} else if (dsp.getDataSource().equalsIgnoreCase("idols_articles")) {
			return analyzeAlbumIdolsArticles(html,es,fdar);
			
		}else if (dsp.getDataSource().equalsIgnoreCase("hot_articles")) {
			return analyzeHotAlbumArticles(html,es,albid,fdar);
			
		}else if (dsp.getDataSource().equalsIgnoreCase("partners")) {
			return analyzeAlbumPartners(html,es,albid,fdar);
			
		}else if (dsp.getDataSource().equalsIgnoreCase("classifications")) {
			return analyzeClassifyes(html,es,albid,fdar);
			
		}
		
		

		/*
		 * 以后再增加
		 * 
		 */

		return html;

	}
	
	
	public static String analyze(String html,long albid,EnvirSet es,FindedDataAnalyzeResult fdar,WeightValuesOfVisit wvov) {
		if (fdar.getDsp().getCurpage()==0) {
			fdar.getDsp().setCurpage(es.getPage());
		}
		if (fdar.getDsp().getPagesize()==0) {
			fdar.getDsp().setPagesize(es.getPageSize());
		}
		EnvParms ep = HttpUtil.epInit(es.getRequest(), es.getResponse(), null,es.getMessageSource());
		DataShowParams dsp = fdar.getDsp();
		String lf = dsp.getLoopFormatStr();
		boolean asc;
		if (dsp.getOrder() == 0) {
			asc = false;
		} else {
			asc = true;
		}
		Album album=es.getAlbumDaoImpl().findByID(albid);
		if (album==null) {
			return html;
		}
		TempletAlbumMain template=album.getTemplet();
		
		if (template==null) {
			template=es.getTempletAlbumMainDaoImpl().findDef();
		}
		if (template==null) {
			return html;
		}
		String imgHtmlTemplet=TempletAlbumUtil.sundriesTag(template, "imgHtmlTemplet");
		String tmp, tmpAll = "";
		AppEnvParms aep=TempletUtil.init(ep, template.getResFolder(), 2);
		int artOrdBy = Integer.valueOf(es.getMessageSource().getMessage("album.art.orderby.mod", null, "0", null));
		if (dsp.getSingle() == 1) {
			if (dsp.getSingleID() > 0) {
				AlbumArticle article = es.getAlbumArticleDaoImpl().findByID(dsp.getSingleID());
				lf = AlbumArticleUtil.fmt(aep,lf, article,imgHtmlTemplet,dsp.getTitleLen(),dsp.getTxtlen(),dsp.getOverMark(),true);
			} else {
				long startT=0L,endT=0L;
				if (dsp.getDaysAgo()>0) {
					long curr=System.currentTimeMillis();
					endT=curr-dsp.getDaysAgo()*24*60*60*1000;
					
				}else if(dsp.getDaysOver()>0) {
					long curr=System.currentTimeMillis();
					startT=curr-dsp.getDaysAgo()*24*60*60*1000;
				}else {
					if (dsp.getTimeStart()>0) {
						startT=TimeUtil.coverStrToLong(""+dsp.getTimeStart(),"yyyyMMddHHmmss");
					}
					if (dsp.getTimeEnd()>0) {
						endT=TimeUtil.coverStrToLong(""+dsp.getTimeEnd(),"yyyyMMddHHmmss");
					}
				}
				int mainv=0;
				if (dsp.getMain()==1) {
					mainv=1;
				}else if (dsp.getUnmain()==1){
					mainv=-1;
				}
				int imgn=dsp.getImg();
				if (dsp.getBigimg()==1) {
					imgn=3;
				}
				Rs rs = es.getAlbumArticleDaoImpl().queryByAid(albid,1,1,mainv,startT,endT,dsp.getFirstResult(), 1, 1, false,imgn,dsp.getSoul(),artOrdBy,wvov);
				AlbumArticle article = (AlbumArticle) rs.getList().get(0);
				lf = AlbumArticleUtil.fmt(aep,lf, article,imgHtmlTemplet,dsp.getTitleLen(),dsp.getTxtlen(),dsp.getOverMark(),true);
				html = AnalyzeUtil.replace(html, "tag", "dataCount", ""+rs.getCount());
				html = AnalyzeUtil.replace(html, "tag", "pageCurr", ""+rs.getPage());
				html = AnalyzeUtil.replace(html, "tag", "pageSize", ""+rs.getPageSize());
				
			}
			html = StringUtil.strReplace(html, fdar.getWholeTag(), lf);
			
		} else {
			/*
			 * 根据用户的权限
			 */
			int statusMark=1;
			if (es.isPower()) {
				statusMark=0;
			}
			long startT=0L,endT=0L;
			if (dsp.getDaysAgo()>0) {
				long curr=System.currentTimeMillis();
				endT=curr-dsp.getDaysAgo()*24*60*60*1000;
				
			}else {
				if (dsp.getTimeStart()>0) {
					startT=TimeUtil.coverStrToLong(""+dsp.getTimeStart(),"yyyyMMddHHmmss");
				}
				if (dsp.getTimeEnd()>0) {
					endT=TimeUtil.coverStrToLong(""+dsp.getTimeEnd(),"yyyyMMddHHmmss");
				}
			}
			int mainv=0;
			if (dsp.getMain()==1) {
				mainv=1;
			}else if (dsp.getUnmain()==1){
				mainv=-1;
			}
			
			int imgn=dsp.getImg();
			if (dsp.getBigimg()==1) {
				imgn=3;
			}
			
			Rs rs = es.getAlbumArticleDaoImpl().queryByAid(albid,statusMark,1,mainv,startT,endT,dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), asc,imgn,dsp.getSoul(),artOrdBy,wvov);
			
			int step2=0;
			
			for (Object obj : rs.getList()) {
				step2++;
				
				AlbumArticle article = (AlbumArticle) obj;
				article=es.getAlbumArticleDaoImpl().findByID(article.getId());
				tmp = lf;
				tmp = AlbumArticleUtil.fmt(aep,tmp, article,imgHtmlTemplet,dsp.getTitleLen(),dsp.getTxtlen(),dsp.getOverMark(),true);
				int curStep = ((rs.getPage() - 1) * rs.getPageSize()) + step2;
				tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + curStep);
				tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (curStep-1));
				tmpAll += tmp;
			}
							
			
			html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);

		
		
		}

		return html;
	
	}
	
	
	public static String tagForResFolder(ResourceBundleMessageSource messageSource,String html,TempletAlbumMain templet) {
		if (templet!=null && templet.getResFolder()!=null && !templet.getResFolder().trim().equals("")) {
			html = AnalyzeUtil.replace(html, "tag", "resFolder", templet.getResFolder());
		}else {
			html = AnalyzeUtil.replace(html, "tag", "resFolder",messageSource.getMessage("res.folder.default", null, "resFolder", null));
		}
		return html;
	}
	
	public static TempletAlbumMain copy(TempletAlbumMain oldTemplate,TempletAlbumMain newTemplate){
		newTemplate.setName(oldTemplate.getName());
		newTemplate.setAuthor(oldTemplate.getAuthor());
		newTemplate.setResFolder(oldTemplate.getResFolder());
		newTemplate.setCustomFormatCode1(oldTemplate.getCustomFormatCode1());
		newTemplate.setCustomFormatCode2(oldTemplate.getCustomFormatCode2());
		newTemplate.setCustomFormatCode3(oldTemplate.getCustomFormatCode3());
		newTemplate.setCustomFormatCode4(oldTemplate.getCustomFormatCode4());
		newTemplate.setCustomFormatCode5(oldTemplate.getCustomFormatCode5());
		newTemplate.setCustomFormatCode6(oldTemplate.getCustomFormatCode6());
		newTemplate.setCustomFormatCode7(oldTemplate.getCustomFormatCode7());
		newTemplate.setCustomFormatCode8(oldTemplate.getCustomFormatCode8());
		newTemplate.setDef(false);
		newTemplate.setDescription(oldTemplate.getDescription());
		newTemplate.setSundriesTag(oldTemplate.getSundriesTag());
		newTemplate.setOrderNum(0);
		newTemplate.setPublicCode1(oldTemplate.getPublicCode1());
		newTemplate.setPublicCode2(oldTemplate.getPublicCode2());
		newTemplate.setPublicCode3(oldTemplate.getPublicCode3());
		newTemplate.setPublicCode4(oldTemplate.getPublicCode4());
		newTemplate.setState(true);
		newTemplate.setElArt(TempletUtil.copy(oldTemplate.getElArt()));
		newTemplate.setElExtend(TempletUtil.copy(oldTemplate.getElExtend()));
		newTemplate.setElIndex(TempletUtil.copy(oldTemplate.getElIndex()));
		newTemplate.setElNav(TempletUtil.copy(oldTemplate.getElNav()));
		newTemplate.setElPublic(TempletUtil.copy(oldTemplate.getElPublic()));
		newTemplate.setElCorpus(TempletUtil.copy(oldTemplate.getElCorpus()));
		newTemplate.setElEdit(TempletUtil.copy(oldTemplate.getElEdit()));
		newTemplate.setElComment(TempletUtil.copy(oldTemplate.getElComment()));
		return newTemplate;
		
	}
	
	public static TempletAlbumMain copy(TempletAlbumMain oldTemplate,String newTitle){
		TempletAlbumMain newTemplate=new TempletAlbumMain();
		newTemplate.setAuthor(oldTemplate.getAuthor());
		newTemplate.setResFolder(oldTemplate.getResFolder());
		newTemplate.setCustomFormatCode1(oldTemplate.getCustomFormatCode1());
		newTemplate.setCustomFormatCode2(oldTemplate.getCustomFormatCode2());
		newTemplate.setCustomFormatCode3(oldTemplate.getCustomFormatCode3());
		newTemplate.setCustomFormatCode4(oldTemplate.getCustomFormatCode4());
		newTemplate.setCustomFormatCode5(oldTemplate.getCustomFormatCode5());
		newTemplate.setCustomFormatCode6(oldTemplate.getCustomFormatCode6());
		newTemplate.setCustomFormatCode7(oldTemplate.getCustomFormatCode7());
		newTemplate.setCustomFormatCode8(oldTemplate.getCustomFormatCode8());
		newTemplate.setDef(false);
		newTemplate.setDescription(oldTemplate.getDescription());
		newTemplate.setDesignTime(System.currentTimeMillis());
		newTemplate.setSundriesTag(oldTemplate.getSundriesTag());
		newTemplate.setOrderNum(0);
		newTemplate.setPublicCode1(oldTemplate.getPublicCode1());
		newTemplate.setPublicCode2(oldTemplate.getPublicCode2());
		newTemplate.setPublicCode3(oldTemplate.getPublicCode3());
		newTemplate.setPublicCode4(oldTemplate.getPublicCode4());
		newTemplate.setState(oldTemplate.isState());
		newTemplate.setName(newTitle);
		newTemplate.setElArt(TempletUtil.copy(oldTemplate.getElArt()));
		newTemplate.setElExtend(TempletUtil.copy(oldTemplate.getElExtend()));
		newTemplate.setElIndex(TempletUtil.copy(oldTemplate.getElIndex()));
		newTemplate.setElNav(TempletUtil.copy(oldTemplate.getElNav()));
		newTemplate.setElPublic(TempletUtil.copy(oldTemplate.getElPublic()));
		newTemplate.setElCorpus(TempletUtil.copy(oldTemplate.getElCorpus()));
		newTemplate.setElEdit(TempletUtil.copy(oldTemplate.getElEdit()));
		newTemplate.setElComment(TempletUtil.copy(oldTemplate.getElComment()));
		return newTemplate;
		
	}
	
	
	public static String analyzeAlbums(String html,EnvirSet es,FindedDataAnalyzeResult fdar) {
		DataShowParams dsp = fdar.getDsp();
		long gid=es.getGid();
		if (es.getGid()==0L) {
			gid=dsp.getGid();
		}
		
		
		String lf = dsp.getLoopFormatStr();
		String tmp,tmpAll="";
		Rs rs;
		
		rs=es.getAlbumDaoImpl().query(gid, dsp.getCurpage(), dsp.getPagesize(), 1, 1, fdar.getDsp().getOrderby(), fdar.getDsp().getOrder());
		int step=0;
		for (Object ao:rs.getList()) {
			step++;
			tmp = lf;
			Album album=(Album) ao;
			tmp=AlbumUtil.fmt(tmp, album);
			if (AnalyzeUtil.find(tmp, "tag", "albhref") || AnalyzeUtil.find(tmp, "tag", "href")) {
				tmp=AlbumUtil.hrefAnalyze(tmp, album, es.getMessageSource(), es.getRequest(),false);
			}
			int curStep = ((rs.getPage() - 1) * rs.getPageSize()) + step;
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + curStep);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (curStep-1));
			tmpAll += tmp;
		}
		html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		return html;
	}
	
	
	public static String analyzeAlbumArts(String html,long albid,String imgHtmlTemplet,String resFolder,int templetType,EnvirSet es,FindedDataAnalyzeResult fdar,WeightValuesOfVisit wvov) {
		/*
		 * 根据用户的权限
		 */
		int statusMark=1;
		if (es.isPower()) {
			statusMark=0;
		}
		
		
		DataShowParams dsp = fdar.getDsp();
		long gid=es.getGid();
		if (es.getGid()==0L) {
			gid=dsp.getGid();
		}
		/*Albgenre genre=es.getAlbgenreDaoImpl().findByID(gid);
		if (genre==null) {
			return html;
		}*/
		EnvParms ep = HttpUtil.epInit(es.getRequest(), es.getResponse(), null,es.getMessageSource());
		String lf = dsp.getLoopFormatStr();
		boolean asc;
		if (dsp.getOrder() == 0) {
			asc = false;
		} else {
			asc = true;
		}
		int mainv=0;
		if (dsp.getMain()==1) {
			mainv=1;
		}else if (dsp.getUnmain()==1){
			mainv=-1;
		}
		Rs rs;
		long startT=0L,endT=0L;
		if (dsp.getDaysAgo()>0) {
			long curr=System.currentTimeMillis();
			endT=TimeUtil.cal(curr, 3, 0- dsp.getDaysAgo());
			
		}else if(dsp.getDaysOver()>0) {
			long curr=System.currentTimeMillis();
			startT=TimeUtil.cal(curr, 3, 0- dsp.getDaysOver());
		}else {
			if (dsp.getTimeStart()>0) {
				startT=TimeUtil.coverStrToLong(""+dsp.getTimeStart(),"yyyyMMddHHmmss");
			}
			if (dsp.getTimeEnd()>0) {
				endT=TimeUtil.coverStrToLong(""+dsp.getTimeEnd(),"yyyyMMddHHmmss");
			}
		}
		AppEnvParms aep=TempletUtil.init(ep, resFolder, templetType);
		Album album=es.getAlbumDaoImpl().findByID(albid);
		int imgn=dsp.getImg();
		if (dsp.getBigimg()==1) {
			imgn=3;
		}
		if (dsp.getSpare1()==1 && fdar.getDsp().getSubLoopFormatStr()!=null && !fdar.getDsp().getSubLoopFormatStr().trim().equals("")) {
			//嵌套循环，多个栏目
			
			List<AlbumArticleClassify> listg = es.getAlbumArticleClassifyDaoImpl().findByGID(album.getGenre().getId());
			List<AlbumArticleClassify> lista = es.getAlbumArticleClassifyDaoImpl().findByAID(album.getId());
			
			Comparator<AlbumArticleClassify> byMain = Comparator.comparing(AlbumArticleClassify::isMain);
			Comparator<AlbumArticleClassify> byOrdn = Comparator.comparing(AlbumArticleClassify::getOrdn);
			listg.sort(byOrdn.thenComparing(byMain));
			List<AlbumArticleClassify> classifyList = new ArrayList<AlbumArticleClassify>();
			for (AlbumArticleClassify aac:listg) {
				if (dsp.getMain()==1 && !aac.isMain()) {
					continue;
				}
				if (dsp.getUnmain()==1 && aac.isMain()) {
					continue;
				}
				classifyList.add(aac);
			}
			
			lista.sort(byMain.thenComparing(byOrdn));
			
			for (AlbumArticleClassify aac:lista) {
				if (dsp.getMain()==1 && !aac.isMain()) {
					continue;
				}
				if (dsp.getUnmain()==1 && aac.isMain()) {
					continue;
				}
				classifyList.add(aac);
			}
			
			/*
			 * List<AlbumArticleClassify>
			 * classifyList=es.getAlbumArticleClassifyDaoImpl().findByGID(album.getGenre().
			 */
			
			String tmpAll2;
			int curStep,step = 0,step2;
			String tmp2;
			String tmp, tmpAll = "";
			for (AlbumArticleClassify c:classifyList) {
				/*
				 * 如果查找到以下标志，说明下面这个gid的内容已经处理过了，在聚集中就不要再处理了
				 */
//				System.out.println("gid:"+agroup.getId());
				if (es.getTmpStr()!=null && es.getTmpStr().indexOf("f<"+c.getId()+">") > -1) {
					continue;
				}
				step++;
				tmp=fdar.getDsp().getLoopFormatStr();
				tmp=AlbumArticleClassifyUtil.fmt(tmp, c);
				tmp = AnalyzeUtil.replace(tmp, "tag", "nsn", "" + step);
				tmp = AnalyzeUtil.replace(tmp, "tag", "aid", "" + albid);
				tmp = AnalyzeUtil.replace(tmp, "tag", "albid", "" + albid);
				tmp = AnalyzeUtil.replace(tmp, "tag", "nsn-1", "" + (step-1));
				
				rs = es.getAlbumArticleDaoImpl().queryByAidAndCid(albid,c.getId(),1,1,mainv,startT,endT,dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), false,imgn,dsp.getSoul(),dsp.getOrderby(),wvov);;
				
				step2=0;
				tmpAll2="";
				
				for (Object obj : rs.getList()) {
					step2++;
					
					AlbumArticle article = (AlbumArticle) obj;
					tmp2 = fdar.getDsp().getSubLoopFormatStr();
					tmp2 = AlbumArticleUtil.fmt(aep,tmp2, article,imgHtmlTemplet,dsp.getTitleLen(),dsp.getTxtlen(),dsp.getOverMark(),false);
					curStep = ((rs.getPage() - 1) * rs.getPageSize()) + step2;
					tmp2 = AnalyzeUtil.replace(tmp2, "tag", "sn", "" + curStep);
					tmp2 = AnalyzeUtil.replace(tmp2, "tag", "sn-1", "" + (curStep-1));
					
					tmpAll2 += tmp2;
				}
				tmp = AnalyzeUtil.replace(tmp, "tag", "articles", tmpAll2);
				tmpAll+=tmp;
				
			}
			
			html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		}else {
			long aacid=es.getAacid();
			if (aacid==0 && dsp.getAacid()>0) {
				aacid=dsp.getAacid();
			}
			if (albid>0) {
				if (aacid>0) {
					rs= es.getAlbumArticleDaoImpl().queryByAidAndCid(albid,aacid,statusMark,1,mainv,startT,endT,dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), asc,imgn,dsp.getSoul(),dsp.getOrderby(),wvov);
				}else {
					rs= es.getAlbumArticleDaoImpl().queryByAid(albid,statusMark,1,mainv,startT,endT,dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), asc,imgn,dsp.getSoul(),dsp.getOrderby(),wvov);
				}
			}else {
				if (aacid>0) {
					gid=0;
					rs= es.getAlbumArticleDaoImpl().queryByGidAndCid(gid,aacid,1,1,mainv,startT,endT, dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), asc, imgn,dsp.getSoul(),dsp.getOrderby(),wvov);
				}else {
					rs= es.getAlbumArticleDaoImpl().queryByGid(gid,1,1,mainv,startT,endT, dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), asc, imgn,dsp.getSoul(),dsp.getOrderby(),wvov);
				}
			}
			
			int step=0;
			
			String tmp,tmpAll="";
			for (Object obj : rs.getList()) {
				step++;
				AlbumArticle article = (AlbumArticle) obj;
				tmp = lf;
				tmp = AlbumArticleUtil.fmt(aep,tmp, article,imgHtmlTemplet,dsp.getTitleLen(),dsp.getTxtlen(),dsp.getOverMark(),true);
				int curStep = ((rs.getPage() - 1) * rs.getPageSize()) + step;
				tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + curStep);
				tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (curStep-1));
				tmpAll += tmp;
			}

			html = AnalyzeUtil.replace(html, "tag", "recCount", "" + rs.getCount());
			html = AnalyzeUtil.replace(html, "tag", "pageCount", "" + rs.getPageCount());
			
			html = AnalyzeUtil.replace(html, "tag", "dataCount", ""+rs.getCount());
			html = AnalyzeUtil.replace(html, "tag", "pageCurr", ""+rs.getPage());
			html = AnalyzeUtil.replace(html, "tag", "pageSize", ""+rs.getPageSize());
			
			html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		}
		

		return html;
	}
	
	
	public static String analyzeAlbumPartners(String html,EnvirSet es,long albid,FindedDataAnalyzeResult fdar) {
		DataShowParams dsp = fdar.getDsp();
		
		
		String lf = dsp.getLoopFormatStr();
		String tmp,tmpAll="";
		if (dsp.getGid()==0) {
			dsp.setGid(es.getGid());
		}
		if (dsp.getUid()==0) {
			dsp.setUid(es.getUid());
		}
		List<AlbumPartner> list=es.getAlbumPartnerDaoImpl().queryByAid(albid);
		
		int step=0;
		for (AlbumPartner partner:list) {
			step++;
			tmp = lf;
			tmp=UserUtil.fmt(tmp, partner.getUser(),null);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + step);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (step-1));
			tmpAll += tmp;
		}
		html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		return html;
	}
	
	
	public static String analyzeAlbumIdolsArticles(String html,EnvirSet es,FindedDataAnalyzeResult fdar) {
		DataShowParams dsp = fdar.getDsp();
		
		String lf = dsp.getLoopFormatStr();
		String tmp,tmpAll="";
		if (dsp.getGid()==0) {
			dsp.setGid(es.getGid());
		}
		if (dsp.getUid()==0) {
			dsp.setUid(es.getUid());
		}
		Rs rs;
		if (dsp.getGid()==0) {
			rs = es.getAlbumArticleDaoImpl().findByFansUid(dsp.getUid(), dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), false,dsp.getOrderby());
		}else {
			if (dsp.getMain()==0) {
				rs = es.getAlbumArticleDaoImpl().findByFansUid(dsp.getUid(), dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), false,dsp.getOrderby());
			}else {
				List<FansGroup> list=es.getFansGroupDaoImpl().find(dsp.getUid(), 1);
				if (list!=null && !list.isEmpty() && list.size()>0) {
					FansGroup fg=list.get(0);
					rs = es.getAlbumArticleDaoImpl().findByFansGroupID(fg.getId(), dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), false,dsp.getOrderby());
				}else {
					rs = es.getAlbumArticleDaoImpl().findByFansUid(dsp.getUid(), dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize(), false,dsp.getOrderby());
				}
			}
			
		}

		@SuppressWarnings("unchecked")
		List<AlbumArticle> list =(List<AlbumArticle>) rs.getList();
		
		int step=0;
		for (AlbumArticle a:list) {
			step++;
			tmp = lf;
			tmp = AlbumArticleUtil.fmt(lf, a, AlbumArticleUtil.url(a, es.getMessageSource(), es.getRequest()));
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + step);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (step-1));
			tmpAll += tmp;
		}
		html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		return html;
	}
	
	
	public static String analyzeHotAlbumArticles(String html,EnvirSet es,long albid,FindedDataAnalyzeResult fdar) {
		DataShowParams dsp = fdar.getDsp();
		
		String lf = dsp.getLoopFormatStr();
		String tmp,tmpAll="";
		Rs rs;
		rs = es.getAlbumArticleDaoImpl().queryByAid(albid, 1, 1, 0, 0L, 0L, 0, dsp.getCurpage(), dsp.getPagesize(), false, 0, 0, 7, null);

		@SuppressWarnings("unchecked")
		List<AlbumArticle> list =(List<AlbumArticle>) rs.getList();
		
		int step=0;
		for (AlbumArticle a:list) {
			step++;
			tmp = lf;
			tmp = AlbumArticleUtil.fmt(lf, a, AlbumArticleUtil.url(a, es.getMessageSource(), es.getRequest()));
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + step);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (step-1));
			tmpAll += tmp;
		}
		html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		return html;
	}
	
	public static String analyzeAlbumLinks(String html,EnvirSet es,long albid,FindedDataAnalyzeResult fdar) {
		DataShowParams dsp = fdar.getDsp();
		
		
		String lf = dsp.getLoopFormatStr();
		String tmp,tmpAll="";
		List<AlbumExternalLink> linklist = es.getAlbumExternalLinkDaoImpl().findByAid(albid,dsp.getOrder());
		int step=0;
		for (AlbumExternalLink link:linklist) {
			step++;
			tmp = lf;
			tmp=AlbumExternalLinkUtil.fmt(tmp, link);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + step);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (step-1));
			tmpAll += tmp;
		}
		html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		return html;
	}
	
	public static String analyzeClassifyes(String html,EnvirSet es,long albid,FindedDataAnalyzeResult fdar) {
		DataShowParams dsp = fdar.getDsp();
		
		
		String lf = dsp.getLoopFormatStr();
		String tmp,tmpAll="";
		//List<AlbumArticleClassify> linklist = es.getAlbumArticleClassifyDaoImpl().findByAid(albid,dsp.getOrder());
		Album album=es.getAlbumDaoImpl().findByID(albid);
		List<AlbumArticleClassify> linklist = es.getAlbumArticleClassifyDaoImpl().findByGID(album.getGenre().getId());
		List<AlbumArticleClassify> linklist2 = es.getAlbumArticleClassifyDaoImpl().findByAID(albid);
		for (AlbumArticleClassify ctmp:linklist2) {
			linklist.add(ctmp);
		}
		int step=0;
		for (AlbumArticleClassify link:linklist) {
			step++;
			tmp = lf;
			tmp=AlbumArticleClassifyUtil.fmt(tmp, link);
			tmp=AlbumUtil.fmt(tmp, album);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + step);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (step-1));
			tmpAll += tmp;
		}
		html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		return html;
	}
	
	public static String analyzeAlbumIdols(String html,EnvirSet es,FindedDataAnalyzeResult fdar) {
		DataShowParams dsp = fdar.getDsp();
		
		
		String lf = dsp.getLoopFormatStr();
		String tmp,tmpAll="";
		if (dsp.getGid()==0) {
			dsp.setGid(es.getGid());
		}
		if (dsp.getUid()==0) {
			dsp.setUid(es.getUid());
		}
		Rs rs;
		if (dsp.getGid()==0) {
			rs= es.getAlbumFansDaoImpl().queryByUid(es.getUid(), dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize());
		}else {
			if (dsp.getMain()==0) {
				rs= es.getAlbumFansDaoImpl().queryByUid(dsp.getUid(), dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize());
				
			}else {
				List<FansGroup> list=es.getFansGroupDaoImpl().find(dsp.getUid(), 1);
				if (list!=null && !list.isEmpty() && list.size()>0) {
					FansGroup fg=list.get(0);
					rs= es.getAlbumFansDaoImpl().queryByFGid(fg.getId(), dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize());
				}else {
					rs= es.getAlbumFansDaoImpl().queryByUid(dsp.getUid(), dsp.getFirstResult(), dsp.getCurpage(), dsp.getPagesize());
				}
//				es.getFansGroupDaoImpl().find(albID, page, pagesize, ordn)
				
			}
			
		}

		@SuppressWarnings("unchecked")
		List<AlbumFans> list =(List<AlbumFans>) rs.getList();
		
		int step=0;
		for (AlbumFans af:list) {
			step++;
			tmp = lf;
			Album album=af.getTagAlb();
			tmp=AlbumUtil.fmt(tmp, album);
			tmp = AnalyzeUtil.replace(tmp, "tag", "href", AlbumUtil.getHref(es.getMessageSource(), es.getRequest(), album, false));
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn", "" + step);
			tmp = AnalyzeUtil.replace(tmp, "tag", "sn-1", "" + (step-1));
			tmpAll += tmp;
		}
		html = StringUtil.strReplace(html, fdar.getWholeTag(), tmpAll);
		return html;
	}
	
	public static String labelsAnalyze(String html,Album album) {
		List<KeyValue> list=AlbumUtil.lablesInit(album);
		for (KeyValue kv:list) {
			html = AnalyzeUtil.replace(html, "tag", kv.getName(), kv.getValue());
		}
		return html;
	}
	
	
	
	public static String htmlStyleByCustom(String html,Album album) {
		html = AnalyzeUtil.replace(html, "tag", "mycss", album.getCss());
		html = AnalyzeUtil.replace(html, "tag", "color1", album.getColor1());
		html = AnalyzeUtil.replace(html, "tag", "color2", album.getColor2());
		html = AnalyzeUtil.replace(html, "tag", "color3", album.getColor3());
		html = labelsAnalyze(html,album);
		return html;
	}
	
	

}
