package com.lerx.v6.util;

import java.io.File;

import javax.servlet.http.HttpServletRequest;

import org.springframework.context.support.ResourceBundleMessageSource;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.entities.Portal;
import com.lerx.entities.Role;
import com.lerx.entities.TempletComment;
import com.lerx.entities.TempletSubElement;
import com.lerx.entities.User;
import com.lerx.portal.obj.AppEnvParms;
import com.lerx.portal.obj.EnvirSet;
import com.lerx.sys.obj.EnvParms;
import com.lerx.sys.util.FileUtil;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;

public class TempletUtil {
	
	/*
	 * 初始化无缩略图，如果模板目录下images中无，则使用网站根目录下的images下的
	 */
	public static AppEnvParms init(EnvParms ep, String resFolder, int templetType) {
		AppEnvParms aep = new AppEnvParms();
		aep.setEp(ep);
		
		if (resFolder == null || resFolder.trim().equals("")) {
			resFolder = "default";
		}
		
		String templetDir;
		switch (templetType) {
		case 1:
			templetDir = ep.getMessageSource().getMessage("templet.albgenre.dir", null, "templates/albgenre", null);
			break;
		case 2:
			templetDir = ep.getMessageSource().getMessage("templet.album.dir", null, "templates/album", null);
			break;
		default:
			templetDir = ep.getMessageSource().getMessage("templet.portal.dir", null, "templates/portal", null);
		}
		resFolder=templetDir+"/"+resFolder;
		String thumbnailNone=resFolder+"/images/thumbnail-null.jpg";
		String realimg=FileUtil.appPath()+"/"+thumbnailNone;
		realimg=FileUtil.repairFilePath(realimg);
		File f = new File(realimg);
		if (f.exists()) {
			aep.setThumbnailNone(HttpUtil.repairUrl(ep.getRequest().getContextPath()+"/"+thumbnailNone));
		} else {
			aep.setThumbnailNone(HttpUtil.repairUrl(ep.getRequest().getContextPath()+"/"+"images/thumbnail-null.jpg"));
		}
		return aep;
	}
	
	public static String tagToEnvir(String html, HttpServletRequest request,ResourceBundleMessageSource messageSource) {
		if (html==null || html.trim().equals("") ) {
			return html;
		}
		
		html = AnalyzeUtil.replace(html, "tag", "contextPath", request.getContextPath());
		
		html = AnalyzeUtil.replace(html, "tag", "currTime", ""+System.currentTimeMillis());
		html = AnalyzeUtil.replace(html, "tag", "appName", messageSource.getMessage("app.name", null, "CMS", null));
		html = AnalyzeUtil.replace(html, "tag", "developer", messageSource.getMessage("company", null, "Lerx", null));
		html = AnalyzeUtil.replace(html, "tag", "developerUrl", messageSource.getMessage("company.portal.url", null, "http://www.lerx.com", null));
		html = AnalyzeUtil.replace(html, "tag", "lerxVersionNumber", messageSource.getMessage("version.Number", null, "1.0", null));
		html = AnalyzeUtil.replace(html, "tag", "lerxVersionBuild", messageSource.getMessage("version.Build", null, "20180101", null));
		html = AnalyzeUtil.replace(html, "tag", "date", TimeUtil.coverLongToStr(System.currentTimeMillis(), "yyyy-MM-dd"));
		html = AnalyzeUtil.replace(html, "tag", "datecn", SysUtil.currdate(messageSource));
		html = AnalyzeUtil.replace(html, "tag", "year", TimeUtil.coverLongToStr(System.currentTimeMillis(), "yyyy"));
		
		return html;
	}
	
	public static String tagToEnvir(String html, EnvirSet is) {
		if (html==null || html.trim().equals("") || is==null) {
			return html;
		}
		html=tagToEnvir(html,is.getRequest(),is.getMessageSource());
		
		/*html = AnalyzeUtil.replace(html, "tag", "contextPath", is.getRequest().getContextPath());
		
		html = AnalyzeUtil.replace(html, "tag", "currTime", ""+System.currentTimeMillis());
		html = AnalyzeUtil.replace(html, "tag", "appName", is.getMessageSource().getMessage("app.name", null, "CMS", null));
		html = AnalyzeUtil.replace(html, "tag", "developer", is.getMessageSource().getMessage("company", null, "Lerx", null));
		html = AnalyzeUtil.replace(html, "tag", "developerUrl", is.getMessageSource().getMessage("company.portal.url", null, "http://www.lerx.com", null));
		html = AnalyzeUtil.replace(html, "tag", "lerxVersionNumber", is.getMessageSource().getMessage("version.Number", null, "1.0", null));
		html = AnalyzeUtil.replace(html, "tag", "lerxVersionBuild", is.getMessageSource().getMessage("version.Build", null, "20180101", null));
		html = AnalyzeUtil.replace(html, "tag", "date", TimeUtil.coverLongToStr(System.currentTimeMillis(), "yyyy-MM-dd"));
		html = AnalyzeUtil.replace(html, "tag", "year", TimeUtil.coverLongToStr(System.currentTimeMillis(), "yyyy"));*/
		Portal portal = is.getPortalDaoImpl().query_update();
		
		html = PortalUtil.fmt(html, portal);
		//页面执行时间
		if (is.getStartTime()>0L) {
			html = AnalyzeUtil.replace(html, "tag", "executeTimes", ""+(System.currentTimeMillis()-is.getStartTime()));
			
		}else {
			html = AnalyzeUtil.replace(html, "tag", "executeTimes", "");
			
		}
		
		return html;
	}
	
	
	public static TempletComment copy(TempletComment oldEl){
		TempletComment el=new TempletComment();
		el.setActDelCode(oldEl.getActDelCode());
		el.setActPassCode(oldEl.getActPassCode());
		el.setActReplyCode(oldEl.getActReplyCode());
		el.setFormCode(oldEl.getFormCode());
		el.setItemLoopCode(oldEl.getItemLoopCode());
		return el;
	}
	
	public static TempletSubElement copy(TempletSubElement oldEl){
		TempletSubElement el=new TempletSubElement();
		el.setBorderCode(oldEl.getBorderCode());
		el.setCssCode(oldEl.getCssCode());
		el.setExclusiveCode1(oldEl.getExclusiveCode1());
		el.setExclusiveCode2(oldEl.getExclusiveCode2());
		el.setExclusiveCode3(oldEl.getExclusiveCode3());
		el.setExclusiveCode4(oldEl.getExclusiveCode4());
		el.setFooterCode(oldEl.getFooterCode());
		el.setFunctionAreaCode(oldEl.getFunctionAreaCode());
		el.setMainCode(oldEl.getMainCode());
		el.setMajorLoopCodeInLump(oldEl.getMajorLoopCodeInLump());
		el.setMinorLoopCodeInLump(oldEl.getMinorLoopCodeInLump());
		el.setSearchAreaCode(oldEl.getSearchAreaCode());
		el.setTargetStr(oldEl.getTargetStr());
		el.setTopCode(oldEl.getTopCode());
		el.setFooterCode(oldEl.getFooterCode());
		el.setTitleFormat(oldEl.getTitleFormat());
		el.setUserPanelCodeLogin(oldEl.getUserPanelCodeLogin());
		el.setUserPanelCodeLogout(oldEl.getUserPanelCodeLogout());
		return el;
	}
	
	public static String escape(String str) {
		str=StringUtil.strReplace(str, "\\58", ":");
		str=StringUtil.strReplace(str, "\\44", ",");
		return str;
	}
	
	public static String roleExclusiveCode(String panelCode,User user) {
		Role role=user.getRole();
		String roleExclusiveCode;
		if (role==null) {
			roleExclusiveCode=null;
		}else {
			roleExclusiveCode=role.getExclusiveCode();
		}
		
		if (roleExclusiveCode!=null && !roleExclusiveCode.trim().equals("")) {
			panelCode = AnalyzeUtil.replace(panelCode, "code", "exclusive", roleExclusiveCode);
		}else {
			panelCode = AnalyzeUtil.replace(panelCode, "code", "exclusive", "");
		}
		return panelCode;
	}

}
