package com.lerx.v6.util;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.context.support.ResourceBundleMessageSource;

import com.lerx.analyze.util.AnalyzeUtil;
import com.lerx.dao.iface.IRoleDao;
import com.lerx.dao.iface.IUserArtsCountDao;
import com.lerx.dao.iface.IUserDao;
import com.lerx.entities.Role;
import com.lerx.entities.UploadedFile;
import com.lerx.entities.User;
import com.lerx.entities.UserArtsCount;
import com.lerx.login.util.LoginUtil;
import com.lerx.portal.obj.EnvirSet;
import com.lerx.portal.obj.ReciveUserModular;
import com.lerx.portal.obj.SimpleReciveUser;
import com.lerx.portal.obj.UacCollArgs;
import com.lerx.portal.obj.UploadArgs;
import com.lerx.sys.util.DesUtils;
import com.lerx.sys.util.HttpUtil;
import com.lerx.sys.util.StringUtil;
import com.lerx.sys.util.TimeUtil;

public class UserUtil {
	
	public static long loginRefresh(EnvirSet es,String username,String password){
		long uid= -1;
		
		if (username!=null && !username.trim().equals("")){
			User user=new User();
			user.setUsername(username);
			user.setPassword(password);
			String passwordPlain=user.getPassword();
			user=es.getUserDaoImpl().login(user);
			if (user!=null){
				uid=user.getId();
				HttpUtil.saveCookie(es.getMessageSource(), es.getResponse(), "uid_lerx", ""+uid);
				Role role=user.getRole();
				if (role!=null) {
					role=es.getRoleDaoImpl().findByID(role.getId());
				}
				if (role!=null) {
					HttpUtil.saveCookie(es.getMessageSource(), es.getResponse(), "rid_lerx", ""+user.getId());
					HttpUtil.saveCookie(es.getMessageSource(), es.getResponse(), "username_lerx", user.getUsername());
					HttpUtil.saveCookie(es.getMessageSource(), es.getResponse(), "password_lerx", passwordPlain);
					HttpUtil.saveCookie(es.getMessageSource(), es.getResponse(), "role_name_lerx", role.getName());
					
					if (user.getRole()!=null && user.getRole().getMask()!=null && user.getRole().getMask().trim().equals("0")) {
						HttpUtil.saveCookie(es.getMessageSource(), es.getResponse(), "role0_lerx", "true");
					}else {
						HttpUtil.saveCookie(es.getMessageSource(), es.getResponse(), "role0_lerx", "false");
					}
				}
				
				
			}else {
				HttpUtil.clearCookie(es.getRequest(), es.getResponse(), "username_lerx");
				HttpUtil.clearCookie(es.getRequest(), es.getResponse(), "password_lerx");
				HttpUtil.clearCookie(es.getRequest(), es.getResponse(), "uid_lerx");
				HttpUtil.clearCookie(es.getRequest(), es.getResponse(), "rid_lerx");
				HttpUtil.clearCookie(es.getRequest(), es.getResponse(), "role0_lerx");
				HttpUtil.clearCookie(es.getRequest(), es.getResponse(), "role_name_lerx");
			}
		}
		
		return uid;
		
	}
	
	public static String maskChkForArtAdd(EnvirSet es) {
		String username=HttpUtil.getCookie(es.getMessageSource(), es.getRequest(), "username_lerx");
		String password=HttpUtil.getCookie(es.getMessageSource(), es.getRequest(), "password_lerx");
		long uid=loginRefresh(es,username,password);
		if (uid<=0) {
			return null;
		}else {
			String uidStr=HttpUtil.getCookie(es.getMessageSource(), es.getRequest(), "uid_lerx");
			if (!StringUtil.isNumber(uidStr)) {
				return null;
			}
			User user=es.getUserDaoImpl().findByID(Long.valueOf(uidStr));
			if (user == null) {
				return null;
			}
			Role role = user.getRole();
			
			if (role ==null) {
				return null;
			}
			String mask=role.getMask();
			if (mask==null || mask.trim().equals("")) {
				return null;
			}
			if (mask.trim().equals("0")) {
				return "0";
			}
			if (mask.indexOf("p") != -1) {
				return "p";
			}else if (mask.indexOf("a") != -1) {
				return "a";
			}else {
				return "";
			}
		}
		
	}
	
	
	public static String fmt(String lf,User user,String imgHtmlTemplet){
		lf=AnalyzeUtil.replace(lf, "tag", "uid", ""+user.getId());
		lf=AnalyzeUtil.replace(lf, "tag", "username", user.getUsername());
		lf=AnalyzeUtil.replace(lf, "tag", "truename", user.getTruename());
		lf=AnalyzeUtil.replace(lf, "tag", "email", user.getEmail());
		String nickname=user.getNickname();
		if (nickname==null || nickname.trim().equals("")) {
			nickname=user.getUsername();
		}
		lf=AnalyzeUtil.replace(lf, "tag", "nickname", nickname);
		lf=AnalyzeUtil.replace(lf, "tag", "penname", nickname);
		if (user.getRole()!=null) {
			lf=AnalyzeUtil.replace(lf, "tag", "roleID", ""+user.getRole().getId());
			lf=AnalyzeUtil.replace(lf, "tag", "rid", ""+user.getRole().getId());
			lf=AnalyzeUtil.replace(lf, "tag", "role", user.getRole().getName());
		}else {
			lf=AnalyzeUtil.replace(lf, "tag", "roleID", "0");
			lf=AnalyzeUtil.replace(lf, "tag", "rid", "0");
			lf=AnalyzeUtil.replace(lf, "tag", "role", "");
		}
		
		String tmp;
		
		if (imgHtmlTemplet!=null && !imgHtmlTemplet.trim().equals("")) {
			if (user.getAvatarUrl()!=null && !user.getAvatarUrl().equals("")) {
				tmp=imgHtmlTemplet;
				tmp=AnalyzeUtil.replace(tmp, "tag", "src", user.getAvatarUrl());
				lf=AnalyzeUtil.replace(lf, "tag", "avatar", tmp);
			}else {
				lf=AnalyzeUtil.replace(lf, "tag", "avatar", "");
			}
			
			
			
		}else {
			if (user.getAvatarUrl()!=null && !user.getAvatarUrl().equals("")) {
				lf=AnalyzeUtil.replace(lf, "tag", "avatar", user.getAvatarUrl());
			}else {
				lf=AnalyzeUtil.replace(lf, "tag", "avatar", "");
			}
			
		}
		return lf;
	}
	
	/*
	 * 检测是否前台管理员
	 */
	public static boolean isadmin(User user) {
		if (user!=null && user.isState() && user.getRole()!=null && user.getRole().isStatus() && user.getRole().getMask()!=null && user.getRole().getMask().trim().equals("0")) {
			return true;
		}else {
			return false;
		}
		
	}
	
	/*
	 * 检测是否前台管理员
	 */
	public static boolean isSl(User user) {
		if (user!=null && user.isState() && user.getRole()!=null && user.getRole().isStatus() && user.getRole().getMask()!=null && user.getRole().getMask().indexOf("sl")>=0) {
			return true;
		}else {
			return false;
		}
		
	}
	
	
	private  static void uacModify(User u,int atype, String timeKeyStr, long addTime,
			IUserArtsCountDao userArtsCountDaoImp, int col, int v,
			boolean quarter) {
		java.text.SimpleDateFormat formatter = new java.text.SimpleDateFormat(
				timeKeyStr);
		int timeKey;
		if (!quarter) {
			timeKey = Integer.valueOf(formatter.format(addTime));
		} else {
			timeKey = Integer.parseInt(timeKeyStr);
		}
		UserArtsCount uac = userArtsCountDaoImp.findByUK(u, timeKey);
		if (uac == null) {
			uac = new UserArtsCount();
			uac.setUser(u);
			uac.setTimeKey(timeKey);
			/*
			 * uac.setArtsTotal(0); uac.setArtsPassed(0); uac.setAlbumPassed(0);
			 */
			

		}
		if (col == 1) {
			
			uac.setArtsPassed(uac.getArtsPassed() + v);
			
			if (atype==1) {
				uac.setAlbumPassed(uac.getAlbumPassed() + v);
			}else {
				uac.setPortalPassed(uac.getPortalPassed() + v);
			}
			
			
			/*
			 * if (v == 1) { uac.setArtsPassed(uac.getArtsPassed() + 1); if (atype==1) {
			 * uac.setAlbumPassed(uac.getAlbumPassed()+1); }else {
			 * uac.setPortalPassed(uac.getPortalPassed()+1); } } else if (v == -1) { if
			 * (uac.getArtsPassed() > 0) { uac.setArtsPassed(uac.getArtsPassed() - 1); } if
			 * (atype==1) { if (uac.getAlbumPassed() > 0) {
			 * uac.setAlbumPassed(uac.getAlbumPassed() - 1); } }else { if
			 * (uac.getPortalPassed()>0) { uac.setPortalPassed(uac.getPortalPassed() - 1); }
			 * } }
			 */
		} else if (col == 0) {
			uac.setArtsTotal(uac.getArtsTotal() + v);
			if (atype==1) {
				uac.setAlbumTotal(uac.getAlbumTotal() + v);
			}else {
				uac.setPortalTotal(uac.getPortalTotal() + v);
			}
			
			/*
			 * if (v == 1) { uac.setArtsTotal(uac.getArtsTotal() + 1); if (atype==1) {
			 * uac.setAlbumTotal(uac.getAlbumTotal() + 1); }else {
			 * uac.setPortalTotal(uac.getPortalTotal() + 1); } } else if (v == -1) { if
			 * (uac.getArtsTotal() > 0) { uac.setArtsTotal(uac.getArtsTotal() - 1); } if
			 * (atype==1) { if (uac.getAlbumTotal() > 0) {
			 * uac.setAlbumTotal(uac.getAlbumTotal() - 1); } }else { if
			 * (uac.getPortalTotal()>0) { uac.setPortalTotal(uac.getPortalTotal() - 1); } }
			 * }
			 */
		}
		
		if (uac.getAlbumPassed()<0) {
			uac.setAlbumPassed(0);
		}
		if (uac.getAlbumTotal()<0) {
			uac.setAlbumTotal(0);
		}
		if (uac.getArtsPassed()<0) {
			uac.setArtsPassed(0);
		}
		if (uac.getArtsTotal()<0) {
			uac.setArtsTotal(0);
		}
		if (uac.getPortalPassed()<0) {
			uac.setPortalPassed(0);
		}
		if (uac.getPortalTotal()<0) {
			uac.setPortalTotal(0);
		}

		userArtsCountDaoImp.modify(uac);
	}
	
	
	/*
	 * 更新用户的文章发表和通数数
	 */
	public static void uacUpdate(UacCollArgs uca) {
		if (uca.getUser()!=null) {
			uacModify(uca.getUser(),uca.getAtype(), "yyyy", uca.getCreationDT(),uca.getUserArtsCountDaoImpl(), uca.getTag(), uca.getV(),false);
			uacModify(uca.getUser(),uca.getAtype(), "yyyyMM", uca.getCreationDT(),uca.getUserArtsCountDaoImpl(), uca.getTag(), uca.getV(),false);
			
			Date weekStamp=TimeUtil.firstDayAtWeek(new Date(uca.getCreationDT()));
			uacModify(uca.getUser(),uca.getAtype(), "yyyyMMdd", weekStamp.getTime(),uca.getUserArtsCountDaoImpl(), uca.getTag(), uca.getV(),false);
			
			uacModify(uca.getUser(),uca.getAtype(), String.valueOf(TimeUtil.quarter(uca.getCreationDT())), uca.getCreationDT(),uca.getUserArtsCountDaoImpl(), uca.getTag(), uca.getV(),false);
			
		}
		
	}
	/*
	 * public static void uacUpdate(User user,Article article,IUserArtsCountDao
	 * userArtsCountDaoImp,int tag,int v) { UserUtil.uacModify(user, "yyyy",
	 * article.getCreationTime(),userArtsCountDaoImp, tag, v,false);
	 * UserUtil.uacModify(user, "yyyyMM",
	 * article.getCreationTime(),userArtsCountDaoImp, tag, v,false); Date
	 * weekStamp=TimeUtil.firstDayAtWeek(new Date(article.getCreationTime()));
	 * UserUtil.uacModify(user, "yyyyMMdd", weekStamp.getTime(),userArtsCountDaoImp,
	 * tag, v,false); UserUtil.uacModify(user,
	 * String.valueOf(TimeUtil.quarter(article.getCreationTime())),
	 * article.getCreationTime(),userArtsCountDaoImp, tag, v,true); }
	 */
	
	public static User findLoginer (ResourceBundleMessageSource messageSource,HttpServletRequest request,IUserDao userDaoImpl) {
		long currUid = LoginUtil.uid(messageSource, request);
		if (currUid==0) {
			return null;
		}
		User user = userDaoImpl.findByID(currUid);
		
		return user;
	}
	
	public static String findUsername(IUserDao userDaoImpl,String username) {
		if (username==null || username.trim().equals("")) {
			return "";
		}else {
			username = username.trim();
			username=username.replaceAll("\\d+$","");
		}
		if (userDaoImpl.findByUsername(username)==null) {
			return username;
		}
		boolean con=true;
		String nametmp=null;
		while (con) {
			for (int i=1;i<1000;i++) {
				nametmp=username;
				nametmp += StringUtil.covIntToStr(i,4);
				if (userDaoImpl.findByUsername(nametmp)==null) {
					return nametmp;
				}
			}
		}
		return username;
		
	};
	
	public static User mailUsable(User user) {
		if (user!=null && user.getEmail()!=null && StringUtil.emailTest(user.getEmail()) && StringUtil.positionStatus(user.getContactsVerifyed(), 1)) {
			return user;
		}else {
			return null;
		}
	}
	
	public static User mobileUsable(User user) {
		
		if (user!=null && user.getMobile()!=null && StringUtil.isNumber(user.getMobile()) && StringUtil.positionStatus(user.getContactsVerifyed(), 2)) {
			return user;
		}else {
			return null;
		}
	}
	
	public static ReciveUserModular reviceUser(SimpleReciveUser suser,IUserDao userDaoImpl,IRoleDao roleDaoImpl,UploadArgs ua,HttpServletRequest request,HttpServletResponse response) {
		ReciveUserModular rum = new ReciveUserModular();
		if (suser==null || suser.getUuid()==null ) {
			rum.setUser(null);
			ua.setUid(0);
			rum.setUa(ua);
			return rum;
		}
		User user = userDaoImpl.findByUuid(suser.getUuid());
		if (user==null) {
			user = new User();
			if (userDaoImpl.findByUsername(suser.getUsername())==null) {
				user.setUsername(suser.getUsername());
			}else {
				user.setUsername(suser.getUsername()+"_"+TimeUtil.coverLongToStr(System.currentTimeMillis(), "yyyyMMdd"));
			}
			user.setUuid(suser.getUuid());
			user.setTruename(suser.getTruename());
			user.setNickname(suser.getNickname());
			if (suser.getEmail()!=null && !suser.getEmail().trim().equals("")) {
				user.setEmail(suser.getEmail());
			}
			if (suser.getMobile()!=null && !suser.getMobile().trim().equals("")) {
				user.setMobile(suser.getMobile());
			}
			
			user.setCreateTime(suser.getCreateTime());
			user.setCreateIP(suser.getCreateIP());
			user.setState(suser.isState());
			user.setDept(suser.getDept());
			user.setPassword(suser.getPassword());
			user.setSalt(suser.getSalt());
			user.setRole(roleDaoImpl.findDef());
			user.setPwdChangeTime(System.currentTimeMillis());
			user=userDaoImpl.addAndUuid(user);
			ua.setUid(user.getId());
			if (suser.getAvatarUrl()!=null && !suser.getAvatarUrl().trim().equals("")) {
				UploadedFile uf=UploadUtil.downUrlFile(ua, suser.getAvatarUrl(),request, response);
				user.setAvatarUrl(uf.getUrl());
			}
			userDaoImpl.modify(user);
			
		}
		
		rum.setUser(user);
		rum.setUa(ua);
		return rum;
	}
	
	public static String qrcode(User user,long ctime) {
		String qrcStr;
		if (user==null || !user.isState()) {
			return "";
		}
		
		String salt=user.getSalt();
		String uuid=user.getUuid();
		
		String saltmd5=StringUtil.md5(StringUtil.nullFilter(salt)+StringUtil.nullFilter(uuid) + String.valueOf(ctime));
		
		qrcStr=DesUtils.escapeStr(saltmd5,true,true);
		
		return qrcStr;
	}

}
