/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNumeric;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;

public final class Logstash
implements Runnable,
AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(Logstash.class);
    private final Ruby ruby;

    public static void main(String ... args) {
        String lsHome = System.getenv("LS_HOME");
        if (lsHome == null) {
            throw new IllegalStateException("LS_HOME environment variable must be set. This is likely a bug that should be reported.");
        }
        Path home = Paths.get(lsHome, new String[0]).toAbsolutePath();
        try (Logstash logstash = new Logstash(home, args, System.out, System.err, System.in);){
            logstash.run();
        }
        catch (IllegalStateException e) {
            String[] errorMessage = null;
            if (e.getMessage().contains("Could not load FFI Provider")) {
                errorMessage = new String[]{"\nError accessing temp directory: " + System.getProperty("java.io.tmpdir"), "This often occurs because the temp directory has been mounted with NOEXEC or", "the Logstash user has insufficient permissions on the directory. Possible", "workarounds include setting the -Djava.io.tmpdir property in the jvm.options", "file to an alternate directory or correcting the Logstash user's permissions."};
            }
            Logstash.handleCriticalError(e, errorMessage);
        }
        catch (Throwable t) {
            Logstash.handleCriticalError(t, null);
        }
        System.exit(0);
    }

    private static void handleCriticalError(Throwable t, String[] errorMessage) {
        LOGGER.error(t);
        if (errorMessage != null) {
            for (String err : errorMessage) {
                System.err.println(err);
            }
        }
        System.exit(1);
    }

    Logstash(Path home, String[] args, PrintStream output, PrintStream error, InputStream input) {
        RubyInstanceConfig config = Logstash.buildConfig(home, args);
        config.setOutput(output);
        config.setError(error);
        config.setInput(input);
        this.ruby = Ruby.newInstance((RubyInstanceConfig)config);
    }

    @Override
    public void run() {
        if (RubyUtil.RUBY != this.ruby) {
            throw new IllegalStateException("More than one JRuby Runtime detected in the current JVM!");
        }
        RubyInstanceConfig config = this.ruby.getInstanceConfig();
        try (InputStream script = config.getScriptSource();){
            Thread.currentThread().setContextClassLoader((ClassLoader)this.ruby.getJRubyClassLoader());
            this.ruby.runFromMain(script, config.displayedFileName());
        }
        catch (RaiseException ex) {
            RubyException rexep = ex.getException();
            if (this.ruby.getSystemExit().isInstance((IRubyObject)rexep)) {
                IRubyObject status = rexep.callMethod(this.ruby.getCurrentContext(), "status");
                if (status != null && !status.isNil() && RubyNumeric.fix2int((IRubyObject)status) != 0) {
                    Logstash.uncleanShutdown((Exception)((Object)ex));
                }
            } else {
                Logstash.uncleanShutdown((Exception)((Object)ex));
            }
        }
        catch (IOException ex) {
            Logstash.uncleanShutdown(ex);
        }
    }

    @Override
    public void close() {
        this.ruby.tearDown(false);
    }

    private static RubyInstanceConfig buildConfig(Path home, String[] args) {
        String[] arguments = new String[args.length + 2];
        System.arraycopy(args, 0, arguments, 2, args.length);
        arguments[0] = Logstash.safePath(home, "lib", "bootstrap", "environment.rb");
        arguments[1] = Logstash.safePath(home, "logstash-core", "lib", "logstash", "runner.rb");
        RubyInstanceConfig config = new RubyInstanceConfig();
        config.processArguments(arguments);
        return config;
    }

    private static String safePath(Path home, String ... subs) {
        Path resolved = home;
        for (String element : subs) {
            resolved = resolved.resolve(element);
        }
        if (!resolved.toFile().exists()) {
            throw new IllegalArgumentException(String.format("Missing: %s.", resolved));
        }
        return resolved.toString();
    }

    private static void uncleanShutdown(Exception ex) {
        throw new IllegalStateException("Logstash stopped processing because of an error: " + ex.getMessage(), ex);
    }
}

