/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.javaapi;

import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.v0.Input;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.logstash.execution.queue.QueueWriter;

@LogstashPlugin(name="java_input_example")
public class JavaInputExample
implements Input {
    public static final PluginConfigSpec<Long> EVENT_COUNT_CONFIG = Configuration.numSetting("count", 3L);
    public static final PluginConfigSpec<String> PREFIX_CONFIG = Configuration.stringSetting("prefix", "message");
    private long count;
    private String prefix;
    private final CountDownLatch done = new CountDownLatch(1);
    private volatile boolean stopped;

    public JavaInputExample(Configuration config, Context context) {
        this.count = config.get(EVENT_COUNT_CONFIG);
        this.prefix = config.get(PREFIX_CONFIG);
    }

    @Override
    public void start(QueueWriter queueWriter) {
        int eventCount = 0;
        try {
            while (!this.stopped && (long)eventCount < this.count) {
                queueWriter.push(Collections.singletonMap("message", this.prefix + " " + StringUtils.center(++eventCount + " of " + this.count, 20)));
            }
        }
        finally {
            this.stopped = true;
            this.done.countDown();
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public void awaitStop() throws InterruptedException {
        this.done.await();
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return Arrays.asList(EVENT_COUNT_CONFIG, PREFIX_CONFIG);
    }
}

