## Logstash Roadmap

[Logstash](https://www.elastic.co/products/logstash "Logstash") is a data collection engine that is developed directly on Github. The roadmap is defined by the core themes of performance, resiliency, and manageability, along with the overall plugin ecosystem. User requirements are the main driving force behind our development efforts. If a user has a bad time, it’s a bug!  All submitted [issues](https://github.com/elastic/logstash/issues/new "New Issue"), suggestions, or ideas are greatly encouraged and appreciated.

### Logstash Core

With an open development model, the core roadmap can generally be distilled in Github. Long term roadmap features can be viewed with the "[roadmap](https://github.com/elastic/logstash/labels/roadmap "Roadmap Features")" label. The features and bug fixes targeted for an upcoming release can be viewed with the specific release label, e.g. "[v5.0.0](https://github.com/elastic/logstash/issues?utf8=%E2%9C%93&q=is%3Aissue+label%3Av5.0.0 "Logstash 5.0 Release")". Please note that feature timing and priorities are susceptible to change and therefore not guaranteed.

### Logstash Plugins

The [Logstash Plugins](https://github.com/logstash-plugins "Logstash Plugins") ecosystem enables the innovation of additional integrations and processing capabilities for the core engine. Plugins in this organization are either maintained by Elastic or the community. Community maintained plugins have a special banner in the documentation page, e.g. [Salesforce input](https://www.elastic.co/guide/en/logstash/current/plugins-inputs-salesforce.html "Salesforce Input Plugin"). Many awesome humans have taken the roadmap into their own hands by becoming community maintainers. If you’re actively working with specific community plugins and would like to get more involved, feel free to reach out in this [forum thread](https://discuss.elastic.co/t/logstash-plugins-community-maintainers/35953 "Community Maintainers").

## Latest Changes

For a list of latest changes across Logstash and its plugins, see the [release notes](https://www.elastic.co/guide/en/logstash/current/releasenotes.html "Current Release Notes").
