/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * <p>This source code is licensed under the MIT license found in the LICENSE file in the root
 * directory of this source tree.
 *
 * <p>Generated by an internal genrule from Flow types.
 *
 * @generated
 * @nolint
 */

package com.facebook.fbreact.specs;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReactModuleWithSpec;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class NativeUIManagerSpec extends ReactContextBaseJavaModule implements ReactModuleWithSpec, TurboModule {
  public NativeUIManagerSpec(ReactApplicationContext reactContext) {
    super(reactContext);
  }

  @ReactMethod(
      isBlockingSynchronousMethod = true
  )
  public abstract WritableArray getDefaultEventTypes();

  @ReactMethod
  public abstract void setLayoutAnimationEnabledExperimental(boolean enabled);

  @ReactMethod
  public abstract void configureNextLayoutAnimation(ReadableMap config, Callback callback,
      Callback errorCallback);

  @ReactMethod
  public abstract void playTouchSound();

  @ReactMethod
  public abstract void blur(Double reactTag);

  @ReactMethod
  public abstract void focus(Double reactTag);

  @ReactMethod
  public abstract void removeSubviewsFromContainerWithID(double containerID);

  @ReactMethod
  public abstract void setJSResponder(Double reactTag, boolean blockNativeResponder);

  @ReactMethod
  public abstract void clearJSResponder();

  @ReactMethod
  public abstract void measureLayout(Double reactTag, Double ancestorReactTag,
      Callback errorCallback, Callback callback);

  @ReactMethod(
      isBlockingSynchronousMethod = true
  )
  public abstract WritableMap getConstantsForViewManager(String viewManagerName);

  @ReactMethod
  public abstract void updateView(double reactTag, String viewName, ReadableMap props);

  @ReactMethod
  public abstract void dispatchViewManagerCommand(Double reactTag, double commandID,
      ReadableArray commandArgs);

  @ReactMethod
  public abstract void createView(Double reactTag, String viewName, double rootTag,
      ReadableMap props);

  @ReactMethod
  public abstract void sendAccessibilityEvent(Double reactTag, double eventType);

  @ReactMethod
  public abstract void measureInWindow(Double reactTag, Callback callback);

  @ReactMethod
  public abstract void viewIsDescendantOf(Double reactTag, Double ancestorReactTag,
      Callback callback);

  @ReactMethod(
      isBlockingSynchronousMethod = true
  )
  public abstract WritableMap lazilyLoadView(String name);

  @ReactMethod
  public abstract void findSubviewIn(Double reactTag, ReadableArray point, Callback callback);

  @ReactMethod
  public abstract void manageChildren(Double containerTag, ReadableArray moveFromIndices,
      ReadableArray moveToIndices, ReadableArray addChildReactTags, ReadableArray addAtIndices,
      ReadableArray removeAtIndices);

  @ReactMethod
  public abstract void showPopupMenu(Double reactTag, ReadableArray items, Callback error,
      Callback success);

  @ReactMethod
  public abstract void replaceExistingNonRootView(Double reactTag, Double newReactTag);

  @ReactMethod
  public abstract void dismissPopupMenu();

  @ReactMethod
  public abstract void measure(Double reactTag, Callback callback);

  @ReactMethod
  public abstract void measureLayoutRelativeToParent(Double reactTag, Callback errorCallback,
      Callback callback);

  @ReactMethod
  public abstract void setChildren(Double containerTag, ReadableArray reactTags);

  protected abstract Map<String, Object> getTypedExportedConstants();

  @Override
  public final @Nullable Map<String, Object> getConstants() {
    Map<String, Object> constants = getTypedExportedConstants();
    return constants;
  }
}
