<?php

    // +----------------------------------------------------------------------
    // | 应用公共文件1
    // +----------------------------------------------------------------------
    // | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
    // +----------------------------------------------------------------------
    // | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
    // +----------------------------------------------------------------------
    // | Author: 流年 <liu21st@gmail.com>
    // +----------------------------------------------------------------------

    use think\facade\Config;
    use think\Loader;
    use think\facade\Url;
    use think\facade\Cache;
    use think\Db;
    use app\ucenter\model\User;

    //根据长网址获取短网址
    function short_url_sina($url, $long = true)
    {
        //拼接请求地址，此地址你可以在官方的文档中查看到
        $url = 'http://api.t.sina.com.cn/short_url/shorten.json?source=31641035&url_long=' . $url;
        $reuslt = \yicmf\Http::get($url);
        if ( 200 == $reuslt['code'] ) {
            return $reuslt['content'][0];
        } else {
            throw new \think\Exception('请求失败');
        }
    }

    function is_weixin()
    {
        if ( strpos($_SERVER['HTTP_USER_AGENT'],
                'MicroMessenger') !== false ) {
            return true;
        }
        return false;
    }

    /**
     * 取得根域名
     * @param string $domain 域名
     * @return string 返回根域名
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/16 11:30
     */
    function get_url_root_domain($domain)
    {
        $domain_postfix_cn_array = array("com", "net", "org", "gov", "edu", "com.cn", "cn");
        $array_domain = explode(".", $domain);
        $array_num = count($array_domain) - 1;
        if ( $array_domain[$array_num] == 'cn' ) {
            if ( in_array($array_domain[$array_num - 1], $domain_postfix_cn_array) ) {
                $root_domain = $array_domain[$array_num - 2] . "." . $array_domain[$array_num - 1] . "." . $array_domain[$array_num];
            } else {
                $root_domain = $array_domain[$array_num - 1] . "." . $array_domain[$array_num];
            }
        } else {
            $root_domain = $array_domain[$array_num - 1] . "." . $array_domain[$array_num];
        }
        return $root_domain;
    }

    function create_guid()
    {
        $uid = uniqid("", true);
        $data = 'card';
        $data .= $_SERVER ['REQUEST_TIME'];    // 请求那一刻的时间戳
        $data .= $_SERVER ['HTTP_USER_AGENT'];    // 获取访问者在用什么操作系统
        $data .= $_SERVER ['SERVER_ADDR'];        // 服务器IP
        $data .= $_SERVER ['SERVER_PORT'];        // 端口号
        $data .= $_SERVER ['REMOTE_ADDR'];        // 远程IP
        $data .= $_SERVER ['REMOTE_PORT'];        // 端口信息
        $hash = strtoupper(hash('ripemd128', $uid . md5($data)));
        return substr($hash, 0, 8) . '-' . substr($hash, 8, 4) . '-' . substr($hash, 12, 4) . '-' . substr($hash, 16, 4) . '-' . substr($hash, 20, 12);
    }

    function tencent_captcha_check($param)
    {
        if ( Config::get('setting.tencent_captcha_open') ) {

            try {
                // 腾讯安全验证
                $params = array(
                    "aid" => $param['appid'],
                    "AppSecretKey" => Config::get('setting.tencent_captcha_secret_key'),
                    "Ticket" => $param['ticket'],
                    "Randstr" => $param['randstr'],
                    "UserIP" => request()->ip()
                );
                $params = http_build_query($params);
                $result = \yicmf\Http::post('https://ssl.captcha.qq.com/ticket/verify', $params);
                $data = json_decode($result['content'], true);
            } catch ( \Exception $e ) {
                $data['response'] = 0;
                $data['err_msg'] = '验证异常';
            }
        } else {
            $data['response'] = 1;
            $data['err_msg'] = '未开通';
        }

        return $data;

    }

    function randNickname()
    {
        $tou = array('快乐', '冷静', '醉熏', '潇洒', '糊涂', '积极', '冷酷', '深情', '粗暴', '温柔', '可爱', '愉快', '义气', '认真', '威武', '帅气', '传统', '潇洒', '漂亮', '自然', '专一', '听话', '昏睡', '狂野', '等待', '搞怪', '幽默', '魁梧', '活泼', '开心', '高兴', '超帅', '留胡子', '坦率', '直率', '轻松', '痴情', '完美', '精明', '无聊', '有魅力', '丰富', '繁荣', '饱满', '炙热', '暴躁', '碧蓝', '俊逸', '英勇', '健忘', '故意', '无心', '土豪', '朴实', '兴奋', '幸福', '淡定', '不安', '阔达', '孤独', '独特', '疯狂', '时尚', '落后', '风趣', '忧伤', '大胆', '爱笑', '矮小', '健康', '合适', '玩命', '沉默', '斯文', '香蕉', '苹果', '鲤鱼', '鳗鱼', '任性', '细心', '粗心', '大意', '甜甜', '酷酷', '健壮', '英俊', '霸气', '阳光', '默默', '大力', '孝顺', '忧虑', '着急', '紧张', '善良', '凶狠', '害怕', '重要', '危机', '欢喜', '欣慰', '满意', '跳跃', '诚心', '称心', '如意', '怡然', '娇气', '无奈', '无语', '激动', '愤怒', '美好', '感动', '激情', '激昂', '震动', '虚拟', '超级', '寒冷', '精明', '明理', '犹豫', '忧郁', '寂寞', '奋斗', '勤奋', '现代', '过时', '稳重', '热情', '含蓄', '开放', '无辜', '多情', '纯真', '拉长', '热心', '从容', '体贴', '风中', '曾经', '追寻', '儒雅', '优雅', '开朗', '外向', '内向', '清爽', '文艺', '长情', '平常', '单身', '伶俐', '高大', '懦弱', '柔弱', '爱笑', '乐观', '耍酷', '酷炫', '神勇', '年轻', '唠叨', '瘦瘦', '无情', '包容', '顺心', '畅快', '舒适', '靓丽', '负责', '背后', '简单', '谦让', '彩色', '缥缈', '欢呼', '生动', '复杂', '慈祥', '仁爱', '魔幻', '虚幻', '淡然', '受伤', '雪白', '高高', '糟糕', '顺利', '闪闪', '羞涩', '缓慢', '迅速', '优秀', '聪明', '含糊', '俏皮', '淡淡', '坚强', '平淡', '欣喜', '能干', '灵巧', '友好', '机智', '机灵', '正直', '谨慎', '俭朴', '殷勤', '虚心', '辛勤', '自觉', '无私', '无限', '踏实', '老实', '现实', '可靠', '务实', '拼搏', '个性', '粗犷', '活力', '成就', '勤劳', '单纯', '落寞', '朴素', '悲凉', '忧心', '洁净', '清秀', '自由', '小巧', '单薄', '贪玩', '刻苦', '干净', '壮观', '和谐', '文静', '调皮', '害羞', '安详', '自信', '端庄', '坚定', '美满', '舒心', '温暖', '专注', '勤恳', '美丽', '腼腆', '优美', '甜美', '甜蜜', '整齐', '动人', '典雅', '尊敬', '舒服', '妩媚', '秀丽', '喜悦', '甜美', '彪壮', '强健', '大方', '俊秀', '聪慧', '迷人', '陶醉', '悦耳', '动听', '明亮', '结实', '魁梧', '标致', '清脆', '敏感', '光亮', '大气', '老迟到', '知性', '冷傲', '呆萌', '野性', '隐形', '笑点低', '微笑', '笨笨', '难过', '沉静', '火星上', '失眠', '安静', '纯情', '要减肥', '迷路', '烂漫', '哭泣', '贤惠', '苗条', '温婉', '发嗲', '会撒娇', '贪玩', '执着', '眯眯眼', '花痴', '想人陪', '眼睛大', '高贵', '傲娇', '心灵美', '爱撒娇', '细腻', '天真', '怕黑', '感性', '飘逸', '怕孤独', '忐忑', '高挑', '傻傻', '冷艳', '爱听歌', '还单身', '怕孤单', '懵懂');
        $do = array("的", "爱", "", "与", "给", "扯", "和", "用", "方", "打", "就", "迎", "向", "踢", "笑", "闻", "有", "等于", "保卫", "演变");
        $wei = array('嚓茶', '凉面', '便当', '毛豆', '花生', '可乐', '灯泡', '哈密瓜', '野狼', '背包', '眼神', '缘分', '雪碧', '人生', '牛排', '蚂蚁', '飞鸟', '灰狼', '斑马', '汉堡', '悟空', '巨人', '绿茶', '自行车', '保温杯', '大碗', '墨镜', '魔镜', '煎饼', '月饼', '月亮', '星星', '芝麻', '啤酒', '玫瑰', '大叔', '小伙', '哈密瓜，数据线', '太阳', '树叶', '芹菜', '黄蜂', '蜜粉', '蜜蜂', '信封', '西装', '外套', '裙子', '大象', '猫咪', '母鸡', '路灯', '蓝天', '白云', '星月', '彩虹', '微笑', '摩托', '板栗', '高山', '大地', '大树', '电灯胆', '砖头', '楼房', '水池', '鸡翅', '蜻蜓', '红牛', '咖啡', '机器猫', '枕头', '大船', '诺言', '钢笔', '刺猬', '天空', '飞机', '大炮', '冬天', '洋葱', '春天', '夏天', '秋天', '冬日', '航空', '毛衣', '豌豆', '黑米', '玉米', '眼睛', '老鼠', '白羊', '帅哥', '美女', '季节', '鲜花', '服饰', '裙子', '白开水', '秀发', '大山', '火车', '汽车', '歌曲', '舞蹈', '老师', '导师', '方盒', '大米', '麦片', '水杯', '水壶', '手套', '鞋子', '自行车', '鼠标', '手机', '电脑', '书本', '奇迹', '身影', '香烟', '夕阳', '台灯', '宝贝', '未来', '皮带', '钥匙', '心锁', '故事', '花瓣', '滑板', '画笔', '画板', '学姐', '店员', '电源', '饼干', '宝马', '过客', '大白', '时光', '石头', '钻石', '河马', '犀牛', '西牛', '绿草', '抽屉', '柜子', '往事', '寒风', '路人', '橘子', '耳机', '鸵鸟', '朋友', '苗条', '铅笔', '钢笔', '硬币', '热狗', '大侠', '御姐', '萝莉', '毛巾', '期待', '盼望', '白昼', '黑夜', '大门', '黑裤', '钢铁侠', '哑铃', '板凳', '枫叶', '荷花', '乌龟', '仙人掌', '衬衫', '大神', '草丛', '早晨', '心情', '茉莉', '流沙', '蜗牛', '战斗机', '冥王星', '猎豹', '棒球', '篮球', '乐曲', '电话', '网络', '世界', '中心', '鱼', '鸡', '狗', '老虎', '鸭子', '雨', '羽毛', '翅膀', '外套', '火', '丝袜', '书包', '钢笔', '冷风', '八宝粥', '烤鸡', '大雁', '音响', '招牌', '胡萝卜', '冰棍', '帽子', '菠萝', '蛋挞', '香水', '泥猴桃', '吐司', '溪流', '黄豆', '樱桃', '小鸽子', '小蝴蝶', '爆米花', '花卷', '小鸭子', '小海豚', '日记本', '小熊猫', '小懒猪', '小懒虫', '荔枝', '镜子', '曲奇', '金针菇', '小松鼠', '小虾米', '酒窝', '紫菜', '金鱼', '柚子', '果汁', '百褶裙', '项链', '帆布鞋', '火龙果', '奇异果', '煎蛋', '唇彩', '小土豆', '高跟鞋', '戒指', '雪糕', '睫毛', '铃铛', '手链', '香氛', '红酒', '月光', '酸奶', '银耳汤', '咖啡豆', '小蜜蜂', '小蚂蚁', '蜡烛', '棉花糖', '向日葵', '水蜜桃', '小蝴蝶', '小刺猬', '小丸子', '指甲油', '康乃馨', '糖豆', '薯片', '口红', '超短裙', '乌冬面', '冰淇淋', '棒棒糖', '长颈鹿', '豆芽', '发箍', '发卡', '发夹', '发带', '铃铛', '小馒头', '小笼包', '小甜瓜', '冬瓜', '香菇', '小兔子', '含羞草', '短靴', '睫毛膏', '小蘑菇', '跳跳糖', '小白菜', '草莓', '柠檬', '月饼', '百合', '纸鹤', '小天鹅', '云朵', '芒果', '面包', '海燕', '小猫咪', '龙猫', '唇膏', '鞋垫', '羊', '黑猫', '白猫', '万宝路', '金毛', '山水', '音响', '尊云', '西安');
        $tou_num = rand(0, 331);
        $do_num = rand(0, 19);
        $wei_num = rand(0, 327);
        $type = rand(0, 1);
        if ( $type == 0 ) {
            $username = $tou[$tou_num] . $do[$do_num] . $wei[$wei_num];
        } else {
            $username = $wei[$wei_num] . $tou[$tou_num];
        }
        return $username; //输出生成昵称
    }

    function picture($id, $field = 'url')
    {
        $picture = \app\file\model\Picture::find($id);
        if ( $picture ) {
            return $picture[$field];
        } else {
            return ' ';
        }
    }

    /**
     * t函数用于过滤标签，输出没有html的干净的文本.
     * @param string text 文本内容
     * @return string 处理后内容
     */
    function op_t($text)
    {
        $text = nl2br($text);
        $text = real_strip_tags($text);
        $text = addslashes($text);
        $text = trim($text);

        return $text;
    }

    /**
     * 友好显示时间
     * @param      $the_time
     * @param null $now_time
     * @return false|string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/7 9:18
     */
    function time_friend($the_time, $now_time = null)
    {
        if ( is_null($now_time) ) {
            $now_time = $_SERVER['REQUEST_TIME'];
        }
        $the_time = is_numeric($the_time) ? $the_time : strtotime($the_time);
        $dur = $now_time - $the_time;
        if ( $dur < 0 ) {
            return date('Y-m-d', $the_time);
        } else {
            if ( $dur < (60 * 15) ) {
                return '刚刚';
            } else {
                if ( $dur < 3600 ) {
                    return floor($dur / 60) . '分钟前';
                } else {
                    if ( $dur < 86400 ) {
                        return floor($dur / 3600) . '小时前';
                    } else {
                        if ( $dur <= 86400 * 7 ) {//一周
                            return floor($dur / 86400) . '天前';
                        } else {
                            if ( $dur <= 86400 * 30 ) {//一个月
                                return floor($dur / (86400 * 7)) . '周前';
                            } else {
                                if ( $dur <= 86400 * 365 ) {
                                    return floor($dur / (86400 * 30)) . '月前';
                                } else {
                                    return floor($dur / (86400 * 365)) . '年前';
                                }
                            }
                        }
                    }
                }
            }
        }
    }


    /**
     * 时间根据指定格式格式化.
     * @param string $time   时间
     * @param string $format 格式类型、默认是Config::get('database.datetime_format')
     * @return string
     * @throws Exception
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 11:24
     */
    function time_format($time = '', $format = '')
    {
        $format = $format ?: Config::get('database.datetime_format');
        if ( is_numeric($time) ) {
            $obj = new DateTime();
            $obj->setTimestamp($time);
        } else {
            $obj = new \DateTime($time);
        }
        return $obj->format($format);
    }

    /**
     * 格式化字节大小.
     * @param number $size      字节数
     * @param string $delimiter 数字和单位分隔符
     * @return string 格式化后的带单位的大小
     */
    function format_bytes($size, $delimiter = '')
    {
        $units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB'];
        for ( $i = 0; $size >= 1024 && $i < 5; $i++ ) {
            $size /= 1024;
        }

        return round($size, 2) . $delimiter . $units[$i];
    }

    /**
     * 函数用于过滤不安全的html标签，输出安全的html.
     * @param string $text 待过滤的字符串
     * @param string $type 保留的标签格式
     * @return string 处理后内容
     */
    function op_h($text, $type = 'html')
    {
        // 无标签格式
        $text_tags = '';
        //只保留链接
        $link_tags = '<a>';
        //只保留图片
        $image_tags = '<img>';
        //只存在字体样式
        $font_tags = '<i><b><u><s><em><strong><font><big><small><sup><sub><bdo><h1><h2><h3><h4><h5><h6>';
        //标题摘要基本格式
        $base_tags = $font_tags . '<p><br><hr><a><img><map><area><pre><code><q><blockquote><acronym><cite><ins><del><center><strike>';
        //兼容Form格式
        $form_tags = $base_tags . '<form><input><textarea><button><select><optgroup><option><label><fieldset><legend>';
        //内容等允许HTML的格式
        $html_tags = $base_tags . '<ul><ol><li><dl><dd><dt><table><caption><td><th><tr><thead><tbody><tfoot><col><colgroup><div><span><object><embed><param>';
        //专题等全HTML格式
        $all_tags = $form_tags . $html_tags . '<!DOCTYPE><meta><html><head><title><body><base><basefont><script><noscript><applet><object><param><style><frame><frameset><noframes><iframe>';
        //过滤标签
        $text = real_strip_tags($text, ${$type . '_tags'});
        // 过滤攻击代码
        if ( $type != 'all' ) {
            // 过滤危险的属性，如：过滤on事件lang js
            while ( preg_match('/(<[^><]+)(ondblclick|onclick|onload|onerror|unload|onmouseover|onmouseup|onmouseout|onmousedown|onkeydown|onkeypress|onkeyup|onblur|onchange|onfocus|action|background|codebase|dynsrc|lowsrc)([^><]*)/i', $text, $mat) ) {
                $text = str_ireplace($mat[0], $mat[1] . $mat[3], $text);
            }
            while ( preg_match('/(<[^><]+)(window\.|javascript:|js:|about:|file:|document\.|vbs:|cookie)([^><]*)/i', $text, $mat) ) {
                $text = str_ireplace($mat[0], $mat[1] . $mat[3], $text);
            }
        }

        return $text;
    }

    /**
     * 过滤函数，别名函数，op_t的别名
     */
    function text($text)
    {
        return op_t($text);
    }

    /**
     * 过滤函数，别名函数，op_h的别名
     */
    function html($text)
    {
        return op_h($text);
    }

    function real_strip_tags($str, $allowable_tags = '')
    {
        $str = html_entity_decode($str, ENT_QUOTES, 'UTF-8');

        return strip_tags($str, $allowable_tags);
    }

    /**
     * 加密数字
     * @param $user_id
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/24 17:42
     */
    function createCode($user_id)
    {
        static $source_string = 'E5FCG3HQA4B1NOPIJ2RSTUV67MWX89KLYZ';
        $num = $user_id;
        $code = '';
        while ( $num > 0 ) {
            $mod = $num % 34;
            $num = ($num - $mod) / 34;
            $code = $source_string[$mod] . $code;
        }
        if ( empty($code[3]) )
            $code = str_pad($code, 5, 'D', STR_PAD_LEFT);
        return strtolower($code);
    }

    /**
     * 解密数字
     * @param $code
     * @return float|int
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/24 17:42
     */
    function decodeCode($code)
    {
        $code = strtoupper($code);
        static $source_string = 'E5FCG3HQA4B1NOPIJ2RSTUV67MWX89KLYZ';
        if ( strrpos($code, 'D') !== false )
            $code = substr($code, strrpos($code, 'D') + 1);
        $len = strlen($code);
        $code = strrev($code);
        $num = 0;
        for ( $i = 0; $i < $len; $i++ ) {
            $num += strpos($source_string, $code[$i]) * pow(34, $i);
        }
        return $num;
    }

    /**
     * 内容转换函数
     * @param string $message 内容模板
     * @param array  $param   内容参数数组
     * @return string 通知内容
     */
    function string_replace($content, $param)
    {
        if ( !is_array($param) )
            return false;
        foreach ( $param as $k => $v ) {
            $content = str_replace('{$' . $k . '}', $v, $content);
        }
        return $content;
    }

    /**
     * 获取图片信息
     * @param number $id    图片的id
     * @param string $field 要获取的字段，默认为url
     * @return string
     * @author 微尘 <yicmf@qq.com>
     */
    function get_picture($id = 0, $field = 'url')
    {
        $info = \app\file\model\Picture::get($id);
        return empty($info[$field]) ? '' : $info[$field];
    }

    /**
     * 生成加密密钥.
     */
    function build_encrypt_key($long = 32)
    {
        $chars = 'abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $chars .= '`~!@#$%^&*()_+-=[]{};:"|,.<>/?';
        $chars = str_shuffle($chars);

        return substr($chars, 0, $long);
    }

    /**
     * 获取类中非继承方法和重写方法
     * 只获取在本类中声明的方法，包含重写的父类方法，其他继承自父类但未重写的，不获取
     * 例
     * class A{
     *        public function a1(){}
     *        public function a2(){}
     * }
     * class B extends A{
     *        public function b1(){}
     *        public function a1(){}
     * }
     * get_current_class_methods('B')返回方法名b1和a1，a2虽然被B继承了，但未重写，故不返回
     * get_current_class_methods(__CLASS__).
     * @param string $classname          类名
     * @param string $access             public or protected  or private or final 方法的访问权限
     * @return array(methodname=>access) or array(methodname) 返回数组，如果第二个参数有效，
     *                                   则返回以方法名为key，访问权限为value的数组
     * @see  使用了命名空间，故在new 时类前加反斜线；如果此此函数不是作为类中方法使用，可能由于权限问题，
     *                                   只能获得public方法
     */
    function get_current_class_methods($classname, $access = null)
    {
        $class = new \ReflectionClass($classname);
        $methods = $class->getMethods();
        $returnArr = [];
        foreach ( $methods as $value ) {
            if ( $value->class == $classname ) {
                if ( $access != null ) {
                    $methodAccess = new \ReflectionMethod($classname, $value->name);
                    switch ( $access ) {
                        case 'public':
                            if ( $methodAccess->isPublic() ) {
                                $returnArr[$value->name] = 'public';
                            }
                            break;
                        case 'protected':
                            if ( $methodAccess->isProtected() ) {
                                $returnArr[$value->name] = 'protected';
                            }
                            break;
                        case 'private':
                            if ( $methodAccess->isPrivate() ) {
                                $returnArr[$value->name] = 'private';
                            }
                            break;
                        case 'final':
                            if ( $methodAccess->isFinal() ) {
                                $returnArr[$value->name] = 'final';
                            }
                            break;
                    }
                } else {
                    array_push($returnArr, $value->name);
                }
            }
        }

        return $returnArr;
    }

    /**
     * 根据用户ID获取用户信息.
     * @param int    $user  用户ID
     * @param string $field 获取用户的字段，默认是nickname
     * @return mixed
     */
    function get_user_info($user_id, $field = 'nickname')
    {
        static $list;

        /* 获取缓存数据 */
        if ( empty($list) ) {
            $list = Cache::get('sys_user_info_list');
        }
        /* 查找用户信息 */
        $key = "u{$user_id}";
        if ( isset($list[$key]) ) { //已缓存，直接使用
            $name = $list[$key][$field];
        } else { //调用接口获取用户信息
            $user = User::find($user_id);
            if ( $user ) {
                $temp = $user->toArray();
                if ('nickname' == $field)
                {
                    $nickname = $user->getData('nickname');
                    $temp['nickname'] = $nickname;
                }
                $list[$key] = $temp;
                $name = $temp[$field];
                /* 缓存用户 */
                $count = count($list);
                $max = Config::get('ucenter.user_max_cache');
                while ( $count-- > $max ) {
                    array_shift($list);
                }
                Cache::set('sys_user_info_list', $list);
            } else {
                $name = '';
            }
        }
        return $name;
    }

    /**
     * 获取导航URL.
     * @param string $url 导航URL
     * @return string 解析或的url
     */
    function get_nav_url($url, $module = 'Home')
    {
        switch ( $url ) {
            case strpos($url, 'http'):
            case '#' === substr($url, 0, 1):
                break;
            //         case '/' === substr($url, 0, 1):
            //             break;
            default:
                $url = Url::build($url);
                break;
        }

        return $url;
    }

    /**
     * 字符串截取，支持中文和其他编码
     * @static
     * @param string $str     需要转换的字符串
     * @param string $start   开始位置
     * @param string $length  截取长度
     * @param string $charset 编码格式
     * @param string $suffix  截断显示字符
     * @return string
     */
    function msubstr($str, $start, $length, $charset = 'utf-8', $suffix = false)
    {
        if ( function_exists('mb_substr') ) {
            $slice = mb_substr($str, $start, $length, $charset);
        } elseif ( function_exists('iconv_substr') ) {
            $slice = iconv_substr($str, $start, $length, $charset);
            if ( false === $slice ) {
                $slice = '';
            }
        } else {
            $re['utf-8'] = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
            $re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
            $re['gbk'] = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
            $re['big5'] = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
            preg_match_all($re[$charset], $str, $match);
            $slice = implode('', array_slice($match[0], $start, $length));
        }

        return $suffix ? $slice . '...' : $slice;
    }

    /**
     * 系统加密方法.
     * @param string $data   要加密的字符串
     * @param string $key    加密密钥
     * @param int    $expire 过期时间 单位 秒
     * @return string
     */
    function think_encrypt($data, $key = '', $expire = 0)
    {
        $key = md5(empty($key) ? Config::get('ucenter.data_auth_key') : $key);
        $data = base64_encode($data);
        $x = 0;
        $len = strlen($data);
        $l = strlen($key);
        $char = '';

        for ( $i = 0; $i < $len; $i++ ) {
            if ( $x == $l ) {
                $x = 0;
            }
            $char .= substr($key, $x, 1);
            $x++;
        }

        $str = sprintf('%010d', $expire ? $expire + time() : 0);

        for ( $i = 0; $i < $len; $i++ ) {
            $str .= chr(ord(substr($data, $i, 1)) + (ord(substr($char, $i, 1))) % 256);
        }

        return str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($str));
    }

    /**
     * 系统解密方法.
     * @param string $data 要解密的字符串 （必须是think_encrypt方法加密的字符串）
     * @param string $key  加密密钥
     * @return string
     */
    function think_decrypt($data, $key = '')
    {
        $key = md5(empty($key) ? Config::get('ucenter.data_auth_key') : $key);
        $data = str_replace(['-', '_'], ['+', '/'], $data);
        $mod4 = strlen($data) % 4;
        if ( $mod4 ) {
            $data .= substr('====', $mod4);
        }
        $data = base64_decode($data);
        $expire = substr($data, 0, 10);
        $data = substr($data, 10);

        if ( $expire > 0 && $expire < time() ) {
            return '';
        }
        $x = 0;
        $len = strlen($data);
        $l = strlen($key);
        $char = $str = '';

        for ( $i = 0; $i < $len; $i++ ) {
            if ( $x == $l ) {
                $x = 0;
            }
            $char .= substr($key, $x, 1);
            $x++;
        }

        for ( $i = 0; $i < $len; $i++ ) {
            if ( ord(substr($data, $i, 1)) < ord(substr($char, $i, 1)) ) {
                $str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
            } else {
                $str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
            }
        }

        return base64_decode($str);
    }

    /**
     * 数据签名认证
     * @param array $data 被认证的数据
     * @return string 签名
     */
    function data_auth_sign($data)
    {
        //数据类型检测
        if ( !is_array($data) ) {
            $data = (array)$data;
        }
        ksort($data); //排序
        $code = http_build_query($data); //url编码并生成query字符串
        $sign = sha1($code); //生成签名
        return $sign;
    }

    /**
     * 对查询结果集进行排序.
     * @param array  $list   查询结果
     * @param string $field  排序的字段名
     * @param array  $sortby 排序类型
     *                       asc正向排序 desc逆向排序 nat自然排序
     * @return array
     */
    function list_sort_by($list, $field, $sortby = 'asc')
    {
        if ( is_array($list) ) {
            $refer = $resultSet = [];
            foreach ( $list as $i => $data ) {
                $refer[$i] = &$data[$field];
            }
            switch ( $sortby ) {
                case 'asc': // 正向排序
                    asort($refer);
                    break;
                case 'desc':// 逆向排序
                    arsort($refer);
                    break;
                case 'nat': // 自然排序
                    natcasesort($refer);
                    break;
            }
            foreach ( $refer as $key => $val ) {
                $resultSet[] = &$list[$key];
            }

            return $resultSet;
        }

        return false;
    }

    /**
     * 把返回的数据集转换成Tree.
     * @param array  $list  要转换的数据集
     * @param string $pid   parent标记字段
     * @param string $level level标记字段
     * @return array
     */
    function list_to_tree($list, $pk = 'id', $pid = 'pid', $child = '_child', $root = 0)
    {
        // 创建Tree
        $tree = [];
        if ( is_array($list) ) {
            // 创建基于主键的数组引用
            $refer = [];
            foreach ( $list as $key => $data ) {
                $refer[$data[$pk]] = &$list[$key];
            }
            foreach ( $list as $key => $data ) {
                // 判断是否存在parent
                $parentId = $data[$pid];
                if ( $root == $parentId ) {
                    $tree[] = &$list[$key];
                } else {
                    //XXX:已经修复需要确认http://stackoverflow.com/questions/20053269/indirect-modification-of-overloaded-element-of-splfixedarray-has-no-effect
                    if ( isset($refer[$parentId]) ) {
                        $parent = &$refer[$parentId];
//                                             $temp=& $list[$key];
//                                             $temp[]=$temp;
//                                             $parent[$child]=$temp;
                        $parent[$child][] = &$list[$key];
                    }
                }
            }
        }

        return $tree;
    }

    /**
     * 将list_to_tree的树还原成列表.
     * @param array  $tree  原来的树
     * @param string $child 孩子节点的键
     * @param string $order 排序显示的键，一般是主键 升序排列
     * @param array  $list  过渡用的中间数组，
     * @return array 返回排过序的列表数组
     */
    function tree_to_list($tree, $child = '_child', $order = 'id', &$list = [])
    {
        if ( is_array($tree) ) {
            foreach ( $tree as $key => $value ) {
                $reffer = $value;
                if ( isset($reffer[$child]) ) {
                    unset($reffer[$child]);
                    tree_to_list($value[$child], $child, $order, $list);
                }
                $list[] = $reffer;
            }
            $list = list_sort_by($list, $order, $sortby = 'asc');
        }

        return $list;
    }

    /**
     * 获取顶级模型信息.
     */
    function get_top_model($model_id = null)
    {
        $map = ['status' => 1, 'extend' => 0];
        if ( !is_null($model_id) ) {
            $map['id'] = ['neq', $model_id];
        }
        $model = Db::name('Model')->where($map)->field(true)->select();
        foreach ( $model as $value ) {
            $list[$value['id']] = $value;
        }

        return $list;
    }

    /**
     * 获取文档模型信息.
     * @param int    $id    模型ID
     * @param string $field 模型字段
     * @return array
     */
    function get_document_model($id = null, $field = null)
    {
        static $list;

        /* 非法分类ID */
        if ( !(is_numeric($id) || is_null($id)) ) {
            return '';
        }

        /* 读取缓存数据 */
        if ( empty($list) ) {
            $list = Cache::get('document_model_list');
        }

        /* 获取模型名称 */
        if ( empty($list) ) {
            $map = ['status' => 1, 'extend' => 1];
            $model = Db::name('Model')->where($map)->select();
            foreach ( $model as $value ) {
                $list[$value['id']] = $value;
            }
            Cache::set('document_model_list', $list); //更新缓存
        }

        /* 根据条件返回数据 */
        if ( is_null($id) ) {
            return $list;
        } elseif ( is_null($field) ) {
            return $list[$id];
        } else {
            return $list[$id][$field];
        }
    }

    //基于数组创建目录和文件
    function create_dir_or_files($files)
    {
        foreach ( $files as $key => $value ) {
            if ( substr($value, -1) == '/' ) {
                mkdir($value);
            } else {
                @file_put_contents($value, '');
            }
        }
    }

    if ( !function_exists('array_column') ) {
        function array_column(array $input, $columnKey, $indexKey = null)
        {
            $result = [];
            if ( null === $indexKey ) {
                if ( null === $columnKey ) {
                    $result = array_values($input);
                } else {
                    foreach ( $input as $row ) {
                        $result[] = $row[$columnKey];
                    }
                }
            } else {
                if ( null === $columnKey ) {
                    foreach ( $input as $row ) {
                        $result[$row[$indexKey]] = $row;
                    }
                } else {
                    foreach ( $input as $row ) {
                        $result[$row[$indexKey]] = $row[$columnKey];
                    }
                }
            }

            return $result;
        }
    }
    /**
     * 获取文档封面图片.
     * @param int    $cover_id
     * @param string $field
     * @return 完整的数据 或者  指定的$field字段值
     */
    function get_cover($cover_id, $field = null)
    {
        if ( empty($cover_id) ) {
            return false;
        }
        $picture = \app\file\model\Picture::where('status', 1)->getById($cover_id);
        if ( $field == 'path' ) {
            if ( !empty($picture['url']) ) {
                $picture['path'] = $picture['url'];
            } else {
                $picture['path'] = $picture['path'];
            }
        }

        return empty($field) ? $picture : $picture[$field];
    }

    /**
     * 远程调用插件控制器的操作方法.
     * @param string                 $url
     * @param array|string|bool|null $vars
     */
    function addon($url, $vars)
    {
        $info = pathinfo($url);
        $action = $info['basename'];
        $module = $info['dirname'];
        $class_name = 'addon\\' . Loader::parseName($module) . '\controller\\' . $module;
        $class = Loader::controller($class_name);
        if ( $class ) {
            return call_user_func([&$class, $action . Config::get('action_suffix')], $vars);
        } else {
            return false;
        }
    }

    /**
     * 获取插件类的类名.
     * @param        $name 插件名
     * @param string $type 返回命名空间类型
     * @return string
     */
    function get_addon_class($name, $type = 'hook')
    {
        switch ( $type ) {
            case 'controller':
                $namespace = '\\addon\\' . Loader::parseName($name) . '\\controller';
                break;
            default:
                $namespace = '\\addon\\' . Loader::parseName($name) . '\\' . Loader::parseName($name, 1);
        }

        return $namespace;
    }

    /**
     * 获取插件类的配置文件数组.
     * @param string $name 插件名
     * @return array
     */
    function get_addon_config($name)
    {
        $class = get_addon_class($name);
        if ( class_exists($class) ) {
            $addon = new $class();

            return $addon->getConfig();
        } else {
            return [];
        }
    }

    /**
     * 插件显示内容里生成访问插件的url.
     * @param string $url   url
     * @param array  $param 参数
     */
    function addon_url($url, $param = [])
    {
        $url = parse_url($url);
        $case = Config::get('url_convert');
        $addon = $case ? Loader::parseName($url['scheme']) : $url['scheme'];
        $controller = $case ? Loader::parseName($url['host']) : $url['host'];
        $action = trim($case ? strtolower($url['path']) : $url['path'], '/');
        /* 解析URL带的参数 */
        if ( isset($url['query']) ) {
            parse_str($url['query'], $query);
            $param = array_merge($query, $param);
        }
        /* 基础参数 */
        $params = [
            '_addon' => $addon,
            '_controller' => $controller,
            '_action' => $action,
        ];
        $params = array_merge($params, $param); // 添加额外参数

        return Url::build('app\common\addon\Execute@index', $params);
    }

    /**
     * 将字符保密输出
     * @param     $str
     * @param int $start  从第几个位置开始加密(从1开始)
     * @param int $length 连续加密多少位
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/4 11:33
     */
    function secrecy_show($str, $start = null, $length = null)
    {
        $array = preg_split('/(?<!^)(?!$)/u', $str );
        $start = is_null($start) ? abs(count($array) / 3) : $start;
        $length = is_null($length) ? (2 * abs(count($array) / 3)) : $start;
        $end = $start - 1 + $length;
        foreach ( $array as $k => $v ) {
            if ( $k >= $start - 1 && $k < $end ) {
                $array[$k] = '*';
            }
        }
        return implode('', $array);
    }