<?php

// +----------------------------------------------------------------------
// | builder
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\common\builder;

use app\file\model\Attachment as AttachmentModel;
use think\Db;
use think\facade\Hook;
use think\Loader;
use think\facade\Url;
use think\Exception;
use app\file\model\Picture as PictureModel;

/**
 * Class Lists.
 * @method warning 页面警告信息
 */
class Lists extends Builder
{
    private $_title;

    private $_suggest;

    private $_warning;

    private $_keyList = [];

    private $_buttonList = [];
    // 是否分页
    private $_pagination = true;

    private $_data = [];

    private $_searchPostUrl;

    private $_selectPostUrl;

    private $_setClearUrl;

    private $_search = [];

    private $_search_more = [];

    private $_select = [];

    private $_group = [];

    private $_hidden = [];

    private $_callback = '';

    private $_callback_field = '';
    /**
     * 当前行样式
     * @var unknown
     */
    private $_row_style;

    // 默认配置值
    // 默认获取主键的字段
    protected $_default_pk = 'id';
    // 默认获取状态的字段
    protected $_default_status = 'status';

    protected function initialize()
    {
        if ($this->request->param('callback', '')) {
            $this->_callback = $this->request->param('callback');
            $this->_callback_field = trim($this->request->param('field'));
        }
    }

    /**
     * 配置默认主键.
     * @param $pk
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:35
     */
    public function setDefaultPk($pk)
    {
        $this->_default_pk = $pk;
        return $this;
    }

    /**
     * 配置默认status.
     * @param $status
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:35
     */
    public function setDefaultStatus($status)
    {
        $this->_default_status = $status;
    }

    /**
     * 设置页面标题
     * @param $title
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:34
     */
    public function title($title)
    {
        $this->_title = $title;
        return $this;
    }

    /**
     * 设置页面隐藏数据
     * @param $name
     * @param $value
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:34
     */
    public function hidden($name, $value)
    {
        $this->_hidden[] = [
            'name' => $name,
            'value' => $value,
        ];
        return $this;
    }

    /**
     * suggest 页面标题边上的提示信息
     * @param $suggest
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:34
     */
    public function suggest($suggest)
    {
        $this->_suggest = $suggest;
        return $this;
    }

    /**
     * warning 页面标题边上的错误信息
     * @param $warning
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:34
     */
    public function warning($warning)
    {
        $this->_warning = $warning;
        return $this;
    }

    /**
     * 设置回收站根据ids彻底删除的URL
     * @param $url
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:34
     */
    public function setClearUrl($url)
    {
        $this->_setClearUrl = $url;

        return $this;
    }

    /**
     * 筛选下拉选择url
     * @param $url
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:33
     */
    public function setSelectPostUrl($url)
    {
        $this->_selectPostUrl = Url::build($url);

        return $this;
    }

    /**
     * 设置搜索提交表单的URL 更新筛选搜索功能
     * @param string $url 提交的getURL
     * @param array $param GET参数
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:33
     */
    public function setSearchPostUrl($url, $param = [])
    {
        $this->_searchPostUrl = Url::build($url, $param);
        return $this;
    }

    /**
     * 加入一个按钮
     * @param $title
     * @param $attr
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:33
     */
    public function button($title, $attr)
    {
        $this->_buttonList[] = [
            'title' => $title,
            'attr' => $attr,
        ];

        return $this;
    }

    /**
     * 加入新增按钮.
     * @param        $href
     * @param string $title
     * @param array $attr
     * @return Lists
     */
    public function buttonNew($href, $title = '新增', $width = '', $height = '', $attr = [])
    {
        $default['href'] = $href;
        $default['class'] = 'btn btn-green';
        $default['data-icon'] = 'plus';
        $default['data-width'] = $width ?: $this->dialog_width_default;
        $default['data-height'] = $height ?: $this->dialog_height_default;
        $default['data-title'] = $title != '新增' ? $title : $this->request->controller() . '新增';
        $default['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-add-' . $this->request->time());

        return $this->buttonDialog($title, array_merge($default, $attr));
    }

    /**
     * 全屏操作
     * @param        $href
     * @param string $title
     * @param array $attr
     * @return Lists
     */
    public function buttonFull($href, $title = '新增', $icon = 'plus', $attr = [])
    {
        $default['href'] = $href;
        $default['class'] = 'btn btn-green';
        $default['data-icon'] = $icon;
        $default['data-mask'] = true;
        $default['data-max'] = true;
        $default['data-title'] = $title != '新增' ? $title : $this->request->controller() . '新增';
        $default['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-add-' . $this->request->time());

        return $this->buttonDialog($title, array_merge($default, $attr));
    }

    /**
     * 自定义按钮.
     * @param        $href
     * @param string $title
     * @param array $attr
     * @return Lists
     */
    public function buttonCustom($href, $title, $attr = [])
    {
        $attr['href'] = $href;
        $attr['class'] = isset($attr['class']) ? $attr['class'] : 'btn btn-green';
        $attr['data-width'] = isset($attr['data-width']) ? $attr['data-width'] : $this->dialog_width_default;
        $attr['data-height'] = isset($attr['data-height']) ? $attr['data-height'] : $this->dialog_height_default;
        $attr['data-toggle'] = 'dialog';
        $attr['data-title'] = $title ?: $this->request->controller();
        $attr['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-custom-' . $this->request->time());

        return $this->button($title, $attr);
    }

    /**
     * button的ajax操作.
     * @param 操作名称 $title
     * @param 参数数组 $attr
     * @param string $toggle
     * @return Lists
     */
    public function buttonDialog($title, $attr, $toggle = 'dialog')
    {
        return $this->button($title, array_merge($attr, [
            'data-toggle' => $toggle,
        ]));
    }

    /**
     * button的ajax操作.
     * @param 操作名称 $title
     * @param 参数数组 $attr
     * @param string $toggle
     * @return Lists
     */
    public function buttonAjax($url, $title, $toggle = 'doajax', $attr = [])
    {
        $attr['href'] = $url;
        $attr['class'] = isset($attr['class']) ? $attr['class'] : 'btn btn-default';
        if (!isset($attr['data-icon'])) {
            $attr['data-icon'] = 'refresh';
        }
        $attr['data-toggle'] = $toggle;

        return $this->button($title, $attr);
    }


    /**
     * 批量选定禁用按钮，必须有选定情况.
     * @param unknown $url
     * @param string $title
     * @param array $attr
     * @return Lists
     */
    public function buttonDisable($url, $title = '禁用', $attr = [])
    {
        $attr['class'] = 'btn btn-red';
        $attr['data-confirm-msg'] = '确定要' . $title . '么？';
        $attr['data-icon'] = 'minus-circle';
        $attr['type'] = 'button';

        return $this->buttonAjax($url, $title, 'doajaxchecked', $attr);
    }

    /**
     * 批量选定启用按钮，必须有选定情况.
     * @param unknown $url
     * @param string $title
     * @param array $attr
     * @return Lists
     */
    public function buttonEnable($url, $title = '启用', $attr = [])
    {
        $attr['class'] = 'btn btn-green';
        $attr['data-confirm-msg'] = '确定要' . $title . '么？';
        $attr['data-icon'] = 'check-circle-o';
        $attr['type'] = 'button';

        return $this->buttonAjax($title, $attr, 'doajaxchecked', $attr);
    }

    /**
     * 批量选定删除到回收站.
     * @param string $url
     * @param string $title
     * @param array $attr
     * @return Lists
     */
    public function buttonDelete($url, $title = '删除选中', $attr = [])
    {
        $attr['class'] = 'btn-blue';
        $attr['data-confirm-msg'] = '确定要' . $title . '么？';
        $attr['data-icon'] = 'trash-o';
        $attr['data-idname'] = 'id';
        $attr['data-group'] = 'ids';
        $attr['type'] = 'button';

        return $this->buttonAjax($url, $title, 'doajaxchecked', $attr);
    }

    /**
     * 无条件ajax请求
     * @param string $url
     * @param string $title
     * @return Lists
     */
    public function buttonDeleteAll($url, $title = '删除所有', $attr = [])
    {
        $attr['class'] = 'btn btn-blue';
        $attr['data-confirm-msg'] = '确定要' . $title . '么？';
        $attr['data-icon'] = 'trash-o';

        return $this->buttonAjax($url, $title, 'doajax', $attr);
    }

    /**
     * 无条件ajax请求
     * @param string $url
     * @param string $title
     * @param array $attr
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/14 12:52
     */
    public function buttonRefresh($url, $title = '刷新', $attr = [])
    {
        !isset($attr['class']) && $attr['class'] = 'btn btn-blue';
        //         $attr['data-icon'] = 'trash-o';
        return $this->buttonAjax($url, $title, 'doajax', $attr);
    }

    /**
     * 根据指定条件还原禁用.
     * @param string $url
     * @param string $title
     * @param array $attr
     * @return Lists
     */
    public function buttonRestore($url, $title = '还原', $attr = [])
    {
        $attr['class'] = 'btn-blue';
        $attr['data-confirm-msg'] = '确定要' . $title . '么？';
        $attr['data-icon'] = 'undo';
        $attr['type'] = 'button';
        return $this->buttonAjax($url, $title, 'doajaxchecked', $attr);
    }

    /**
     * 彻底删除回收站.
     * @param null $url
     * @return Lists
     */
    public function buttonClear($url = null)
    {
        if (!$url) {
            $url = $this->_setClearUrl;
        }
        $attr['class'] = 'btn ajax-post tox-confirm';
        $attr['data-confirm'] = '您确实要彻底删除吗？（彻底删除后不可恢复）';
        $attr['url'] = $url;
        $attr['target-form'] = 'ids';

        return $this->button('彻底删除', $attr);
    }

    public function buttonSort($href, $title = '排序', $attr = [])
    {
        $attr['href'] = $href;

        return $this->button($title, $attr);
    }

    /**
     * 复选框操作.
     * @param 选选名字 $title
     * @param 提示 $msg
     * @param 操作url $url
     * @return Lists
     * @author  微尘 <yicmf@qq.com>
     * @version v1.0.1
     */
    public function groupAction($title, $url, $msg, $toggle, $idname = null, $group = null, $class = null, $br = null)
    {
        $this->_group[] = [
            'msg' => $msg,
            'title' => $title,
            'url' => $url,
            'toggle' => $toggle,
            'idname' => $idname,
            'group' => $group,
            'class' => $class,
            'br' => $br,
        ];

        return $this;
    }

    public function groupOutxls($url = '', $title = '导出<span style="color: green;">全部</span>', $msg = '确定要导出信息吗？')
    {
        $url = $url ? $url : $this->request->controller() . '/outxls';
        $toggle = 'doexport';

        return $this->groupAction($title, $url, $msg, $toggle);
    }

    public function groupOutxlsCheck($url = '', $title = '导出<span style="color: red;">选中</span>', $msg = '确定要导出选中项吗？')
    {
        $url = $url ? $url : $this->request->controller() . '/outxls_check';
        $toggle = 'doexportchecked';
        $idname = 'expids';
        $group = 'ids';

        return $this->groupAction($title, $url, $msg, $toggle, $idname, $group);
    }

    public function groupDel($url = '', $title = '删除选中', $msg = '确定要删除选中项吗？')
    {
        $url = $url ? $url : $this->request->controller() . '/del';
        $toggle = 'doajaxchecked';
        $idname = 'id';
        $group = 'ids';

        return $this->groupAction($title, $url, $msg, $toggle, $idname, $group);
    }

    public function groupBr($class = 'divider')
    {
        return $this->groupAction(null, null, null, null, null, null, $class, 1);
    }

    /**
     * 搜索.
     * @param string $title 标题
     * @param string $name 键名
     * @param string $type 类型，默认文本
     * @param string $des 描述
     * @param        $attr  标签文本
     * @return $this @auth
     */
    /*
 * public function search($title = '搜索', $name = 'key', $type = 'text', $des = '', $attr) { $this->_search[] = array( 'title' => $title, 'name' => $name, 'type' => $type, 'des' => $des, 'attr' => $attr ); return $this; }
 */

    /**
     * 搜索text文本信息.
     * @param string $title
     * @param string $name
     * @param string $type
     * @param string $des
     * @param array $attr
     * @return $this
     */
    public function searchText($name, $title, $des = '', $attr = [])
    {
        $this->_search[] = [
            'title' => $title,
            'name' => $name,
            'type' => 'text',
            'des' => $des,
            'attr' => $attr,
        ];

        return $this;
    }

    /**
     * 时间搜索.
     * @param unknown $name
     * @param unknown $title
     * @param array $attr
     * @return $this
     */
    public function searchTime($name, $title, $attr = [])
    {
        $this->_search[] = [
            'title' => $title,
            'name' => $name,
            'type' => 'datepicker',
            'attr' => $attr,
        ];

        return $this;
    }

    /**
     * 选择搜索
     * @param        $name
     * @param        $title
     * @param array $options
     * @param string $des
     * @param array $attr
     * @param string $arrdb
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/5/8 13:15
     */
    public function searchSelect($name, $title, $options = [], $des = '', $attr = [], $arrdb = '')
    {
        $this->_search[] = [
            'title' => $title,
            'name' => $name,
            'type' => 'select',
            'des' => $des,
            'attr' => $attr,
            'field' => '',
            'table' => '',
            'options' => $options,
        ];

        return $this;
    }

    /**
     * 高级选择搜索.
     * @param unknown $name
     * @param unknown $title
     * @param unknown $options
     * @param array $attr
     * @param string $arrdb
     * @return $this
     */
    public function searchMoreSelect($name, $title, $options = null, $attr = [], $arrdb = '')
    {
        $this->_search_more[] = [
            'title' => $title,
            'name' => $name,
            'type' => 'select',
            'des' => '',
            'attr' => $attr,
            'field' => '',
            'table' => '',
            'options' => $options,
        ];

        return $this;
    }

    /**
     * 高级时间搜索.
     * @param unknown $name
     * @param unknown $title
     * @param array $attr
     * @return $this
     */
    public function searchMoreTime($name, $title, $attr = [])
    {
        $this->_search_more[] = [
            'title' => $title,
            'name' => $name,
            'type' => 'datepicker',
            'attr' => $attr,
        ];

        return $this;
    }

    /**
     * 高级时间搜索.
     * @param unknown $name
     * @param unknown $title
     * @param array $attr
     * @return $this
     */
    public function searchMoreText($name, $title, $des = '', $attr = [])
    {
        $this->_search[] = [
            'title' => $title,
            'name' => $name,
            'type' => 'text',
            'des' => $des,
            'attr' => $attr,
        ];

        return $this;
    }

    /**
     * 更新筛选搜索功能 ，修正连续提交多出N+个GET参数的BUG.
     * @param string $title 标题
     * @param string $name 键名
     * @param string $type 类型，默认文本
     * @param string $des 描述
     * @param        $attr     标签文本
     * @param string $arrdb 择筛选项数据来源
     * @param string $options 筛选数据（包含ID 和value的数组:array(array('id'=>1,'value'=>'系统'),array('id'=>2,'value'=>'项目'),array('id'=>3,'value'=>'机构'));）
     * @return $this
     */
    public function search($title = '搜索', $name = 'key', $type = 'text', $des = '', $attr = [], $arrdb = '', $options = null)
    {
        if (empty($type) && $type = 'text') {
            $this->_search[] = [
                'title' => $title,
                'name' => $name,
                'type' => $type,
                'des' => $des,
                'attr' => $attr,
            ];
        } else {
            if (empty($arrdb)) {
                $field = ''; // TODO:暂时不清楚原因
                $table = '';
                $this->_search[] = [
                    'title' => $title,
                    'name' => $name,
                    'type' => $type,
                    'des' => $des,
                    'attr' => $attr,
                    'field' => $field,
                    'table' => $table,
                    'options' => $options,
                ];
            } else {
                // TODO:需完善如果$arrdb存在的就把当前数据表的$name字段的信息全部查询出来供筛选。
            }
        }

        return $this;
    }

    /**
     * 更新筛选搜索功能 ，修正连续提交多出N+个GET参数的BUG.
     * @param string $title 标题
     * @param string $name 键名
     * @param string $type 类型，默认文本
     * @param string $des 描述
     * @param        $attr     标签文本
     * @param string $arrdb 择筛选项数据来源
     * @param string $options 筛选数据（包含ID 和value的数组:array(array('id'=>1,'value'=>'系统'),array('id'=>2,'value'=>'项目'),array('id'=>3,'value'=>'机构'));）
     * @return $this
     */
    public function searchMore($title = '搜索', $name = 'key', $type = 'text', $des = '', $attr = [], $arrdb = '', $options = null)
    {
        if (empty($type) && $type = 'text') {
            $this->_search_more[] = [
                'title' => $title,
                'name' => $name,
                'type' => $type,
                'des' => $des,
                'attr' => $attr,
            ];
            $this->setSearchPostUrl('', $name, $_GET[$name]);
        } else {
            if (empty($arrdb)) {
                $field = ''; // TODO:暂时不清楚原因
                $table = '';
                $this->_search_more[] = [
                    'title' => $title,
                    'name' => $name,
                    'type' => $type,
                    'des' => $des,
                    'attr' => $attr,
                    'field' => $field,
                    'table' => $table,
                    'options' => $options,
                ];
                // $this->setSearchPostUrl('',$field,$_GET[$field]);
            } else {
                // TODO:需完善如果$arrdb存在的就把当前数据表的$name字段的信息全部查询出来供筛选。
            }
        }

        return $this;
    }

    /**
     * 添加筛选功能.
     * @param string $title 标题
     * @param string $name 键名
     * @param string $type 类型，默认文本
     * @param string $des 描述
     * @param        $attr     标签文本
     * @param string $arrdb 择筛选项数据来源
     * @param string $options 筛选数据（包含ID 和value的数组:array(array('id'=>1,'value'=>'系统'),array('id'=>2,'value'=>'项目'),array('id'=>3,'value'=>'机构'));）
     * @return $this
     * @author
     */
    public function select($title, $name, $type, $des, $attr, $arrdb = '', $options = null)
    {
        if (empty($arrdb)) {
            $this->_select[] = [
                'title' => $title,
                'name' => $name,
                'type' => $type,
                'des' => $des,
                'attr' => $attr,
                'options' => $options,
            ];
        } else {
            // TODO:呆完善如果$arrdb存在的就把当前数据表的$name字段的信息全部查询出来供筛选。
        }

        return $this;
    }

    /**
     * 需要展示的键值
     * @param       $name
     * @param       $title
     * @param       $type
     * @param array $opt
     * @param bool $sort
     * @param null $width
     * @param array $param
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/20 12:42
     */
    public function key($name, $title, $type, $opt = [], $sort = false, $width = null, $param = [])
    {
        $key = [
            'name' => $name,
            'title' => $title,
            'type' => $type,
            'sort' => $sort,
            'width' => $width,
            'opt' => $opt,
            'param' => $param,
        ];
        $this->_keyList[] = $key;

        return $this;
    }

    /**
     * 显示纯文本
     * @param string $name 键名
     * @param string $title 标题
     * @param bool $sort 排序方式，默认是不参与排序
     * @param null $width
     * @param array $opt
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:31
     */
    public function keyText($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, text($title), 'text', $opt, $sort, $width);
    }

    /**
     * 显示金额
     * @param string $name 键名
     * @param string $title 标题
     * @param bool $sort 排序方式，默认是不参与排序
     * @param null $width
     * @param array $opt
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:32
     */
    public function keyDecimal($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, text($title), 'decimal', $opt, $sort, $width);
    }

    /**
     * 显示颜色.
     * @param string $name 键名
     * @param string $title 标题
     * @param bool $sort 排序方式，默认是不参与排序
     * @param null $width
     * @param array $opt
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:32
     */
    public function keyColor($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, text($title), 'color', $opt, $sort, $width);
    }

    /**
     * 创建时间
     * @param string $title
     * @param string $format
     * @param bool $sort
     * @param null $width
     * @param array $opt
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 10:52
     */
    public function keyCreateTime($title = '创建时间', $format = 'm-d H:i', $sort = false, $width = null, $opt = [])
    {
        return $this->keyTime('create_time', text($title), $format, $sort, $sort, $width);
    }

    /**
     * 更新时间
     * @param string $title
     * @param string $format
     * @param bool $sort
     * @param null $width
     * @param array $opt
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 10:52
     */
    public function keyUpdateTime($title = '更新时间', $format = 'm-d H:i', $sort = false, $width = null, $opt = [])
    {
        return $this->keyTime('update_time', text($title), $format, $sort, $sort, $width);
    }

    /**
     * 时间
     * @param string $name 键名
     * @param string $title 标题
     * @param string $format
     * @param bool $sort
     * @param null $width
     * @param array $opt
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/28 13:31
     */
    public function keyTime($name, $title, $format = 'm-d H:i', $sort = false, $width = null, $opt = [])
    {
        $opt['format'] = $format;
        return $this->key($name, text($title), 'time', $opt, $sort, $width);
    }

    /**
     * 邮件地址
     * @param       $name
     * @param       $title
     * @param bool $sort
     * @param null $width
     * @param array $opt
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 12:57
     */
    public function keyEmail($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, text($title), 'email', $opt, $sort, $width);
    }

    /**
     * 显示html
     * @param $name
     * @param $title
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 12:57
     */
    public function keyHtml($name, $title)
    {
        return $this->key($name, $title, 'html');
    }

    public function keyMap($name, $title, $map)
    {
        return $this->key($name, $title, 'map', $map);
    }

    public function keyId($name = 'id', $title = 'ID', $sort = 'desc', $width = null, $opt = [])
    {
        return $this->keyText($name, $title, $sort, $width, $opt);
    }

    public function keyYesNo($name, $title, $map = [])
    {
        $map = empty($map) ? [
            0 => '<i class="fa fa-times red" aria-hidden="true"></i>',
            1 => '<i class="fa fa-check green" aria-hidden="true"></i>',
        ] : $map;
        return $this->keyMap($name, $title, $map);
    }

    public function keyBool($name, $title, $sort = 'desc', $width = null, $opt = [])
    {
        return $this->keyYesNo($name, $title);
    }

    public function keyAvatar($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, $title, 'avatar', $opt, $sort, $width);
    }

    public function keyImage($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, $title, 'image', $opt, $sort, $width);
    }

    public function keyMedia($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, $title, 'media', $opt, $sort, $width);
    }

    public function keyUser($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, $title, 'user', $opt, $sort, $width);
    }

    public function keyAuthor($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, $title, 'author', $opt, $sort, $width);
    }

    public function keyDistrict($name, $title, $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, $title, 'district', $opt, $sort, $width);
    }

    public function keyIp($name = 'ip', $title = 'IP地址', $sort = false, $width = null, $opt = [])
    {
        return $this->key($name, $title, 'ip', $opt, $sort, $width);
    }

    public function keyTitle($name = 'title', $title = '标题', $sort = false, $width = null, $opt = [])
    {
        return $this->keyText($name, $title, $sort, $width, $opt);
    }

    /**
     * 闭包函数
     * @param string $name
     * @param string $title
     * @param        $closure
     * @param bool $sort
     * @param null $width
     * @param array $opt
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/20 12:53
     */
    public function keyClosure($name, $title, $closure, $sort = false, $width = null, $opt = [])
    {

        return $this->key($name, text($title), $closure, $opt, $sort, $width);
    }

    /**
     * @param $name
     * @param $title
     * @param $getUrl Closure|string 可以是函数或U函数解析的字符串。如果是字符串，该函数将附带一个id参数
     * @return Lists
     */
    public function keyLink($name, $title, $getUrl, $target = '_self')
    {
        // 修整添加多个空字段时显示不正常的
        if (empty($name)) {
            $name = $title;
        }
        // 添加key
        return $this->key($name, $title, 'link', ['url' => $getUrl, 'target' => $target]);
    }

    public function keyDialog($title, $getUrl, $arr = null)
    {
        $arr['class'] = 'btn btn-green btn';
        $arr['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-defalut-' . $this->request->time());
        $arr['data-icon'] = isset($arr['icon']) ? $arr['icon'] : 'plus';
        $arr['data-toggle'] = 'dialog';
        $arr['data-width'] = isset($arr['width']) ? $arr['width'] : $this->dialog_width_default;
        $arr['data-height'] = isset($arr['height']) ? $arr['height'] : $this->dialog_height_default;
        $arr['href'] = $getUrl;
        // 添加key
        return $this->key(null, $title, 'dialog', $arr);
    }

    public function keyStatus($name = 'status', $title = '状态', $map = null)
    {
        $map = $map ?: [
            -2 => '<i class="fa fa-trash-o red" aria-hidden="true"></i> 已删除',
            -1 => '<i class="fa fa-minus-circle red" aria-hidden="true"></i> 禁用',
            1 => '<i class="fa fa-check-square-o green" aria-hidden="true"></i> 启用',
            0 => '<i class="fa fa-question red" aria-hidden="true"></i> 未审核',
            2 => '<i class="fa fa-thumbs-o-up green" aria-hidden="true"></i> 推荐',
        ];

        return $this->key($name, $title, 'status', $map);
    }

    public function keyDoAction($getUrl, $text, $attr = [], $status = [], $title = '操作', $disable = false)
    {
        // 确认已经创建了doactions字段
        $doActionKey = null;
        foreach ($this->_keyList as $key) {
            if ($key['name'] === 'doactions') {
                $doActionKey = $key;
                break;
            }
        }
        if (!$doActionKey) {
            $this->key('doactions', $title, 'doaction', []);
        }

        // 找出第一个doactions字段
        $doActionKey = null;
        foreach ($this->_keyList as &$key) {
            if ($key['name'] == 'doactions') {
                $doActionKey = &$key;
                break;
            }
        }
        $attr['class'] = !empty($attr['class']) ? $attr['class'] : 'btn btn-green btn-sm';
        $attr['data-id'] = !empty($attr['data-id']) ? $attr['data-id'] : ('id' . md5('dialog-' . $this->request->controller() . '-defalut-' . $this->request->time()));
        $attr['data-icon'] = !empty($attr['data-icon']) ? $attr['data-icon'] : 'pencil-square-o';
        if (empty($status)) {
            $status = [-1, 0, 1, 2];
        }
        $action['status'] = $status;
        $action['get_url'] = $getUrl;
        $action['attr'] = $attr;
        $action['text'] = $text;
        $action['disable'] = $disable;
        // 在doactions中增加action
        $doActionKey['opt']['actions'][] = $action;
        return $this;
    }

    /**
     * 新页面功能<a href="doc/chart/highcharts.html" data-toggle="navtab" data-id="doc-highcharts" data-title="Highcharts图表说明">使用说明</a>.
     * @param unknown $getUrl
     * @param string $text
     * @param unknown $arr
     * @return Lists
     */
    public function keyDoActionMask($getUrl, $text = '编辑', $status = [], $attrs = [])
    {
        $attr['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-mask-' . $this->request->time());
        $attr['class'] = 'btn btn-green btn-sm';
        $attr['data-toggle'] = 'dialog';
        $attr['data-maxable'] = 'true';
        $attr['data-resizable'] = false;
        $attr['data-drawable'] = 'false';
        $attr['data-maxable'] = 'false';
        $attr['data-mask'] = 'true';
        $attr['data-icon'] = !empty($attr['icon']) ? $attr['icon'] : 'pencil-square-o';
        $attr['data-width'] = isset($attrs['width']) ? $attrs['width'] : $this->dialog_width_default;
        $attr['data-height'] = isset($attrs['height']) ? $attrs['height'] : $this->dialog_height_default;

        return $this->keyDoAction($getUrl, $text, array_merge($attr, $attrs), $status);
    }

    public function keyDoActionFull($getUrl, $text = '全屏', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-green btn-sm';
        $attr['data-toggle'] = 'dialog';
        $attr['data-maxable'] = 'false';
        $attr['data-max'] = 'true';
        $attr['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-edit-full-' . $this->request->time());
        $attr['data-icon'] = !empty($attr['icon']) ? $attr['icon'] : 'pencil-square-o';

        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }

    public function keyDoActionEdit($getUrl, $text = '编辑', $status = [], $attrs = [])
    {
        $attr['class'] = 'btn btn-green btn-sm';
        $attr['data-toggle'] = 'dialog';
        $attr['data-width'] = isset($attrs['width']) ? $attrs['width'] : $this->dialog_width_default;
        $attr['data-height'] = isset($attrs['height']) ? $attrs['height'] : $this->dialog_height_default;
        $attr['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-edit' . $this->request->time());
        $attr['data-icon'] = 'pencil-square-o';

        return $this->keyDoAction($getUrl, $text, array_merge($attr, $attrs), $status);
    }

    public function keyNoAction($text = '不可操作', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-red btn-sm';
        $attr['data-icon'] = 'square';

        return $this->keyDoAction('', $text, $attr, $status, '', true);
    }

    /**
     * 较大的操作框
     * @param        $getUrl
     * @param string $text
     * @param array $status
     * @param array $attr
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 16:16
     */
    public function keyDoActionBig($getUrl, $text = '编辑', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-green btn-sm';
        $attr['data-toggle'] = 'dialog';
        $attr['data-width'] = !empty($attr['width']) ? $attr['width'] : '1200';
        $attr['data-height'] = !empty($attr['height']) ? $attr['height'] : '730';
        $attr['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-edit-' . $this->request->time());
        $attr['data-icon'] = 'pencil-square-o';

        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }

    public function keyDoActionView($getUrl, $text = '查看详情', $status = [], $attrs = [])
    {
        $attr['class'] = 'btn btn-green btn-sm';
        $attr['data-toggle'] = 'dialog';
        $attr['data-width'] = $this->dialog_width_default;
        $attr['data-height'] = $this->dialog_height_default;
        $attr['data-width'] = isset($attrs['width']) ? $attrs['width'] : $this->dialog_width_default;
        $attr['data-height'] = isset($attrs['height']) ? $attrs['height'] : $this->dialog_height_default;
        $attr['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-view-' . $this->request->time());
        $attr['data-mask'] = 'false';
        $attr['data-icon'] = 'search';
        $status = empty($status) ? [
            0,
            1,
            2,
        ] : $status;

        return $this->keyDoAction($getUrl, $text, array_merge($attr, $attrs), $status);
    }

    public function keyDoActionManager($getUrl, $text = '授权', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-green btn-sm';
        $attr['data-toggle'] = 'navtab';
        $attr['data-width'] = $this->dialog_width_default;
        $attr['data-height'] = $this->dialog_height_default;
        $attr['data-id'] = 'id' . md5('dialog-' . $this->request->controller() . '-manager-' . $this->request->time());
        $attr['data-icon'] = 'asterisk';
        $status = empty($status) ? [
            0,
            1,
            2,
        ] : $status;

        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }


    public function keyDoActionLink($getUrl, $text, $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-green';
        $attr['data-toggle'] = 'navtab';
        $attr['data-icon'] = 'external-link';
        $status = empty($status) ? [
            -1,
            0,
            1,
            2,
        ] : $status;

        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }

    public function keyDoActionDel($getUrl, $text = '删除', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-red';
        $attr['data-toggle'] = 'doajax';
        $attr['data-confirm-msg'] = '确定删除么？';
        $attr['data-icon'] = 'trash-o';
        $status = empty($status) ? [
            -1,
            0,
            1,
            2,
        ] : $status;

        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }

    public function keyDoActionClear($getUrl, $text = '彻底删除', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-red';
        $attr['data-toggle'] = 'doajax';
        $attr['data-confirm-msg'] = '确定彻底删除么？';
        $attr['data-icon'] = 'trash-o';
        $status = empty($status) ? [
            -2,
        ] : $status;

        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }

    /**
     * 禁用
     * @param        $getUrl
     * @param string $text
     * @param array $status
     * @param array $attr
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 16:16
     */
    public function keyDoActionForbid($getUrl, $text = '禁用', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-red';
        $attr['data-toggle'] = 'doajax';
        $attr['data-confirm-msg'] = '确定' . $text . '么？';
        $attr['data-icon'] = 'minus-circle';
        $status = empty($status) ? [
            1,
            2,
        ] : $status;

        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }

    public function keyDoActionToCheck($getUrl, $text = '通过审核', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-green';
        $attr['data-toggle'] = 'doajax';
        $attr['data-confirm-msg'] = '确定' . $text . '么？';
        $attr['data-icon'] = 'check-square-o';
        $status = empty($status) ? [
            0,
        ] : $status;
        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }

    /**
     * 还原
     * @param string $getUrl
     * @param string $text
     * @param array $status
     * @param array $attr
     * @return Lists
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 18:19
     */
    public function keyDoActionRestore($getUrl, $text = '还原', $status = [], $attr = [])
    {
        $attr['class'] = 'btn btn-red';
        $attr['data-toggle'] = 'doajax';
        $attr['data-confirm-msg'] = '确定还原么？';
        $attr['data-icon'] = 'undo';
        $status = empty($status) ? [
            -1,
            -2,
        ] : $status;

        return $this->keyDoAction($getUrl, $text, $attr, $status);
    }

    /**
     * 设置行样式
     *      .active    鼠标悬停在行或单元格上时所设置的颜色
     *      .success    标识成功或积极的动作
     *      .info    标识普通的提示信息或动作
     *      .warning    标识警告或需要用户注意
     *      .danger    标识危险或潜在的带来负面影响的动作*
     *      例如：
     *      ->rowStyle(function($row){
     *           if (0== $row['status']) {
     *               return 'danger';
     *           }else {
     *               return '';
     *           }
     *       })
     * @param $function
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 18:19
     */
    public function rowStyle($function)
    {
        $this->_row_style = $function;
        return $this;
    }

    /**
     * 当前的数据信息.
     * @param array $data 分页信息
     * @param bool $pagination 是否启用分页
     * @return $this
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:56
     */
    public function data($data, $pagination = true)
    {
        $this->_data = $data;
        $this->_pagination = $pagination;
        return $this;
    }

    /**
     * 返回页面
     * @param string $template
     * @param array $vars
     * @param array $replace
     * @param array $config
     * @return string
     * @throws \Exception
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:54
     */
    public function fetch($template = '', $vars = [], $replace = [], $config = [])
    {
        // 编译buttonList中的属性
        foreach ($this->_buttonList as &$button) {
            $button['tag'] = 'button';
            $this->addDefaultCssClass($button);
            $button['attr'] = $this->compileHtmlAttr($button['attr']);
        }
        // 页码代码
        if ($this->_data && $this->_pagination) {
            $this->assign('has_page', 1);
            if (is_object($this->_data)) {
                // 对象;
                $this->assign('totalCount', $this->_data->total());
                $this->assign('currentPage', $this->_data->currentPage());
                $this->assign('numPerPage', $this->_data->listRows());
            } elseif (is_array($this->_data)) {
                $this->assign('totalCount', $this->_data['total']);
                $this->assign('currentPage', $this->_data['current_page']);
                $this->assign('numPerPage', $this->_data['per_page']);
            }
        }
        // 显示页面
        $this->assign('title', $this->_title);
        $this->assign('suggest', $this->_suggest);
        $this->assign('warning', $this->_warning);
        $this->assign('keyList', $this->_keyList);
        $this->assign('buttonList', $this->_buttonList);
        $this->assign('callback', $this->_callback);
        // 数据转换
        if ((!empty($this->_data) && is_object($this->_data)) || (!empty($this->_data) && empty($this->_data['data']))) {
            // 采用分页类||单纯的数据数组
            $list = [];
            foreach ($this->_data as $value) {
                $list[] = $this->convertKey($value);
            }
            $this->assign('list', $list);
        } elseif (!empty($this->_data['data']) && is_array($this->_data['data'])) {
            // 采用分页类
            $list = [];
            foreach ($this->_data['data'] as $value) {
                $list[] = $this->convertKey($value);
            }
            $this->assign('list', $list);
        }
        /*
         * 配置主键*
         */
        $this->assign('pk', $this->_default_pk);
        /* 加入搜索 */
        if (count($this->_search) > 0) {
            $this->assign('searches', $this->_search);
            if (count($this->_search_more) > 0) {
                $this->assign('search_more', $this->_search_more);
            }
        }
        $this->assign('searchPostUrl', empty($this->_searchPostUrl) ? $this->request->url() : $this->_searchPostUrl);
        /* 复选框 */
        $this->assign('group', $this->_group);
        /* 加入筛选select */
        $this->assign('selects', $this->_select);
        $this->assign('selectPostUrl', $this->_selectPostUrl);
        /* 加入隐藏表单 */
        $this->assign('hidden', $this->_hidden);
        return parent::fetch('lists', $vars, $config);
    }

    /**
     * 根据类型转换格式.
     */
    private function convertKey($data)
    {
        $conver_data = [];
        foreach ($this->_keyList as $key) {
            if ($key['type'] instanceof \Closure) {
                // 闭包
                $conver_data[$key['name']] = $key['type']($data);
            } else {
                $method = 'convert' . Loader::parseName($key['type'], 1) . 'Value';
                if ('doaction' === $key['type'] || 'dialog' === $key['type']) {
                    $conver_data[$key['name']] = $this->$method($key, $data);
                } else {
                    if (false !== strpos($key['name'], '{$')) {
                        $display = $key['name'];
                    } else {
                        $display = '{$data.' . $key['name'] . '}';
                    }
                    $view = $this->app['view'];
                    $value = $view->display($display, ['data' => $data]);
                    if (method_exists($this, $method)) {
                        $conver_data[$key['name']] = $this->$method($value, $key, $data);
                    } else {
                        $conver_data[$key['name']] = $value;
                    }
                }
            }
        }
        // 获取行样式
        $conver_data['_row_style'] = $this->convertRowStyle($data);
        return $conver_data;
    }

    /**
     * 获取当前行样式
     * @param $data
     * @return mixed|string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:13
     */
    private function convertRowStyle($data)
    {
        if ($this->_row_style instanceof \Closure) {
            return call_user_func_array($this->_row_style, [& $data]);
        } else {
            return '';
        }
    }

    /**
     * @param $value
     * @param $key
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/7 11:34
     */
    protected function convertMapValue($value, $key)
    {
        // map转换成text
        return isset($key['opt'][$value]) ? $key['opt'][$value] : '--无--';
    }

    /**
     * 增加颜色
     * @param $value
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:13
     */
    protected function convertColorValue($value)
    {
        // map转换成text
        return '<span style=\'color:' . $value . '\'>' . $value . '</span>';
    }

    /**
     * time转换为html
     * @param $value
     * @param $key
     * @return string
     * @throws \Exception
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 11:29
     */
    protected function convertTimeValue($value, $key)
    {
        // time转换成text
        if ('' === trim($value) || 0 === strpos($value, '0000')) {
            return '-';
        } elseif ($value != 0 && is_numeric($value)) {
            return '<span title="' . $value . '" style="cursor:pointer"><i class="fa fa-clock-o" aria-hidden="true"></i> ' . time_format($value) . '</span>';
        } elseif (!is_numeric($value) && isset($key['opt']['format'])) {
            return '<span title="' . $value . '" style="cursor:pointer"><i class="fa fa-clock-o" aria-hidden="true"></i> ' . time_format($value, $key['opt']['format']) . '</span>';
        } elseif (!is_numeric($value)) {
            return '<span title="' . $value . '" style="cursor:pointer"><i class="fa fa-clock-o" aria-hidden="true"></i> ' . $value . '</span>';
        } else {
            return '-';
        }
    }

    /**
     * 增加金额标记
     * @param $value
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 10:53
     */
    protected function convertDecimalValue($value)
    {
        return '<i class="fa fa-jpy"></i> ' . $value;
    }

    /**
     * email转换为html
     * @param $value
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 11:30
     */
    protected function convertEmailValue($value)
    {
        // email转换成text
        return '&nbsp;<i class="fa fa-envelope"></i>&nbsp;' . $value;
    }

    /**
     * district转换为html
     * @param $value
     * @return mixed|string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/2/22 11:30
     */
    protected function convertDistrictValue($value)
    {
        // 区域信息转换district
        if ($value != 0) {
            return Hook::listen('china_city_info', $value);
        } else {
            return '-';
        }
    }


    /**
     * link转换为html
     * @param $value
     * @param $key
     * @param $data
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:12
     */
    protected function convertLinkValue($value, $key, $data)
    {
        // link转换为html
        $value = htmlspecialchars($value);
        $url = $this->createUrlConvert($data, $key['opt']['url']);
        if ('_self' == $key['opt']['target']) {
            return '<a data-toggle="navtab"  href="' . $url . '" data-title=' . $key['title'] . ' >' . $value . '</a>';
        } else {
            return '<a href="' . $url . '" data-title=' . $key['title'] . '  target="' . $key['opt']['target'] . '">' . $value . '</a>';
        }
    }

    /**
     * 生成dialog
     * @param $key
     * @param $data
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:51
     */
    protected function convertDialogValue($key, $data)
    {
        // 获取操作url
        $key['opt']['href'] = $this->createUrlConvert($data, $key['opt']['href']);
        $param = $this->compileHtmlAttr($key['opt']);
        return "<a $param>" . $key['title'] . '</a>';
    }

    /**
     * 媒体文件显示
     * @param       $value
     * @param       $key
     * @param array $data
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/29 8:37
     */
    protected function convertMediaValue($value, $key, $data = [])
    {
        if (is_numeric($value)) {
            $data = AttachmentModel::find($value);
        }
        if ('mp4' == $data['ext']) {
            $html = '
                    <video  height="70" controls="controls">
                      <source src="' . $data['url'] . '" type="video/ogg">
                      <source src="' . $data['url'] . '" type="video/mp4">
                    您的浏览器暂不支持播放
                    </video>
                    ';
        } elseif ('mp3' == $data['ext']) {
            $html = '
                    <audio controls="controls" height="100" width="100">
                      <source src="' . $data['url'] . '" type="audio/mp3" />
                      <source src="' . $data['url'] . '" type="audio/ogg" />
                    <embed height="60" width="100" src="' . $data['url'] . '" />
                    </audio>';
        } else {
            $html = '暂不支持媒体格式';
        }
        return $html;
    }

    /**
     * image转换为html
     * @param $value
     * @param $key
     * @param $data
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/29 8:36
     */
    protected function convertImageValue($value, $key, $data)
    {
        // image转换为图片
        if (is_numeric($value)) { // value是图片id
            $picture = PictureModel::find($value);
            $html = '<div class="popup-gallery" ><a target="_black" title="查看大图" href="' . $picture['url_big'] . '"><img src="' . $picture['url_mini'] . '"  ></a></div>';
        } elseif (false !== strpos($value, ',')) {
            $ids = explode(',', $value);
            $html = '<div class=\'popup-gallery\' >';
            foreach ($ids as $id) {
                $id = htmlspecialchars($id);
                $sc_src = get_cover($id, 'path');
                $html .= "<a title=\"查看大图\" target=\"_black\" href=\"$sc_src\"><img src=\"$sc_src\"/  ></a>";
            }
            $html .= '</div>';
        } elseif ('url_mini' == $key['name']) {
            // 注意，此处为Picture模型专用
            $html = '<div class="popup-gallery" ><a  target="_black" title="查看大图" href="' . $data['url_big'] . '"><img   src="' . $value . '"/ ></a></div>';
        } else { // value是图片路径
            $html = '<div class="popup-gallery" ><a  target="_black" title="查看大图" href="' . $value . '"><img style="width: 100px;"  src="' . $value . '"/ ></a></div>';
        }

        return $html;
    }

    /**
     * 转换头像
     * @param $value
     * @param $key
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:52
     */
    protected function convertAvatarValue($value, $key)
    {
        // image转换为图片
        if (is_numeric($value)) { // value是图片id
            $value = htmlspecialchars($value);
            $sc_src = get_cover($value, 'path');
            $html = "<div class='popup-gallery' ><a target=\"_black\" title=\"查看大图\" href=\"$sc_src\"><img src=\"$sc_src\"/ style=\"width:50px;height:50px;border-radius:100%;\"></a></div>";
        } elseif (false !== strpos($value, ',')) {
            $ids = explode(',', $value);
            $html = '<div class=\'popup-gallery\' >';
            foreach ($ids as $id) {
                $id = htmlspecialchars($id);
                $sc_src = get_cover($id, 'path');
                $html .= "<a title=\"查看大图\" target=\"_black\" href=\"$sc_src\"><img src=\"$sc_src\"/ style=\"width:50px;height:50px;border-radius:100%;\"></a>";
            }
            $html .= '</div>';
        } else { // value是图片路径
            $sc_src = $value;
            $html = "<div class='popup-gallery' ><a  target=\"_black\" title=\"查看大图\" href=\"$sc_src\"><img  style='width:50px;height:50px;border-radius:100%;' src=\"$sc_src\"/ ></a></div>";
        }
        return $html;
    }

    /**
     * user转换为可点击页面.
     * @param $value
     * @param $key
     * @param $data
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/3/24 10:24
     */
    protected function convertUserValue($value, $key, $data)
    {
        if (is_numeric($value) && $value>0) {
            $value = htmlspecialchars($value);
            $attr['href'] = Url::build('ucenter/admin.User/view?id=' . $value);
            $attr['data-toggle'] = 'dialog';
            $attr['data-width'] = $this->dialog_width_default;
            $attr['data-height'] = $this->dialog_height_default;
            $attr['data-title'] = get_user_info($value) . '(ID:' . $value . ')的详细情况';
            $attr['data-id'] = "dialog-user-view-{$value}";
            $html = '<a ' . $this->compileHtmlAttr($attr) . '><img src="' . get_user_info($value, 'avatar') . '" style="width:25px;height:25px;    border-radius: 50%;margin-right:5px;">' . get_user_info($value) . '</a>&nbsp;';
        } else {
            $html = '-';
        }
        return $html;
    }

    /**
     * author转换为问答的访客页
     * @param $value
     * @param $key
     * @param $data
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 16:10
     */
    protected function convertAuthorValue($value, $key, $data)
    {
        if ($data['website']) {
            $attr['href'] = $data['website'];
            $attr['target'] = '_blank';
            $html = '<a ' . $this->compileHtmlAttr($attr) . '>' . $data['author'] . '</a>&nbsp;';
        } else {
            $html = $data['author'];
        }
        return $html;
    }

    /**
     * doaction转换为html
     * @param $key
     * @param $data
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 16:10
     */
    protected function convertDoactionValue($key, $data)
    {
        $actions = $key['opt']['actions'];
        $html = '';
        foreach ($actions as $action) {
            if ($action['status'] instanceof \Closure) {
                // 闭包
                if (!$action['status']($data)) {
                    continue;
                }
            } elseif (!in_array($data[$this->_default_status], $action['status'])) {
                continue;
            }
            $attr = $action['attr'];
            if ($action['disable']) {
                $html .= "<a disabled {$this->compileHtmlAttr($attr)}>{$action['text']}</a>&nbsp;";
            } else {
                $attr['href'] = $this->createUrlConvert($data, $action['get_url']);
                $html .= "<a {$this->compileHtmlAttr($attr)}>{$action['text']}</a>&nbsp;";
            }
        }
        if ($this->_callback) {
            $html .= '<a href="javascript:;"onclick="' . $this->_callback . '(' . $data['id'] . ',\'' . $data[$this->_callback_field] . '\')" class="btn btn-blue" title="选择本项" data-icon="check">选择</a>';
        }
        return $html;
    }

    /**
     * status转换为html
     * @param $value
     * @param $key
     * @return mixed
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:10
     */
    protected function convertStatusValue($value, $key)
    {
        // 废除状态支持链接操作
        $map = $key['opt'];
        $text = $map[$value];
        return $text;
    }

    private function addDefaultCssClass(&$button)
    {
        if (empty($button['attr']['class'])) {
            $button['attr']['class'] = 'btn';
        } // else {
        // $button['attr']['class'] .= ' btn';
        // }
    }

    /**
     * Url::build生成地址，且根据当前data替换对应值 例如：index?id={$id}&name={$name} 替换成对应的值index?id=1&name=value.
     * @param array $data 当前列信息
     * @param string $pattern 需要转换的参数
     * @return string
     * @author  : 微尘 <yicmf@qq.com>
     * @datetime: 2019/4/12 17:10
     */
    private function createUrlConvert($data, $pattern)
    {
        if (preg_match_all('/\{\$(\S+?)\}/', $pattern, $match)) {
            foreach ($match[1] as $value) {
                $replace[] = $data[$value];
            }
            return $this->urlBuild(str_replace($match[0], $replace, $pattern));
        } else {
            return $this->urlBuild($pattern);
        }
    }

    protected function urlBuild($pattern)
    {
        if (strpos($pattern, '://')) {
            return addon_url($pattern);
        } else {
            return Url::build($pattern);
        }
    }
}
