<?php

// +----------------------------------------------------------------------
// | 所有Event控制器共有类
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\common\event;

use think\Container;
use think\facade\App;

class Base
{
    /**
     * Request实例
     * @var \think\Request
     */
    protected $request;
    /**
     * 应用实例
     * @var \think\App
     */
    protected $app = null;

    public function __construct(App $app = null)
    {
        $this->app     = $app ?: Container::get('app');
        $this->request = $this->app['request'];
        if (method_exists($this, 'initialize')) {
            $this->initialize();
        }
    }
}
