<?php

// +----------------------------------------------------------------------
// | 模型基类
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\common\model;

use think\facade\Lang;
use think\Model;
use think\Container;
use think\db\Where;

class Base extends Model
{
    protected $request;

    /**
     * 初始化处理
     * 
     * @access protected
     * @return void
     */
    protected function initialize()
    {
        parent::initialize();
        $this->request = Container::get('request');
    }
    /**
     * 通用更新方法
     * @param array $param
     * @param unknown $user
     * @throws \Exception
     * @return number
     */
    public function commonUpdateData($param = [],$user = null)
    {
        try {
            if (empty($param)) {
                throw new \Exception(Lang::get('__data_format_error_'));
            }
            if (! empty($param[$this->getPk()])) {
                // 更新操作
                $map[$this->getPk()] = $param[$this->getPk()];
                $result = $this->save($param, $map);
            } else { // 新增
                $result = $this->create($param);
            }
            $data['code'] = 0;
            $data['data'] = $result;
            $data['message'] = '操作成功';
        } catch (\Exception $e) {
            $data['code'] = 1;
            $data['message'] = $e->getMessage();
        }
       return $data;
    }
    
    /**
     * 清除已经删除数据.
     *
     * @return number
     *
     * @author		微尘 <yicmf@qq.com>
     *
     * @version	v1.0.1
     */
    public function clear($id)
    {
        $this->error = '功能开发中';

        return false;
    }

    /**
     * 根据主键恢复删除的数据.
     */
    public function restore($id,$status = 1)
    {
        if (isset($id)) {
            return  $this->where($this->getPk() , 'in',explode(',', $id))->setField('status', $status) ?: false;
        } else {
            $this->error = '参数错误';

            return false;
        }
    }

    /**
     * 禁用该数据.
     *
     * @return number
     * @date		2015-4-13 下午5:54:49
     *
     * @author		微尘 <yicmf@qq.com>
     *
     * @version	v1.0.0
     */
    public function forbid($id)
    {
        if (isset($id)) {
            return  $this->where($this->getPk() , 'in',explode(',', $id))->setField('status', -1) ?: false;
        } else {
            $this->error = '参数错误';

            return false;
        }
    }

    /**
     * 删除记录.
     *
     * @param 主键 $id
     *
     * @return number
     */
    public function preDel($id)
    {
        if ($id) {
            $map = new Where();
            $map[$this->getPk()] = ['in', explode(',', $id)];
            return  $this->where($map)->setField('status', -2) ?: false;
        } else {
            $this->error = '参数错误';

            return false;
        }
    }

}
