<?php

// +----------------------------------------------------------------------
// | 公共模型
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\common\model;

use think\facade\Config;
use think\db\Where;

class Common extends Base
{
    
    public function _list($map, $order = null, $asc = false, $field = '')
    {
        // 排序字段 默认为主键名
        if (isset($_REQUEST['orderField'])) {
            $order = $_REQUEST['orderField'];
        }
        if (!isset($map['status'])) {
            $map['status'] = ['>=', -1];
        }
        if ($order == '') {
            $order = $this->getPk();
        }
        $sort = '';
        if (isset($_REQUEST['orderDirection'])) {
            $sort = $_REQUEST['orderDirection'];
        } else {
            $sort = $asc ? 'asc' : 'desc';
        }
        $list_rows = $this->request->has('pageSize', 'post') ? $this->request->post('pageSize') : Config::get('paginate.list_rows');

        return $this->where(new Where($map))->order($order.' '.$sort)->paginate($list_rows);
    }
}
