<?php

    // +----------------------------------------------------------------------
    // | 图片模型--负责图片的上传.
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\file\model;

    use app\ucenter\model\User;
    use think\facade\Env;

    class Picture extends Common
    {
        protected static $config = [];

        protected static function init()
        {
            self::$config = include Env::get('root_path') . 'config' . DIRECTORY_SEPARATOR . 'upload_picture.php';
            Picture::afterInsert(function($picture) {

            });
        }

        public function getUrlAttr($value, $data)
        {
            return $this->_formatUrl($data, 'original');
        }

        /**
         * 处理好的图片
         * @param $value
         * @param $data
         * @return string
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 16:08
         */
        public function getUrlMiniAttr($value, $data)
        {
            return $this->_formatUrl($data, 60);
        }

        /**
         * 处理好的图片
         * @param $value
         * @param $data
         * @return string
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 16:08
         */
        public function getUrlSmallAttr($value, $data)
        {
            return $this->_formatUrl($data, 240);
        }

        /**
         * 处理好的图片
         * @param $value
         * @param $data
         * @return string
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 16:08
         */
        public function getUrlNormalAttr($value, $data)
        {
            return $this->_formatUrl($data, 360);
        }
        /**
         * 处理好的图片
         * @param $value
         * @param $data
         * @return string
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 16:08
         */
        public function getUrlPreviewAttr($value, $data)
        {
            return $this->_formatUrl($data, 720);
        }

        /**
         * 处理好的图片
         * @param $value
         * @param $data
         * @return string
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/1/29 16:08
         */
        public function getUrlBigAttr($value, $data)
        {
            return $this->_formatUrl($data, 1280);
        }

        protected function _formatUrl($data, $width)
        {
            $ext = '.' . pathinfo($data['savename'], PATHINFO_EXTENSION);
            $basename = basename($data['savename'], $ext);
            if ( 'qiniu' == $data['driver'] ) {
                $domian = self::$config['qiniu_domain'];
            } else {
                $domian = $this->request->domain();
            }
            return $domian . str_replace($data['savename'], $basename . '_' . $width . $ext, $data['url']);
        }

        // 定义关联方法
        public function user()
        {
            return $this->belongsTo(User::class);
        }

        // 以下是自动完成
        protected $insert = [
            'status' => 1,
            'url'
        ];
        protected $type = [
            'info' => 'array',
        ];

        /**
         * 优化访问url
         */
        protected function setUrlAttr($value, $data)
        {

            $url = '/' . str_replace(DIRECTORY_SEPARATOR, '/', str_replace(Env::get('root_path') , '', $data['path']));
            // 注册图片修改url钩子
            //         Hook::listen('upload_picture_set_url',$data);
            return $url;
        }
    }
