<?php
    // +----------------------------------------------------------------------
    // | 前台首页控制器
    // | 主要获取首页聚合数据.
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------
    namespace app\index\controller;

    use app\common\model\Advertising;
    use app\common\model\Search as SearchModel;

    class Index extends Common
    {
        // 系统首页
        public function index()
        {
            $model = new SearchModel;
            $lists = $model->typeLists;
            foreach ($lists as $index => $list) {
                $lists[$index] = SearchModel::where('type',$index)->where('status',1)->order('sort ASC')->select();
            }
            $this->assign('lists',$lists);
            return $this->fetch();
        }
        // 系统首页
        public function search()
        {
            $kw = $this->request->param('wd','');
            if (!$kw)
            {
                $this->error('请输入搜索词');
            }
            if ($this->request->has('id'))
            {
                $data = SearchModel::where('id',$this->request->param('id'))->find();
                if (!$data){
                    $this->error('请求错误');
                }
            }else{
                // 根据分类查询
                $data = SearchModel::where('type',$this->request->param('type'))->where('status',1)->order('sort ASC')->find();
                if (!$data)
                {
                    $this->error('请求页面错误');
                }
            }
            $rand = SearchModel::where('type',$data['type'])
                ->where('status',1)
                ->where('id','<>',$data['id'])->select();
            if (count($rand))
            {
                $rand_ids = rand(0,count($rand)-1);
                $rand = $rand[$rand_ids];
            }else{
                $rand = '';
            }
            $this->assign('rand',$rand?$rand['id']:$data['id']);
            $url = str_replace('###',$kw,$data['url']);
            $this->assign('url',$url);
            $model = new SearchModel;
            $this->assign('lists',$model->typeLists);
            $this->assign('searchs',SearchModel::where('type',$data['type'])->where('status',1)->order('sort ASC')->select());
            $this->assign('data',$data);
                $ad  = Advertising::where('status',1)->whereTime('start_time','<','now')
                    ->whereTime('end_time','>','now')
                    ->order('sort ASC')
                    ->find();
                $this->assign('ad',$ad);
            return $this->fetch();
        }

        public function video()
        {
            $data['video_title'] = '如果部分视频无法观看,<a href="http://bbs.yaosou.cc/plugin.php?id=vipvideo:index" target="_blank"><span style="color:#E53333;">请点击我</span></a>';
            $data['video_new_url'] =  'http://juqingwang.net/jiexi/?v='.$this->request->param('vod_url');
            return json($data);
        }
    }
