<?php

    // +----------------------------------------------------------------------
    // | 行为控制器
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\ucenter\controller\admin;

    use app\ucenter\model\Action as ActionModel;
    use app\ucenter\event\Action as ActionEvent;
    use app\common\builder\Edit;
    use app\common\builder\Lists;
    use think\facade\Url;
    use app\common\model\Module;
    use app\admin\controller\Common;

    class Action extends Common
    {
        public function initialize()
        {
            parent::initialize();
            $this->model = new ActionModel();
        }

        public function _filter(&$map)
        {
        }

        /**
         * 行为管理
         * @return mixed|string
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/5/8 15:49
         */
        public function index()
        {
            // 读取规则列表
            $map = $this->_search($this->dbname);
            $this->_filter($map);
            $data = $this->model->_list($map);
            // 显示页面
            $builder = new Lists();
            $builder->suggest('合理搭配日志规则，方便管理网站运行')
                ->setSearchPostUrl('Action/index', '')
                ->searchText('title', '操作名称', '操作名称')
                ->buttonNew(Url::build('ucenter/admin.Action/update'))
                ->keyId('id', 'ID', 'desc')
                ->keyTitle('title', '操作名称')
                ->keyText('name', '标识')
                ->keyText('type_text', '类型')
                ->keyText('remark', '行为描述')
                ->keyUpdateTime()
                ->data($data)
                ->keyDoActionEdit('ucenter/admin.Action/update?id={$id}', '编辑')
                ->keyDoActionDel('ucenter/admin.Action/del?id={$id}');

            return $builder->fetch();
        }

        /**
         * 更新|编辑行为
         * @return string|void
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/5/8 15:48
         */
        public function update()
        {
            if ( $this->request->isPost() ) {
                // 数据验证
                $result = $this->validate($this->request->post(), 'action');
                if ( $result !== true ) {
                    $this->ajax(300, '行为数据验证错误，【' . $result . '】');
                } else {
                    $event = new ActionEvent();
                    $result = $event->update($this->request->post(), $this->user);
                    if ( 0 == $result['code'] ) {
                        $this->ajax(200, '操作成功', true);
                    } else {
                        $this->ajax(300, '操作失败，失败信息【' . $result['message'] . '】');
                    }
                }
            } else {
                $id = $this->request->get('id');
                //判断是否为编辑模式
                $isEdit = $id ? true : false;
                if ( $isEdit ) {
                    $data = $this->model->get($id);
                } else {
                    $data['type'] = 1;
                }
                $builder = new Edit();
                $builder->title($isEdit ? '编辑行为' : '添加行为')
                    ->keyText('name', '行为标识', '系统调用标识，具有唯一性，创建后不可更改')
                    ->keyText('title', '行为名称', '规则名称，方便记忆')
                    ->keyRadio('module', '所属模块', Module::getAll())
                    ->keyRadio('type', '行为类型', $this->model->action_type, '选择行为类型')
                    ->keyText('remark', '行为描述', '输入行为描述')
                    ->keyTextArea('action_rule', '行为规则', '输入行为规则，不写则只记录日志')
                    ->keyTextArea('log_rule', '日志规则', '记录日志备注时按此规则来生成，支持[变量|函数]。目前变量有：user,time,model,record,data')
                    ->explain('注意规则合理性')
                    ->data($data)
                    ->buttonSubmit('ucenter/admin.Action/update', '保存')->buttonBack();

                return $builder->fetch();
            }
        }
    }
