<?php

    // +----------------------------------------------------------------------
    // | 行为日志控制器
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\ucenter\controller\admin;

    use app\ucenter\model\ActionLog as ActionLogModel;
    use app\ucenter\event\User as UserEvent;
    use app\common\builder\Lists;
    use app\common\builder\View;
    use think\facade\Url;
    use app\admin\controller\Common;

    class ActionLog extends Common
    {
        protected function initialize()
        {
            parent::initialize();
            $this->model = new ActionLogModel();
        }
        public function _filter(&$map)
        {
            if (!UserEvent::isAdministrator())
            {
                $map['user_id'] = $this->user['id'];
            }
            if ( !$this->request->param('status') ) {
                $map['status'] = ['>', -1];
            }
        }

        /**
         * @return mixed|string
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/5/8 15:50
         */
        public function index()
        {
            $map = $this->_search($this->dbname);
            $this->_filter($map);
            $data = $this->model->_list($map, $this->model->getPk());
            // 显示页面
            $builder = new Lists();
            $builder->setSearchPostUrl('ActionLog/index', '')
                ->suggest('请定期清理日志，提示网站运行性能')
                ->searchText('remark', '内容', '日志内容')
                ->searchMoreTime('create_time', '时间：', ['pattern' => 'yyyy-MM-dd HH:mm:ss'])
                ->buttonDeleteAll(Url::build('clearOld'), '清除过期日志')
                ->keyId('id', 'ID', 'desc')
                ->keyText('action.title', '行为名称')
                ->keyUser('user_id', '执行者')
                ->keyText('remark', '备注')
                ->keyCreateTime()
                ->groupOutxls()
                ->groupOutxlsCheck()
                ->groupBr()
                ->groupDel('del')
                ->data($data)
                ->keyDoActionView('ucenter/admin.ActionLog/view?id={$id}', '查看详情')
                ->keyDoActionDel('ucenter/admin.ActionLog/del?id={$id}');

            return $builder->fetch();
        }

        /**
         * 浏览日志详情.
         */
        public function view()
        {
            if ( $this->request->has('id', 'get') ) {
                $data = $this->model->get($this->request->get('id'));
                if ( $data ) {
                    $builder = new View();
                    $builder->title('查看日志信息')
                        ->keyLabel('action.title', '操作类型')
                        ->keyLabel('remark', '备注')
                        ->keyLabel('param', 'param')
                        ->keyLabel('os', '运行环境')
                        ->keyLabel('header', 'header')
                        ->keyLabel('url', 'url')
                        ->keyLabel('ip_info', 'IP信息')
                        ->keyLabel('create_time', '操作时间')
                        ->data($data)
                        ->buttonBack();

                    return $builder->fetch();
                } else {
                    $this->ajax(300, '详情查询失败，该日志可能已经被删除', true);
                }
            } else {
                $this->ajax(300, '详情日志查询失败，请求错误', true);
            }
        }

        /**
         * 清理过期日志.
         */
        public function clearOld()
        {
            $result = $this->model->clearOld();
            if ( $result !== false ) {
                $this->ajax(200, '成功删除' . $result . '条数据');
            } else {
                $this->ajax(300, '删除失败，信息：' . $this->model->getError());
            }
        }

        public function outxls()
        {
            $map = $this->_search();
            if ( method_exists($this, '_filter') ) {
                $this->_filter($map);
            }
            $list = $this->model->where($map)
                //         ->order($this->request->get('orderField').' '.$this->request->get('orderDirection'))
                ->limit(2000)
                ->field('id,remark,ip,create_time,user')
                ->select();
            $headArr = [
                'ID',
                '备注信息',
                'ip',
                '创建时间',
                '用户'
            ];
            $this->excelOut('导出日志', $headArr, $list);
        }

        public function outxls_check()
        {
            $map['id'] = [
                'in',
                explode(',', $this->request->get('expids')),
            ];
            $list = $this->model->where($map)
                ->field('id,remark,ip_info,create_time,user')
                ->select();
            $headArr = [
                'ID',
                '备注信息',
                'ip',
                '创建时间',
                '用户'
            ];
            $this->excelOut('导出日志', $headArr, $list);
        }
    }
