<?php

    // +----------------------------------------------------------------------
    // | 行为事件
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\ucenter\event;

    use app\ucenter\model\Action as ActionModel;
    use app\ucenter\model\User as UserModel;
    use think\Db;
    use think\Exception;
    use think\facade\Log;
    use think\Model;

    class Action
    {
        /**
         * 新增|更新用户组
         * @param   array     $param
         * @param   UserModel $user
         * @return mixed
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/3/25 16:15
         */
        public function update($param, $user = null)
        {
            try {
                if ( !empty($param['id']) ) {
                    $action = ActionModel::get($param['id']);
                    $action['name'] = $param['name'];
                    $action['title'] = $param['title'];
                    $action['module'] = $param['module'];
                    $action['remark'] = $param['remark'];
                    $action['action_rule'] = $param['action_rule'];
                    $action['log_rule'] = $param['log_rule'];
                    $action['type'] = $param['type'];
//                    $action['is_open'] = $param['is_open'];
                    if ( !$action->save() ) {
                        throw new \Exception('数据储存失败');
                    }
                } else {
                    $action['name'] = $param['name'];
                    $action['title'] = $param['title'];
                    $action['module'] = $param['module'];
                    $action['remark'] = $param['remark'];
                    $action['action_rule'] = $param['action_rule'];
                    $action['log_rule'] = $param['log_rule'];
                    $action['type'] = $param['type'];
//                    $action['is_open'] = $param['is_open'];
                    if ( !ActionModel::create($action) ) {
                        throw new \Exception('新建行为失败');
                    }
                }
                $data['code'] = 0;
            } catch ( \Exception $e ) {
                $data['code'] = 1;
                $data['message'] = $e->getMessage();
            }
            return $data;
        }

        /**
         * 记录行为日志，并执行该行为的规则
         * @param   string    $action_name 行为标识
         * @param   string    $model       触发行为的模型名
         * @param   Model     $record
         * @param   UserModel $user
         * @param   array     $param       可替换参数
         * @return  bool
         * @throws  Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/4/4 9:11
         */
        public static function log($action_name, $model, $record, $user = null, $param = [])
        {
            // 参数检查
            if ( empty($action_name) || empty($model) || empty($record) ) {
                throw new Exception('参数不能为空');
            }
            if ( empty($user) ) {
                $user = User::isLogin();
            }
            // 查询行为,判断是否执行
            $action = ActionModel::get(['name' => $action_name, 'status' => 1]);
            if ( !$action || !is_object($action) ) {
                throw new Exception('当前执行的日志行为不存在');
            }
            // 插入行为日志
            $log = [];
            $log['model'] = $model;
            $log['user_id'] = $user['id'];
            if (is_object($record))
            {
                $log['record_id'] = $record['id'];
            }
            $log['action_status'] = isset($param['status']) ? $param['status'] : 1;
            if ( !empty($param) && is_string($param) ) {
                $log['remark'] = $param;
            } else {
                // TODO:解析日志规则,生成日志备注
                if ( !empty($action['log_rule']) ) {
                    if ( false !== strpos($action['log_rule'], '{') ) {
                        $view = App()->view;
                        $action['log_rule'] = $view->display($action['log_rule'], [
                            'remark' => $param,
                            'record' => $record,
                            'user' => $user
                        ]);
                    }
                    $log['remark'] = $action['log_rule'];
                } else {
                    // 未定义日志规则，记录操作url
                    $log['remark'] = '操作url：' . request()->url(true);
                }
            }
            $log_save = $action->logs()->save($log);
            // 保存日志
            if ( !$log_save ) {
                Log::write('日志行为日志写入异常，写入数据:' . var_export($log, true));
                return false;
            } else {
                if ( !empty($action['action_rule']) ) {
                    // 解析行为
                    $rules = self::parseAction($action, $user['id'], $param);
                    if ( $rules ) {
                        // 执行行为
                        return self::executeAction($rules, $action, $user, $log_save, $param);
                    } else {
                        Log::write('行为解析失败' . var_export($log_save, true));
                        throw new Exception('行为解析失败');
                    }
                }
                return true;
            }
        }


        /**
         * 执行行为.
         * @param array       $rules  解析后的规则数组
         * @param ActionModel $action 当前行为对象
         * @param UserModel  user执行的用户
         * @param array       $param  解析后的规则数组
         * @param             $log
         * @return bool
         * @throws \Exception
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/4/3 12:46
         */
        protected static function executeAction($rules, $action, $user, $log, $param)
        {
            if ( !$rules || empty($action) ) {
                return false;
            }
            $return = true;
            foreach ( $rules as $rule ) {
                if ( isset($rule['max']) ) {
                    // 检查执行周期
                    if ( is_numeric($rule['cycle']) ) {
                        // 数字，以小时为单位;
                        if ( $action->logs()
                                ->where('user_id', $user['id'])
                                ->whereTime('create_time', '>=', time_format($_SERVER['REQUEST_TIME'] - intval($rule['cycle']) * 3600))
                                ->count('id') > $rule['max'] ) {
                            continue;
                        }
                    } else {
                        // 支持高级函数
                        if ( $action->logs()
                                ->where('user_id', $user['id'])
                                ->whereTime('create_time', '>', $rule['cycle'])
                                ->count('id') > $rule['max'] ) {
                            continue;
                        }
                    }
                }
                if ( !empty($rule['table']) && !empty($rule['field']) && !empty($rule['condition']) ) {
                    $fields = explode(',', $rule['field']);
                    $values = explode(',', $rule['rule']);
                    $arr = [];
                    foreach ( $fields as $key => $field ) {
                        //$data['point'] = Db::raw('point+1');
                        $arr[$field] = Db::raw($field . '+' . $values[$key]);
                        //                     $arr[$field] = ['exp',$values[$key]];
                    }
                    if ( count($arr) > 0 ) {
                        // 执行数据库操作
                        $res = Db::name($rule['table'])->where($rule['condition'])->setField($arr);
                        if ( !$res ) {
                            $return = false;
                        }
                    } else {
                        Log::write('日志规范解析错误：' . var_export($rule));
                        $return = false;
                    }
                } elseif ( isset($rule['event']) && isset($rule['method']) ) {
                    $param = [];
                    if ( isset($rule['param']) ) {
                        parse_str($rule['param'], $param);
                    }
                    if ( !isset($param['relation_id']) ) {
                        $param['relation_id'] = $log['id'];
                    }
                    // 用户配置为主
                    $param = array_merge($param, $param);
//                    ('\app\\'.$rule['event'])::$rule['method']($user, $action['name'], $param);
                }
            }
            return $return;
        }

        /**
         * 解析行为规则
         * 规则定义 table:$table|field:$field|condition:$condition|rule:$rule[|cycle:$cycle|max:$max][;......]
         * 规则字段解释：  table->要操作的数据表，不需要加表前缀；
         *              field->要操作的字段；
         *              condition->操作的条件，目前支持字符串，默认变量{$self}为执行行为的用户
         *              rule->对字段进行的具体操作，目前支持四则混合运算，如：1+point*2/2-3
         *              cycle->执行周期，单位（小时），表示$cycle小时内最多执行$max次，时间表达式语法
         *              max->单个周期内的最大执行次数（$cycle和$max必须同时定义，否则无效）
         * 单个行为后可加 ； 连接其他规则.
         * @param object $action 行为对象
         * @param int    $self   替换规则里的变量为执行用户的id
         * @return bool|array: false解析出错 ， 成功返回规则数组
         */
        public static function parseAction($action, $self, $arr = null)
        {
            if ( !is_object($action) ) {
                return false;
            }
            // 解析规则:table:$table|field:$field|condition:$condition|rule:$rule[|cycle:$cycle|max:$max][;......]
            $rules = $action['action_rule'];
            if ( $arr && is_array($arr) && isset($arr['num']) ) {
                $rules = str_replace('{$num}', $arr['num'], $rules);
            }
            $rules = str_replace('{$self}', $self, $rules);
            $rules = explode(';', $rules);
            $return = [];
            foreach ( $rules as $key => &$rule ) {
                $rule = explode('|', $rule);
                foreach ( $rule as $k => $fields ) {
                    $field = empty($fields) ? [] : explode(':', $fields);
                    if ( !empty($field) ) {
                        $return[$key][$field[0]] = $field[1];
                    }
                }
                // cycle(检查周期)和max(周期内最大执行次数)必须同时存在，否则去掉这两个条件
                if ( !array_key_exists('cycle', $return[$key]) || !array_key_exists('max', $return[$key]) ) {
                    unset($return[$key]['cycle'], $return[$key]['max']);
                }
            }
            return $return;
        }
    }
