<?php

// +----------------------------------------------------------------------
// | 行为日志模型
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\ucenter\model;

use think\facade\Config;

class ActionLog extends Common
{

    /**
     * 清除过期日志.
     */
    public function clearOld()
    {
        $result = $this->where('create_time', '<', $this->request->time() - Config::get('log_max_time') * 84600)->setField('status', -2);
        if ($result) {
            return $result;
        } else {
            $this->error = '暂无过期日志需要清理';

            return false;
        }
    }

    // 定义关联方法
    public function user()
    {
        return $this->belongsTo('User');
    }

    public function action()
    {
        return $this->belongsTo('Action');
    }

    /**
     * 删除全部日志.
     */
    public function deleteAll()
    {
        return $this->where('1')->setField('status', -2) ?: false;
    }

    public function getActionOpt()
    {
        return $this->where('status', 1)->field('name,title')->select();
    }

    //获取器
    public function getIpAttr($value)
    {
        if (is_numeric($value)) {
            return long2ip($value);
        } else {
            return $value;
        }
    }

    //修改器
//    public function setRemarkAttr($value, $data)
//    {
//        //FIXME:此处因会多出action属性，
////         dump($this->getData());
////         dump($this->action['name']);
////         dump($this->getData());
//        //如果传入是字符串，直接返回
//        if (!empty($value['remark']) && is_string($value['remark'])) {
//            return $value;
//        }
//        // 解析日志规则,生成日志备注
//        if (!empty($value['log_rule'])) {
//            if (preg_match_all('/\[(\S+?)\]/', $value['log_rule'], $matchs)) {
//                $variable = $this->getDefaultVariable($data);
//                foreach ($matchs[1] as $match) {
//                    $param = explode('|', $match);
//                    if (isset($param[1])) {
//                        if (method_exists($this, $param[1])) {
//                            $method = $param[1];
//                            $replace[] = $this->$method($variable[$param[0]]);
//                            unset($method);
//                        } else {
//                            $replace[] = call_user_func($param[1], $variable[$param[0]]);
//                        }
//                    } else {
//                        $replace[] = $variable[$param[0]];
//                    }
//                }
//
//                return str_replace($matchs[0], $replace, $value['log_rule']);
//            } else {
//                return $value['log_rule'];
//            }
//        } else {
//            // 未定义日志规则，记录操作url
//            return '操作url：'.$this->request->url(true);
//        }
//    }
//
//    private function getDefaultVariable($data)
//    {
//        $variable['user'] = \app\ucenter\event\User::isLogin();
//        $variable['record'] = $data['record_id'];
//        $variable['model'] = $data['model'];
//        $variable['time'] = $this->request->time();
//        $variable['action'] = $this->request->action();
//        $variable['controller'] = $this->request->controller();
//        $variable['module'] = $this->request->module();
//        $variable['data'] = $data;
//        if (!empty($data['remark']['remark']) && is_array($data['remark']['remark'])) {
//            $variable = array_merge($variable, $data['remark']['remark']);
//        }
//        unset($data['remark']);
//
//        return array_merge($variable, $data);
//    }

      //数据完成
    protected $insert = ['status' => 1, 'ip', 'os', 'param', 'url', 'ip_info'];

    protected function setIpAttr()
    {
        return $this->request->ip();
    }

    protected function setIpInfoAttr()
    {
        $info = $this->order('id DESC')->where('ip', $this->request->ip())->find();
        if ($info && $info['ip_info']) {
            // 存在同ip的日志且已经有相关信息;
            return $info['ip_info'];
        } else {
//             $result = $this->yicmf->ipToCity($this->request->ip());
//             if (200 == $result['resultcode']) {
//                 return "【{$result['result']['area']}】【{$result['result']['location']}】【{$this->request->ip()}】";
//             } else {
                // 如果未获取到，则不再更新
                return $this->request->ip();
//             }
        }
    }

    protected function setOsAttr()
    {
        return $this->request->server('HTTP_USER_AGENT');
    }

//     protected function setServerAttr()
//     {
//         return var_export($this->request->server(), true);
//     }

//     protected function setHeaderAttr()
//     {
//         return var_export($this->request->header(), true);
//     }
    protected function setParamAttr()
    {
        $param = $this->request->param();
        if (is_array($param)) {
            foreach ($param as $key => &$value) {
                if ('password' == $key) {
                    $value = '******';
                }
            }
            return var_export($param, true);
        } else {
            return $this->request->param();
        }
    }

    protected function setUrlAttr()
    {
        return $this->request->url(true);
    }
}
