<?php

    // +----------------------------------------------------------------------
    // | 用户模型验证器
    // +----------------------------------------------------------------------
    // | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
    // +----------------------------------------------------------------------
    // | Author: 微尘 <yicmf@qq.com>
    // +----------------------------------------------------------------------

    namespace app\ucenter\validate;

    use think\Validate;
    use think\facade\Lang;
    use think\facade\Session;

    class User extends Validate
    {

        /* 用户模型自动验证 */
        protected $rule = [
            'account|登录账号' => [
                'checkDenyUser' => 'account',
                'length' => '3,28',
                'unique' => 'user',
            ],
            'email|注册邮箱' => [
                'email',
                'unique' => 'user',
            ],
            'nickname|昵称' => [
                'length' => '1,28',
                'unique' => 'user',
            ],
            'mobile|手机号' => [
                'mobile',
                'unique' => 'user',
            ],
            'true_name|真实姓名' => 'chs',
            'password|密码' => [
                'length' => '5,28',
                'confirm'
            ],
            'verify|验证码' => [
                //             'require',
                'checkCaptcha' => 'login'
            ]
        ];

        // edit 验证场景定义
        public function sceneInstall()
        {
            return $this->only(['account', 'password', 'email'])->remove('account', 'unique');
        }

        // edit 验证场景定义
        public function sceneOauth()
        {
            return $this->only(['nickname']);
        }

        public function sceneChangepassword()
        {
            return $this->only(['password']);
        }

        public function sceneLogin()
        {
            return $this->only(['account', 'password', 'verify'])
                ->remove('account', 'unique')
                ->remove('password', 'confirm');
        }

        public function sceneRegister()
        {
            return $this->only(['mobile', 'password', 'nickname', 'email', 'verify']);
        }

        protected $message = [
            'account.require' => '登陆账号必填',
        ];

        /**
         * 验证码检查
         * @param $value
         * @param $rule
         * @param $data
         * @return bool|string
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/2/16 18:44
         */
        protected function checkCaptcha($value, $rule, $data)
        {
            if ( captcha_check($value) ) {
                return true;
            } else {
                return '验证码错误';
            }
        }

        /**
         * 检测用户名是不是被禁止注册.
         * @param $value
         * @param $rule
         * @param $data
         * @return bool
         * @author  : 微尘 <yicmf@qq.com>
         * @datetime: 2019/2/16 18:44
         */
        protected function checkDenyUser($value, $rule, $data)
        {
            return true; //TODO: 暂不限制，下一个版本完善
        }

        /**
         * 检测邮箱是不是被禁止注册.
         * @param string $email 邮箱
         * @return bool ture - 未禁用，false - 禁止注册
         */
        protected function checkDenyEmail($value, $rule, $data)
        {
            return true; //TODO: 暂不限制，下一个版本完善
        }

        /**
         * 检测手机是不是被禁止注册.
         * @param string $mobile 手机
         * @return bool ture - 未禁用，false - 禁止注册
         */
        protected function checkDenyMobile($value, $rule, $data)
        {
            return true; //TODO: 暂不限制，下一个版本完善
        }
    }
