/*
 Navicat MySQL Data Transfer

 Source Server         : 127.0.0.1
 Source Server Type    : MySQL
 Source Server Version : 50638
 Source Host           : localhost:3306
 Source Schema         : duanlian

 Target Server Type    : MySQL
 Target Server Version : 50638
 File Encoding         : 65001

 Date: 09/05/2019 23:33:29
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for d_ad
-- ----------------------------
DROP TABLE IF EXISTS `d_ad`;
CREATE TABLE `d_ad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` longtext COMMENT '广告内容',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `title` varchar(255) DEFAULT NULL COMMENT '广告标题',
  `use_count` int(11) DEFAULT NULL COMMENT '使用次数',
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='广告';

-- ----------------------------
-- Records of d_ad
-- ----------------------------
BEGIN;
INSERT INTO `d_ad` VALUES (2, '<a href=\"\" target=\"_blank\"><img src=\"http://www.baisi.co/assets/layui/images/banner1.jpg\"></a>', '2019-04-10 23:33:53', '2019-04-22 14:13:20', '广告1', 1164, 1);
INSERT INTO `d_ad` VALUES (3, '<a href=\"\" target=\"_blank\"><img src=\"http://www.baisi.co/assets/layui/images/banner2.jpg\"></a>', '2019-04-11 14:16:24', '2019-04-22 14:13:19', '广告2', 1163, 1);
COMMIT;

-- ----------------------------
-- Table structure for d_ad_config
-- ----------------------------
DROP TABLE IF EXISTS `d_ad_config`;
CREATE TABLE `d_ad_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jump` int(11) DEFAULT NULL COMMENT '跳转时间',
  `status` int(11) DEFAULT NULL COMMENT '跳转状态',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of d_ad_config
-- ----------------------------
BEGIN;
INSERT INTO `d_ad_config` VALUES (1, 5, 1, '2019-04-11 00:56:12', '2019-04-14 21:07:07');
COMMIT;

-- ----------------------------
-- Table structure for d_admin
-- ----------------------------
DROP TABLE IF EXISTS `d_admin`;
CREATE TABLE `d_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `username` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '昵称',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `salt` varchar(30) NOT NULL DEFAULT '' COMMENT '密码盐',
  `avatar` varchar(100) NOT NULL DEFAULT '' COMMENT '头像',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '电子邮箱',
  `loginfailure` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '失败次数',
  `logintime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录时间',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `token` varchar(59) NOT NULL DEFAULT '' COMMENT 'Session标识',
  `status` varchar(30) NOT NULL DEFAULT 'normal' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='管理员表';

-- ----------------------------
-- Records of d_admin
-- ----------------------------
BEGIN;
INSERT INTO `d_admin` VALUES (1, 'admin', 'Admin', '10004a84bcb28e50b8569bbeb5680633', 'e1b833', '/assets/img/avatar.png', 'admin@admin.com', 0, 1555772655, 1492186163, 1555772655, 'cfeb7f83-4a48-49d0-869c-3a3e5afe318a', 'normal');
COMMIT;

-- ----------------------------
-- Table structure for d_admin_log
-- ----------------------------
DROP TABLE IF EXISTS `d_admin_log`;
CREATE TABLE `d_admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `username` varchar(30) NOT NULL DEFAULT '' COMMENT '管理员名字',
  `url` varchar(1500) NOT NULL DEFAULT '' COMMENT '操作页面',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '日志标题',
  `content` text NOT NULL COMMENT '内容',
  `ip` varchar(50) NOT NULL DEFAULT '' COMMENT 'IP',
  `useragent` varchar(255) NOT NULL DEFAULT '' COMMENT 'User-Agent',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`id`),
  KEY `name` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=280 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='管理员日志表';

-- ----------------------------
-- Records of d_admin_log
-- ----------------------------
BEGIN;
INSERT INTO `d_admin_log` VALUES (1, 1, 'admin', '/index.php/admin/index/login', '登录', '{\"__token__\":\"c8b00a314087ff7b80c3d207e272ccc3\",\"username\":\"admin\",\"captcha\":\"mjpf\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876053);
INSERT INTO `d_admin_log` VALUES (2, 1, 'admin', '/index.php/admin/auth/rule/multi/ids/66', '', '{\"action\":\"\",\"ids\":\"66\",\"params\":\"ismenu=0\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876344);
INSERT INTO `d_admin_log` VALUES (3, 1, 'admin', '/index.php/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876345);
INSERT INTO `d_admin_log` VALUES (4, 1, 'admin', '/index.php/admin/auth/rule/multi/ids/4', '', '{\"action\":\"\",\"ids\":\"4\",\"params\":\"ismenu=0\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876346);
INSERT INTO `d_admin_log` VALUES (5, 1, 'admin', '/index.php/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876346);
INSERT INTO `d_admin_log` VALUES (6, 1, 'admin', '/index.php/admin/auth/rule/multi/ids/3', '', '{\"action\":\"\",\"ids\":\"3\",\"params\":\"ismenu=0\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876350);
INSERT INTO `d_admin_log` VALUES (7, 1, 'admin', '/index.php/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876351);
INSERT INTO `d_admin_log` VALUES (8, 1, 'admin', '/index.php/admin/general.config/edit', '常规管理 系统配置 编辑', '{\"row\":{\"name\":\"\\u77ed\\u8fde\\u63a5\",\"beian\":\"\",\"cdnurl\":\"\",\"version\":\"1.0.1\",\"timezone\":\"Asia\\/Shanghai\",\"forbiddenip\":\"\",\"languages\":\"{\\\"backend\\\":\\\"zh-cn\\\",\\\"frontend\\\":\\\"zh-cn\\\"}\",\"fixedpage\":\"dashboard\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876365);
INSERT INTO `d_admin_log` VALUES (9, 1, 'admin', '/index.php/admin/auth/rule/add?dialog=1', '权限管理 菜单规则 添加', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"0\",\"name\":\"short\",\"title\":\"\\u77ed\\u94fe\\u7ba1\\u7406\",\"icon\":\"fa fa-american-sign-language-interpreting\",\"weigh\":\"140\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876435);
INSERT INTO `d_admin_log` VALUES (10, 1, 'admin', '/index.php/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876435);
INSERT INTO `d_admin_log` VALUES (11, 1, 'admin', '/index.php/admin/auth/rule/add?dialog=1', '权限管理 菜单规则 添加', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/host\\/index\",\"title\":\"\\u57df\\u540d\\u7ba1\\u7406\",\"icon\":\"fa fa-delicious\",\"weigh\":\"0\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876468);
INSERT INTO `d_admin_log` VALUES (12, 1, 'admin', '/index.php/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554876468);
INSERT INTO `d_admin_log` VALUES (13, 1, 'admin', '/index.php/admin/short/host/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"host\":\"a.woyaoso.cn\",\"type\":\"main\",\"status\":\"0\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554877943);
INSERT INTO `d_admin_log` VALUES (14, 1, 'admin', '/index.php/admin/short/host/edit/ids/1?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"host\":\"a.woyaoso.cn\",\"type\":\"main\",\"status\":\"1\"},\"ids\":\"1\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554878046);
INSERT INTO `d_admin_log` VALUES (15, 1, 'admin', '/index.php/admin/auth/rule/add?dialog=1', '权限管理 菜单规则 添加', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/url\\/index\",\"title\":\"\\u94fe\\u63a5\",\"icon\":\"fa fa-database\",\"weigh\":\"0\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554878181);
INSERT INTO `d_admin_log` VALUES (16, 1, 'admin', '/index.php/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554878181);
INSERT INTO `d_admin_log` VALUES (17, 1, 'admin', '/index.php/admin/auth/rule/edit/ids/87?dialog=1', '权限管理 菜单规则 编辑', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/url\\/index\",\"title\":\"\\u94fe\\u63a5\\u7ba1\\u7406\",\"icon\":\"fa fa-database\",\"weigh\":\"0\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"},\"ids\":\"87\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554878194);
INSERT INTO `d_admin_log` VALUES (18, 1, 'admin', '/index.php/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554878195);
INSERT INTO `d_admin_log` VALUES (19, 1, 'admin', '/index.php/admin/short/host/edit/ids/1?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"host\":\"duanlian\",\"type\":\"main\",\"status\":\"1\"},\"ids\":\"1\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554882599);
INSERT INTO `d_admin_log` VALUES (20, 1, 'admin', '/admin/short/host/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"host\":\"duanlia\",\"type\":\"jump\",\"status\":\"1\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554907521);
INSERT INTO `d_admin_log` VALUES (21, 1, 'admin', '/admin/auth/rule/add?dialog=1', '权限管理 菜单规则 添加', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/ad\\/index\",\"title\":\"\\u5e7f\\u544a\\u7ba1\\u7406\",\"icon\":\"fa fa-codepen\",\"weigh\":\"0\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554908756);
INSERT INTO `d_admin_log` VALUES (22, 1, 'admin', '/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554908756);
INSERT INTO `d_admin_log` VALUES (23, 1, 'admin', '/admin/auth/rule/multi/ids/4', '', '{\"action\":\"\",\"ids\":\"4\",\"params\":\"ismenu=1\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554909668);
INSERT INTO `d_admin_log` VALUES (24, 1, 'admin', '/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554909669);
INSERT INTO `d_admin_log` VALUES (25, 1, 'admin', '/admin/addon/install', '插件管理 安装', '{\"name\":\"simditor\",\"force\":\"0\",\"uid\":\"0\",\"token\":\"\",\"version\":\"1.0.4\",\"faversion\":\"1.0.0.20190111_beta\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554909682);
INSERT INTO `d_admin_log` VALUES (26, 1, 'admin', '/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554909682);
INSERT INTO `d_admin_log` VALUES (27, 1, 'admin', '/admin/auth/rule/multi/ids/4', '', '{\"action\":\"\",\"ids\":\"4\",\"params\":\"ismenu=0\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554909694);
INSERT INTO `d_admin_log` VALUES (28, 1, 'admin', '/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554909694);
INSERT INTO `d_admin_log` VALUES (29, 1, 'admin', '/admin/short/ad/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"3123\",\"status\":\"1\"},\"content\":\"<p>1231<\\/p>\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554910386);
INSERT INTO `d_admin_log` VALUES (30, 1, 'admin', '/admin/short/ad/del/ids/1', '', '{\"action\":\"del\",\"ids\":\"1\",\"params\":\"\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554910397);
INSERT INTO `d_admin_log` VALUES (31, 1, 'admin', '/admin/short/ad/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"213\",\"status\":\"1\"},\"content\":\"<p>132313<\\/p>\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554910433);
INSERT INTO `d_admin_log` VALUES (32, 1, 'admin', '/admin/short/ad/edit/ids/2?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"213\",\"status\":\"1\"},\"content\":\"<p>3333<\\/p>\",\"ids\":\"2\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554910574);
INSERT INTO `d_admin_log` VALUES (33, 1, 'admin', '/admin/short/ad/edit/ids/2?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"213\",\"content\":\"<p>411241<\\/p>\",\"status\":\"1\"},\"ids\":\"2\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554910610);
INSERT INTO `d_admin_log` VALUES (34, 1, 'admin', '/admin/auth/rule/add?dialog=1', '权限管理 菜单规则 添加', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/ad\\/ad\",\"title\":\"\\u5e7f\\u544a\\u914d\\u7f6e\",\"icon\":\"fa fa-bullseye\",\"weigh\":\"0\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554910938);
INSERT INTO `d_admin_log` VALUES (35, 1, 'admin', '/admin/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554910939);
INSERT INTO `d_admin_log` VALUES (36, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"0\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554945249);
INSERT INTO `d_admin_log` VALUES (37, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"0\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554945252);
INSERT INTO `d_admin_log` VALUES (38, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"1\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554945327);
INSERT INTO `d_admin_log` VALUES (39, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"0\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554945332);
INSERT INTO `d_admin_log` VALUES (40, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"1\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554945334);
INSERT INTO `d_admin_log` VALUES (41, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"0\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554946598);
INSERT INTO `d_admin_log` VALUES (42, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"1\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554947599);
INSERT INTO `d_admin_log` VALUES (43, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"1\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554953684);
INSERT INTO `d_admin_log` VALUES (44, 1, 'admin', '/admin.php/short/ad/ad?addtabs=1', '短链管理 广告配置', '{\"addtabs\":\"1\",\"row\":{\"jump\":\"5\",\"status\":\"1\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554953708);
INSERT INTO `d_admin_log` VALUES (45, 1, 'admin', '/admin.php/short/ad/edit/ids/2?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"213\",\"content\":\"<p>\\u8fd9\\u91cc\\u662f\\u5e7f\\u544a\\u6d4b\\u8bd5<\\/p>\",\"status\":\"1\"},\"ids\":\"2\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554954514);
INSERT INTO `d_admin_log` VALUES (46, 1, 'admin', '/admin.php/short/host/del/ids/1', '', '{\"action\":\"del\",\"ids\":\"1\",\"params\":\"\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36', 1554956667);
INSERT INTO `d_admin_log` VALUES (47, 1, 'admin', '/admin.php/index/login?url=%2Fadmin.php', '登录', '{\"url\":\"\\/admin.php\",\"__token__\":\"9dd939f10cbbc9af1456fecaa979b505\",\"username\":\"admin\",\"captcha\":\"hlb8\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555573606);
INSERT INTO `d_admin_log` VALUES (258, 1, 'admin', '/admin.php/index/login?url=%2Fadmin.php', '登录', '{\"url\":\"\\/admin.php\",\"__token__\":\"fc516f06abb74d4944155968a4b86643\",\"username\":\"admin\",\"captcha\":\"wj2x\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772655);
INSERT INTO `d_admin_log` VALUES (259, 1, 'admin', '/admin.php/auth/rule/add?dialog=1', '权限管理 菜单规则 添加', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/jump\\/index\",\"title\":\"\\u8df3\\u8f6c\\u6c60\",\"icon\":\"fa fa-tasks\",\"weigh\":\"0\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772719);
INSERT INTO `d_admin_log` VALUES (260, 1, 'admin', '/admin.php/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772719);
INSERT INTO `d_admin_log` VALUES (261, 1, 'admin', '/admin.php/auth/rule/edit/ids/86?dialog=1', '权限管理 菜单规则 编辑', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/host\\/index\",\"title\":\"\\u57df\\u540d\\u7ba1\\u7406\",\"icon\":\"fa fa-delicious\",\"weigh\":\"10\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"},\"ids\":\"86\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772749);
INSERT INTO `d_admin_log` VALUES (262, 1, 'admin', '/admin.php/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772750);
INSERT INTO `d_admin_log` VALUES (263, 1, 'admin', '/admin.php/auth/rule/edit/ids/87?dialog=1', '权限管理 菜单规则 编辑', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/url\\/index\",\"title\":\"\\u94fe\\u63a5\\u7ba1\\u7406\",\"icon\":\"fa fa-database\",\"weigh\":\"9\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"},\"ids\":\"87\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772756);
INSERT INTO `d_admin_log` VALUES (264, 1, 'admin', '/admin.php/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772756);
INSERT INTO `d_admin_log` VALUES (265, 1, 'admin', '/admin.php/auth/rule/edit/ids/93?dialog=1', '权限管理 菜单规则 编辑', '{\"dialog\":\"1\",\"row\":{\"ismenu\":\"1\",\"pid\":\"85\",\"name\":\"short\\/jump\\/index\",\"title\":\"\\u8df3\\u8f6c\\u6c60\",\"icon\":\"fa fa-tasks\",\"weigh\":\"8\",\"condition\":\"\",\"remark\":\"\",\"status\":\"normal\"},\"ids\":\"93\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772764);
INSERT INTO `d_admin_log` VALUES (266, 1, 'admin', '/admin.php/index/index', '', '{\"action\":\"refreshmenu\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555772765);
INSERT INTO `d_admin_log` VALUES (267, 1, 'admin', '/admin.php/short/jump/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"121\",\"content\":\"22\",\"url_list\":\"1\\r\\n2\\r\\n3\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555774116);
INSERT INTO `d_admin_log` VALUES (268, 1, 'admin', '/admin.php/short/jump/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"121\",\"content\":\"22\",\"url_list\":\"1\\r\\n2\\r\\n3\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555774127);
INSERT INTO `d_admin_log` VALUES (269, 1, 'admin', '/admin.php/short/jump/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"121\",\"content\":\"22\",\"url_list\":\"1\\r\\n2\\r\\n3\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555774131);
INSERT INTO `d_admin_log` VALUES (270, 1, 'admin', '/admin.php/short/jump/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"121\",\"content\":\"22\",\"url_list\":\"1\\r\\n2\\r\\n3\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555774319);
INSERT INTO `d_admin_log` VALUES (271, 1, 'admin', '/admin.php/short/jump/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"121\",\"content\":\"22\",\"url_list\":\"1\\r\\n2\\r\\n3\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555774347);
INSERT INTO `d_admin_log` VALUES (272, 1, 'admin', '/admin.php/short/jump/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"title\":\"121\",\"content\":\"22\",\"url_list\":\"1\\r\\n2\\r\\n3\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555774356);
INSERT INTO `d_admin_log` VALUES (273, 1, 'admin', '/admin.php/short/jump/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"url_list_id\":\"\",\"title\":\"\\u957f\\u94fe\\u63a5\",\"content\":\"\\u957f\\u8fde\\u63a5\",\"url_list\":\"https:\\/\\/www.kancloud.cn\\/manual\\/thinkphp5\\/135177\\r\\nhttps:\\/\\/www.jb51.net\\/article\\/67571.htm\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555776143);
INSERT INTO `d_admin_log` VALUES (274, 1, 'admin', '/admin.php/short/url/del/ids/714,713,712,711', '', '{\"action\":\"del\",\"ids\":\"714,713,712,711\",\"params\":\"\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555776169);
INSERT INTO `d_admin_log` VALUES (275, 1, 'admin', '/admin.php/short/host/edit/ids/2?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"host\":\"duanlian\",\"type\":\"main\",\"status\":\"1\",\"brand\":\"0\"},\"ids\":\"2\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555776181);
INSERT INTO `d_admin_log` VALUES (276, 1, 'admin', '/admin.php/short/host/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"host\":\"test.com\",\"type\":\"jump\",\"status\":\"1\",\"brand\":\"0\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555776203);
INSERT INTO `d_admin_log` VALUES (277, 1, 'admin', '/admin.php/short/jump/add?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"url_list_id\":\"714\",\"title\":\"\\u6807\\u9898\",\"content\":\"\\u6807\\u9898\",\"url_list\":\"https:\\/\\/www.baidu.com\\/\"}}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555776248);
INSERT INTO `d_admin_log` VALUES (278, 1, 'admin', '/admin.php/short/host/edit/ids/2?dialog=1', '', '{\"dialog\":\"1\",\"row\":{\"host\":\"duanlian.com\",\"type\":\"main\",\"status\":\"1\",\"brand\":\"0\"},\"ids\":\"2\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555777002);
INSERT INTO `d_admin_log` VALUES (279, 1, 'admin', '/admin.php/short/jump/del/ids/3,2,1', '', '{\"action\":\"del\",\"ids\":\"3,2,1\",\"params\":\"\"}', '0.0.0.0', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36', 1555779359);
COMMIT;

-- ----------------------------
-- Table structure for d_attachment
-- ----------------------------
DROP TABLE IF EXISTS `d_attachment`;
CREATE TABLE `d_attachment` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '物理路径',
  `imagewidth` varchar(30) NOT NULL DEFAULT '' COMMENT '宽度',
  `imageheight` varchar(30) NOT NULL DEFAULT '' COMMENT '高度',
  `imagetype` varchar(30) NOT NULL DEFAULT '' COMMENT '图片类型',
  `imageframes` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '图片帧数',
  `filesize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文件大小',
  `mimetype` varchar(100) NOT NULL DEFAULT '' COMMENT 'mime类型',
  `extparam` varchar(255) NOT NULL DEFAULT '' COMMENT '透传数据',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建日期',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `uploadtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上传时间',
  `storage` varchar(100) NOT NULL DEFAULT 'local' COMMENT '存储位置',
  `sha1` varchar(40) NOT NULL DEFAULT '' COMMENT '文件 sha1编码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='附件表';

-- ----------------------------
-- Records of d_attachment
-- ----------------------------
BEGIN;
INSERT INTO `d_attachment` VALUES (1, 1, 0, '/assets/img/qrcode.png', '150', '150', 'png', 0, 21859, 'image/png', '', 1499681848, 1499681848, 1499681848, 'local', '17163603d0263e4838b9387ff2cd4877e8b018f6');
INSERT INTO `d_attachment` VALUES (2, 1, 0, '/uploads/20190412/75e969c4127c4c841869e0231079a24f.jpg', '2000', '167', 'jpg', 0, 145848, 'image/jpeg', '', 1555050397, 1555050397, 1555050397, 'local', 'a8635415ed604fc2e4e5845a223f77838a67dc6b');
COMMIT;

-- ----------------------------
-- Table structure for d_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `d_auth_group`;
CREATE TABLE `d_auth_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父组别',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '组名',
  `rules` text NOT NULL COMMENT '规则ID',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` varchar(30) NOT NULL DEFAULT '' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='分组表';

-- ----------------------------
-- Records of d_auth_group
-- ----------------------------
BEGIN;
INSERT INTO `d_auth_group` VALUES (1, 0, 'Admin group', '*', 1490883540, 149088354, 'normal');
INSERT INTO `d_auth_group` VALUES (2, 1, 'Second group', '13,14,16,15,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,40,41,42,43,44,45,46,47,48,49,50,55,56,57,58,59,60,61,62,63,64,65,1,9,10,11,7,6,8,2,4,5', 1490883540, 1505465692, 'normal');
INSERT INTO `d_auth_group` VALUES (3, 2, 'Third group', '1,4,9,10,11,13,14,15,16,17,40,41,42,43,44,45,46,47,48,49,50,55,56,57,58,59,60,61,62,63,64,65,5', 1490883540, 1502205322, 'normal');
INSERT INTO `d_auth_group` VALUES (4, 1, 'Second group 2', '1,4,13,14,15,16,17,55,56,57,58,59,60,61,62,63,64,65', 1490883540, 1502205350, 'normal');
INSERT INTO `d_auth_group` VALUES (5, 2, 'Third group 2', '1,2,6,7,8,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34', 1490883540, 1502205344, 'normal');
COMMIT;

-- ----------------------------
-- Table structure for d_auth_group_access
-- ----------------------------
DROP TABLE IF EXISTS `d_auth_group_access`;
CREATE TABLE `d_auth_group_access` (
  `uid` int(10) unsigned NOT NULL COMMENT '会员ID',
  `group_id` int(10) unsigned NOT NULL COMMENT '级别ID',
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='权限分组表';

-- ----------------------------
-- Records of d_auth_group_access
-- ----------------------------
BEGIN;
INSERT INTO `d_auth_group_access` VALUES (1, 1);
COMMIT;

-- ----------------------------
-- Table structure for d_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `d_auth_rule`;
CREATE TABLE `d_auth_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('menu','file') NOT NULL DEFAULT 'file' COMMENT 'menu为菜单,file为权限节点',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '规则名称',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '规则名称',
  `icon` varchar(50) NOT NULL DEFAULT '' COMMENT '图标',
  `condition` varchar(255) NOT NULL DEFAULT '' COMMENT '条件',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `ismenu` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为菜单',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重',
  `status` varchar(30) NOT NULL DEFAULT '' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`) USING BTREE,
  KEY `pid` (`pid`),
  KEY `weigh` (`weigh`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='节点表';

-- ----------------------------
-- Records of d_auth_rule
-- ----------------------------
BEGIN;
INSERT INTO `d_auth_rule` VALUES (1, 'file', 0, 'dashboard', 'Dashboard', 'fa fa-dashboard', '', 'Dashboard tips', 1, 1497429920, 1497429920, 143, 'normal');
INSERT INTO `d_auth_rule` VALUES (2, 'file', 0, 'general', 'General', 'fa fa-cogs', '', '', 1, 1497429920, 1497430169, 137, 'normal');
INSERT INTO `d_auth_rule` VALUES (5, 'file', 0, 'auth', 'Auth', 'fa fa-group', '', '', 1, 1497429920, 1497430092, 99, 'normal');
INSERT INTO `d_auth_rule` VALUES (6, 'file', 2, 'general/config', 'Config', 'fa fa-cog', '', 'Config tips', 1, 1497429920, 1497430683, 60, 'normal');
INSERT INTO `d_auth_rule` VALUES (7, 'file', 2, 'general/attachment', 'Attachment', 'fa fa-file-image-o', '', 'Attachment tips', 1, 1497429920, 1497430699, 53, 'normal');
INSERT INTO `d_auth_rule` VALUES (8, 'file', 2, 'general/profile', 'Profile', 'fa fa-user', '', '', 1, 1497429920, 1497429920, 34, 'normal');
INSERT INTO `d_auth_rule` VALUES (9, 'file', 5, 'auth/admin', 'Admin', 'fa fa-user', '', 'Admin tips', 1, 1497429920, 1497430320, 118, 'normal');
INSERT INTO `d_auth_rule` VALUES (10, 'file', 5, 'auth/adminlog', 'Admin log', 'fa fa-list-alt', '', 'Admin log tips', 1, 1497429920, 1497430307, 113, 'normal');
INSERT INTO `d_auth_rule` VALUES (11, 'file', 5, 'auth/group', 'Group', 'fa fa-group', '', 'Group tips', 1, 1497429920, 1497429920, 109, 'normal');
INSERT INTO `d_auth_rule` VALUES (12, 'file', 5, 'auth/rule', 'Rule', 'fa fa-bars', '', 'Rule tips', 1, 1497429920, 1497430581, 104, 'normal');
INSERT INTO `d_auth_rule` VALUES (13, 'file', 1, 'dashboard/index', 'View', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 136, 'normal');
INSERT INTO `d_auth_rule` VALUES (14, 'file', 1, 'dashboard/add', 'Add', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 135, 'normal');
INSERT INTO `d_auth_rule` VALUES (15, 'file', 1, 'dashboard/del', 'Delete', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 133, 'normal');
INSERT INTO `d_auth_rule` VALUES (16, 'file', 1, 'dashboard/edit', 'Edit', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 134, 'normal');
INSERT INTO `d_auth_rule` VALUES (17, 'file', 1, 'dashboard/multi', 'Multi', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 132, 'normal');
INSERT INTO `d_auth_rule` VALUES (18, 'file', 6, 'general/config/index', 'View', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 52, 'normal');
INSERT INTO `d_auth_rule` VALUES (19, 'file', 6, 'general/config/add', 'Add', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 51, 'normal');
INSERT INTO `d_auth_rule` VALUES (20, 'file', 6, 'general/config/edit', 'Edit', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 50, 'normal');
INSERT INTO `d_auth_rule` VALUES (21, 'file', 6, 'general/config/del', 'Delete', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 49, 'normal');
INSERT INTO `d_auth_rule` VALUES (22, 'file', 6, 'general/config/multi', 'Multi', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 48, 'normal');
INSERT INTO `d_auth_rule` VALUES (23, 'file', 7, 'general/attachment/index', 'View', 'fa fa-circle-o', '', 'Attachment tips', 0, 1497429920, 1497429920, 59, 'normal');
INSERT INTO `d_auth_rule` VALUES (24, 'file', 7, 'general/attachment/select', 'Select attachment', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 58, 'normal');
INSERT INTO `d_auth_rule` VALUES (25, 'file', 7, 'general/attachment/add', 'Add', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 57, 'normal');
INSERT INTO `d_auth_rule` VALUES (26, 'file', 7, 'general/attachment/edit', 'Edit', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 56, 'normal');
INSERT INTO `d_auth_rule` VALUES (27, 'file', 7, 'general/attachment/del', 'Delete', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 55, 'normal');
INSERT INTO `d_auth_rule` VALUES (28, 'file', 7, 'general/attachment/multi', 'Multi', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 54, 'normal');
INSERT INTO `d_auth_rule` VALUES (29, 'file', 8, 'general/profile/index', 'View', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 33, 'normal');
INSERT INTO `d_auth_rule` VALUES (30, 'file', 8, 'general/profile/update', 'Update profile', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 32, 'normal');
INSERT INTO `d_auth_rule` VALUES (31, 'file', 8, 'general/profile/add', 'Add', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 31, 'normal');
INSERT INTO `d_auth_rule` VALUES (32, 'file', 8, 'general/profile/edit', 'Edit', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 30, 'normal');
INSERT INTO `d_auth_rule` VALUES (33, 'file', 8, 'general/profile/del', 'Delete', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 29, 'normal');
INSERT INTO `d_auth_rule` VALUES (34, 'file', 8, 'general/profile/multi', 'Multi', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 28, 'normal');
INSERT INTO `d_auth_rule` VALUES (40, 'file', 9, 'auth/admin/index', 'View', 'fa fa-circle-o', '', 'Admin tips', 0, 1497429920, 1497429920, 117, 'normal');
INSERT INTO `d_auth_rule` VALUES (41, 'file', 9, 'auth/admin/add', 'Add', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 116, 'normal');
INSERT INTO `d_auth_rule` VALUES (42, 'file', 9, 'auth/admin/edit', 'Edit', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 115, 'normal');
INSERT INTO `d_auth_rule` VALUES (43, 'file', 9, 'auth/admin/del', 'Delete', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 114, 'normal');
INSERT INTO `d_auth_rule` VALUES (44, 'file', 10, 'auth/adminlog/index', 'View', 'fa fa-circle-o', '', 'Admin log tips', 0, 1497429920, 1497429920, 112, 'normal');
INSERT INTO `d_auth_rule` VALUES (45, 'file', 10, 'auth/adminlog/detail', 'Detail', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 111, 'normal');
INSERT INTO `d_auth_rule` VALUES (46, 'file', 10, 'auth/adminlog/del', 'Delete', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 110, 'normal');
INSERT INTO `d_auth_rule` VALUES (47, 'file', 11, 'auth/group/index', 'View', 'fa fa-circle-o', '', 'Group tips', 0, 1497429920, 1497429920, 108, 'normal');
INSERT INTO `d_auth_rule` VALUES (48, 'file', 11, 'auth/group/add', 'Add', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 107, 'normal');
INSERT INTO `d_auth_rule` VALUES (49, 'file', 11, 'auth/group/edit', 'Edit', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 106, 'normal');
INSERT INTO `d_auth_rule` VALUES (50, 'file', 11, 'auth/group/del', 'Delete', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 105, 'normal');
INSERT INTO `d_auth_rule` VALUES (51, 'file', 12, 'auth/rule/index', 'View', 'fa fa-circle-o', '', 'Rule tips', 0, 1497429920, 1497429920, 103, 'normal');
INSERT INTO `d_auth_rule` VALUES (52, 'file', 12, 'auth/rule/add', 'Add', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 102, 'normal');
INSERT INTO `d_auth_rule` VALUES (53, 'file', 12, 'auth/rule/edit', 'Edit', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 101, 'normal');
INSERT INTO `d_auth_rule` VALUES (54, 'file', 12, 'auth/rule/del', 'Delete', 'fa fa-circle-o', '', '', 0, 1497429920, 1497429920, 100, 'normal');
INSERT INTO `d_auth_rule` VALUES (85, 'file', 0, 'short', '短链管理', 'fa fa-american-sign-language-interpreting', '', '', 1, 1554876435, 1554876435, 140, 'normal');
INSERT INTO `d_auth_rule` VALUES (86, 'file', 85, 'short/host/index', '域名管理', 'fa fa-delicious', '', '', 1, 1554876468, 1555772749, 10, 'normal');
INSERT INTO `d_auth_rule` VALUES (87, 'file', 85, 'short/url/index', '链接管理', 'fa fa-database', '', '', 1, 1554878181, 1555772756, 9, 'normal');
INSERT INTO `d_auth_rule` VALUES (88, 'file', 85, 'short/ad/index', '广告管理', 'fa fa-codepen', '', '', 1, 1554908756, 1554908756, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (89, 'file', 85, 'short/ad/ad', '广告配置', 'fa fa-bullseye', '', '', 1, 1554910938, 1554910938, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (90, 'file', 85, 'short/code/code', '极验验证码', 'fa fa-ambulance', '', '', 1, 1555244891, 1555245046, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (92, 'file', 85, 'short/code/wocoy', '火车头配置', 'fa fa-archive', '', '', 1, 1555247878, 1555248054, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (93, 'file', 85, 'short/jump/index', '跳转落地页', 'fa fa-tasks', '', '', 0, 1555772719, 1555785408, 8, 'normal');
INSERT INTO `d_auth_rule` VALUES (94, 'file', 85, 'short/code/agency', '落地反代', 'fa fa-adjust', '', '', 1, 1555785373, 1555785421, 8, 'normal');
INSERT INTO `d_auth_rule` VALUES (95, 'file', 0, 'weixin', '微信工具', 'fa fa-wechat', '', '', 1, 1556244184, 1556244184, 140, 'normal');
INSERT INTO `d_auth_rule` VALUES (96, 'file', 95, 'fission', '微信裂变', 'fa fa-codiepie', '', '', 1, 1556244309, 1556244330, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (97, 'file', 96, 'fission/qrcode/index', '群二维码管理', 'fa fa-qrcode', '', '', 1, 1556244488, 1556246336, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (98, 'file', 96, 'fission/template/index', '模板管理', 'fa fa-dashcube', '', '', 1, 1556428616, 1556428639, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (99, 'file', 96, 'short/code/wx', '微信公众号配置', 'fa fa-contao', '', '', 1, 1556430138, 1556430138, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (100, 'file', 96, 'fission/url/index', '跳转链接', 'fa fa-chain', '', '', 1, 1556466109, 1556466109, 0, 'normal');
INSERT INTO `d_auth_rule` VALUES (101, 'file', 96, 'fission/url/show', '推广链接', 'fa fa-child', '', '', 1, 1556503300, 1556503300, 10, 'normal');
COMMIT;

-- ----------------------------
-- Table structure for d_category
-- ----------------------------
DROP TABLE IF EXISTS `d_category`;
CREATE TABLE `d_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` varchar(30) NOT NULL DEFAULT '' COMMENT '栏目类型',
  `name` varchar(30) NOT NULL DEFAULT '',
  `nickname` varchar(50) NOT NULL DEFAULT '',
  `flag` set('hot','index','recommend') NOT NULL DEFAULT '',
  `image` varchar(100) NOT NULL DEFAULT '' COMMENT '图片',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `diyname` varchar(30) NOT NULL DEFAULT '' COMMENT '自定义名称',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重',
  `status` varchar(30) NOT NULL DEFAULT '' COMMENT '状态',
  PRIMARY KEY (`id`),
  KEY `weigh` (`weigh`,`id`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='分类表';

-- ----------------------------
-- Records of d_category
-- ----------------------------
BEGIN;
INSERT INTO `d_category` VALUES (1, 0, 'page', '官方新闻', 'news', 'recommend', '/assets/img/qrcode.png', '', '', 'news', 1495262190, 1495262190, 1, 'normal');
INSERT INTO `d_category` VALUES (2, 0, 'page', '移动应用', 'mobileapp', 'hot', '/assets/img/qrcode.png', '', '', 'mobileapp', 1495262244, 1495262244, 2, 'normal');
INSERT INTO `d_category` VALUES (3, 2, 'page', '微信公众号', 'wechatpublic', 'index', '/assets/img/qrcode.png', '', '', 'wechatpublic', 1495262288, 1495262288, 3, 'normal');
INSERT INTO `d_category` VALUES (4, 2, 'page', 'Android开发', 'android', 'recommend', '/assets/img/qrcode.png', '', '', 'android', 1495262317, 1495262317, 4, 'normal');
INSERT INTO `d_category` VALUES (5, 0, 'page', '软件产品', 'software', 'recommend', '/assets/img/qrcode.png', '', '', 'software', 1495262336, 1499681850, 5, 'normal');
INSERT INTO `d_category` VALUES (6, 5, 'page', '网站建站', 'website', 'recommend', '/assets/img/qrcode.png', '', '', 'website', 1495262357, 1495262357, 6, 'normal');
INSERT INTO `d_category` VALUES (7, 5, 'page', '企业管理软件', 'company', 'index', '/assets/img/qrcode.png', '', '', 'company', 1495262391, 1495262391, 7, 'normal');
INSERT INTO `d_category` VALUES (8, 6, 'page', 'PC端', 'website-pc', 'recommend', '/assets/img/qrcode.png', '', '', 'website-pc', 1495262424, 1495262424, 8, 'normal');
INSERT INTO `d_category` VALUES (9, 6, 'page', '移动端', 'website-mobile', 'recommend', '/assets/img/qrcode.png', '', '', 'website-mobile', 1495262456, 1495262456, 9, 'normal');
INSERT INTO `d_category` VALUES (10, 7, 'page', 'CRM系统 ', 'company-crm', 'recommend', '/assets/img/qrcode.png', '', '', 'company-crm', 1495262487, 1495262487, 10, 'normal');
INSERT INTO `d_category` VALUES (11, 7, 'page', 'SASS平台软件', 'company-sass', 'recommend', '/assets/img/qrcode.png', '', '', 'company-sass', 1495262515, 1495262515, 11, 'normal');
INSERT INTO `d_category` VALUES (12, 0, 'test', '测试1', 'test1', 'recommend', '/assets/img/qrcode.png', '', '', 'test1', 1497015727, 1497015727, 12, 'normal');
INSERT INTO `d_category` VALUES (13, 0, 'test', '测试2', 'test2', 'recommend', '/assets/img/qrcode.png', '', '', 'test2', 1497015738, 1497015738, 13, 'normal');
COMMIT;

-- ----------------------------
-- Table structure for d_config
-- ----------------------------
DROP TABLE IF EXISTS `d_config`;
CREATE TABLE `d_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '变量名',
  `group` varchar(30) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '变量标题',
  `tip` varchar(100) NOT NULL DEFAULT '' COMMENT '变量描述',
  `type` varchar(30) NOT NULL DEFAULT '' COMMENT '类型:string,text,int,bool,array,datetime,date,file',
  `value` text NOT NULL COMMENT '变量值',
  `content` text NOT NULL COMMENT '变量字典数据',
  `rule` varchar(100) NOT NULL DEFAULT '' COMMENT '验证规则',
  `extend` varchar(255) NOT NULL DEFAULT '' COMMENT '扩展属性',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='系统配置';

-- ----------------------------
-- Records of d_config
-- ----------------------------
BEGIN;
INSERT INTO `d_config` VALUES (1, 'name', 'basic', 'Site name', '请填写站点名称', 'string', '短连接', '', 'required', '');
INSERT INTO `d_config` VALUES (2, 'beian', 'basic', 'Beian', '粤ICP备15054802号-4', 'string', '', '', '', '');
INSERT INTO `d_config` VALUES (3, 'cdnurl', 'basic', 'Cdn url', '如果静态资源使用第三方云储存请配置该值', 'string', '', '', '', '');
INSERT INTO `d_config` VALUES (4, 'version', 'basic', 'Version', '如果静态资源有变动请重新配置该值', 'string', '1.0.1', '', 'required', '');
INSERT INTO `d_config` VALUES (5, 'timezone', 'basic', 'Timezone', '', 'string', 'Asia/Shanghai', '', 'required', '');
INSERT INTO `d_config` VALUES (6, 'forbiddenip', 'basic', 'Forbidden ip', '一行一条记录', 'text', '', '', '', '');
INSERT INTO `d_config` VALUES (7, 'languages', 'basic', 'Languages', '', 'array', '{\"backend\":\"zh-cn\",\"frontend\":\"zh-cn\"}', '', 'required', '');
INSERT INTO `d_config` VALUES (8, 'fixedpage', 'basic', 'Fixed page', '请尽量输入左侧菜单栏存在的链接', 'string', 'dashboard', '', 'required', '');
INSERT INTO `d_config` VALUES (9, 'categorytype', 'dictionary', 'Category type', '', 'array', '{\"default\":\"Default\",\"page\":\"Page\",\"article\":\"Article\",\"test\":\"Test\"}', '', '', '');
INSERT INTO `d_config` VALUES (10, 'configgroup', 'dictionary', 'Config group', '', 'array', '{\"basic\":\"Basic\",\"email\":\"Email\",\"dictionary\":\"Dictionary\",\"user\":\"User\",\"example\":\"Example\"}', '', '', '');
INSERT INTO `d_config` VALUES (11, 'mail_type', 'email', 'Mail type', '选择邮件发送方式', 'select', '1', '[\"Please select\",\"SMTP\",\"Mail\"]', '', '');
INSERT INTO `d_config` VALUES (12, 'mail_smtp_host', 'email', 'Mail smtp host', '错误的配置发送邮件会导致服务器超时', 'string', 'smtp.qq.com', '', '', '');
INSERT INTO `d_config` VALUES (13, 'mail_smtp_port', 'email', 'Mail smtp port', '(不加密默认25,SSL默认465,TLS默认587)', 'string', '465', '', '', '');
INSERT INTO `d_config` VALUES (14, 'mail_smtp_user', 'email', 'Mail smtp user', '（填写完整用户名）', 'string', '10000', '', '', '');
INSERT INTO `d_config` VALUES (15, 'mail_smtp_pass', 'email', 'Mail smtp password', '（填写您的密码）', 'string', 'password', '', '', '');
INSERT INTO `d_config` VALUES (16, 'mail_verify_type', 'email', 'Mail vertify type', '（SMTP验证方式[推荐SSL]）', 'select', '2', '[\"None\",\"TLS\",\"SSL\"]', '', '');
INSERT INTO `d_config` VALUES (17, 'mail_from', 'email', 'Mail from', '', 'string', '10000@qq.com', '', '', '');
COMMIT;

-- ----------------------------
-- Table structure for d_duan_config
-- ----------------------------
DROP TABLE IF EXISTS `d_duan_config`;
CREATE TABLE `d_duan_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '配置名',
  `value` varchar(255) DEFAULT NULL COMMENT '配置详情',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='短网址配置';

-- ----------------------------
-- Records of d_duan_config
-- ----------------------------
BEGIN;
INSERT INTO `d_duan_config` VALUES (1, 'yzm', '{\"geetestID\":\"48a6ebac4ebc6642d68c217fca33eb4d\",\"geetestKey\":\"4f1c085290bec5afdc54df73535fc361\",\"status\":\"1\"}', '2019-04-14 20:56:51', '2019-04-14 22:03:21');
INSERT INTO `d_duan_config` VALUES (5, 'locoy', '{\"key\":\"4242342\",\"status\":\"1\"}', '2019-04-14 21:22:23', '2019-04-14 21:22:32');
INSERT INTO `d_duan_config` VALUES (6, 'agency', '{\"status\":\"1\"}', '2019-04-21 02:35:31', '2019-04-22 14:38:57');
INSERT INTO `d_duan_config` VALUES (7, 'wx', '{\"app_id\":\"wx310be811df93bfed\",\"secret\":\"8cd6a16b68d7b2addec2e014072484df\",\"friend\":\"1\",\"circle\":\"0\"}', '2019-04-28 13:48:21', '2019-04-29 17:24:08');
COMMIT;

-- ----------------------------
-- Table structure for d_ems
-- ----------------------------
DROP TABLE IF EXISTS `d_ems`;
CREATE TABLE `d_ems` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `event` varchar(30) NOT NULL DEFAULT '' COMMENT '事件',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '邮箱',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '验证码',
  `times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '验证次数',
  `ip` varchar(30) NOT NULL DEFAULT '' COMMENT 'IP',
  `createtime` int(10) unsigned DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='邮箱验证码表';

-- ----------------------------
-- Table structure for d_group_qrcode
-- ----------------------------
DROP TABLE IF EXISTS `d_group_qrcode`;
CREATE TABLE `d_group_qrcode` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL COMMENT '群名',
  `qrcode` varchar(255) DEFAULT NULL COMMENT '二维码',
  `set_count` int(11) DEFAULT '100' COMMENT '预定设置',
  `use_count` int(11) DEFAULT '0' COMMENT '使用次数',
  `status` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL COMMENT '创建时间\n',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='群二维码 ';

-- ----------------------------
-- Table structure for d_group_template
-- ----------------------------
DROP TABLE IF EXISTS `d_group_template`;
CREATE TABLE `d_group_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `sub_title` varchar(255) DEFAULT NULL COMMENT '副标题',
  `status` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `img` varchar(255) DEFAULT NULL COMMENT '加群图片',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='群模板';

-- ----------------------------
-- Table structure for d_group_url
-- ----------------------------
DROP TABLE IF EXISTS `d_group_url`;
CREATE TABLE `d_group_url` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL COMMENT '随机url',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='随机链接';

-- ----------------------------
-- Records of d_group_url
-- ----------------------------
BEGIN;
INSERT INTO `d_group_url` VALUES (1, 'https://www.baidu.com', '2019-04-28 23:43:04', '2019-04-28 23:43:04');
COMMIT;

-- ----------------------------
-- Table structure for d_host
-- ----------------------------
DROP TABLE IF EXISTS `d_host`;
CREATE TABLE `d_host` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL COMMENT '链接地址',
  `check_count` int(11) DEFAULT NULL COMMENT '检查次数',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间\n',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `status` int(11) DEFAULT '1' COMMENT '状态 0:禁用 1:启用',
  `check_time` datetime DEFAULT '0000-00-00 00:00:00' COMMENT '检查时间',
  `type` enum('main','jump') DEFAULT NULL COMMENT 'main 主域名  jump 跳转域名',
  `use_count` int(11) DEFAULT NULL COMMENT '使用次数',
  `brand` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `d_main_url_id_index` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='主域名';

-- ----------------------------
-- Records of d_host
-- ----------------------------
BEGIN;
INSERT INTO `d_host` VALUES (11, 'ugl8.cn', 164, '2019-04-21 01:01:43', '2019-04-29 17:40:02', 1, '2019-04-29 16:36:55', 'jump', 449, 1);
INSERT INTO `d_host` VALUES (12, '55xz.cn', 158, '2019-04-21 01:02:03', '2019-04-28 23:10:14', 1, '2019-04-29 16:38:05', 'main', 3171, 0);
COMMIT;

-- ----------------------------
-- Table structure for d_jump_list
-- ----------------------------
DROP TABLE IF EXISTS `d_jump_list`;
CREATE TABLE `d_jump_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url_list_id` int(11) DEFAULT NULL COMMENT '列表id',
  `url` varchar(255) DEFAULT NULL COMMENT '链接',
  `status` int(11) DEFAULT NULL COMMENT '状态: 0 已被封禁 1 未封禁',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='跳转池';

-- ----------------------------
-- Records of d_jump_list
-- ----------------------------
BEGIN;
INSERT INTO `d_jump_list` VALUES (1, 711, 'http://fm1.shjgr.com/', 1, '2019-04-21 01:03:02', '2019-04-22 05:56:40');
INSERT INTO `d_jump_list` VALUES (2, 711, 'http://fm2.shjgr.com/', 1, '2019-04-21 01:03:02', '2019-04-22 07:21:37');
INSERT INTO `d_jump_list` VALUES (3, 711, 'http://fm3.shjgr.com/', 1, '2019-04-21 01:03:02', '2019-04-22 06:11:58');
COMMIT;

-- ----------------------------
-- Table structure for d_sms
-- ----------------------------
DROP TABLE IF EXISTS `d_sms`;
CREATE TABLE `d_sms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `event` varchar(30) NOT NULL DEFAULT '' COMMENT '事件',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '验证码',
  `times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '验证次数',
  `ip` varchar(30) NOT NULL DEFAULT '' COMMENT 'IP',
  `createtime` int(10) unsigned DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='短信验证码表';

-- ----------------------------
-- Table structure for d_test
-- ----------------------------
DROP TABLE IF EXISTS `d_test`;
CREATE TABLE `d_test` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `admin_id` int(10) NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID(单选)',
  `category_ids` varchar(100) NOT NULL COMMENT '分类ID(多选)',
  `week` enum('monday','tuesday','wednesday') NOT NULL COMMENT '星期(单选):monday=星期一,tuesday=星期二,wednesday=星期三',
  `flag` set('hot','index','recommend') NOT NULL DEFAULT '' COMMENT '标志(多选):hot=热门,index=首页,recommend=推荐',
  `genderdata` enum('male','female') NOT NULL DEFAULT 'male' COMMENT '性别(单选):male=男,female=女',
  `hobbydata` set('music','reading','swimming') NOT NULL COMMENT '爱好(多选):music=音乐,reading=读书,swimming=游泳',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `content` text NOT NULL COMMENT '内容',
  `image` varchar(100) NOT NULL DEFAULT '' COMMENT '图片',
  `images` varchar(1500) NOT NULL DEFAULT '' COMMENT '图片组',
  `attachfile` varchar(100) NOT NULL DEFAULT '' COMMENT '附件',
  `keywords` varchar(100) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `city` varchar(100) NOT NULL DEFAULT '' COMMENT '省市',
  `price` float(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格',
  `views` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击',
  `startdate` date DEFAULT NULL COMMENT '开始日期',
  `activitytime` datetime DEFAULT NULL COMMENT '活动时间(datetime)',
  `year` year(4) DEFAULT NULL COMMENT '年',
  `times` time DEFAULT NULL COMMENT '时间',
  `refreshtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '刷新时间(int)',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重',
  `switch` tinyint(1) NOT NULL DEFAULT '0' COMMENT '开关',
  `status` enum('normal','hidden') NOT NULL DEFAULT 'normal' COMMENT '状态',
  `state` enum('0','1','2') NOT NULL DEFAULT '1' COMMENT '状态值:0=禁用,1=正常,2=推荐',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='测试表';

-- ----------------------------
-- Records of d_test
-- ----------------------------
BEGIN;
INSERT INTO `d_test` VALUES (1, 0, 12, '12,13', 'monday', 'hot,index', 'male', 'music,reading', '我是一篇测试文章', '<p>我是测试内容</p>', '/assets/img/avatar.png', '/assets/img/avatar.png,/assets/img/qrcode.png', '/assets/img/avatar.png', '关键字', '描述', '广西壮族自治区/百色市/平果县', 0.00, 0, '2017-07-10', '2017-07-10 18:24:45', 2017, '18:24:45', 1499682285, 1499682526, 1499682526, 0, 1, 'normal', '1');
COMMIT;

-- ----------------------------
-- Table structure for d_url_list
-- ----------------------------
DROP TABLE IF EXISTS `d_url_list`;
CREATE TABLE `d_url_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT '0' COMMENT '跳转类型 0:默认 1:跳转池',
  `content` text COMMENT '内容',
  `duan` varchar(255)  null,
  `host` varchar(255) DEFAULT NULL COMMENT '域名',
  `url` varchar(255) DEFAULT NULL COMMENT '跳转url',
  `short` varchar(255) DEFAULT NULL COMMENT '短链',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `pass` varchar(255) DEFAULT NULL COMMENT '密码',
  `status` int(11) DEFAULT '1' COMMENT '状态',
  `jump_status` int(11) DEFAULT '1',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `d_url_list_short_uindex` (`short`)
) ENGINE=InnoDB AUTO_INCREMENT=788 DEFAULT CHARSET=utf8 COMMENT='链接跳转';

-- ----------------------------
-- Records of d_url_list
-- ----------------------------
BEGIN;
INSERT INTO `d_url_list` VALUES (685, NULL, NULL, 'baisi.co', 'https://baisi.co', 'xMPws', '微信域名防封短网址站群系统', '', 1, 0, '2019-04-13 18:38:49', '2019-04-13 18:38:53', 1);
INSERT INTO `d_url_list` VALUES (686, NULL, NULL, 'baisi.co', 'https://baisi.co', '19oyE', '超级短网址短链接站群系统', '', 1, 0, '2019-04-13 19:16:12', '2019-04-29 10:47:30', 3);
INSERT INTO `d_url_list` VALUES (695, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'Xejl2', '洞头陈赛玉与人武部', '', 1, 0, '2019-04-14 20:57:21', '2019-04-14 20:57:27', 1);
INSERT INTO `d_url_list` VALUES (696, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'AJV96', '潘思言家境', '', 1, 0, '2019-04-14 20:58:31', '2019-04-14 20:58:31', 0);
INSERT INTO `d_url_list` VALUES (697, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'u58Ms', '洞头陈赛玉与人武部长视频', '', 1, 0, '2019-04-14 20:58:58', '2019-04-29 05:44:24', 1);
INSERT INTO `d_url_list` VALUES (698, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'ROGTc', '花姐真名叫什么', '', 1, 0, '2019-04-14 20:59:16', '2019-04-14 20:59:16', 0);
INSERT INTO `d_url_list` VALUES (699, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'uppRY', '哈尔滨陈华假富二代', '', 1, 0, '2019-04-14 20:59:46', '2019-04-29 04:38:39', 1);
INSERT INTO `d_url_list` VALUES (700, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'OwM5K', '朴春的脸怎么了', '', 1, 0, '2019-04-14 21:00:23', '2019-04-29 05:11:43', 1);
INSERT INTO `d_url_list` VALUES (701, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'Gan9Y', '陆文韬个人资料', '', 1, 0, '2019-04-14 21:01:03', '2019-04-14 21:01:03', 0);
INSERT INTO `d_url_list` VALUES (702, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'pMBq0', '集团公司巡视的五实要求', '', 1, 0, '2019-04-14 21:02:09', '2019-04-29 03:33:32', 1);
INSERT INTO `d_url_list` VALUES (703, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'ZjWHA', '万梓良落魄街头照片', '', 1, 0, '2019-04-14 21:02:40', '2019-04-29 03:39:18', 1);
INSERT INTO `d_url_list` VALUES (704, NULL, NULL, 'baisi.co', 'http://www.jinpaimishu.com/', 'MWGaE', '张鹤伦老婆的相片', '', 1, 0, '2019-04-14 21:02:55', '2019-04-14 21:02:55', 0);
INSERT INTO `d_url_list` VALUES (710, NULL, NULL, 'baisi.co', 'https://www.shenqir.com/t/2.html', 'DJWHa', '企业站群关键词霸屏程序', '', 1, 0, '2019-04-15 22:22:06', '2019-04-15 22:22:06', 0);
INSERT INTO `d_url_list` VALUES (711, 1, '上海精工', 'ugl8.cn', 'http://fm1.shjgr.com/', 'MUejE', '上海精工', NULL, 1, 0, '2019-04-21 01:03:02', '2019-04-24 08:28:13', 13);
INSERT INTO `d_url_list` VALUES (712, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'Q40i2', '3333', '', 1, 0, '2019-04-21 02:53:33', '2019-04-29 04:37:54', 10);
INSERT INTO `d_url_list` VALUES (713, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com/archives/907', 'ydfbx', '3333', '', 1, 0, '2019-04-21 02:57:01', '2019-04-29 04:18:37', 3);
INSERT INTO `d_url_list` VALUES (714, NULL, '', 'ugl8.cn', 'http://fm1.shjgr.com/s/2019/0407/5.html', 'pBjce', '3333', '', 1, 0, '2019-04-21 02:58:07', '2019-04-29 03:40:58', 16);
INSERT INTO `d_url_list` VALUES (715, NULL, '', 'ugl8.cn', 'http://fm1.shjgr.com', 'EZ0Mt', '222', '', 1, 0, '2019-04-21 03:01:55', '2019-04-29 09:57:57', 16);
INSERT INTO `d_url_list` VALUES (716, NULL, '', 'ugl8.cn', 'http://fm2.shjgr.com', 'iPdT8', '222', '', 1, 0, '2019-04-21 03:22:23', '2019-04-29 04:44:35', 5);
INSERT INTO `d_url_list` VALUES (717, NULL, '', 'ugl8.cn', 'http://www.baidu.com', 'jJWc2', '222', '', 1, 0, '2019-04-21 03:32:06', '2019-04-29 05:05:16', 8);
INSERT INTO `d_url_list` VALUES (718, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'nJljb', '222', '', 1, 0, '2019-04-21 03:34:06', '2019-04-29 04:35:19', 353);
INSERT INTO `d_url_list` VALUES (719, NULL, '', 'ugl8.cn', 'http://fm1.shjgr.com', 'e3QCR', '32423', '', 1, 0, '2019-04-21 03:46:22', '2019-04-22 04:50:08', 2);
INSERT INTO `d_url_list` VALUES (720, NULL, '', 'ugl8.cn', 'https://blog.csdn.net/', 'zo4o2', '323', '', 1, 0, '2019-04-21 04:02:05', '2019-04-29 17:36:39', 150);
INSERT INTO `d_url_list` VALUES (721, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'Txwuv', '242', '', 1, 0, '2019-04-21 04:03:26', '2019-04-29 03:39:50', 121);
INSERT INTO `d_url_list` VALUES (722, NULL, '223', 'ugl8.cn', 'http://blog.szwyll.com', 'SPZHS', '2331', '', 1, 0, '2019-04-21 09:46:13', '2019-04-23 05:55:23', 114);
INSERT INTO `d_url_list` VALUES (723, NULL, '223', 'ugl8.cn', 'http://blog.szwyll.com', 'pyhUz', '2331', '', 1, 0, '2019-04-21 09:54:14', '2019-04-29 05:08:33', 168);
INSERT INTO `d_url_list` VALUES (724, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'PCIS9', '22', '', 1, 0, '2019-04-21 10:01:57', '2019-04-29 04:07:11', 52);
INSERT INTO `d_url_list` VALUES (725, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'JZFdI', '323', '', 1, 0, '2019-04-21 10:17:10', '2019-04-29 03:55:26', 4);
INSERT INTO `d_url_list` VALUES (726, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'K2Lxs', '323', '', 1, 0, '2019-04-21 10:20:27', '2019-04-29 03:25:34', 3);
INSERT INTO `d_url_list` VALUES (727, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'PQFOb', '323', '', 1, 0, '2019-04-21 10:31:57', '2019-04-29 05:36:16', 2);
INSERT INTO `d_url_list` VALUES (728, NULL, '', 'ugl8.cn', 'http://fm1.shjgr.com', 'mOSKS', '3424', '', 1, 0, '2019-04-21 11:28:35', '2019-04-29 04:12:28', 4);
INSERT INTO `d_url_list` VALUES (729, NULL, '', 'ugl8.cn', 'http://fm1.shjgr.com', 'mJnFG', 'hahah', '', 1, 0, '2019-04-21 18:18:41', '2019-04-29 16:00:22', 24);
INSERT INTO `d_url_list` VALUES (730, NULL, '', 'ugl8.cn', 'http://fm1.shjgr.com/s/2019/0407/5.html', '5qt6Q', '3424', '', 1, 0, '2019-04-21 18:26:04', '2019-04-29 05:17:57', 10);
INSERT INTO `d_url_list` VALUES (731, NULL, '上海精工阀门厂有限公司位于上海浦东新区，是中国通用机械阀门行业协会成 员单位；是中国石化集团物资装备公司物资资源市场成员单位ISO-9001质量保证体 系认证合格单位；是制造《上工牌》阀门的专业公司。上海精工阀门厂有限《上 工牌》阀门产品系列，于2002年被评为中国驰名品牌。', 'ugl8.cn', 'http://www.shjgr.com/about.html', 'gKALK', '上海精工阀门厂有限公司', '', 1, 0, '2019-04-21 18:30:32', '2019-04-29 03:38:11', 103);
INSERT INTO `d_url_list` VALUES (732, NULL, '上海精工阀门厂有限公司位于上海浦东新区，是中国通用机械阀门行业协会成 员单位；是中国石化集团物资装备公司物资资源市场成员单位ISO-9001质量保证体 系认证合格单位；是制造《上工牌》阀门的专业公司。上海精工阀门厂有限《上 工牌》阀门产品系列，于2002年被评为中国驰名品牌。', 'ugl8.cn', 'http://www.shjgfm.com/', 'esd2n', '上海精工阀门厂有限公司', '', 1, 0, '2019-04-21 18:34:13', '2019-04-29 05:00:43', 65);
INSERT INTO `d_url_list` VALUES (733, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'ZuNhh', '223', '', 1, 0, '2019-04-21 18:35:38', '2019-04-29 04:17:43', 47);
INSERT INTO `d_url_list` VALUES (734, NULL, '', 'ugl8.cn', 'http://fm2.shjgr.com/', 'UC34G', '223', '', 1, 0, '2019-04-21 18:48:35', '2019-04-29 04:58:53', 2);
INSERT INTO `d_url_list` VALUES (735, NULL, '', 'ugl8.cn', 'http://fm3.shjgr.com/', 'pQO6C', '223', '', 1, 0, '2019-04-21 18:49:30', '2019-04-29 04:17:05', 3);
INSERT INTO `d_url_list` VALUES (736, NULL, '222222222', 'ugl8.cn', 'http://www.jinggongvalve.com/Home/', 'cTapd', '2222222222', '', 1, 0, '2019-04-21 18:50:34', '2019-04-29 17:32:57', 6);
INSERT INTO `d_url_list` VALUES (737, NULL, '', 'ugl8.cn', 'http://www.jinggongvalve.com/Home/', 'oLku7', '223', '', 1, 0, '2019-04-21 18:50:53', '2019-04-29 05:34:18', 6);
INSERT INTO `d_url_list` VALUES (738, NULL, '3333333333333333', 'ugl8.cn', 'http://www.jsgfm.com/', 'AJRer', '3333333333', '', 1, 0, '2019-04-21 18:52:18', '2019-04-29 04:11:23', 79);
INSERT INTO `d_url_list` VALUES (739, NULL, '', 'ugl8.cn', 'http://www.jsgfm.com', '49b7i', '223', '', 1, 0, '2019-04-21 18:54:13', '2019-04-29 05:17:04', 66);
INSERT INTO `d_url_list` VALUES (740, NULL, '', 'ugl8.cn', 'http://www.jsgfm.com', 'ZhhFb', '223', '', 1, 0, '2019-04-21 18:56:29', '2019-04-29 03:49:16', 2);
INSERT INTO `d_url_list` VALUES (741, NULL, '44444444444', 'ugl8.cn', 'http://www.jsgfm.com/', 'T8G7M', '44444444', '', 1, 0, '2019-04-21 18:57:12', '2019-04-21 18:57:17', 1);
INSERT INTO `d_url_list` VALUES (742, NULL, '', 'ugl8.cn', 'http://blog.szwyll.com', 'MoGzG', '223', '', 1, 0, '2019-04-21 18:57:20', '2019-04-26 05:31:10', 6);
INSERT INTO `d_url_list` VALUES (743, NULL, '5555555555555', 'ugl8.cn', 'http://www.bjjgfm.net/content/71.html', 'zdUcF', '55555555555555', '', 1, 0, '2019-04-21 18:58:58', '2019-04-29 04:57:27', 9);
INSERT INTO `d_url_list` VALUES (744, NULL, '', 'ugl8.cn', 'https://www.snwx8.com/', 'asmuZ', '223', '', 1, 0, '2019-04-21 19:00:17', '2019-04-29 03:26:41', 9);
INSERT INTO `d_url_list` VALUES (745, NULL, '66666666666666666666', 'ugl8.cn', 'https://mp.weixin.qq.com/s?src=11&timestamp=1555842602&ver=1560&signature=WtDtNRPaHMLsb7ukmqiAe0Z3rh1safXzS4eudNIZzEJfIABaD4NH9aX8RCDedcWwonwA5xZAR1Ur3D8bNnldSaYHGjsjUOngQQn5TBmxg6BiULkMfbpALVBgtbaYmWv9&new=1', '3LpOw', '666666666666', '', 1, 0, '2019-04-21 19:00:20', '2019-04-28 17:14:44', 14);
INSERT INTO `d_url_list` VALUES (746, NULL, '', 'ugl8.cn', 'https://mp.weixin.qq.com/s?src=11&timestamp=1555842602&ver=1560&signature=WtDtNRPaHMLsb7ukmqiAe0Z3rh1safXzS4eudNIZzEJfIABaD4NH9aX8RCDedcWwonwA5xZAR1Ur3D8bNnldSaYHGjsjUOngQQn5TBmxg6BiULkMfbpALVBgtbaYmWv9&new=1', 'pO1TJ', '223', '', 1, 0, '2019-04-21 19:01:40', '2019-04-22 05:58:46', 2);
INSERT INTO `d_url_list` VALUES (747, NULL, '2342432342', 'ugl8.cn', 'https://www.kancloud.cn/manual/thinkphp5/125018', '9TH35', 'wwww', '', 1, 0, '2019-04-21 20:11:55', '2019-04-29 06:07:04', 6);
INSERT INTO `d_url_list` VALUES (748, NULL, '112222222222\r\n222222222', 'ugl8.cn', 'http://www.txtouzi.cn/', 'MwR3o', '12121212', '', 1, 0, '2019-04-21 20:15:13', '2019-04-29 04:39:16', 2);
INSERT INTO `d_url_list` VALUES (749, NULL, '24243&lt;br&gt;', 'ugl8.cn', 'https://www.baidu.com/s?ie=utf-8&f=8&rsv_bp=1&rsv_idx=1&tn=baidu&wd=%E5%AF%8C%E6%96%87%E6%9C%AC%E7%BC%96%E8%BE%91%E5%99%A8&oq=%25E7%25BC%2596%25E8%25BE%2591%25E5%2599%25A8&rsv_pq=bf931679000759de&rsv_t=dc16IX77I5mni4lwfOVS9qO0iCypOovopd7sTUotDfXXHvY3Xf2%2', 'Ebz6z', '1231', '', 1, 0, '2019-04-21 20:36:26', '2019-04-29 05:12:05', 2);
INSERT INTO `d_url_list` VALUES (750, NULL, '刺史临流搴翠帏，揭竿命爵分牝牡。官衣亦闻明，端午被恩荣。先鸣余勇争唆使，未至衔枚脸色沮。精魂飘安在，长者空哽噎。好酒沈醉酬子女节，很是酒，一分歌。竞渡深悲千载冤，忠魂一去讵能还。', 'ugl8.cn', 'https://www.shenqir.com/', 'QH7Ov', '4334322222', '', 1, 0, '2019-04-21 20:40:59', '2019-04-22 06:24:14', 2);
INSERT INTO `d_url_list` VALUES (751, NULL, '刺史临流搴翠帏，揭竿命爵分牝牡。官衣亦闻明，端午被恩荣。先鸣余勇争唆使，未至衔枚脸色沮。精魂飘安在，长者空哽噎。好酒沈醉酬子女节，很是酒，一分歌。竞渡深悲千载冤，忠魂一去讵能还。', 'ugl8.cn', 'https://www.shenqir.com/', 'CcGxO', '666666666666666666', '', 1, 0, '2019-04-21 20:45:53', '2019-04-29 08:01:17', 3);
INSERT INTO `d_url_list` VALUES (752, NULL, '这套短网址站群系统与传统常见的短网址站点功能不同，传统短网址站功能核心功能只是生成以后缀形式如：dwz.cn/BvckN4e 的短链接，我们开发的这套短网址生成的短域名是以 Bvck6.url.com 泛二级域名形式生成，之所以叫短网址站群就是使用本程序可大量无限生成泛二级域名为短网址使用。', 'ugl8.cn', 'https://www.shenqir.com/', 'c4Lx8', '677777777777777777', '', 1, 0, '2019-04-21 20:47:17', '2019-04-29 13:42:49', 3);
INSERT INTO `d_url_list` VALUES (753, NULL, '驱蚊器翁群二qeqweeq', 'ugl8.cn', 'https://www.layui.com/doc/modules/layedit.html', 'OjzQa', '4324', '', 1, 0, '2019-04-21 20:50:05', '2019-04-29 03:44:51', 4);
INSERT INTO `d_url_list` VALUES (754, NULL, '&lt;p&gt;这套短网址站群系统与传统常见的短网址站点功能不同，传统短网址站功能核心功能只是生成以后缀形式&lt;p&gt;如：dwz.cn/BvckN4e 的短链接，&lt;p&gt;我们开发的这套短网址生成的短域名是以 Bvck6.url.com 泛二级域名形式生成，之所以叫短网址站群就是使用本程序可大量无限生成泛二级域名为短网址使用。&lt;p&gt;', 'ugl8.cn', 'https://www.shenqir.com/', 'wVnnc', '8888888888888888', '', 1, 0, '2019-04-21 20:51:31', '2019-04-29 12:27:56', 3);
INSERT INTO `d_url_list` VALUES (755, NULL, '2342424234234', 'ugl8.cn', 'https://www.layui.com/doc/modules/layedit.html', '5N3kk', '1312', '', 1, 0, '2019-04-21 20:53:05', '2019-04-21 20:53:05', 0);
INSERT INTO `d_url_list` VALUES (756, NULL, '2342242&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;', 'ugl8.cn', 'http://fex.baidu.com/ueditor/#start-submit', 'QoZjN', '31231', '', 1, 0, '2019-04-21 21:28:24', '2019-04-29 05:33:12', 2);
INSERT INTO `d_url_list` VALUES (757, NULL, '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;1213123123123123', 'ugl8.cn', 'http://fex.baidu.com/ueditor/#start-submit', 'WuTPG', '31231', '', 1, 0, '2019-04-21 21:30:03', '2019-04-29 17:40:02', 12);
INSERT INTO `d_url_list` VALUES (758, NULL, '一、核心优势1、使用无限泛二级域名当作短网址这套短网址站群系统与传统常见的短网址站点功能不同，传统短网址站功能核心功能只是生成以后缀形式如：dwz.cn/BvckN4e 的短链接，我们开发的这套短网址生成的短域名是以 Bvck6.url.com 泛二级域名形式生成，之所以叫短网址站群就是使用本程序可大量无限生成泛二级域名为短网址使用。2、生成短网址自带标题功能，可操作关键词霸屏并且，再使用本程序生成短网址时，可添加推广的标题，且可在跳转停留页面显示，方便被搜索引擎收录跳转页面，这样极大的可以利用该功能操作大量有关键词指数的标题或关键词来操作搜索引擎关键词霸屏SEO优化。3、自带微信推广域名防封功能并且，本程序自带微信推广域名防封功能，可以极大的避免你推广的域名被微信封掉。本程序系统自动检测你添加的跳转域名生成的泛域名是否被封，被封后会自动禁用该条泛域名并且自动更换为未封的域名，使用非常方便。', 'ugl8.cn', 'https://www.shenqir.com/', 'mnx4l', '33333333333333333', '', 1, 0, '2019-04-21 21:30:46', '2019-04-22 07:04:49', 3);
INSERT INTO `d_url_list` VALUES (759, NULL, '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1233123132131231123131231231123123211231231233112313', 'ugl8.cn', 'http://fex.baidu.com/ueditor/#start-submit', 'e2aG9', '31231', '', 1, 0, '2019-04-21 21:31:14', '2019-04-29 14:59:58', 9);
INSERT INTO `d_url_list` VALUES (760, NULL, '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 1231231', 'ugl8.cn', 'https://ss2.baidu.com/6ONYsjip0QIZ8tyhnq/it/u=2479135742,1423312212&fm=58&s=37F748328C84C9010140FFFF03005025&bpow=121&bpoh=75', 'RZvsh', '31231', '', 1, 0, '2019-04-21 21:33:41', '2019-04-21 21:33:41', 0);
INSERT INTO `d_url_list` VALUES (761, NULL, '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;', 'ugl8.cn', 'https://ss2.baidu.com/6ONYsjip0QIZ8tyhnq/it/u=2479135742,1423312212&fm=58&s=37F748328C84C9010140FFFF03005025&bpow=121&bpoh=75', 'TG1Ou', '23131', '', 1, 1, '2019-04-21 21:35:59', '2019-04-22 07:31:44', 2);
INSERT INTO `d_url_list` VALUES (762, NULL, '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 2微擎二群二群无', 'ugl8.cn', 'https://ss2.baidu.com/6ONYsjip0QIZ8tyhnq/it/u=2479135742,1423312212&fm=58&s=37F748328C84C9010140FFFF03005025&bpow=121&bpoh=75', 'DXp2c', '23131', '', 1, 0, '2019-04-21 21:37:54', '2019-04-22 06:05:10', 2);
INSERT INTO `d_url_list` VALUES (763, NULL, '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; 哈哈哈哈哈哈&nbsp;&nbsp;', 'ugl8.cn', 'https://ss2.baidu.com/6ONYsjip0QIZ8tyhnq/it/u=2479135742,1423312212&fm=58&s=37F748328C84C9010140FFFF03005025&bpow=121&bpoh=75', 'eHQU3', '123123', '', 1, 0, '2019-04-21 21:40:44', '2019-04-29 05:41:19', 1);
INSERT INTO `d_url_list` VALUES (765, NULL, '3242', 'ugl8.cn', 'http://www.jinpaimishu.com/', '4ksWg', '55555555555555555', '', 1, 0, '2019-04-21 21:42:18', '2019-04-29 03:42:38', 2);
INSERT INTO `d_url_list` VALUES (766, NULL, '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;', 'ugl8.cn', 'http://www.jinpaimishu.com/', 'Bcghy', '999999999999999999999', '', 1, 1, '2019-04-21 21:43:18', '2019-04-29 05:41:23', 5);
INSERT INTO `d_url_list` VALUES (767, NULL, '', 'ugl8.cn', 'http://fex.baidu.com/ueditor/#start-submit', 'wMSss', '234', '', 1, 1, '2019-04-22 08:25:46', '2019-04-22 08:25:51', 1);
INSERT INTO `d_url_list` VALUES (768, 0, '', 'ugl8.cn', 'https://www.zhihu.com/search?type=content&q=raid6', 'mnSRP', '23424', '', 1, 1, '2019-04-22 11:23:32', '2019-04-29 08:01:47', 6);
INSERT INTO `d_url_list` VALUES (769, 0, 'asdfasdfasdfasdfasdfasdf', 'ugl8.cn', 'https://baisi.co', 'LyOhK', '111111111112', '', 1, 1, '2019-04-22 13:02:23', '2019-04-25 09:03:33', 4);
INSERT INTO `d_url_list` VALUES (770, 0, 'asdfasdfasdfasdfasdfasdf', 'ugl8.cn', 'https://baisi.co', 'r2Y7O', '2111111112', '', 1, 0, '2019-04-22 13:04:14', '2019-04-29 03:41:11', 4);
INSERT INTO `d_url_list` VALUES (771, 0, '一、核心优势1、使用无限泛二级域名当作短网址这套短网址站群系统与传统常见的短网址站点功能不同，传统短网址站功能核心功能只是生成以后缀形式如：dwz.cn/BvckN4e 的短链接，我们开发的这套短网址生成的短域名是以 Bvck6.url.com 泛二级域名形式生成，之所以叫短网址站群就是使用本程序可大量无限生成泛二级域名为短网址使用。2、生成短网址自带标题功能，可操作关键词霸屏并且，再使用本程序生成短网址时，可添加推广的标题，且可在跳转停留页面显示，方便被搜索引擎收录跳转页面，这样极大的可以利用该功能操作大量有关键词指数的标题或关键词来操作搜索引擎关键词霸屏SEO优化。3、自带微信推广域名防封功能并且，本程序自带微信推广域名防封功能，可以极大的避免你推广的域名被微信封掉。本程序系统自动检测你添加的跳转域名生成的泛域名是否被封，被封后会自动禁用该条泛域名并且自动更换为未封的域名，使用非常方便。', 'ugl8.cn', 'https://baisi.co', 'zteDr', '微信推广域名防封系统短网址', '', 1, 1, '2019-04-22 13:34:11', '2019-04-29 04:59:59', 1);
INSERT INTO `d_url_list` VALUES (772, 0, '222222222222222222222222222222222', 'ugl8.cn', 'https://baisi.co', 'rfYIT', '666666622', '111111', 1, 0, '2019-04-22 13:42:02', '2019-04-29 05:04:57', 13);
INSERT INTO `d_url_list` VALUES (773, 0, '', 'ugl8.cn', 'http://qx223.xiuzhanwang.com/', 'fKwrA', '222222222221111111111', '', 1, 1, '2019-04-22 14:43:52', '2019-04-28 05:36:14', 7);
INSERT INTO `d_url_list` VALUES (774, 0, '', 'ugl8.cn', 'http://yn.shjgr.com/', 'GHD9a', '33333332222222222', '', 1, 1, '2019-04-22 14:57:38', '2019-04-25 08:35:48', 4);
INSERT INTO `d_url_list` VALUES (775, 0, '', 'ugl8.cn', 'https://www.baidu.com/', 'X0quS', '2342', '', 1, 1, '2019-04-22 15:59:50', '2019-04-29 02:58:08', 2);
INSERT INTO `d_url_list` VALUES (776, 0, '', 'ugl8.cn', 'https://www.baidu.com/', 'yCdv0', '4234', '', 1, 1, '2019-04-22 16:04:20', '2019-04-29 05:48:39', 2);
INSERT INTO `d_url_list` VALUES (777, 0, '', 'ugl8.cn', 'https://www.hostloc.com/thread-541486-1-1.html', 'qW50J', '2222222112222', '', 1, 1, '2019-04-22 16:07:32', '2019-04-29 04:33:26', 12);
INSERT INTO `d_url_list` VALUES (778, 0, '', 'ugl8.cn', 'https://www.iconfont.cn/', 'Sutfw', '234', '', 1, 1, '2019-04-22 16:13:45', '2019-04-29 03:34:27', 8);
INSERT INTO `d_url_list` VALUES (779, 0, '', 'ugl8.cn', 'https://www.woyaoso.cn/', 'kg1Yc', '234', '', 1, 1, '2019-04-22 16:14:50', '2019-04-22 16:14:56', 1);
INSERT INTO `d_url_list` VALUES (780, 0, '', 'ugl8.cn', 'https://www.hostloc.com/thread-541486-1-1.html', 'ZzKSh', '234', '', 1, 1, '2019-04-22 16:16:18', '2019-04-29 08:06:53', 9);
INSERT INTO `d_url_list` VALUES (781, 0, '', 'ugl8.cn', 'https://www.hostloc.com/thread-541486-1-1.html', 'zV3Km', '2131', '', 1, 1, '2019-04-22 16:37:12', '2019-04-29 04:33:27', 10);
INSERT INTO `d_url_list` VALUES (782, 0, '', 'ugl8.cn', 'https://www.hostloc.com/thread-541486-1-1.html', 'ViC1Z', '32', '', 1, 1, '2019-04-22 16:40:47', '2019-04-29 05:08:57', 17);
INSERT INTO `d_url_list` VALUES (783, 0, '', 'ugl8.cn', 'https://www.woyaoso.cn/', 'ofWmc', '32', '', 1, 1, '2019-04-22 16:42:32', '2019-04-29 04:17:15', 8);
INSERT INTO `d_url_list` VALUES (784, 0, '', 'ugl8.cn', 'https://www.shenqir.com/', 'kRpOG', '神器SEO软件', '', 1, 1, '2019-04-22 16:43:47', '2019-04-29 05:32:07', 5);
INSERT INTO `d_url_list` VALUES (785, 0, '', 'ugl8.cn', 'https://www.hostloc.com/thread-541486-1-1.html', 'FI4d6', '神器SEO软件', '', 1, 1, '2019-04-22 16:44:40', '2019-04-25 05:58:01', 5);
INSERT INTO `d_url_list` VALUES (786, 0, '', 'ugl8.cn', 'http://yn.shjgr.com', 'OSqll', '22111111111', '', 1, 1, '2019-04-22 16:46:00', '2019-04-29 03:44:40', 2);
INSERT INTO `d_url_list` VALUES (787, 0, '', 'ugl8.cn', 'https://www.hostloc.com/forum.php', 'uoS3H', '22221222222222', '', 1, 1, '2019-04-22 18:16:46', '2019-04-29 04:16:37', 5);
COMMIT;

-- ----------------------------
-- Table structure for d_user
-- ----------------------------
DROP TABLE IF EXISTS `d_user`;
CREATE TABLE `d_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '组别ID',
  `username` varchar(32) NOT NULL DEFAULT '' COMMENT '用户名',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '昵称',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `salt` varchar(30) NOT NULL DEFAULT '' COMMENT '密码盐',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '电子邮箱',
  `mobile` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `level` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '等级',
  `gender` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '性别',
  `birthday` date DEFAULT NULL COMMENT '生日',
  `bio` varchar(100) NOT NULL DEFAULT '' COMMENT '格言',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '余额',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `successions` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '连续登录天数',
  `maxsuccessions` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '最大连续登录天数',
  `prevtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上次登录时间',
  `logintime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录时间',
  `loginip` varchar(50) NOT NULL DEFAULT '' COMMENT '登录IP',
  `loginfailure` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '失败次数',
  `joinip` varchar(50) NOT NULL DEFAULT '' COMMENT '加入IP',
  `jointime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '加入时间',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `token` varchar(50) NOT NULL DEFAULT '' COMMENT 'Token',
  `status` varchar(30) NOT NULL DEFAULT '' COMMENT '状态',
  `verification` varchar(255) NOT NULL DEFAULT '' COMMENT '验证',
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `mobile` (`mobile`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='会员表';

-- ----------------------------
-- Records of d_user
-- ----------------------------
BEGIN;
INSERT INTO `d_user` VALUES (1, 1, 'admin', 'admin', 'c13f62012fd6a8fdf06b3452a94430e5', 'rpR6Bv', 'admin@163.com', '13888888888', '/assets/img/avatar.png', 0, 0, '2017-04-15', '', 0.00, 0, 1, 1, 1516170492, 1516171614, '127.0.0.1', 0, '127.0.0.1', 1491461418, 0, 1516171614, '', 'normal', '');
COMMIT;

-- ----------------------------
-- Table structure for d_user_group
-- ----------------------------
DROP TABLE IF EXISTS `d_user_group`;
CREATE TABLE `d_user_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '组名',
  `rules` text COMMENT '权限节点',
  `createtime` int(10) DEFAULT NULL COMMENT '添加时间',
  `updatetime` int(10) DEFAULT NULL COMMENT '更新时间',
  `status` enum('normal','hidden') DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='会员组表';

-- ----------------------------
-- Records of d_user_group
-- ----------------------------
BEGIN;
INSERT INTO `d_user_group` VALUES (1, '默认组', '1,2,3,4,5,6,7,8,9,10,11,12', 1515386468, 1516168298, 'normal');
COMMIT;

-- ----------------------------
-- Table structure for d_user_money_log
-- ----------------------------
DROP TABLE IF EXISTS `d_user_money_log`;
CREATE TABLE `d_user_money_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变更余额',
  `before` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变更前余额',
  `after` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '变更后余额',
  `memo` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='会员余额变动表';

-- ----------------------------
-- Table structure for d_user_rule
-- ----------------------------
DROP TABLE IF EXISTS `d_user_rule`;
CREATE TABLE `d_user_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) DEFAULT NULL COMMENT '父ID',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `title` varchar(50) DEFAULT '' COMMENT '标题',
  `remark` varchar(100) DEFAULT NULL COMMENT '备注',
  `ismenu` tinyint(1) DEFAULT NULL COMMENT '是否菜单',
  `createtime` int(10) DEFAULT NULL COMMENT '创建时间',
  `updatetime` int(10) DEFAULT NULL COMMENT '更新时间',
  `weigh` int(10) DEFAULT '0' COMMENT '权重',
  `status` enum('normal','hidden') DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='会员规则表';

-- ----------------------------
-- Records of d_user_rule
-- ----------------------------
BEGIN;
INSERT INTO `d_user_rule` VALUES (1, 0, 'index', '前台', '', 1, 1516168079, 1516168079, 1, 'normal');
INSERT INTO `d_user_rule` VALUES (2, 0, 'api', 'API接口', '', 1, 1516168062, 1516168062, 2, 'normal');
INSERT INTO `d_user_rule` VALUES (3, 1, 'user', '会员模块', '', 1, 1515386221, 1516168103, 12, 'normal');
INSERT INTO `d_user_rule` VALUES (4, 2, 'user', '会员模块', '', 1, 1515386221, 1516168092, 11, 'normal');
INSERT INTO `d_user_rule` VALUES (5, 3, 'index/user/login', '登录', '', 0, 1515386247, 1515386247, 5, 'normal');
INSERT INTO `d_user_rule` VALUES (6, 3, 'index/user/register', '注册', '', 0, 1515386262, 1516015236, 7, 'normal');
INSERT INTO `d_user_rule` VALUES (7, 3, 'index/user/index', '会员中心', '', 0, 1516015012, 1516015012, 9, 'normal');
INSERT INTO `d_user_rule` VALUES (8, 3, 'index/user/profile', '个人资料', '', 0, 1516015012, 1516015012, 4, 'normal');
INSERT INTO `d_user_rule` VALUES (9, 4, 'api/user/login', '登录', '', 0, 1515386247, 1515386247, 6, 'normal');
INSERT INTO `d_user_rule` VALUES (10, 4, 'api/user/register', '注册', '', 0, 1515386262, 1516015236, 8, 'normal');
INSERT INTO `d_user_rule` VALUES (11, 4, 'api/user/index', '会员中心', '', 0, 1516015012, 1516015012, 10, 'normal');
INSERT INTO `d_user_rule` VALUES (12, 4, 'api/user/profile', '个人资料', '', 0, 1516015012, 1516015012, 3, 'normal');
COMMIT;

-- ----------------------------
-- Table structure for d_user_score_log
-- ----------------------------
DROP TABLE IF EXISTS `d_user_score_log`;
CREATE TABLE `d_user_score_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `score` int(10) NOT NULL DEFAULT '0' COMMENT '变更积分',
  `before` int(10) NOT NULL DEFAULT '0' COMMENT '变更前积分',
  `after` int(10) NOT NULL DEFAULT '0' COMMENT '变更后积分',
  `memo` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='会员积分变动表';

-- ----------------------------
-- Table structure for d_user_token
-- ----------------------------
DROP TABLE IF EXISTS `d_user_token`;
CREATE TABLE `d_user_token` (
  `token` varchar(50) NOT NULL COMMENT 'Token',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `createtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `expiretime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '过期时间',
  PRIMARY KEY (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='会员Token表';

-- ----------------------------
-- Table structure for d_version
-- ----------------------------
DROP TABLE IF EXISTS `d_version`;
CREATE TABLE `d_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `oldversion` varchar(30) NOT NULL DEFAULT '' COMMENT '旧版本号',
  `newversion` varchar(30) NOT NULL DEFAULT '' COMMENT '新版本号',
  `packagesize` varchar(30) NOT NULL DEFAULT '' COMMENT '包大小',
  `content` varchar(500) NOT NULL DEFAULT '' COMMENT '升级内容',
  `downloadurl` varchar(255) NOT NULL DEFAULT '' COMMENT '下载地址',
  `enforce` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '强制更新',
  `createtime` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `weigh` int(10) NOT NULL DEFAULT '0' COMMENT '权重',
  `status` varchar(30) NOT NULL DEFAULT '' COMMENT '状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='版本表';

-- ----------------------------
-- Records of d_version
-- ----------------------------
BEGIN;
INSERT INTO `d_version` VALUES (1, '1.1.1,2', '1.2.1', '20M', '更新内容', 'https://www.fastadmin.net/download.html', 1, 1520425318, 0, 0, 'normal');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
