define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {
    var Controller = {
        index:function () {
            Table.api.init({
                extend: {
                    index_url: 'fission/template/index',
                    add_url: 'fission/template/add',
                    edit_url: 'fission/template/edit',
                    del_url: 'fission/template/del'
                }
            });
            var table = $("#table");
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                sortName: 'id',
                escape: false,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title:'ID', sortable: true,operate:false},
                        {field:'title',title:'标题'},
                        {field:'sub_title',title:'副标题'},
                        {field:'status',title:'状态',formatter:function (value) {
                                var data={
                                    '0':'<span class="text-danger"><i class="fa fa-circle"></i> 禁用</span>',
                                    '1':'<span class="text-success"><i class="fa fa-circle"></i> 启用</span>'
                                };
                                return data[value]
                            }},
                        {field: 'img', title:'图片',operate:false,formatter:Table.api.formatter.image},
                        {field:'create_time',title:'创建时间',operate:false},
                        {field:'update_time',title:'更新时间',operate:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]

            });
            Table.api.bindevent(table);
        },
        add:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        del:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        edit:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        }

    };
return Controller;
});