define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {
    var Controller = {
        index:function () {
            Table.api.init({
                extend: {
                    index_url: 'short/host/index',
                    add_url: 'short/host/add',
                    edit_url: 'short/host/edit',
                    del_url: 'short/host/del'
                }
            });
            var table = $("#table");
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                sortName: 'id',
                escape: false,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title:'ID', sortable: true,operate:false},
                        {field:'host',title:'域名'},
                        {field:'type',title:'域名类型',formatter:function (value) {
                                var data={
                                    'main':'主域名',
                                    'jump':'跳转域名'
                                };
                                return data[value]
                            }},
                        {field:'brand',title:'品牌',formatter:function (value) {
                                var data={
                                    '0':'<span class="text-danger"><i class="fa fa-circle"></i> 禁用</span>',
                                    '1':'<span class="text-success"><i class="fa fa-circle"></i> 启用</span>'
                                };
                                return data[value]
                            }},
                        {field:'status',title:'状态',formatter:function (value) {
                                var data={
                                    '0':'<span class="text-danger"><i class="fa fa-circle"></i> 禁用</span>',
                                    '1':'<span class="text-success"><i class="fa fa-circle"></i> 启用</span>'
                                };
                                return data[value]
                            }},
                        {field:'check_count',title:'检查次数',operate:false},
                        {field:'check_time',title:'上次检查时间',operate:false},
                        {field:'create_time',title:'创建时间',operate:false},

                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]

            });
            Table.api.bindevent(table);
        },
        add:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        del:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        edit:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        }

    };

    return Controller;
});