define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {
    var Controller = {
        index:function () {
            Table.api.init({
                extend: {
                    index_url: 'short/jump/index',
                    add_url: 'short/jump/add',
                    del_url: 'short/jump/del'
                }
            });
            var table = $("#table");
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                sortName: 'id',
                escape: false,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title:'ID', sortable: true,operate:false},
                        {field:'url_list_id',title:'短链id',operate:false},
                        {field:'short_url',title:'短链',operate:false},
                        {field:'url',title:'落地页'},
                        {field:'status',title:'状态',formatter:function (value) {
                                var data={
                                    '0':'<span class="text-danger"><i class="fa fa-circle"></i>封禁</span>',
                                    '1':'<span class="text-success"><i class="fa fa-circle"></i>正常</span>'
                                };
                                return data[value]
                            }},
                        {field:'create_time',title:'创建时间',operate:false},
                        {field:'update_time',title:'更新时间',operate:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]

            });
            Table.api.bindevent(table);
        },
        add:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        del:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        edit:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        ad:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        }

    };

    return Controller;
});