/**
 * Package:
 * Class:
 * @description: search项目页面相关效果js
 * @author: Zhen.li
 * @Date: 2014-09-23
 */

(function($){
    var page = {
        init:function(){
            var w = this;
            w.flag = true;
            w.initHTML();
            w.initEvent();
        },

        initHTML:function(){
            var w = this;
            var topWrap = $("#j_top_wrap"), x = 0, bottom = 0;
            var h1 = $(window).height(),
                h2 =$(document).height();
            x = $(document).scrollTop();
            bottom = h2-(h1+x);
            /*if(bottom > 0){
                $('.survey-wp').css({
                    height:310,
                    bottom:0
                })
            }*/
            if(topWrap.length){
                window.onscroll = w.throttle(function(){
                    x = $(document).scrollTop();
                    bottom = h2-(h1+x);
                    w.scroll(topWrap,x,bottom)
                }, 10);
            }

        },

        initEvent:function(){
            var w = this;

            var topHover = $('.j-hover');
            if(topHover.length){
                topHover.hover(function(){
                        $(this).addClass('nav-hover');
                    },
                    function(){
                        $(this).removeClass('nav-hover');
                    })
            }
            var slider = $('.j-box-slider');
            if(slider.length){
                slider.bind('click', function(){
                    w.slider($(this));
                })
            }

            /*var form = $('#j_advanced_form');
            if(form.length){
                form.bind('submit', function(e){
                     w.submit(form);
                     return false;
                 })
            }*/
        },
        scroll: function (dom,x,bottom) {
            var w = this;

            if(x>70){
                dom.addClass('top-wrap-fix');
                $('.wrap').css({
                    marginTop:90
                })
            }else{
                dom.removeClass('top-wrap-fix');
                $('.wrap').css({
                    marginTop:20
                })
            }
            /*if(bottom>0){
                $('.survey-wp').css({
                    height:310,
                    bottom:0
                })
            }else{
                $('.survey-wp').css({
                    height:110,
                    bottom:200
                })
            }*/
        },
        submit:function(form){
            var w = this;
            var a = $.trim($('#words').val()),
                b = $.trim($('#keyphraze').val()),
                c = $.trim($('#keyor').val()),
                d = $.trim($('#keynot').val()),
                e = $.trim($('#keyauthor').val());
            if(a==''&& b==''&& c==''&& d==''&& e=='' ){
                $('#words').addClass('error');
            }else{
                form.submit();
            }
        },

        slider:function(dom){
            var w = this;
            var parents = dom.parents('.j-rt-box');
            var h = parents.find('.j-rt-box-txt p').height();
            if(w.flag){
                parents.find('.j-rt-box-txt').animate({height:h});
                dom.html('收起<i class="ico-angle-up"></i>');
            }else{
                parents.find('.j-rt-box-txt').animate({height:'60px'});
                dom.html('更多内容<i class="ico-angle-down"></i>');
            }
            w.flag = !w.flag;
        },
        /**
         * 函数节流功能
         * @param fn
         * @param delay
         * @return {Function}
         */
        throttle:function(fn, delay){
            var timer = null;

            return function(){
                var context = this, args = arguments;
                clearTimeout(timer);
                timer = setTimeout(function(){
                    fn.apply(context, args);
                }, delay);
            }
        }
    }
    /* 响应式相关JS */
    var mPage= {
        init:function(){
            var w = this;
            w.flag = true;
            w.isShow = false;
            w.initHTML();
            w.initEvent();
        },

        initHTML:function(){
            var w = this;
            var topWrap = $("#j_m_top_search"), x = 0,
                mFilter = $('#j_m_filter');
            if(topWrap.length){
                $('body').bind('touchmove', function(){
                    x = $(document).scrollTop();
                    if(x>20){
                    topWrap.addClass('m-top-search-fix');
                    mFilter.addClass('m-wp-filter-fix');
                    $('#j_m_top_search').find('.j-m-down').hasClass('nav-hover') && $('.j-m-down').removeClass('nav-hover');
                    $('.wp-main').css({
                            marginTop:120
                    })
                }else{
                    topWrap.removeClass('m-top-search-fix');
                    mFilter.removeClass('m-wp-filter-fix');
                    $('.wp-main').css({
                        marginTop:0
                    })
                }
                })
            }

            if($('#j_keyword').length){
                $('#j_keyword').focus(function(){
                    $('.index-footer') && $('.index-footer').hide();
                })
                $('#j_keyword').blur(function(){
                    $('.index-footer') && $('.index-footer').show();
                })
            }
        },

        initEvent:function(){
            var w = this;

            var downMenu = $('.j-m-down');
            if(downMenu.length){
                downMenu.bind('click', function(e){
                    w.showMenu($(this),e);
                })
            }

            var slider = $('.j-box-slider');
            if(slider.length){
                slider.bind('click', function(){
                    w.slider($(this));
                })
            }

            var icoDown = $('.j-m-ico-down');
            if(icoDown.length){
               icoDown.bind('click', function(){
                   if($(this).next().is(':hidden')){
                       $(this).next().show();
                   }else{
                       $(this).next().hide();
                   }

               })
            }
            /* 点击body收起弹框*/
            $('body').bind('touchend', function(e){
                $('.j-m-down').each(function(i,item){
                    //alert($.contains( item, e.target))
                    if(!$.contains( item, e.target)){
                        $(item).hasClass('nav-hover') && $(item).removeClass('nav-hover');
                    }
                })
            })


        },


        showMenu:function(dom,e){
            var w = this;
            //alert(dom.hasClass('nav-hover'));
            if(dom.hasClass('nav-hover')){
                dom.removeClass('nav-hover');
                w.isShow = false;
            }else{
                dom.addClass('nav-hover');
                w.isShow = true;
            }
        },

        slider:function(dom){
            var w = this;
            var parents = dom.parents('.j-rt-box');
            var h = parents.find('.j-rt-box-txt p').height();
            if(w.flag){
                parents.find('.j-rt-box-txt').animate({height:h});
                dom.html('收起<i class="ico-angle-up"></i>');
            }else{
                parents.find('.j-rt-box-txt').animate({height:'60px'});
                dom.html('更多内容<i class="ico-angle-down"></i>');
            }
            w.flag = !w.flag;

        }

    }

    $(function(){
        // 响应式JS 判断ua引入
        $.getScript('http://assets.dxycdn.com/core/jslib/isMobile.js',function(){
            if(dxy_isMobile() == 'Mobile'){
                mPage.init();
            }else{
                page.init();
            }
        });

    });

    //增加调研
    var $sur=$('#survey-wp');
    $sur.hover(function(){
            $(this).stop().addClass('hover-survey').animate({'right':'0'},'slow');
        },function(){
        $(this).stop().removeClass('hover-survey').animate({'right':'-194px'},'slow');
    });



})(jQuery);

/*
//增加搜索历史

ViewHistory = function() {

    this.config = {
        limit: 5,
        storageKey: 'viewHistory',
        primaryKey: 'url'
    };

    this.cache = {
        localStorage:  null,
        userData:  null,
        attr:  null
    };
};

ViewHistory.prototype = {

    init: function(config) {
        this.config = config || this.config;
        var _self = this;

        // define localStorage
        if (!window.localStorage && (this.cache.userData = document.body) && this.cache.userData.addBehavior && this.cache.userData.addBehavior('#default#userdata')) {
            this.cache.userData.load((this.cache.attr = 'localStorage'));

            this.cache.localStorage = {
                'getItem': function(key) {
                    return _self.cache.userData.getAttribute(key);
                },
                'setItem': function(key, value) {
                    _self.cache.userData.setAttribute(key, value);
                    _self.cache.userData.save(_self.cache.attr);
                }
            };

        } else {
            this.cache.localStorage = window.localStorage;
        }
    },

    addHistory: function(item) {
        var items = this.getHistories();
        for(var i=0, len=items.length; i<len; i++) {
            if(item[this.config.primaryKey] && items[i][this.config.primaryKey] && item[this.config.primaryKey] === items[i][this.config.primaryKey]) {
                items.splice(i, 1);
                break;
            }
        }

        items.push(item);

        if(this.config.limit > 0 && items.length > this.config.limit) {
            items.splice(0, 1);
        }

        var json = JSON.stringify(items);
        this.cache.localStorage.setItem(this.config.storageKey, json);
    },

    getHistories: function() {
        var history = this.cache.localStorage.getItem(this.config.storageKey);
        if(history) {
            return JSON.parse(history);
        }
        return [];
    }
};

//初始化
if(typeof localStorage !== 'undefined' && typeof JSON !== 'undefined') {
    var viewHistory = new ViewHistory();
    viewHistory.init({
        limit: 5,
        storeagekey: 'viewHistory',
        primaryKey: 'url'
    });
}
// 如果 ViewHistory 的实例存在，则可以将页面信息写入。
if(viewHistory) {
    var page = {
        "title": document.getElementsByTagName('title')[0].innerHTML,
        "url": location.href // 这是 primaryKey

    };
    viewHistory.addHistory(page);
}

var wrap = document.getElementById('j_auto_lst');

// 如果 ViewHistory 的实例存在，并且外层节点存在，则可显示历史浏览记录
if(viewHistory && wrap) {
    // 获取浏览记录
    var histories = viewHistory.getHistories();

    // 组装列表
    var list = document.createElement('ul');
    if(histories && histories.length > 0) {
        for(var i=histories.length-1; i>=0; i--) {
            var history = histories[i];

            var item = document.createElement('li');
            var link = document.createElement('a');
            link.href = history.url;
            link.innerHTML = history.title;

            item.appendChild(link);
            list.appendChild(item);
        }

        // 插入页面特定位置
        wrap.appendChild(list);
    }
}
*/
