<?php
namespace Admin\Controller;
use Think\Controller;

class ProgramController extends BasicController
{

    public function index()
    {
        header('Location: /admin/Program/programList');
    }

    //小程序列表
    public function programList()
    {
        $where = "1=1 and is_del=0 ";
        $search_param = array();
        $program = M('program');
        $p = I('get.p', '1', 'htmlspecialchars');

        //搜索条件
        $category = I('category', '', 'htmlspecialchars');
        $name = I('name', '', 'htmlspecialchars');
        $begintm = I('begintm', '', 'htmlspecialchars');
        $endtm = I('endtm', '', 'htmlspecialchars');

        $search_param = array(
            'category' => $category,
            'name' => $name,
            'begintm' => $begintm,
            'endtm' => $endtm
        );
        if ($name != '') {
            $where .= " and `name` like '%$name%'";
        }
        if ($category != '') {
            $programCategory = M('program_category');
            $pid = $programCategory->field("GROUP_CONCAT(distinct pid) as pid")->where("cid='$category'")->find();
            if ($pid['pid'] != '') {
                $where .= " and id in(" . $pid['pid'] . ")";
            }
        }
        
        if ($begintm != '') {
            $intbegintm = strtotime($begintm);
            $where .= " and tm>=$intbegintm";
        }

        if ($endtm != '') {
            $intendtm = strtotime($endtm) + 60 * 60 * 24;
            $where .= " and tm<=$intendtm";
        }

        $count = $program->where($where)->count();// 查询满足要求的总记录数
        $Page = new \Think\Page($count, 20, $search_param);// 实例化分页类 传入总记录数和每页显示的记录数(25)
        $show = $Page->show();// 分页显示输出
        $programList = $program->where($where)->order("id desc")->page($p . ',20')->select();

        $this->assign('programList', $programList);
        $this->assign('page', $show);
        $this->assign('search_param', $search_param);
        
        //小程序分类
        $pcategory = M('pcategory');
        $categoryList = $pcategory->where("is_del=0")->select();
        $this->assign('categoryList', $categoryList);

        $this->assign('roleid', session('role'));
        $this->assign('title', '追格小程序列表');
        $this->display();
    }

    //小程序详情
    public function programDetail()
    {
        $id = I('get.id', '', 'htmlspecialchars');

        //小程序基本信息
        $program = M('program');
        $programInfo = $program->where("id='$id'")->find();
        //分类
        $programCategory = M('program_category');
        $categorys = $programCategory->field("GROUP_CONCAT(cid) as cid")->where("pid='$id'")->find();
        $cateArr = explode(',', $categorys['cid']);
        //标签
        $programLabel = M('program_label');
        $label = $programLabel->field("GROUP_CONCAT(plabel.`name`) as `name`")->join("left join plabel on program_label.lid=plabel.id")->where("program_label.pid='$id' and plabel.is_del=0")->find();
        $programInfo['label'] = $label['name'];

        $this->assign('programInfo', $programInfo);
        $this->assign('cateArr', $cateArr);


        $pcategory = M('pcategory');
        $categoryList = $pcategory->where("is_del=0")->select();
        $this->assign('categoryList', $categoryList);
        $this->assign('id', $id);

        $this->assign('title', '小程序详情');
        $this->assign('action_name', 'programList');
        $this->display('programDetail');
    }

    //删除小程序
    public function delprogram()
    {
        $id = I('id', '', 'htmlspecialchars');
        $program = M('program');
        $programLabel = M('program_label');
        $programCategory = M('program_category');
        $data['is_del'] = 1;

        $program->where("id='$id'")->save($data);
        $programCategory->where("pid=$id")->delete();
        $programLabel->where("pid='$id'")->delete();
        echo 1;
    }

    //添加小程序
    public function addProgram()
    {
        if (IS_POST) {
            $program = M('program');
            $data['name'] = I('post.name', '', 'htmlspecialchars');
            $data['logo'] = I('post.logo', '', 'htmlspecialchars');
            $data['qrcode'] = I('post.qrcode', '', 'htmlspecialchars');
            $data['shotone'] = I('post.shotone', '', 'htmlspecialchars');
            $data['shotwo'] = I('post.shotwo', '', 'htmlspecialchars');
            $data['shothree'] = I('post.shothree', '', 'htmlspecialchars');
            $data['shotfour'] = I('post.shotfour', '', 'htmlspecialchars');
            $data['shotfive'] = I('post.shotfive', '', 'htmlspecialchars');
            $data['introduce'] = I('post.introduce', '', 'htmlspecialchars');
            $data['company'] = I('post.company', '', 'htmlspecialchars');

            $category = I('post.category', '', 'htmlspecialchars');
            $label = I('post.label', '', 'htmlspecialchars');
            $data['tm'] =time();//发布时间
            //添加小程序
            $pid = $program->add($data);
            //添加分类
            foreach ($category as $k => $v) {
                $cateArr[$k]['pid'] = $pid;
                $cateArr[$k]['cid'] = $v;
            }
            $programCategory = M('program_category');
            $programCategory->addAll($cateArr);
            //添加标签
            if ($label != '') {
                $label = explode(',', $label);
                $plabel = M('plabel');
                $programLabel = M('program_label');
                foreach ($label as $k => $v) {
                    $info = $plabel->where("`name`='$v' and is_del=0")->find();
                    $lid = $info['id'];
                    if (count($info) <= 0) {
                        //新标签
                        $labelArr['name'] = $v;
                        $lid = $plabel->add($labelArr);
                    }
                    $pro_label['pid'] = $pid;
                    $pro_label['lid'] = $lid;
                    $programLabel->add($pro_label);
                }
            }

            echo 1;
            exit();
        }

        $pcategory = M('pcategory');
        $categoryList = $pcategory->where("is_del=0")->select();
        $this->assign('categoryList', $categoryList);
        

        $this->assign('title', '添加小程序');
        $this->display();
    }

    //上传logo
    public function uploadlogo()
    {
        $upload = new \Think\Upload();// 实例化上传类
        $upload->maxSize = 3145728;// 设置附件上传大小
        $upload->exts = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
        $upload->rootPath = './Upload/'; // 设置附件上传根目录
        $upload->savePath = 'logo/'; // 设置附件上传（子）目录
        // 上传文件
        $info = $upload->upload();
        $path = "/Upload/" . $info['logoimg']['savepath'] . $info['logoimg']['savename'];
        if ($info) {
            echo $path;

        } else {
            echo "-1";//上传失败
        }
    }

    //上传二维码图片
    public function uploadqrcode()
    {
        $upload = new \Think\Upload();// 实例化上传类
        $upload->maxSize = 3145728;// 设置附件上传大小
        $upload->exts = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
        $upload->rootPath = './Upload/'; // 设置附件上传根目录
        $upload->savePath = 'qrcode/'; // 设置附件上传（子）目录
        // 上传文件
        $info = $upload->upload();
        $path = "/Upload/" . $info['qrcodeimg']['savepath'] . $info['qrcodeimg']['savename'];
        if ($info) {
            echo $path;

        } else {
            echo "-1";//上传失败
        }
    }

    //上传截图
    public function uploadScreenshot()
    {
        $id = I('post.id', '', 'htmlspecialchars');
        $upload = new \Think\Upload();// 实例化上传类
        $upload->maxSize = 3145728;// 设置附件上传大小
        $upload->exts = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
        $upload->rootPath = './Upload/'; // 设置附件上传根目录
        $upload->savePath = 'screenshot/'; // 设置附件上传（子）目录
        // 上传文件
        $info = $upload->upload();
        $path = "/Upload/" . $info[$id]['savepath'] . $info[$id]['savename'];
        if ($info) {
            echo $path;

        } else {
            echo "-1";//上传失败
        }
    }

    //编辑小程序
    public function editProgram()
    {
        $id = I('get.id', '', 'htmlspecialchars');
        $program = M('program');
        $programCategory = M('program_category');
        $programLabel = M('program_label');
        $pcategory = M('pcategory');

        if (IS_POST) {
            $data['name'] = I('post.name', '', 'htmlspecialchars');
            $data['version'] = I('post.version', '', 'htmlspecialchars');
            $logo = I('post.logo', '', 'htmlspecialchars');
            $qrcode = I('post.qrcode', '', 'htmlspecialchars');
            $shotone = I('post.shotone', '', 'htmlspecialchars');
            $shotwo = I('post.shotwo', '', 'htmlspecialchars');
            $shothree = I('post.shothree', '', 'htmlspecialchars');
            $shotfour = I('post.shotfour', '', 'htmlspecialchars');
            $shotfive = I('post.shotfive', '', 'htmlspecialchars');
            $data['introduce'] = I('post.introduce', '', 'htmlspecialchars');
            $data['company'] = I('post.company', '', 'htmlspecialchars');
            $category = I('post.category', '', 'htmlspecialchars');
            $label = I('post.label', '', 'htmlspecialchars');
            $id = I('post.id', '', 'htmlspecialchars');


            if ($shotone != '') {
                $data['shotone'] = $shotone;
            }
            if ($shotwo != '') {
                $data['shotwo'] = $shotwo;
            }
            if ($shothree != '') {
                $data['shothree'] = $shothree;
            }
            if ($shotfour != '') {
                $data['shotfour'] = $shotfour;
            }
            if ($shotfive != '') {
                $data['shotfive'] = $shotfive;
            }
            if ($logo != '') {
                $data['logo'] = $logo;
            }
            if ($qrcode != '') {
                $data['qrcode'] = $qrcode;
            }
            //基本信息
            $program->where("id='$id'")->save($data);
            //分类
            $programCategory->where("pid='$id'")->delete();
            foreach ($category as $k => $v) {
                $cateArr[$k]['pid'] = $id;
                $cateArr[$k]['cid'] = $v;
            }
            $programCategory->addAll($cateArr);
            //添加标签
            if ($label != '') {
                $label = explode(',', $label);
                $plabel = M('plabel');
                foreach ($label as $k => $v) {
                    $info = $plabel->where("`name`='$v' and is_del=0")->find();
                    $lid = $info['id'];
                    if (count($info) <= 0) {
                        //新标签
                        $labelArr['name'] = $v;
                        $lid = $plabel->add($labelArr);
                    }
                    $pro_label['pid'] = $id;
                    $pro_label['lid'] = $lid;
                    $programLabel->add($pro_label);
                }
            }

            echo 'ok';
            exit();
        }

        $programInfo = $program->where("id='$id'")->find();//小程序信息
        //分类
        $categorys = $programCategory->field("GROUP_CONCAT(cid) as cid")->where("pid='$id'")->find();
        $cateArr = explode(',', $categorys['cid']);
        //标签
        $label = $programLabel->field("plabel.id,plabel.`name`")->join("left join plabel on program_label.lid=plabel.id")->where("program_label.pid='$id' and plabel.is_del=0")->select();

        $this->assign('programInfo', $programInfo);
        $this->assign('cateArr', $cateArr);
        $this->assign('label', $label);


        $categoryList = $pcategory->where("is_del=0")->select();
        $this->assign('categoryList', $categoryList);
        $this->assign('id', $id);

        $this->assign('title', '编辑小程序');
        $this->assign('action_name', 'programList');
        $this->display();
    }

    //删除标签
    public function delLabel()
    {
        $id = I('post.id', '', 'htmlspecialchars');
        $pid = I('post.pid', '', 'htmlspecialchars');
        $programLabel = M('program_label');

        $programLabel->where("pid='$pid' and lid='$id'")->delete();
        echo 1;
    }

}